/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class EiffelTokenMarker
extends TokenMarker {
    private static KeywordMap eiffelKeywords;
    private boolean cpp;
    private KeywordMap keywords = EiffelTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        int i = offset;
        block19: while (i < length) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '%') {
                backslash = !backslash;
            } else {
                block0 : switch (token) {
                    case 0: {
                        switch (c) {
                            case '\"': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)4;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '\'': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)13;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case ':': {
                                if (this.lastKeyword == offset) {
                                    if (this.doKeyword(line, i, c)) break block0;
                                    backslash = false;
                                    this.addToken(i1 - this.lastOffset, (byte)6);
                                    this.lastOffset = this.lastKeyword = i1;
                                    break;
                                }
                                if (!this.doKeyword(line, i, c)) break block0;
                                break;
                            }
                            case '-': {
                                backslash = false;
                                this.doKeyword(line, i, c);
                                if (length - i <= 1) break block0;
                                switch (array[i1]) {
                                    case '-': {
                                        this.addToken(i - this.lastOffset, token);
                                        this.addToken(length - i, (byte)1);
                                        this.lastOffset = this.lastKeyword = length;
                                        break block19;
                                    }
                                }
                                break block0;
                            }
                            default: {
                                backslash = false;
                                if (Character.isLetterOrDigit(c) || c == '_') break block0;
                                this.doKeyword(line, i, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        throw new RuntimeException("Wrong eiffel parser state");
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\"') break;
                        this.addToken(i1 - this.lastOffset, token);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 13: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(i1 - this.lastOffset, (byte)4);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + token);
                    }
                }
            }
            ++i;
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 4: 
            case 13: {
                this.addToken(length - this.lastOffset, (byte)11);
                token = 0;
                break;
            }
            case 8: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (eiffelKeywords == null) {
            eiffelKeywords = new KeywordMap(true);
            eiffelKeywords.add("alias", (byte)7);
            eiffelKeywords.add("all", (byte)7);
            eiffelKeywords.add("and", (byte)7);
            eiffelKeywords.add("as", (byte)7);
            eiffelKeywords.add("check", (byte)7);
            eiffelKeywords.add("class", (byte)7);
            eiffelKeywords.add("creation", (byte)7);
            eiffelKeywords.add("debug", (byte)7);
            eiffelKeywords.add("deferred", (byte)7);
            eiffelKeywords.add("do", (byte)7);
            eiffelKeywords.add("else", (byte)7);
            eiffelKeywords.add("elseif", (byte)7);
            eiffelKeywords.add("end", (byte)7);
            eiffelKeywords.add("ensure", (byte)7);
            eiffelKeywords.add("expanded", (byte)7);
            eiffelKeywords.add("export", (byte)7);
            eiffelKeywords.add("external", (byte)7);
            eiffelKeywords.add("feature", (byte)7);
            eiffelKeywords.add("from", (byte)7);
            eiffelKeywords.add("frozen", (byte)7);
            eiffelKeywords.add("if", (byte)7);
            eiffelKeywords.add("implies", (byte)7);
            eiffelKeywords.add("indexing", (byte)7);
            eiffelKeywords.add("infix", (byte)7);
            eiffelKeywords.add("inherit", (byte)7);
            eiffelKeywords.add("inspect", (byte)7);
            eiffelKeywords.add("invariant", (byte)7);
            eiffelKeywords.add("is", (byte)7);
            eiffelKeywords.add("like", (byte)7);
            eiffelKeywords.add("local", (byte)7);
            eiffelKeywords.add("loop", (byte)7);
            eiffelKeywords.add("not", (byte)7);
            eiffelKeywords.add("obsolete", (byte)7);
            eiffelKeywords.add("old", (byte)7);
            eiffelKeywords.add("once", (byte)7);
            eiffelKeywords.add("or", (byte)7);
            eiffelKeywords.add("prefix", (byte)7);
            eiffelKeywords.add("redefine", (byte)7);
            eiffelKeywords.add("rename", (byte)7);
            eiffelKeywords.add("require", (byte)7);
            eiffelKeywords.add("rescue", (byte)7);
            eiffelKeywords.add("retry", (byte)7);
            eiffelKeywords.add("select", (byte)7);
            eiffelKeywords.add("separate", (byte)7);
            eiffelKeywords.add("then", (byte)7);
            eiffelKeywords.add("undefine", (byte)7);
            eiffelKeywords.add("until", (byte)7);
            eiffelKeywords.add("variant", (byte)7);
            eiffelKeywords.add("when", (byte)7);
            eiffelKeywords.add("xor", (byte)7);
            eiffelKeywords.add("current", (byte)13);
            eiffelKeywords.add("false", (byte)13);
            eiffelKeywords.add("precursor", (byte)13);
            eiffelKeywords.add("result", (byte)13);
            eiffelKeywords.add("strip", (byte)13);
            eiffelKeywords.add("true", (byte)13);
            eiffelKeywords.add("unique", (byte)13);
            eiffelKeywords.add("void", (byte)13);
        }
        return eiffelKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        boolean klassname = false;
        int len = i - this.lastKeyword;
        int id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id == 0) {
            klassname = true;
            int at = this.lastKeyword;
            while (at < this.lastKeyword + len) {
                char ch = line.array[at];
                if (ch != '_' && !Character.isUpperCase(ch)) {
                    klassname = false;
                    break;
                }
                ++at;
            }
            if (klassname) {
                id = 9;
            }
        }
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, (byte)id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

