/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class SyntaxDocument
extends PlainDocument {
    protected Color[] colors;
    protected TokenMarker tokenMarker;

    public SyntaxDocument(Color[] colors) {
        this.colors = colors;
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setTokenMarker(TokenMarker tm) {
        this.tokenMarker = tm;
        if (tm == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int start, int len) {
        if (this.tokenMarker == null || !this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        Segment lineSegment = new Segment();
        Element map = this.getDefaultRootElement();
        len += start;
        try {
            int i = start;
            while (i < len) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                this.getText(lineStart, lineElement.getEndOffset() - lineStart - 1, lineSegment);
                this.tokenMarker.markTokens(lineSegment, i);
                ++i;
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    public void beginCompoundEdit() {
    }

    public void endCompoundEdit() {
    }

    public void addUndoableEdit(UndoableEdit edit) {
    }

    protected void fireInsertUpdate(DocumentEvent evt) {
        DocumentEvent.ElementChange ch;
        if (this.tokenMarker != null && (ch = evt.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(ch.getIndex() + 1, ch.getChildrenAdded().length - ch.getChildrenRemoved().length);
        }
        super.fireInsertUpdate(evt);
    }

    protected void fireRemoveUpdate(DocumentEvent evt) {
        DocumentEvent.ElementChange ch;
        if (this.tokenMarker != null && (ch = evt.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(ch.getIndex() + 1, ch.getChildrenRemoved().length - ch.getChildrenAdded().length);
        }
        super.fireRemoveUpdate(evt);
    }
}

