/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import java.awt.Color;
import java.util.Properties;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import org.syntax.jedit.SyntaxDocument;

public class MoeSyntaxDocument
extends SyntaxDocument {
    public static final String OUTPUT = "output";
    public static final String ERROR = "error";
    private static Color[] colors = null;

    public MoeSyntaxDocument() {
        super(MoeSyntaxDocument.getUserColors());
        int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
        this.putProperty("tabSize", new Integer(tabSize));
    }

    public void setParagraphAttributes(int offset, AttributeSet s) {
        try {
            this.writeLock();
            Element paragraph = this.getParagraphElement(offset);
            MutableAttributeSet attr = (MutableAttributeSet)paragraph.getAttributes();
            attr.addAttributes(s);
        }
        finally {
            this.writeUnlock();
        }
    }

    private static Color[] getUserColors() {
        if (colors == null) {
            int colorInt;
            Properties editorProps = Config.moe_user_props;
            colors = new Color[12];
            String colorStr = editorProps.getProperty("comment", "1a1a80");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 1710720;
            }
            MoeSyntaxDocument.colors[1] = new Color(colorInt);
            colorStr = editorProps.getProperty("javadoc", "1a1a80");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 1710720;
            }
            MoeSyntaxDocument.colors[2] = new Color(colorInt);
            colorStr = editorProps.getProperty("stand-out", "ee00bb");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 0xEE00BB;
            }
            MoeSyntaxDocument.colors[3] = new Color(colorInt);
            colorStr = editorProps.getProperty("keyword1", "660033");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 0x660033;
            }
            MoeSyntaxDocument.colors[7] = new Color(colorInt);
            colorStr = editorProps.getProperty("keyword2", "cc8033");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 13402163;
            }
            MoeSyntaxDocument.colors[8] = new Color(colorInt);
            colorStr = editorProps.getProperty("keyword3", "006699");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 26265;
            }
            MoeSyntaxDocument.colors[9] = new Color(colorInt);
            colorStr = editorProps.getProperty("primitive", "cc0000");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 0xCC0000;
            }
            MoeSyntaxDocument.colors[5] = new Color(colorInt);
            colorStr = editorProps.getProperty("string", "339933");
            try {
                colorInt = Integer.parseInt(colorStr, 16);
            }
            catch (NumberFormatException e) {
                colorInt = 0x339933;
            }
            MoeSyntaxDocument.colors[4] = new Color(colorInt);
            MoeSyntaxDocument.colors[6] = new Color(0x990000);
            MoeSyntaxDocument.colors[10] = new Color(0xCC9900);
            MoeSyntaxDocument.colors[11] = new Color(0xFF3300);
        }
        return colors;
    }
}

