/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.editor.moe.Finder;
import bluej.editor.moe.MoeEditor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class MoeEditorManager
extends EditorManager {
    protected static MoeEditorManager editorManager;
    private Properties resources;
    private List editors = new ArrayList(4);
    private Finder finder = new Finder();
    private boolean showLineNum = false;
    private boolean showToolBar = true;

    public MoeEditorManager() {
        this.resources = Config.moe_user_props;
        editorManager = this;
    }

    public Editor openClass(String filename, String docFilename, String windowTitle, EditorWatcher watcher, boolean compiled, List breakpoints, ClassLoader projectClassLoader, Rectangle bounds) {
        return this.openEditor(filename, docFilename, true, windowTitle, watcher, compiled, breakpoints, projectClassLoader, bounds);
    }

    public Editor openText(String filename, String windowTitle, Rectangle bounds) {
        return this.openEditor(filename, null, false, windowTitle, null, false, null, null, bounds);
    }

    public void refreshAll() {
        Iterator e = this.editors.iterator();
        while (e.hasNext()) {
            Editor ed = (Editor)e.next();
            if (!ed.isShowing()) continue;
            ed.refresh();
        }
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void discardEditor(Editor ed) {
        ed.close();
        this.editors.remove(ed);
    }

    Finder getFinder() {
        return this.finder;
    }

    private Editor openEditor(String filename, String docFilename, boolean isCode, String windowTitle, EditorWatcher watcher, boolean compiled, List breakpoints, ClassLoader projectClassLoader, Rectangle bounds) {
        MoeEditor editor = new MoeEditor(windowTitle, isCode, watcher, this.showToolBar, this.showLineNum, this.resources, projectClassLoader);
        this.editors.add(editor);
        if (watcher != null && filename == null) {
            return editor;
        }
        if (editor.showFile(filename, compiled, docFilename, bounds)) {
            return editor;
        }
        editor.doClose();
        return null;
    }
}

