/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.FunctionDialog;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public final class MoeActions {
    private static final String KEYS_FILE = "editor.keys";
    private static int SHORTCUT_MASK;
    private static int ALT_SHORTCUT_MASK;
    private static int SHIFT_SHORTCUT_MASK;
    private static int SHIFT_ALT_SHORTCUT_MASK;
    private static int DOUBLE_SHORTCUT_MASK;
    private static final int tabSize;
    private static final String spaces = "                                        ";
    private static final char TAB_CHAR = '\t';
    private Action[] actionTable;
    private Hashtable actions;
    private String[] categories;
    private int[] categoryIndex;
    private Keymap keymap;
    private KeyCatcher keyCatcher;
    private boolean lastActionWasCut;
    public UndoAction undoAction;
    public RedoAction redoAction;
    public Action compileAction;
    private InputMap componentInputMap;
    private static MoeActions moeActions;

    static {
        tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
    }

    public static MoeActions getActions(JTextComponent textComponent) {
        if (moeActions == null) {
            moeActions = new MoeActions(textComponent);
        }
        if (textComponent != null) {
            textComponent.setKeymap(MoeActions.moeActions.keymap);
        }
        return moeActions;
    }

    private MoeActions(JTextComponent textComponent) {
        SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ALT_SHORTCUT_MASK = SHORTCUT_MASK == 2 ? 4 : 2;
        SHIFT_SHORTCUT_MASK = SHORTCUT_MASK + 1;
        SHIFT_ALT_SHORTCUT_MASK = 1 + ALT_SHORTCUT_MASK;
        DOUBLE_SHORTCUT_MASK = SHORTCUT_MASK + ALT_SHORTCUT_MASK;
        this.keymap = JTextComponent.addKeymap("BlueJ map", textComponent.getKeymap());
        this.createActionTable(textComponent);
        this.keyCatcher = new KeyCatcher();
        if (!this.load()) {
            this.setDefaultKeyBindings();
        }
        this.lastActionWasCut = false;
        this.componentInputMap = textComponent.getInputMap();
    }

    public Action getActionByName(String name) {
        return (Action)this.actions.get(name);
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        KeyStroke[] keys = this.keymap.getKeyStrokesForAction(action);
        if ((keys = this.addComponentKeyStrokes(action, keys)) != null && keys.length > 0) {
            return keys;
        }
        return null;
    }

    public KeyStroke[] addComponentKeyStrokes(Action action, KeyStroke[] keys) {
        KeyStroke[] allKeys;
        ArrayList<KeyStroke> keyStrokes = null;
        KeyStroke[] componentKeys = this.componentInputMap.allKeys();
        int i = 0;
        while (i < componentKeys.length) {
            if (this.componentInputMap.get(componentKeys[i]).equals(action.getValue("Name"))) {
                if (keyStrokes == null) {
                    keyStrokes = new ArrayList<KeyStroke>();
                }
                keyStrokes.add(componentKeys[i]);
            }
            ++i;
        }
        if (keyStrokes != null) {
            Iterator i2 = keyStrokes.iterator();
            while (i2.hasNext()) {
                if (this.keymap.getAction((KeyStroke)i2.next()) == null) continue;
                i2.remove();
            }
        }
        if (keyStrokes == null || keyStrokes.size() == 0) {
            return keys;
        }
        if (keys == null) {
            allKeys = new KeyStroke[keyStrokes.size()];
            keyStrokes.toArray(allKeys);
        } else {
            allKeys = new KeyStroke[keyStrokes.size() + keys.length];
            keyStrokes.toArray(allKeys);
            System.arraycopy(allKeys, 0, allKeys, keys.length, keyStrokes.size());
            System.arraycopy(keys, 0, allKeys, 0, keys.length);
        }
        return allKeys;
    }

    public void addActionForKeyStroke(KeyStroke key, Action a) {
        this.keymap.addActionForKeyStroke(key, a);
    }

    public void removeKeyStrokeBinding(KeyStroke key) {
        this.keymap.removeKeyStrokeBinding(key);
    }

    public boolean save() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE);
            FileOutputStream ostream = new FileOutputStream(file);
            ObjectOutputStream stream = new ObjectOutputStream(ostream);
            KeyStroke[] keys = this.keymap.getBoundKeyStrokes();
            stream.writeInt(200);
            stream.writeInt(keys.length);
            int i = 0;
            while (i < keys.length) {
                stream.writeObject(keys[i]);
                stream.writeObject(this.keymap.getAction(keys[i]).getValue("Name"));
                ++i;
            }
            stream.flush();
            ostream.close();
            return true;
        }
        catch (Exception exc) {
            Debug.message((String)("Cannot save key bindings: " + exc));
            return false;
        }
    }

    public boolean load() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE);
            FileInputStream istream = new FileInputStream(file);
            ObjectInputStream stream = new ObjectInputStream(istream);
            int version = 0;
            int count = stream.readInt();
            if (count > 100) {
                version = count;
                count = stream.readInt();
            }
            if (Config.isMacOS() && version < 140) {
                return false;
            }
            int i = 0;
            while (i < count) {
                KeyStroke key = (KeyStroke)stream.readObject();
                String actionName = (String)stream.readObject();
                Action action = (Action)this.actions.get(actionName);
                if (action != null) {
                    this.keymap.addActionForKeyStroke(key, action);
                }
                ++i;
            }
            istream.close();
            if (version < 130) {
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), (Action)this.actions.get("indent"));
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), (Action)this.actions.get("insert-tab"));
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), (Action)this.actions.get("new-line"));
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), (Action)this.actions.get("insert-break"));
            }
            if (version < 200) {
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), (Action)this.actions.get("de-indent"));
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(73, SHORTCUT_MASK), (Action)this.actions.get("insert-tab"));
            }
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public void userAction() {
        this.lastActionWasCut = false;
    }

    public void textInsertAction(DocumentEvent evt, JTextComponent textPane) {
        try {
            int offset;
            Document doc;
            char ch;
            if (evt.getLength() == 1 && (ch = (doc = evt.getDocument()).getText(offset = evt.getOffset(), 1).charAt(0)) == '}') {
                this.closingBrace(textPane, doc, offset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void closingBrace(JTextComponent textPane, Document doc, int offset) throws BadLocationException {
        int lineIndex = this.getCurrentLineIndex(textPane);
        Element line = this.getLine(textPane, lineIndex);
        int lineStart = line.getStartOffset();
        String prefix = doc.getText(lineStart, offset - lineStart);
        if (prefix.trim().length() == 0) {
            textPane.setCaretPosition(lineStart);
            this.doIndent(textPane, true);
            textPane.setCaretPosition(textPane.getCaretPosition() + 1);
        }
    }

    public void addSelectionToClipboard(JTextComponent textComponent) {
        Clipboard clipboard = textComponent.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        String clipContent = "";
        if (content != null) {
            try {
                clipContent = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringSelection contents = new StringSelection(String.valueOf(clipContent) + textComponent.getSelectedText());
        clipboard.setContents(contents, contents);
    }

    private int getCurrentColumn(JTextComponent textPane) {
        Caret caret = textPane.getCaret();
        int pos = Math.min(caret.getMark(), caret.getDot());
        AbstractDocument doc = (AbstractDocument)textPane.getDocument();
        int lineStart = doc.getParagraphElement(pos).getStartOffset();
        return pos - lineStart;
    }

    private Element getLine(JTextComponent text, int lineNo) {
        return text.getDocument().getDefaultRootElement().getElement(lineNo);
    }

    private Element getLineAt(JTextComponent text, int pos) {
        MoeSyntaxDocument document = (MoeSyntaxDocument)text.getDocument();
        return document.getParagraphElement(pos);
    }

    private int getCurrentLineIndex(JTextComponent text) {
        MoeSyntaxDocument document = (MoeSyntaxDocument)text.getDocument();
        return document.getDefaultRootElement().getElementIndex(text.getCaretPosition());
    }

    private void doIndent(JTextComponent textPane, boolean isNewLine) {
        int lineIndex = this.getCurrentLineIndex(textPane);
        if (lineIndex == 0) {
            if (!isNewLine) {
                this.insertSpacedTab(textPane);
            }
            return;
        }
        MoeSyntaxDocument doc = (MoeSyntaxDocument)textPane.getDocument();
        Element line = this.getLine(textPane, lineIndex);
        int lineStart = line.getStartOffset();
        int pos = textPane.getCaretPosition();
        try {
            boolean isOpenBrace = false;
            boolean isCommentEnd = false;
            boolean isCommentEndOnly = false;
            String prefix = doc.getText(lineStart, pos - lineStart);
            if (prefix.trim().length() > 0) {
                this.insertSpacedTab(textPane);
                return;
            }
            boolean foundLine = false;
            int lineOffset = 1;
            String prevLineText = null;
            while (lineIndex - lineOffset >= 0 && !foundLine) {
                int prevLineEnd;
                Element prevline = this.getLine(textPane, lineIndex - lineOffset);
                int prevLineStart = prevline.getStartOffset();
                prevLineText = doc.getText(prevLineStart, (prevLineEnd = prevline.getEndOffset()) - prevLineStart);
                if (!this.isWhiteSpaceOnly(prevLineText)) {
                    foundLine = true;
                    continue;
                }
                ++lineOffset;
            }
            if (!foundLine) {
                if (!isNewLine) {
                    this.insertSpacedTab(textPane);
                }
                return;
            }
            if (this.isOpenBrace(prevLineText)) {
                isOpenBrace = true;
            } else {
                isCommentEnd = prevLineText.trim().endsWith("*/");
                isCommentEndOnly = prevLineText.trim().equals("*/");
            }
            int indentPos = this.findFirstNonIndentChar(prevLineText, isCommentEnd);
            int caretColumn = this.getCurrentColumn(textPane);
            if (caretColumn >= indentPos) {
                if (!isNewLine) {
                    this.insertSpacedTab(textPane);
                }
                return;
            }
            String indent = prevLineText.substring(0, indentPos);
            if (isNewLine && this.isCommentStart(indent)) {
                this.completeNewCommentBlock(textPane, indent);
                return;
            }
            int lineEnd = line.getEndOffset();
            String lineText = doc.getText(lineStart, lineEnd - lineStart);
            indentPos = this.findFirstNonIndentChar(lineText, true);
            char firstChar = lineText.charAt(indentPos);
            doc.remove(lineStart, indentPos);
            doc.insertString(lineStart, this.nextIndent(indent, isOpenBrace, isCommentEndOnly), null);
            if (firstChar == '}') {
                this.removeTab(textPane, doc);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isWhiteSpaceOnly(String s) {
        return s.trim().length() == 0;
    }

    private void doDeIndent(JTextComponent textPane) {
        int lineIndex = this.getCurrentLineIndex(textPane);
        MoeSyntaxDocument doc = (MoeSyntaxDocument)textPane.getDocument();
        try {
            int prevLineEnd;
            Element line = this.getLine(textPane, lineIndex);
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            String lineText = doc.getText(lineStart, lineEnd - lineStart);
            int currentIndentPos = this.findFirstNonIndentChar(lineText, true);
            char firstChar = lineText.charAt(currentIndentPos);
            textPane.setCaretPosition(lineStart + currentIndentPos);
            if (lineIndex == 0) {
                this.removeTab(textPane, doc);
                return;
            }
            Element prevline = this.getLine(textPane, lineIndex - 1);
            int prevLineStart = prevline.getStartOffset();
            String prevLineText = doc.getText(prevLineStart, (prevLineEnd = prevline.getEndOffset()) - prevLineStart);
            int targetIndentPos = this.findFirstNonIndentChar(prevLineText, true);
            if (currentIndentPos > targetIndentPos) {
                String indent = prevLineText.substring(0, targetIndentPos);
                doc.remove(lineStart, currentIndentPos);
                doc.insertString(lineStart, indent, null);
                if (firstChar == '}') {
                    this.removeTab(textPane, doc);
                }
            } else {
                this.removeTab(textPane, doc);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isCommentStart(String s) {
        return (s = s.trim()).endsWith("/**") || s.endsWith("/*");
    }

    private void completeNewCommentBlock(JTextComponent textPane, String indentString) {
        String nextIndent = indentString.substring(0, indentString.length() - 2);
        textPane.replaceSelection(String.valueOf(nextIndent) + " * ");
        int pos = textPane.getCaretPosition();
        textPane.replaceSelection("\n");
        textPane.replaceSelection(String.valueOf(nextIndent) + " */");
        textPane.setCaretPosition(pos);
    }

    private boolean isOpenBrace(String s) {
        int index = s.lastIndexOf(123);
        if (index == -1) {
            return false;
        }
        return s.indexOf(125, index + 1) == -1;
    }

    /*
     * Unable to fully structure code
     */
    private int findFirstNonIndentChar(String s, boolean whitespaceOnly) {
        block3: {
            cnt = 0;
            ch = s.charAt(0);
            if (!whitespaceOnly) ** GOTO lbl9
            while (ch == ' ' || ch == '\t') {
                ch = s.charAt(++cnt);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                ch = s.charAt(++cnt);
lbl9:
                // 2 sources

                ** while (ch == ' ' || ch == '\t' || ch == '*')
            }
lbl10:
            // 1 sources

            if (s.charAt(cnt) == '/' && s.charAt(cnt + 1) == '*') {
                cnt += 2;
            }
        }
        return cnt;
    }

    private String nextIndent(String s, boolean openBrace, boolean commentEndOnly) {
        if (openBrace) {
            return String.valueOf(s) + spaces.substring(0, tabSize);
        }
        if (commentEndOnly) {
            return s.substring(0, s.length() - 1);
        }
        if (s.endsWith("/*")) {
            return String.valueOf(s.substring(0, s.length() - 2)) + " * ";
        }
        return s;
    }

    private void insertSpacedTab(JTextComponent textPane) {
        int numSpaces = tabSize - this.getCurrentColumn(textPane) % tabSize;
        textPane.replaceSelection(spaces.substring(0, numSpaces));
    }

    private void removeTab(JTextComponent textPane, Document doc) throws BadLocationException {
        int col = this.getCurrentColumn(textPane);
        if (col > 0) {
            int remove = col % tabSize;
            if (remove == 0) {
                remove = tabSize;
            }
            int pos = textPane.getCaretPosition();
            doc.remove(pos - remove, remove);
        }
    }

    private int convertTabsToSpaces(JTextComponent textPane) {
        int count = 0;
        int lineNo = 0;
        AbstractDocument doc = (AbstractDocument)textPane.getDocument();
        Element root = doc.getDefaultRootElement();
        Element line = root.getElement(lineNo);
        try {
            while (line != null) {
                int start = line.getStartOffset();
                int length = line.getEndOffset() - start;
                String text = doc.getText(start, length);
                int startCount = count;
                int tabIndex = text.indexOf(9);
                while (tabIndex != -1) {
                    text = this.expandTab(text, tabIndex);
                    ++count;
                    tabIndex = text.indexOf(9);
                }
                if (count != startCount) {
                    doc.remove(start, length);
                    doc.insertString(start, text, null);
                }
                line = root.getElement(++lineNo);
            }
        }
        catch (BadLocationException exc) {
            Debug.reportError((String)"stuffed up in 'convertTabsToSpaces'");
        }
        return count;
    }

    private String expandTab(String s, int idx) {
        int numSpaces = tabSize - idx % tabSize;
        return String.valueOf(s.substring(0, idx)) + spaces.substring(0, numSpaces) + s.substring(idx + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertTemplate(JTextComponent textPane, String templateName) {
        try {
            File template = Config.getTemplateFile((String)templateName);
            BufferedReader in = new BufferedReader(new FileReader(template));
            int pos = textPane.getCaretPosition();
            int column = this.getCurrentColumn(textPane);
            if (column > 40) {
                column = 40;
            }
            String line = in.readLine();
            block2: while (true) {
                if (line == null) {
                    textPane.setCaretPosition(pos);
                    return;
                }
                while (true) {
                    if (line.length() <= 0 || line.charAt(0) != '\t') {
                        textPane.replaceSelection(line);
                        textPane.replaceSelection("\n");
                        textPane.replaceSelection(spaces.substring(0, column));
                        line = in.readLine();
                        continue block2;
                    }
                    this.insertSpacedTab(textPane);
                    line = line.substring(1);
                }
                break;
            }
        }
        catch (IOException exc) {
            Debug.reportError((String)"Could not read method template.");
            Debug.reportError((String)("Exception: " + exc));
        }
    }

    private void blockAction(JTextComponent textPane, LineAction lineAction) {
        int selectionEnd;
        Caret caret = textPane.getCaret();
        int selectionStart = caret.getMark();
        if (selectionStart > (selectionEnd = caret.getDot())) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
        }
        if (selectionStart != selectionEnd) {
            --selectionEnd;
        }
        MoeSyntaxDocument doc = (MoeSyntaxDocument)textPane.getDocument();
        Element text = doc.getDefaultRootElement();
        int firstLineIndex = text.getElementIndex(selectionStart);
        int lastLineIndex = text.getElementIndex(selectionEnd);
        int i = firstLineIndex;
        while (i <= lastLineIndex) {
            Element line = text.getElement(i);
            lineAction.apply(line, doc);
            ++i;
        }
        textPane.setCaretPosition(text.getElement(firstLineIndex).getStartOffset());
        textPane.moveCaretPosition(text.getElement(lastLineIndex).getEndOffset());
    }

    private void createActionTable(JTextComponent textComponent) {
        Action action;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.compileAction = new CompileAction();
        Action[] textActions = textComponent.getActions();
        Action[] myActions = new Action[]{new SaveAction(), new ReloadAction(), new PageSetupAction(), new PrintAction(), new CloseAction(), this.undoAction, this.redoAction, new CommentBlockAction(), new UncommentBlockAction(), new IndentBlockAction(), new DeindentBlockAction(), new InsertMethodAction(), new IndentAction(), new DeIndentAction(), new NewLineAction(), new CopyLineAction(), new CutLineAction(), new CutEndOfLineAction(), new CutWordAction(), new CutEndOfWordAction(), new FindAction(), new FindNextAction(), new FindNextBackwardAction(), new ReplaceAction(), this.compileAction, new GoToLineAction(), new ToggleInterfaceAction(), new ToggleBreakPointAction(), new KeyBindingsAction(), new PreferencesAction(), new AboutAction(), new DescribeKeyAction(), new HelpMouseAction(), new ShowManualAction()};
        this.actions = new Hashtable();
        int i = 0;
        while (i < textActions.length) {
            action = textActions[i];
            this.actions.put(action.getValue("Name"), action);
            ++i;
        }
        i = 0;
        while (i < myActions.length) {
            action = myActions[i];
            this.actions.put(action.getValue("Name"), action);
            ++i;
        }
        this.actionTable = new Action[]{(Action)this.actions.get("delete-previous"), (Action)this.actions.get("delete-next"), (Action)this.actions.get("copy-to-clipboard"), (Action)this.actions.get("cut-to-clipboard"), (Action)this.actions.get("copy-line"), (Action)this.actions.get("cut-line"), (Action)this.actions.get("cut-end-of-line"), (Action)this.actions.get("cut-word"), (Action)this.actions.get("cut-end-of-word"), (Action)this.actions.get("paste-from-clipboard"), (Action)this.actions.get("indent"), (Action)this.actions.get("de-indent"), (Action)this.actions.get("insert-tab"), (Action)this.actions.get("new-line"), (Action)this.actions.get("insert-break"), (Action)this.actions.get("insert-method"), (Action)this.actions.get("comment-block"), (Action)this.actions.get("uncomment-block"), (Action)this.actions.get("indent-block"), (Action)this.actions.get("deindent-block"), (Action)this.actions.get("select-word"), (Action)this.actions.get("select-line"), (Action)this.actions.get("select-paragraph"), (Action)this.actions.get("select-all"), (Action)this.actions.get("selection-backward"), (Action)this.actions.get("selection-forward"), (Action)this.actions.get("selection-up"), (Action)this.actions.get("selection-down"), (Action)this.actions.get("selection-begin-word"), (Action)this.actions.get("selection-end-word"), (Action)this.actions.get("selection-previous-word"), (Action)this.actions.get("selection-next-word"), (Action)this.actions.get("selection-begin-line"), (Action)this.actions.get("selection-end-line"), (Action)this.actions.get("selection-begin-paragraph"), (Action)this.actions.get("selection-end-paragraph"), (Action)this.actions.get("selection-page-up"), (Action)this.actions.get("selection-page-down"), (Action)this.actions.get("selection-begin"), (Action)this.actions.get("selection-end"), (Action)this.actions.get("unselect"), (Action)this.actions.get("caret-backward"), (Action)this.actions.get("caret-forward"), (Action)this.actions.get("caret-up"), (Action)this.actions.get("caret-down"), (Action)this.actions.get("caret-begin-word"), (Action)this.actions.get("caret-end-word"), (Action)this.actions.get("caret-previous-word"), (Action)this.actions.get("caret-next-word"), (Action)this.actions.get("caret-begin-line"), (Action)this.actions.get("caret-end-line"), (Action)this.actions.get("caret-begin-paragraph"), (Action)this.actions.get("caret-end-paragraph"), (Action)this.actions.get("page-up"), (Action)this.actions.get("page-down"), (Action)this.actions.get("caret-begin"), (Action)this.actions.get("caret-end"), (Action)this.actions.get("save"), (Action)this.actions.get("reload"), (Action)this.actions.get("close"), (Action)this.actions.get("print"), (Action)this.actions.get("page-setup"), (Action)this.actions.get("key-bindings"), (Action)this.actions.get("preferences"), (Action)this.actions.get("describe-key"), (Action)this.actions.get("help-mouse"), (Action)this.actions.get("show-manual"), (Action)this.actions.get("about-editor"), this.undoAction, this.redoAction, (Action)this.actions.get("find"), (Action)this.actions.get("find-next"), (Action)this.actions.get("find-next-backward"), (Action)this.actions.get("replace"), (Action)this.actions.get("compile"), (Action)this.actions.get("toggle-interface-view"), (Action)this.actions.get("toggle-breakpoint"), (Action)this.actions.get("go-to-line")};
        this.categories = new String[]{Config.getString((String)"editor.functions.editFunctions"), Config.getString((String)"editor.functions.moveScroll"), Config.getString((String)"editor.functions.classFunctions"), Config.getString((String)"editor.functions.customisation"), Config.getString((String)"editor.functions.help"), Config.getString((String)"editor.functions.misc")};
        int[] nArray = new int[7];
        nArray[1] = 41;
        nArray[2] = 57;
        nArray[3] = 62;
        nArray[4] = 64;
        nArray[5] = 68;
        nArray[6] = 78;
        this.categoryIndex = nArray;
    }

    public void setDefaultKeyBindings() {
        this.keymap.removeBindings();
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(83, SHORTCUT_MASK), (Action)this.actions.get("save"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(80, SHORTCUT_MASK), (Action)this.actions.get("print"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(87, SHORTCUT_MASK), (Action)this.actions.get("close"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(90, SHORTCUT_MASK), (Action)this.actions.get("undo"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(89, SHORTCUT_MASK), (Action)this.actions.get("redo"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(119, 0), (Action)this.actions.get("comment-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(118, 0), (Action)this.actions.get("uncomment-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(117, 0), (Action)this.actions.get("indent-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(116, 0), (Action)this.actions.get("deindent-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(77, SHORTCUT_MASK), (Action)this.actions.get("insert-method"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), (Action)this.actions.get("indent"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), (Action)this.actions.get("de-indent"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(73, SHORTCUT_MASK), (Action)this.actions.get("insert-tab"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), (Action)this.actions.get("new-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), (Action)this.actions.get("insert-break"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(70, SHORTCUT_MASK), (Action)this.actions.get("find"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(71, SHORTCUT_MASK), (Action)this.actions.get("find-next"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(71, SHIFT_SHORTCUT_MASK), (Action)this.actions.get("find-next-backward"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(82, SHORTCUT_MASK), (Action)this.actions.get("replace"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(76, SHORTCUT_MASK), (Action)this.actions.get("go-to-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(75, SHORTCUT_MASK), (Action)this.actions.get("compile"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(74, SHORTCUT_MASK), (Action)this.actions.get("toggle-interface-view"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(66, SHORTCUT_MASK), (Action)this.actions.get("toggle-breakpoint"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(68, SHORTCUT_MASK), (Action)this.actions.get("describe-key"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, SHORTCUT_MASK), (Action)this.actions.get("copy-to-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, SHORTCUT_MASK), (Action)this.actions.get("cut-to-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, SHORTCUT_MASK), (Action)this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(113, 0), (Action)this.actions.get("copy-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(114, 0), (Action)this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(115, 0), (Action)this.actions.get("cut-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, ALT_SHORTCUT_MASK), (Action)this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, ALT_SHORTCUT_MASK), (Action)this.actions.get("delete-previous"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, ALT_SHORTCUT_MASK), (Action)this.actions.get("delete-next"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, SHIFT_ALT_SHORTCUT_MASK), (Action)this.actions.get("cut-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, SHIFT_ALT_SHORTCUT_MASK), (Action)this.actions.get("cut-end-of-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, DOUBLE_SHORTCUT_MASK), (Action)this.actions.get("cut-word"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, DOUBLE_SHORTCUT_MASK), (Action)this.actions.get("cut-end-of-word"));
    }

    abstract class MoeAbstractAction
    extends TextAction {
        public MoeAbstractAction(String name) {
            super(name);
        }

        protected final MoeEditor getEditor(ActionEvent e) {
            Container c;
            JTextComponent textComponent;
            Container c2;
            MoeEditor ed = null;
            Object source = e.getSource();
            if (source instanceof JComponent && (c2 = ((JComponent)source).getTopLevelAncestor()) instanceof MoeEditor) {
                ed = (MoeEditor)c2;
            }
            if (ed == null && (textComponent = this.getTextComponent(e)) != null && (c = textComponent.getTopLevelAncestor()) instanceof MoeEditor) {
                ed = (MoeEditor)c;
            }
            if (ed != null) {
                ed.clearMessage();
            }
            return ed;
        }
    }

    class SaveAction
    extends MoeAbstractAction {
        public SaveAction() {
            super("save");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).userSave();
        }
    }

    class ReloadAction
    extends MoeAbstractAction {
        public ReloadAction() {
            super("reload");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).reload();
        }
    }

    class PrintAction
    extends MoeAbstractAction {
        public PrintAction() {
            super("print");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).print();
        }
    }

    class PageSetupAction
    extends MoeAbstractAction {
        public PageSetupAction() {
            super("page-setup");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).pageSetup();
        }
    }

    class CloseAction
    extends MoeAbstractAction {
        public CloseAction() {
            super("close");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).close();
        }
    }

    class UndoAction
    extends MoeAbstractAction {
        public UndoAction() {
            super("undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            try {
                editor.undoManager.undo();
            }
            catch (CannotUndoException ex) {
                Debug.message((String)"moe: cannot undo...");
            }
            editor.updateUndoControls();
            editor.updateRedoControls();
        }
    }

    class RedoAction
    extends MoeAbstractAction {
        public RedoAction() {
            super("redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            try {
                editor.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                Debug.message((String)"moe: cannot redo...");
            }
            editor.updateUndoControls();
            editor.updateRedoControls();
        }
    }

    class CommentBlockAction
    extends MoeAbstractAction {
        public CommentBlockAction() {
            super("comment-block");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e);
            MoeActions.this.blockAction(this.getTextComponent(e), new CommentLineAction());
        }
    }

    class UncommentBlockAction
    extends MoeAbstractAction {
        public UncommentBlockAction() {
            super("uncomment-block");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e);
            MoeActions.this.blockAction(this.getTextComponent(e), new UncommentLineAction());
        }
    }

    class IndentBlockAction
    extends MoeAbstractAction {
        public IndentBlockAction() {
            super("indent-block");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e);
            MoeActions.this.blockAction(this.getTextComponent(e), new IndentLineAction());
        }
    }

    class DeindentBlockAction
    extends MoeAbstractAction {
        public DeindentBlockAction() {
            super("deindent-block");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e);
            MoeActions.this.blockAction(this.getTextComponent(e), new DeindentLineAction());
        }
    }

    class InsertMethodAction
    extends MoeAbstractAction {
        public InsertMethodAction() {
            super("insert-method");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e);
            MoeActions.this.insertTemplate(this.getTextComponent(e), "method");
        }
    }

    class IndentAction
    extends MoeAbstractAction {
        public IndentAction() {
            super("indent");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent textPane = this.getTextComponent(e);
            MoeEditor ed = this.getEditor(e);
            int converted = 0;
            if (ed.checkExpandTabs()) {
                converted = MoeActions.this.convertTabsToSpaces(textPane);
            }
            if (PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                MoeActions.this.doIndent(textPane, false);
            } else {
                MoeActions.this.insertSpacedTab(textPane);
            }
            if (converted > 0) {
                ed.writeMessage(Config.getString((String)"editor.info.tabsExpanded"));
            }
        }
    }

    class DeIndentAction
    extends MoeAbstractAction {
        public DeIndentAction() {
            super("de-indent");
        }

        public void actionPerformed(ActionEvent e) {
            int converted;
            JTextComponent textPane = this.getTextComponent(e);
            MoeEditor ed = this.getEditor(e);
            if (ed.checkExpandTabs() && (converted = MoeActions.this.convertTabsToSpaces(textPane)) > 0) {
                ed.writeMessage(Config.getString((String)"editor.info.tabsExpanded"));
            }
            MoeActions.this.doDeIndent(textPane);
        }
    }

    class NewLineAction
    extends MoeAbstractAction {
        public NewLineAction() {
            super("new-line");
        }

        public void actionPerformed(ActionEvent e) {
            Action action = (Action)MoeActions.this.actions.get("insert-break");
            action.actionPerformed(e);
            if (PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                JTextComponent textPane = this.getTextComponent(e);
                MoeActions.this.doIndent(textPane, true);
            }
        }
    }

    class CopyLineAction
    extends MoeAbstractAction {
        public CopyLineAction() {
            super("copy-line");
        }

        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-begin-line").actionPerformed(e);
            MoeActions.this.getActionByName("selection-down").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
            } else {
                MoeActions.this.getActionByName("copy-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class CutLineAction
    extends MoeAbstractAction {
        public CutLineAction() {
            super("cut-line");
        }

        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-begin-line").actionPerformed(e);
            MoeActions.this.getActionByName("selection-down").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class CutEndOfLineAction
    extends MoeAbstractAction {
        public CutEndOfLineAction() {
            super("cut-end-of-line");
        }

        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("selection-end-line").actionPerformed(e);
            JTextComponent textComponent = this.getTextComponent(e);
            String selection = textComponent.getSelectedText();
            if (selection == null) {
                MoeActions.this.getActionByName("selection-forward").actionPerformed(e);
            }
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(textComponent);
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class CutWordAction
    extends MoeAbstractAction {
        public CutWordAction() {
            super("cut-word");
        }

        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-previous-word").actionPerformed(e);
            MoeActions.this.getActionByName("selection-next-word").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class CutEndOfWordAction
    extends MoeAbstractAction {
        public CutEndOfWordAction() {
            super("cut-end-of-word");
        }

        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("selection-next-word").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class FindAction
    extends MoeAbstractAction {
        public FindAction() {
            super("find");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).find();
        }
    }

    class FindNextAction
    extends MoeAbstractAction {
        public FindNextAction() {
            super("find-next");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).findNext();
        }
    }

    class FindNextBackwardAction
    extends MoeAbstractAction {
        public FindNextBackwardAction() {
            super("find-next-backward");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).findNextBackward();
        }
    }

    class ReplaceAction
    extends MoeAbstractAction {
        public ReplaceAction() {
            super("replace");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).replace();
        }
    }

    class CompileAction
    extends MoeAbstractAction {
        public CompileAction() {
            super("compile");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).compile();
        }
    }

    class ToggleInterfaceAction
    extends MoeAbstractAction {
        public ToggleInterfaceAction() {
            super("toggle-interface-view");
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JComboBox) {
                this.getEditor(e).toggleInterface();
            } else {
                this.getEditor(e).toggleInterfaceMenu();
            }
        }
    }

    class ToggleBreakPointAction
    extends MoeAbstractAction {
        public ToggleBreakPointAction() {
            super("toggle-breakpoint");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).toggleBreakpoint();
        }
    }

    class KeyBindingsAction
    extends MoeAbstractAction {
        public KeyBindingsAction() {
            super("key-bindings");
        }

        public void actionPerformed(ActionEvent e) {
            FunctionDialog dlg = new FunctionDialog(this.getEditor(e), MoeActions.this.actionTable, MoeActions.this.categories, MoeActions.this.categoryIndex);
            dlg.setVisible(true);
        }
    }

    class PreferencesAction
    extends MoeAbstractAction {
        public PreferencesAction() {
            super("preferences");
        }

        public void actionPerformed(ActionEvent e) {
            PrefMgrDialog.showDialog((int)0);
        }
    }

    class AboutAction
    extends MoeAbstractAction {
        public AboutAction() {
            super("about-editor");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(this.getEditor(e), new String[]{"Moe", "Version 2.0", " ", "Moe is the editor of the BlueJ programming environment.", "Written by Michael K\u00f6lling (mik@bluej.org)."}, "About Moe", 1);
        }
    }

    class DescribeKeyAction
    extends MoeAbstractAction {
        public DescribeKeyAction() {
            super("describe-key");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            textComponent.addKeyListener(MoeActions.this.keyCatcher);
            MoeEditor ed = this.getEditor(e);
            MoeActions.this.keyCatcher.setEditor(ed);
            ed.writeMessage("Describe key: ");
        }
    }

    class HelpMouseAction
    extends MoeAbstractAction {
        public HelpMouseAction() {
            super("help-mouse");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(this.getEditor(e), new String[]{"Moe Mouse Buttons:", " ", "left button:", "   click: place cursor", "   double-click: select word", "   triple-click: select line", "   drag: make selection", " ", "right button:", "   (currently unused)"}, "Moe Mouse Buttons", 1);
        }
    }

    class ShowManualAction
    extends MoeAbstractAction {
        public ShowManualAction() {
            super("show-manual");
        }

        public void actionPerformed(ActionEvent e) {
            DialogManager.NYI((Component)this.getEditor(e));
        }
    }

    class GoToLineAction
    extends MoeAbstractAction {
        public GoToLineAction() {
            super("go-to-line");
        }

        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).goToLine();
        }
    }

    static interface LineAction {
        public void apply(Element var1, MoeSyntaxDocument var2);
    }

    class CommentLineAction
    implements LineAction {
        CommentLineAction() {
        }

        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            try {
                doc.insertString(lineStart, "// ", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class UncommentLineAction
    implements LineAction {
        UncommentLineAction() {
        }

        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getText(lineStart, lineEnd - lineStart);
                if (lineText.trim().startsWith("//")) {
                    int cnt = 0;
                    while (lineText.charAt(cnt) != '/') {
                        ++cnt;
                    }
                    if (lineText.charAt(cnt + 2) == ' ') {
                        doc.remove(lineStart, cnt + 3);
                    } else {
                        doc.remove(lineStart, cnt + 2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class IndentLineAction
    implements LineAction {
        IndentLineAction() {
        }

        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            try {
                doc.insertString(lineStart, MoeActions.spaces.substring(0, tabSize), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class DeindentLineAction
    implements LineAction {
        DeindentLineAction() {
        }

        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getText(lineStart, lineEnd - lineStart);
                String spacedTab = MoeActions.spaces.substring(0, tabSize);
                if (lineText.startsWith(spacedTab)) {
                    doc.remove(lineStart, tabSize);
                } else if (lineText.charAt(0) == '\t') {
                    doc.remove(lineStart, 1);
                } else {
                    int cnt = 0;
                    while (lineText.charAt(cnt) == ' ') {
                        ++cnt;
                    }
                    doc.remove(lineStart, cnt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class KeyCatcher
    extends KeyAdapter {
        MoeEditor editor;

        KeyCatcher() {
        }

        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 20 || keyCode == 16 || keyCode == 17 || keyCode == 157 || keyCode == 18 || keyCode == 65406 || keyCode == 65312 || keyCode == 144 || keyCode == 145 || keyCode == 0) {
                return;
            }
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            String modifierName = KeyEvent.getKeyModifiersText(key.getModifiers());
            String keyName = KeyEvent.getKeyText(keyCode);
            if (modifierName.length() > 0) {
                keyName = String.valueOf(modifierName) + "+" + keyName;
            }
            Keymap map = MoeActions.this.keymap;
            Action action = null;
            while (map != null && action == null) {
                action = map.getAction(key);
                map = map.getResolveParent();
            }
            if (action == null) {
                Object binding = MoeActions.this.componentInputMap.get(key);
                if (binding == null) {
                    this.editor.writeMessage(String.valueOf(keyName) + Config.getString((String)"editor.keypressed.keyIsNotBound"));
                } else {
                    this.editor.writeMessage(String.valueOf(keyName) + Config.getString((String)"editor.keypressed.callsTheFunction") + binding + "\"");
                }
            } else {
                String name = (String)action.getValue("Name");
                this.editor.writeMessage(String.valueOf(keyName) + Config.getString((String)"editor.keypressed.callsTheFunction") + name + "\"");
            }
            e.getComponent().removeKeyListener(MoeActions.this.keyCatcher);
            e.consume();
        }

        public void setEditor(MoeEditor ed) {
            this.editor = ed;
        }
    }
}

