/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeActions;
import bluej.editor.moe.MoeEditor;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.FixedMultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class FunctionDialog
extends EscapeDialog
implements ActionListener,
ListSelectionListener,
ItemListener {
    static final String title = Config.getString((String)"editor.functions.title");
    static final String close = Config.getString((String)"close");
    static final String defaultsLabel = Config.getString((String)"editor.functions.defaults");
    static final String categoriesLabel = Config.getString((String)"editor.functions.categories");
    static final String keyLabel = Config.getString((String)"editor.functions.keys");
    static final String addKeyLabel = Config.getString((String)"editor.functions.addkey");
    static final String delKeyLabel = Config.getString((String)"editor.functions.delkey");
    private FocusManager focusMgr = FocusManager.getCurrentManager();
    private JButton defaultsButton;
    private JButton closeButton;
    private JButton addKeyButton;
    private JButton delKeyButton;
    private JComboBox categoryMenu;
    private JList functionList;
    private JList keyList;
    private FixedMultiLineLabel helpLabel;
    private MoeActions actions = MoeActions.getActions(null);
    private Action currentAction = null;
    private KeyStroke[] currentKeys = null;
    private Action[] functions;
    private int[] categoryIndex;
    private int firstDisplayedFunc;
    private Properties help;

    public FunctionDialog(JFrame parent, Action[] actiontable, String[] categories, int[] categoryIndex) {
        super((Frame)parent, title, true);
        this.functions = actiontable;
        this.categoryIndex = categoryIndex;
        this.makeDialog(categories);
        this.openHelpFile();
    }

    private void handleClose() {
        this.removeKeyListener();
        if (!this.actions.save()) {
            DialogManager.showError((Component)((Object)this), (String)"cannot-save-keys");
        }
        this.setVisible(false);
    }

    private void handleDefaults() {
        int answer = DialogManager.askQuestion((Component)((Object)this), (String)"default-keys");
        if (answer == 0) {
            this.actions.setDefaultKeyBindings();
            this.handleFuncListSelect();
        }
    }

    private void handleFuncListSelect() {
        int index = this.functionList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.currentAction = this.functions[this.firstDisplayedFunc + index];
        this.updateKeyList(this.currentAction);
        String helpText = this.getHelpText((String)this.currentAction.getValue("Name"));
        this.helpLabel.setText(helpText);
    }

    private void handleKeyListSelect() {
        this.delKeyButton.setEnabled(true);
    }

    private void handleAddKey() {
        this.helpLabel.setText(this.getHelpText("press-key"));
        this.addKeyListener();
    }

    private void handleDelKey() {
        if (this.currentKeys == null) {
            return;
        }
        int index = this.keyList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.actions.removeKeyStrokeBinding(this.currentKeys[index]);
        this.updateKeyList(this.currentAction);
    }

    private void updateKeyList(Action action) {
        this.currentKeys = this.actions.getKeyStrokesForAction(action);
        if (this.currentKeys == null) {
            this.clearKeyList();
        } else {
            String[] keyStrings = this.getKeyStrings(this.currentKeys);
            this.keyList.setListData(keyStrings);
            this.delKeyButton.setEnabled(false);
        }
        this.addKeyButton.setEnabled(true);
    }

    private String[] getKeyStrings(KeyStroke[] keys) {
        String[] keyStrings = new String[keys.length];
        int i = 0;
        while (i < keys.length) {
            int modifiers = keys[i].getModifiers();
            keyStrings[i] = KeyEvent.getKeyModifiersText(modifiers);
            if (keyStrings[i].length() > 0) {
                int n = i;
                keyStrings[n] = String.valueOf(keyStrings[n]) + "+";
            }
            int n = i;
            keyStrings[n] = String.valueOf(keyStrings[n]) + KeyEvent.getKeyText(keys[i].getKeyCode());
            ++i;
        }
        return keyStrings;
    }

    private void clearKeyList() {
        this.keyList.setListData(new String[0]);
    }

    private void clearHelpText() {
        this.helpLabel.setText(null);
    }

    private void openHelpFile() {
        this.help = Config.getMoeHelp();
    }

    private String getHelpText(String function) {
        if (this.help == null) {
            return null;
        }
        return this.help.getProperty(function);
    }

    private void addKeyListener() {
        FocusManager.setCurrentManager(new KeyCatcher());
    }

    private void removeKeyListener() {
        FocusManager.setCurrentManager(this.focusMgr);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.closeButton) {
            this.handleClose();
        } else if (src == this.defaultsButton) {
            this.handleDefaults();
        } else if (src == this.addKeyButton) {
            this.handleAddKey();
        } else if (src == this.delKeyButton) {
            this.handleDelKey();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        int selected = this.categoryMenu.getSelectedIndex();
        this.firstDisplayedFunc = this.categoryIndex[selected];
        int lastFunc = this.categoryIndex[selected + 1];
        String[] names = new String[lastFunc - this.firstDisplayedFunc];
        int i = this.firstDisplayedFunc;
        while (i < lastFunc) {
            names[i - this.firstDisplayedFunc] = (String)this.functions[i].getValue("Name");
            ++i;
        }
        this.functionList.setListData(names);
        this.clearKeyList();
        this.clearHelpText();
        this.addKeyButton.setEnabled(false);
        this.delKeyButton.setEnabled(false);
        this.currentAction = null;
        this.currentKeys = null;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        Object src = event.getSource();
        if (src == this.functionList) {
            this.handleFuncListSelect();
        } else if (src == this.keyList) {
            this.handleKeyListSelect();
        }
    }

    private void makeDialog(String[] categories) {
        JPanel mainPanel = (JPanel)this.getContentPane();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel helpPanel = new JPanel(new GridLayout());
        helpPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), BorderFactory.createLineBorder(Color.black)));
        this.helpLabel = new FixedMultiLineLabel(4);
        this.helpLabel.setBackground(MoeEditor.infoColor);
        helpPanel.add((Component)this.helpLabel);
        mainPanel.add((Component)helpPanel, "South");
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 1, 5, 5));
        this.closeButton = new JButton(close);
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.defaultsButton = new JButton(defaultsLabel);
        this.defaultsButton.addActionListener(this);
        buttonPanel.add(this.defaultsButton);
        JPanel buttonFramePanel = new JPanel();
        buttonFramePanel.setLayout(new BorderLayout(0, 0));
        buttonFramePanel.add((Component)buttonPanel, "North");
        controlPanel.add((Component)buttonFramePanel, "East");
        JPanel keyPanel = new JPanel();
        keyPanel.setLayout(new BorderLayout());
        keyPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), keyLabel));
        this.keyList = new JList();
        this.keyList.setSelectionMode(0);
        this.keyList.setPrototypeCellValue("shift-ctrl-delete");
        this.keyList.addListSelectionListener(this);
        this.keyList.setVisibleRowCount(4);
        JScrollPane scrollPane = new JScrollPane(this.keyList);
        keyPanel.add((Component)scrollPane, "Center");
        JPanel keyButtonPanel = new JPanel();
        this.addKeyButton = new JButton(addKeyLabel);
        this.addKeyButton.addActionListener(this);
        this.addKeyButton.setMargin(new Insets(2, 2, 2, 2));
        keyButtonPanel.add(this.addKeyButton);
        this.delKeyButton = new JButton(delKeyLabel);
        this.delKeyButton.addActionListener(this);
        this.delKeyButton.setMargin(new Insets(2, 2, 2, 2));
        keyButtonPanel.add(this.delKeyButton);
        keyPanel.add((Component)keyButtonPanel, "South");
        controlPanel.add((Component)keyPanel, "South");
        mainPanel.add((Component)controlPanel, "East");
        JPanel funcPanel = new JPanel(new BorderLayout());
        funcPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.functionList = new JList();
        this.functionList.setSelectionMode(0);
        this.functionList.addListSelectionListener(this);
        this.functionList.setVisibleRowCount(12);
        scrollPane = new JScrollPane(this.functionList);
        funcPanel.add((Component)scrollPane, "Center");
        JPanel categoryPanel = new JPanel();
        JLabel label = new JLabel(categoriesLabel);
        categoryPanel.add(label);
        this.categoryMenu = new JComboBox();
        this.categoryMenu.addItemListener(this);
        int i = 0;
        while (i < categories.length) {
            this.categoryMenu.addItem(categories[i]);
            ++i;
        }
        categoryPanel.add(this.categoryMenu);
        funcPanel.add((Component)categoryPanel, "North");
        mainPanel.add((Component)funcPanel, "Center");
        this.getRootPane().setDefaultButton(this.closeButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                FunctionDialog.this.setVisible(false);
            }
        });
        this.pack();
        DialogManager.centreDialog((JDialog)((Object)this));
    }

    class KeyCatcher
    extends FocusManager {
        KeyCatcher() {
        }

        public void processKeyEvent(Component focusedComponent, KeyEvent e) {
            if (e.getID() != 401) {
                return;
            }
            int keyCode = e.getKeyCode();
            if (keyCode == 20 || keyCode == 16 || keyCode == 17 || keyCode == 157 || keyCode == 18 || keyCode == 65406 || keyCode == 65312 || keyCode == 144 || keyCode == 145 || keyCode == 0) {
                return;
            }
            if (FunctionDialog.this.currentAction == null) {
                Debug.message((String)"FunctionDialog: currentAction is null...");
            } else {
                KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
                if (this.isPrintable(key, e)) {
                    FunctionDialog.this.helpLabel.setText(FunctionDialog.this.getHelpText("cannot-redefine"));
                } else {
                    FunctionDialog.this.actions.addActionForKeyStroke(key, FunctionDialog.this.currentAction);
                    FunctionDialog.this.handleFuncListSelect();
                }
            }
            e.consume();
            FunctionDialog.this.removeKeyListener();
        }

        private boolean isPrintable(KeyStroke key, KeyEvent e) {
            int modifiers = key.getModifiers();
            if (modifiers != 0 && modifiers != 1) {
                return false;
            }
            if (e.isActionKey()) {
                return false;
            }
            int keyCode = e.getKeyCode();
            return keyCode != 8 && keyCode != 127 && keyCode != 10 && keyCode != 9 && keyCode != 27;
        }

        public void focusNextComponent(Component c) {
        }

        public void focusPreviousComponent(Component c) {
        }
    }
}

