/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.utility.EscapeDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Finder
extends EscapeDialog
implements ActionListener,
DocumentListener {
    static final String title = Config.getString((String)"editor.find.title");
    static final String findLabel = Config.getString((String)"editor.find.find.label");
    static final String replaceLabel = Config.getString((String)"editor.find.replace.label");
    static final String UP = "up";
    static final String DOWN = "down";
    private boolean searchFound = true;
    private boolean replacing;
    private JButton findButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JButton cancelButton;
    private JTextField searchField;
    private JTextField replaceField;
    private JCheckBox wholeWord;
    private JCheckBox ignoreCase;
    private ButtonGroup directionButtons;
    private MoeEditor editor;

    public Finder() {
        super(null, title, true);
        this.makeDialog();
    }

    public void show(MoeEditor currentEditor, String selection, boolean replace) {
        this.editor = currentEditor;
        this.replacing = replace;
        this.getRootPane().setDefaultButton(this.findButton);
        if (selection != null && selection.length() > 0) {
            this.setSearchString(selection);
            this.replaceButton.setEnabled(true);
        } else {
            this.replaceButton.setEnabled(false);
        }
        if (!this.replacing) {
            this.replaceField.setText("");
        }
        this.searchField.selectAll();
        this.searchField.requestFocus();
        this.setVisible(true);
    }

    private void find() {
        this.searchFound = this.editor.findString(this.getSearchString(), this.getSearchBack(), this.getIgnoreCase(), this.getWholeWord(), !this.searchFound);
        this.replaceButton.setEnabled(this.searchFound);
        if (this.searchFound && this.replacing) {
            this.getRootPane().setDefaultButton(this.replaceButton);
        }
    }

    private void replace() {
        String replaceText = this.smartFormat(this.editor.getSelectedText(), this.replaceField.getText());
        this.editor.insertText(replaceText, this.getSearchBack());
        this.find();
    }

    /*
     * Unable to fully structure code
     */
    private void replaceAll() {
        block4: {
            searchString = this.getSearchString();
            replaceString = this.replaceField.getText();
            count = 0;
            if (!this.getSearchBack()) ** GOTO lbl12
            while (this.editor.doFindBackward(searchString, this.getIgnoreCase(), this.getWholeWord(), false)) {
                this.editor.insertText(this.smartFormat(this.editor.getSelectedText(), replaceString), true);
                ++count;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                this.editor.insertText(this.smartFormat(this.editor.getSelectedText(), replaceString), false);
                ++count;
lbl12:
                // 2 sources

                ** while (this.editor.doFind((String)searchString, (boolean)this.getIgnoreCase(), (boolean)this.getWholeWord(), (boolean)false))
            }
        }
        if (count > 0) {
            this.editor.writeMessage(String.valueOf(Config.getString((String)"editor.replaceAll.replaced")) + count + Config.getString((String)"editor.replaceAll.intancesOf") + searchString);
        } else {
            this.editor.writeMessage(String.valueOf(Config.getString((String)"editor.replaceAll.string")) + searchString + Config.getString((String)"editor.replaceAll.notFoundNothingReplaced"));
        }
    }

    private String smartFormat(String original, String replacement) {
        if (original == null || replacement == null) {
            return replacement;
        }
        String search = this.getSearchString();
        if (!this.isLowerCase(replacement) || !this.isLowerCase(search)) {
            return replacement;
        }
        if (this.isUpperCase(original)) {
            return replacement.toUpperCase();
        }
        if (this.isTitleCase(original)) {
            return String.valueOf(Character.toTitleCase(replacement.charAt(0))) + replacement.substring(1);
        }
        return replacement;
    }

    public boolean isLowerCase(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isLowerCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isUpperCase(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isUpperCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isTitleCase(String s) {
        if (s.length() < 2) {
            return false;
        }
        return Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1));
    }

    public void setSearchString(String s) {
        this.searchField.setText(s);
    }

    public String getSearchString() {
        return this.searchField.getText();
    }

    private boolean getSearchBack() {
        return this.directionButtons.getSelection().getActionCommand() == UP;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase.isSelected();
    }

    public boolean getWholeWord() {
        return this.wholeWord.isSelected();
    }

    public void setSearchFound(boolean found) {
        this.searchFound = found;
    }

    public boolean getSearchFound() {
        return this.searchFound;
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.findButton) {
            this.find();
        } else if (src == this.replaceButton) {
            this.replace();
        } else if (src == this.replaceAllButton) {
            this.replaceAll();
        } else if (src == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void changedUpdate(DocumentEvent evt) {
    }

    public void insertUpdate(DocumentEvent evt) {
        this.findButton.setEnabled(true);
        this.replaceAllButton.setEnabled(true);
    }

    public void removeUpdate(DocumentEvent evt) {
        if (this.getSearchString().length() == 0) {
            this.findButton.setEnabled(false);
            this.replaceAllButton.setEnabled(false);
        }
    }

    private void makeDialog() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                Finder.this.setVisible(false);
            }
        });
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        JPanel findPanel = new JPanel(new BorderLayout());
        findPanel.add((Component)new JLabel(findLabel), "West");
        this.searchField = new JTextField(16);
        this.searchField.getDocument().addDocumentListener(this);
        findPanel.add((Component)this.searchField, "Center");
        textPanel.add(findPanel);
        textPanel.add(Box.createVerticalStrut(6));
        JPanel replacePanel = new JPanel(new BorderLayout());
        replacePanel.add((Component)new JLabel(replaceLabel), "West");
        this.replaceField = new JTextField(16);
        replacePanel.add((Component)this.replaceField, "Center");
        textPanel.add(replacePanel);
        textPanel.add(Box.createVerticalStrut(6));
        Box togglesBox = new Box(0);
        Box optionBox = new Box(1);
        this.ignoreCase = new JCheckBox(Config.getString((String)"editor.find.ignoreCase"), true);
        optionBox.add(this.ignoreCase);
        optionBox.add(Box.createVerticalStrut(6));
        this.wholeWord = new JCheckBox(Config.getString((String)"editor.find.wholeWord"));
        optionBox.add(this.wholeWord);
        togglesBox.add(optionBox);
        Box directionBox = new Box(1);
        this.directionButtons = new ButtonGroup();
        JRadioButton dirUp = new JRadioButton(Config.getString((String)"editor.find.up"));
        dirUp.setActionCommand(UP);
        this.directionButtons.add(dirUp);
        directionBox.add(dirUp);
        directionBox.add(Box.createVerticalStrut(6));
        JRadioButton dirDown = new JRadioButton(Config.getString((String)"editor.find.down"), true);
        dirDown.setActionCommand(DOWN);
        this.directionButtons.add(dirDown);
        directionBox.add(dirDown);
        togglesBox.add(directionBox);
        textPanel.add(togglesBox);
        this.getContentPane().add((Component)textPanel, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 0, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.findButton = new JButton(Config.getString((String)"editor.find.findNext"));
        this.findButton.setEnabled(false);
        buttonPanel.add(this.findButton);
        this.findButton.addActionListener(this);
        this.replaceButton = new JButton(Config.getString((String)"editor.find.replace"));
        buttonPanel.add(this.replaceButton);
        this.replaceButton.setEnabled(false);
        this.replaceButton.addActionListener(this);
        this.replaceAllButton = new JButton(Config.getString((String)"editor.find.replaceAll"));
        this.replaceAllButton.setEnabled(false);
        buttonPanel.add(this.replaceAllButton);
        this.replaceAllButton.addActionListener(this);
        this.cancelButton = new JButton(Config.getString((String)"close"));
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.getContentPane().add("East", buttonPanel);
        this.pack();
    }
}

