/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BField;
import bluej.extensions.BObject;
import bluej.extensions.DirectInvoker;
import bluej.extensions.Identifier;
import bluej.extensions.InvocationArgumentException;
import bluej.extensions.InvocationErrorException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.CallableView;
import bluej.views.MethodView;
import bluej.views.View;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.lang.reflect.Modifier;

public class BMethod {
    private Identifier parentId;
    private MethodView bluej_view;

    BMethod(Identifier aParentId, MethodView i_bluej_view) {
        this.parentId = aParentId;
        this.bluej_view = i_bluej_view;
    }

    public boolean matches(String methodName, Class[] parameter) {
        if (methodName == null) {
            return false;
        }
        if (!methodName.equals(this.bluej_view.getName())) {
            return false;
        }
        Class[] thisArgs = this.bluej_view.getParameters();
        if (thisArgs != null && thisArgs.length <= 0) {
            thisArgs = null;
        }
        if (parameter != null && parameter.length <= 0) {
            parameter = null;
        }
        if (thisArgs == null && parameter == null) {
            return true;
        }
        if (thisArgs == null || parameter == null) {
            return false;
        }
        if (thisArgs.length != parameter.length) {
            return false;
        }
        int index = 0;
        while (index < thisArgs.length) {
            if (!thisArgs[index].isAssignableFrom(parameter[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public Class[] getParameterTypes() {
        return this.bluej_view.getParameters();
    }

    public String getName() {
        return this.bluej_view.getName();
    }

    public Class getReturnType() {
        View aView = this.bluej_view.getReturnType();
        return aView.getViewClass();
    }

    public int getModifiers() {
        return this.bluej_view.getModifiers();
    }

    public Object invoke(BObject onThis, Object[] params) throws ProjectNotOpenException, PackageNotFoundException, InvocationArgumentException, InvocationErrorException {
        PkgMgrFrame pkgFrame;
        DirectInvoker invoker;
        DebuggerObject result;
        ObjectWrapper instanceWrapper = null;
        if (onThis != null) {
            instanceWrapper = onThis.getObjectWrapper();
        }
        if ((result = (invoker = new DirectInvoker(pkgFrame = this.parentId.getPackageFrame(), (CallableView)this.bluej_view)).invokeMethod(instanceWrapper, params)) == null) {
            return null;
        }
        String resultName = invoker.getResultName();
        ObjectReference objRef = result.getObjectReference();
        ReferenceType type = objRef.referenceType();
        Field thisField = type.fieldByName("result");
        if (thisField == null) {
            return null;
        }
        return BField.doGetVal(pkgFrame, resultName, objRef.getValue(thisField));
    }

    public String toString() {
        Class[] signature = this.getParameterTypes();
        String sig = "";
        int i = 0;
        while (i < signature.length) {
            sig = String.valueOf(sig) + signature[i].getName() + (i == signature.length - 1 ? "" : ", ");
            ++i;
        }
        String mod = Modifier.toString(this.getModifiers());
        if (mod.length() > 0) {
            mod = String.valueOf(mod) + " ";
        }
        return String.valueOf(mod) + this.getReturnType() + " " + this.getName() + "(" + sig + ")";
    }
}

