/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.jdi.JdiObject;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BObject;
import bluej.extensions.Identifier;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.views.FieldView;
import bluej.views.View;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.lang.reflect.Field;

public class BField {
    private final FieldView bluej_view;
    private final Identifier parentId;

    BField(Identifier aParentId, FieldView i_bluej_view) {
        this.parentId = aParentId;
        this.bluej_view = i_bluej_view;
    }

    public boolean matches(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        return fieldName.equals(this.getName());
    }

    public String getName() {
        return this.bluej_view.getName();
    }

    public Class getType() {
        return this.bluej_view.getType().getViewClass();
    }

    public Field getJavaField() {
        return this.bluej_view.getField();
    }

    public int getModifiers() {
        return this.bluej_view.getModifiers();
    }

    private Object getStaticField() throws ProjectNotOpenException, PackageNotFoundException {
        DebuggerClass debuggerClass;
        Package bluejPkg = this.parentId.getBluejPackage();
        PkgMgrFrame aFrame = this.parentId.getPackageFrame();
        String wantFieldName = this.getName();
        View parentView = this.bluej_view.getDeclaringView();
        String className = parentView.getQualifiedName();
        try {
            debuggerClass = bluejPkg.getDebugger().getClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            Debug.message((String)("BField.getStatucField: Class=" + className + " Field=" + wantFieldName + " WARNING: cannod get debuggerClass"));
            return null;
        }
        int staticCount = debuggerClass.getStaticFieldCount();
        DebuggerObject debugObj = null;
        int index = 0;
        while (index < staticCount) {
            if (wantFieldName.equals(debuggerClass.getStaticFieldName(index))) {
                debugObj = debuggerClass.getStaticFieldObject(index);
                break;
            }
            ++index;
        }
        if (debugObj == null) {
            return null;
        }
        ObjectReference objRef = debugObj.getObjectReference();
        if (objRef == null) {
            return null;
        }
        return BField.doGetVal(aFrame, wantFieldName, objRef);
    }

    public Object getValue(BObject onThis) throws ProjectNotOpenException, PackageNotFoundException {
        if (onThis == null) {
            return this.getStaticField();
        }
        ObjectReference objRef = onThis.getObjectReference();
        ReferenceType type = objRef.referenceType();
        com.sun.jdi.Field thisField = type.fieldByName(this.bluej_view.getName());
        if (thisField == null) {
            return null;
        }
        PkgMgrFrame aFrame = onThis.getPackageFrame();
        return BField.doGetVal(aFrame, this.bluej_view.getName(), objRef.getValue(thisField));
    }

    static Object doGetVal(PkgMgrFrame packageFrame, String instanceName, Value val) {
        if (val == null) {
            return null;
        }
        if (val instanceof StringReference) {
            return ((StringReference)val).value();
        }
        if (val instanceof BooleanValue) {
            return new Boolean(((BooleanValue)val).value());
        }
        if (val instanceof ByteValue) {
            return new Byte(((ByteValue)val).value());
        }
        if (val instanceof CharValue) {
            return new Character(((CharValue)val).value());
        }
        if (val instanceof DoubleValue) {
            return new Double(((DoubleValue)val).value());
        }
        if (val instanceof FloatValue) {
            return new Float(((FloatValue)val).value());
        }
        if (val instanceof IntegerValue) {
            return new Integer(((IntegerValue)val).value());
        }
        if (val instanceof LongValue) {
            return new Long(((LongValue)val).value());
        }
        if (val instanceof ShortValue) {
            return new Short(((ShortValue)val).value());
        }
        if (val instanceof ObjectReference) {
            ObjectWrapper objWrap = ObjectWrapper.getWrapper((PkgMgrFrame)packageFrame, (ObjectBench)packageFrame.getObjectBench(), (DebuggerObject)JdiObject.getDebuggerObject((ObjectReference)((ObjectReference)val)), (String)instanceName);
            return objWrap.getBObject();
        }
        return val.toString();
    }
}

