/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public abstract class SplashLabel
extends JComponent {
    private BufferedImage image;

    public SplashLabel(String imageName) {
        this.loadImage(imageName);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension();
        if (this.image != null) {
            prefSize.setSize(this.image.getWidth(), this.image.getHeight());
        }
        return prefSize;
    }

    private void loadImage(String imageName) {
        URL splashURL = this.getClass().getResource(imageName);
        if (splashURL == null) {
            System.out.println("cannot find splash image: " + imageName);
            return;
        }
        try {
            this.image = ImageIO.read(splashURL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

