/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJLabel;
import bluej.GreenfootLabel;
import bluej.SplashLabel;
import bluej.SplashWindow;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Properties;

public class Boot {
    public static final int BLUEJ_VERSION_MAJOR = 2;
    public static final int BLUEJ_VERSION_MINOR = 1;
    public static final int BLUEJ_VERSION_RELEASE = 1;
    public static final String BLUEJ_VERSION_SUFFIX = "";
    public static final int BLUEJ_VERSION_NUMBER = 2101;
    public static final String BLUEJ_VERSION = "2.1.1";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 2.1.1";
    public static String GREENFOOT_VERSION = " 0.3.0";
    private static Boot instance;
    private static final int bluejBuildJars = 3;
    private static String[] bluejJars;
    private static String[] bluejUserJars;
    private static String[] greenfootUserJars;
    private static boolean isGreenfoot;
    private Properties commandLineProps;
    private String[] args;
    private File javaHomeDir;
    private File bluejLibDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;

    static {
        bluejJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr.jar", "MRJ141Stubs.jar"};
        bluejUserJars = new String[]{"bluejcore.jar", "junit.jar"};
        greenfootUserJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr.jar", "MRJ141Stubs.jar", "junit.jar", "bluej.jar"};
        isGreenfoot = false;
    }

    public static void main(String[] args) {
        if (args.length >= 1 && "-version".equals(args[0])) {
            System.out.println("BlueJ version 2.1.1 (Java version " + System.getProperty("java.version") + ")");
            System.out.println("--");
            System.out.println("virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            System.out.println("running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
            System.exit(-1);
        }
        Properties commandLineProps = Boot.processCommandLineProperties(args);
        isGreenfoot = commandLineProps.getProperty("greenfoot", "false").equals("true");
        SplashLabel image = null;
        if (isGreenfoot) {
            image = new GreenfootLabel();
            bluejUserJars = greenfootUserJars;
        } else {
            image = new BlueJLabel();
        }
        SplashWindow splash = new SplashWindow(image);
        instance = new Boot(args, commandLineProps);
        instance.bootBluej();
        splash.dispose();
    }

    public static Boot getInstance() {
        return instance;
    }

    private Boot(String[] args, Properties props) {
        this.args = args;
        this.commandLineProps = props;
    }

    public String[] getArgs() {
        return this.args;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public File getBluejLibDir() {
        return this.bluejLibDir;
    }

    public File getJunitLib() {
        File risul = new File(this.bluejLibDir, "junit.jar");
        if (!risul.canRead()) {
            throw new IllegalStateException("junit.jar is missing or unreadable");
        }
        return risul;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader runtimeLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> mainClass = Class.forName("bluej.Main", true, runtimeLoader);
            mainClass.newInstance();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        this.bluejLibDir = this.calculateBluejLibDir();
        try {
            this.runtimeClassPath = this.getKnownJars(this.bluejLibDir, bluejJars, true);
            this.runtimeUserClassPath = this.getKnownJars(this.bluejLibDir, bluejUserJars, false);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private File calculateBluejLibDir() {
        File bluejDir = null;
        String bootFullName = this.getClass().getResource("Boot.class").getFile();
        int classIndex = bootFullName.indexOf("!");
        String bootName = null;
        if (classIndex < 0) {
            File startingDir = new File(bootFullName).getParentFile();
            while (startingDir != null && !new File(startingDir.getParentFile(), "lib").isDirectory()) {
                startingDir = startingDir.getParentFile();
            }
            bluejDir = startingDir == null ? null : new File(startingDir.getParentFile(), "lib");
        } else {
            bootName = bootFullName.substring(0, classIndex);
            bootName = this.getURLPath(bootName);
            File finalFile = new File(bootName);
            bluejDir = finalFile.getParentFile();
        }
        return bluejDir;
    }

    private String getURLPath(String url) {
        if (!url.startsWith("file:")) {
            throw new IllegalStateException("Unexpected format of jar file URL (class Boot.java): " + url);
        }
        url = url.substring(5);
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            return null;
        }
    }

    private URL[] getKnownJars(File libDir, String[] jars, boolean isSystem) throws MalformedURLException {
        URL toolsURL;
        File classesDir;
        boolean useClassesDir = this.commandLineProps.getProperty("useclassesdir", "false").equals("true");
        int startJar = 0;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if ((isSystem || isGreenfoot) && useClassesDir && (classesDir = new File(libDir.getParentFile(), "classes")).isDirectory()) {
            urlList.add(classesDir.toURI().toURL());
            startJar = 3;
        }
        int i = startJar;
        while (i < jars.length) {
            File toAdd = new File(libDir, jars[i]);
            if (!toAdd.canRead()) {
                throw new IllegalStateException("required jar is missing or unreadable: " + toAdd);
            }
            urlList.add(toAdd.toURI().toURL());
            ++i;
        }
        if (isSystem && (toolsURL = this.getToolsURL()) != null) {
            urlList.add(toolsURL);
        }
        return urlList.toArray(new URL[0]);
    }

    private boolean hasValidExtension(File aFile) {
        if (aFile == null) {
            return false;
        }
        if (aFile.getName().endsWith(".jar")) {
            return true;
        }
        return aFile.getName().endsWith(".zip");
    }

    private URL getToolsURL() throws MalformedURLException {
        String osname = System.getProperty("os.name", BLUEJ_VERSION_SUFFIX);
        if (osname.startsWith("Mac")) {
            return null;
        }
        File toolsFile = new File(this.javaHomeDir, "lib/tools.jar");
        if (toolsFile.canRead()) {
            return toolsFile.toURI().toURL();
        }
        File parentDir = this.javaHomeDir.getParentFile();
        toolsFile = new File(parentDir, "lib/tools.jar");
        if (toolsFile.canRead()) {
            return toolsFile.toURI().toURL();
        }
        System.err.println("class Boot: tools.jar not found. Potential problem for execution.");
        return null;
    }

    private static Properties processCommandLineProperties(String[] args) {
        Properties props = new Properties();
        int i = 0;
        while (i < args.length) {
            String definition;
            int definitionEquals;
            if (args[i].startsWith("-") && (definitionEquals = (definition = args[i].substring(1)).indexOf(61)) >= 0) {
                String propName = definition.substring(0, definitionEquals);
                String propValue = definition.substring(definitionEquals + 1);
                if (!propName.equals(BLUEJ_VERSION_SUFFIX) && !propValue.equals(BLUEJ_VERSION_SUFFIX)) {
                    props.put(propName, propValue);
                }
            }
            ++i;
        }
        return props;
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }
}

