/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.JavaNames;
import bluej.utility.PackageFileView;
import bluej.utility.filefilter.DirectoryFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;

class PackageChooser
extends JFileChooser {
    static final Icon classIcon = Config.getImageAsIcon("image.filechooser.classIcon");
    static final Icon packageIcon = Config.getImageAsIcon("image.filechooser.packageIcon");
    static final String previewLine1 = Config.getString("utility.packageChooser.previewPane1");
    static final String previewLine2 = Config.getString("utility.packageChooser.previewPane2");
    PackageDisplay displayPanel;

    public PackageChooser(File startDirectory, boolean showArchives) {
        this(startDirectory, true, showArchives);
    }

    public PackageChooser(File startDirectory, boolean preview, boolean showArchives) {
        super(startDirectory);
        if (!showArchives) {
            this.setFileSelectionMode(1);
        } else {
            this.setFileSelectionMode(2);
        }
        this.setFileView(new PackageFileView());
        if (preview) {
            this.displayPanel = new PackageDisplay(startDirectory);
            this.setAccessory(this.displayPanel);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (!(e.getNewValue() instanceof File)) {
                        return;
                    }
                    File dir = (File)e.getNewValue();
                    if (dir == null) {
                        return;
                    }
                    if (dir.getName().equals("")) {
                        return;
                    }
                    PackageChooser.this.displayPanel.setDisplayDirectory(dir.getAbsoluteFile());
                }
            });
        }
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fname = f.getName();
        return fname.endsWith(".jar") || fname.endsWith(".JAR") || fname.endsWith(".zip") || fname.endsWith(".ZIP");
    }

    class PackageDisplay
    extends JList {
        final int headerLines = 3;
        int lastClass = 0;

        PackageDisplay(File displayDir) {
            this.setPreferredSize(new Dimension(150, 200));
            this.setCellRenderer(new MyListRenderer());
            this.setDisplayDirectory(displayDir);
        }

        protected void processMouseEvent(MouseEvent e) {
        }

        protected void processMouseMotionEvent(MouseEvent e) {
        }

        void setDisplayDirectory(File displayDir) {
            if (displayDir == null) {
                return;
            }
            int maxDisplay = 3;
            File[] subDirs = displayDir.listFiles(new DirectoryFilter());
            File[] srcFiles = displayDir.listFiles(new JavaSourceFilter());
            ArrayList<String> listVec = new ArrayList<String>();
            listVec.add(previewLine1);
            listVec.add(previewLine2);
            listVec.add(" ");
            if (subDirs != null) {
                this.lastClass = 0;
                while (this.lastClass < srcFiles.length && this.lastClass < maxDisplay) {
                    String javaFileName = JavaNames.stripSuffix(srcFiles[this.lastClass].getName(), ".java");
                    if (JavaNames.isIdentifier(javaFileName) && javaFileName.indexOf(36) == -1) {
                        listVec.add(javaFileName);
                    }
                    ++this.lastClass;
                }
            }
            if (srcFiles != null) {
                for (int i = 0; i < subDirs.length && i < maxDisplay; ++i) {
                    if (!JavaNames.isIdentifier(subDirs[i].getName())) continue;
                    listVec.add(subDirs[i].getName());
                    File[] subSubDirs = subDirs[i].listFiles(new DirectoryFilter());
                    if (subSubDirs == null) continue;
                    for (int j = 0; j < subSubDirs.length; ++j) {
                        if (!JavaNames.isIdentifier(subSubDirs[j].getName())) continue;
                        listVec.add(subDirs[i].getName() + "." + subSubDirs[j].getName());
                    }
                }
            }
            this.setListData(listVec.toArray());
        }

        class MyListRenderer
        extends DefaultListCellRenderer {
            MyListRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component s = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index >= 3) {
                    if (index - 3 < PackageDisplay.this.lastClass) {
                        ((JLabel)s).setIcon(classIcon);
                    } else {
                        ((JLabel)s).setIcon(packageIcon);
                    }
                }
                return s;
            }
        }
    }
}

