/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.extensions.BClass;
import bluej.extensions.ExtensionBridge;
import bluej.extmgr.MenuManager;
import bluej.graph.Moveable;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.SourceInfo;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.EditableTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.AbstractClassRole;
import bluej.pkgmgr.target.role.AppletClassRole;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.pkgmgr.target.role.EnumClassRole;
import bluej.pkgmgr.target.role.InterfaceClassRole;
import bluej.pkgmgr.target.role.StdClassRole;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileEditor;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.JavaUtils;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.applet.Applet;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import junit.framework.TestCase;

public class ClassTarget
extends EditableTarget
implements Moveable,
InvokeListener {
    static final int MIN_WIDTH = 60;
    static final int MIN_HEIGHT = 30;
    private static final String editStr = Config.getString("pkgmgr.classmenu.edit");
    private static final String compileStr = Config.getString("pkgmgr.classmenu.compile");
    private static final String inspectStr = Config.getString("pkgmgr.classmenu.inspect");
    private static final String removeStr = Config.getString("pkgmgr.classmenu.remove");
    private static final String createTestStr = Config.getString("pkgmgr.classmenu.createTest");
    private static final Color compbg = Config.getItemColour("colour.target.bg.compiling");
    private static final Color colBorder = Config.getItemColour("colour.target.border");
    private static final Color textfg = Config.getItemColour("colour.text.fg");
    private static String usesArrowMsg = Config.getString("pkgmgr.usesArrowMsg");
    private static String TEMP_FILE_EXTENSION = "-temp";
    private ClassRole role = new StdClassRole();
    private boolean openWithInterface = false;
    protected List breakpoints = new ArrayList();
    private SourceInfo sourceInfo = new SourceInfo();
    private boolean isAbstract;
    public int dfn;
    public int link;
    private boolean analysing = false;
    private int ghostX;
    private int ghostY;
    private int ghostWidth;
    private int ghostHeight;
    private boolean isDragging = false;
    private boolean isMoveable = true;
    private boolean hasSource = this.getSourceFile().canRead();
    private String typeParameters = "";
    private BClass singleBClass;
    protected JPopupMenu menu = null;
    boolean compiledMenu = false;

    public ClassTarget(Package pkg, String baseName) {
        this(pkg, baseName, null);
    }

    public ClassTarget(Package pkg, String baseName, String template) {
        super(pkg, baseName);
        if (template != null) {
            if (template.startsWith("applet")) {
                this.role = new AppletClassRole();
            } else if (template.startsWith("unittest")) {
                this.role = new UnitTestClassRole();
            } else if (template.startsWith("abstract")) {
                this.role = new AbstractClassRole();
            } else if (template.startsWith("interface")) {
                this.role = new InterfaceClassRole();
            } else if (template.startsWith("enum")) {
                this.role = new EnumClassRole();
            }
        }
        this.setGhostPosition(0, 0);
        this.setGhostSize(0, 0);
    }

    public final synchronized BClass getBClass() {
        if (this.singleBClass == null) {
            this.singleBClass = ExtensionBridge.newBClass((ClassTarget)this);
        }
        return this.singleBClass;
    }

    public String getQualifiedName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    public String getBaseName() {
        return this.getIdentifierName();
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public String getDisplayName() {
        return super.getDisplayName() + this.getTypeParameters();
    }

    private String getTypeParameters() {
        return this.typeParameters;
    }

    public void setState(int newState) {
        this.getPackage().getProject().removeInspectorInstance(this.getQualifiedName());
        super.setState(newState);
    }

    public ClassRole getRole() {
        return this.role;
    }

    protected void setRole(ClassRole newRole) {
        if (this.role == null || !newRole.getClass().equals(this.role.getClass())) {
            this.role = newRole;
        }
    }

    public void determineRole(Class cl) {
        this.isAbstract = false;
        if (cl != null) {
            this.isAbstract = Modifier.isAbstract(cl.getModifiers());
            Class junitClass = null;
            try {
                junitClass = cl.getClassLoader().loadClass("junit.framework.TestCase");
            }
            catch (ClassNotFoundException cnfe) {
                junitClass = TestCase.class;
            }
            Class appletClass = null;
            try {
                appletClass = cl.getClassLoader().loadClass("java.applet.Applet");
            }
            catch (ClassNotFoundException cnfe) {
                Class clazz = appletClass = Applet.class;
            }
            if (appletClass.isAssignableFrom(cl)) {
                this.setRole(new AppletClassRole());
            } else if (junitClass.isAssignableFrom(cl)) {
                this.setRole(new UnitTestClassRole());
            } else if (Modifier.isInterface(cl.getModifiers())) {
                this.setRole(new InterfaceClassRole());
            } else if (JavaUtils.getJavaUtils().isEnum(cl)) {
                this.setRole(new EnumClassRole());
            } else if (this.isAbstract) {
                this.setRole(new AbstractClassRole());
            } else {
                this.setRole(new StdClassRole());
            }
        } else {
            ClassInfo classInfo = this.sourceInfo.getInfoIfAvailable();
            if (classInfo != null) {
                if (classInfo.isApplet()) {
                    this.setRole(new AppletClassRole());
                } else if (classInfo.isUnitTest()) {
                    this.setRole(new UnitTestClassRole());
                } else if (classInfo.isInterface()) {
                    this.setRole(new InterfaceClassRole());
                } else if (classInfo.isEnum()) {
                    this.setRole(new EnumClassRole());
                } else if (classInfo.isAbstract()) {
                    this.setRole(new AbstractClassRole());
                } else if (!(this.role instanceof AppletClassRole) && !(this.role instanceof UnitTestClassRole)) {
                    this.setRole(new StdClassRole());
                }
            }
        }
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
        super.load(props, prefix);
        String type = props.getProperty(prefix + ".type");
        String intf = props.getProperty(prefix + ".showInterface");
        this.openWithInterface = Boolean.valueOf(intf);
        if ("AppletTarget".equals(type)) {
            this.setRole(new AppletClassRole());
        } else if ("UnitTestTarget".equals(type)) {
            this.setRole(new UnitTestClassRole());
        } else if ("AbstractTarget".equals(type)) {
            this.setRole(new AbstractClassRole());
        } else if ("InterfaceTarget".equals(type)) {
            this.setRole(new InterfaceClassRole());
        } else if ("EnumTarget".equals(type)) {
            this.setRole(new EnumClassRole());
        }
        this.getRole().load(props, prefix);
    }

    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        if (this.getRole().getRoleName() != null) {
            props.put(prefix + ".type", this.getRole().getRoleName());
        }
        if (this.editorOpen()) {
            this.openWithInterface = this.getEditor().isShowingInterface();
        }
        props.put(prefix + ".showInterface", new Boolean(this.openWithInterface).toString());
        this.getRole().save(props, 0, prefix);
    }

    public boolean upToDate() {
        File src = this.getSourceFile();
        File clss = this.getClassFile();
        if (!this.hasSourceCode()) {
            return true;
        }
        return clss.exists() && (!src.exists() || src.lastModified() <= clss.lastModified());
    }

    public void invalidate() {
        this.setState(1);
        Iterator it = this.dependents();
        while (it.hasNext()) {
            Dependency d = (Dependency)it.next();
            DependentTarget dependent = d.getFrom();
            dependent.setState(1);
        }
    }

    public boolean isInterface() {
        return this.getRole() instanceof InterfaceClassRole;
    }

    public boolean isUnitTest() {
        return this.getRole() instanceof UnitTestClassRole;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    Color getBackgroundColour() {
        if (this.state == 2) {
            return compbg;
        }
        return this.getRole().getBackgroundColour();
    }

    Color getBorderColour() {
        return colBorder;
    }

    Color getTextColour() {
        return textfg;
    }

    Font getFont() {
        return PrefMgr.getTargetFont();
    }

    public boolean hasSourceCode() {
        return this.hasSource;
    }

    public File getSourceFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".java");
    }

    public File getContextFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".ctxt");
    }

    public File getClassFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".class");
    }

    public FileFilter getInnerClassFiles() {
        return new InnerClassFileFilter();
    }

    public Editor getEditor() {
        return this.getEditor(this.openWithInterface);
    }

    private Editor getEditor(boolean showInterface) {
        if (this.editor == null && this.hasSourceCode()) {
            String filename = this.getSourceFile().getPath();
            String docFilename = this.getPackage().getProject().getDocumentationFile(filename);
            this.editor = EditorManager.getEditorManager().openClass(filename, docFilename, this.getBaseName(), (EditorWatcher)this, this.isCompiled(), this.breakpoints, (ClassLoader)this.getPackage().getProject().getClassLoader(), this.editorBounds);
            this.editor.showInterface(showInterface);
        }
        return this.editor;
    }

    public void ensureSaved() throws IOException {
        if (this.editor != null) {
            this.editor.save();
        }
    }

    private void inspect() {
        new Thread(){
            int state = 0;
            DebuggerClass clss;

            public void run() {
                switch (this.state) {
                    case 0: {
                        try {
                            this.clss = ClassTarget.this.getPackage().getDebugger().getClass(ClassTarget.this.getQualifiedName());
                            this.state = 1;
                            EventQueue.invokeLater(this);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        break;
                    }
                    case 1: {
                        ClassTarget.this.getPackage().getProject().getClassInspectorInstance(this.clss, ClassTarget.this.getPackage(), PkgMgrFrame.findFrame(ClassTarget.this.getPackage()));
                    }
                }
            }
        }.start();
    }

    public void modificationEvent(Editor editor) {
        this.invalidate();
        this.removeBreakpoints();
        this.sourceInfo.setSourceModified();
    }

    public void saveEvent(Editor editor) {
        ClassInfo info = this.analyseSource();
        if (info != null) {
            this.updateTargetFile(info);
        }
        this.determineRole(null);
    }

    public String breakpointToggleEvent(Editor editor, int lineNo, boolean set) {
        if (this.isCompiled()) {
            return this.getPackage().getDebugger().toggleBreakpoint(this.getQualifiedName(), lineNo, set);
        }
        return Config.getString("pkgmgr.breakpointMsg");
    }

    public void removeBreakpoints() {
        if (this.editor != null) {
            this.editor.removeBreakpoints();
        }
    }

    public void removeStepMark() {
        if (this.editor != null) {
            this.editor.removeStepMark();
        }
    }

    public boolean isCompiled() {
        return this.state == 0;
    }

    public void compile(Editor editor) {
        this.getPackage().compile(this);
    }

    public void endCompile() {
        Class cl = this.getPackage().loadClass(this.getQualifiedName());
        this.determineRole(cl);
    }

    public boolean generateSkeleton(String template) {
        if (template == null) {
            Debug.reportError("generate class skeleton error");
            return false;
        }
        boolean success = this.role.generateSkeleton(template, this.getPackage(), this.getBaseName(), this.getSourceFile().getPath());
        if (success) {
            this.setState(1);
            this.hasSource = true;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enforcePackage(String packageName) throws IOException {
        if (!JavaNames.isQualifiedIdentifier(packageName)) {
            throw new IllegalArgumentException();
        }
        ClassInfo info = this.sourceInfo.getInfo(this.getSourceFile(), this.getPackage());
        if (info == null) {
            return;
        }
        String semiReplacement = null;
        String nameReplacement = null;
        String pkgStatementReplacement = null;
        if (packageName.length() == 0) {
            if (!info.hasPackageStatement()) return;
            semiReplacement = "";
            nameReplacement = "";
            pkgStatementReplacement = "";
        } else if (info.hasPackageStatement()) {
            if (info.getPackage().equals(packageName)) {
                return;
            }
            nameReplacement = packageName;
        } else {
            semiReplacement = ";\n\n";
            nameReplacement = packageName;
            pkgStatementReplacement = "package ";
        }
        FileEditor fed = new FileEditor(this.getSourceFile());
        if (semiReplacement != null) {
            Selection selSemi = info.getPackageSemiSelection();
            fed.replaceSelection(selSemi, semiReplacement);
        }
        if (nameReplacement != null) {
            Selection selName = info.getPackageNameSelection();
            fed.replaceSelection(selName, nameReplacement);
        }
        if (pkgStatementReplacement != null) {
            Selection selStatement = info.getPackageStatementSelection();
            fed.replaceSelection(selStatement, pkgStatementReplacement);
        }
        fed.save();
    }

    public ClassInfo analyseSource() {
        if (this.analysing) {
            return null;
        }
        this.analysing = true;
        ClassInfo info = this.sourceInfo.getInfo(this.getSourceFile(), this.getPackage());
        if (info != null) {
            this.determineRole(null);
            this.setTypeParameters(info);
            this.analyseDependencies(info);
        }
        this.analysing = false;
        return info;
    }

    private void updateTargetFile(ClassInfo info) {
        if (this.analyseClassName(info)) {
            if (this.nameEqualsIgnoreCase(info.getName())) {
                this.doClassNameChange(info.getName() + TEMP_FILE_EXTENSION);
            }
            this.doClassNameChange(info.getName());
        }
        if (this.analysePackageName(info)) {
            this.doPackageNameChange(info.getPackage());
        }
    }

    public void setTypeParameters(ClassInfo info) {
        String newTypeParameters = "";
        if (info.hasTypeParameter()) {
            Iterator i = info.getTypeParameterTexts().iterator();
            newTypeParameters = "<" + i.next();
            while (i.hasNext()) {
                newTypeParameters = newTypeParameters + "," + i.next();
            }
            newTypeParameters = newTypeParameters + ">";
        }
        if (!newTypeParameters.equals(this.typeParameters)) {
            this.typeParameters = newTypeParameters;
            this.updateSize();
        }
    }

    public boolean analyseClassName(ClassInfo info) {
        String newName = info.getName();
        if (newName == null || newName.length() == 0) {
            return false;
        }
        return !this.getBaseName().equals(newName);
    }

    public boolean analysePackageName(ClassInfo info) {
        String newName = info.getPackage();
        return !this.getPackage().getQualifiedName().equals(newName);
    }

    public void analyseDependencies(ClassInfo info) {
        String name;
        DependentTarget superclass;
        this.removeInheritDependencies();
        this.unflagAllOutDependencies();
        if (info.getSuperclass() != null && (superclass = this.getPackage().getDependentTarget(info.getSuperclass())) != null) {
            this.getPackage().addDependency(new ExtendsDependency(this.getPackage(), this, superclass), false);
        }
        List vect = info.getImplements();
        Iterator it = vect.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            DependentTarget interfce = this.getPackage().getDependentTarget(name);
            if (interfce == null) continue;
            this.getPackage().addDependency(new ImplementsDependency(this.getPackage(), this, interfce), false);
        }
        vect = info.getUsed();
        it = vect.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            DependentTarget used = this.getPackage().getDependentTarget(name);
            if (used == null || used.getAssociation() == this || this.getAssociation() == used) continue;
            this.getPackage().addDependency(new UsesDependency(this.getPackage(), this, used), true);
        }
        it = this.usesDependencies();
        while (it.hasNext()) {
            UsesDependency usesDep = (UsesDependency)it.next();
            if (usesDep.isFlagged()) continue;
            this.getPackage().setStatus(usesArrowMsg + usesDep);
        }
    }

    private boolean doClassNameChange(String newName) {
        if (this.getPackage().getTarget(newName) != null) {
            this.getPackage().showError("duplicate-name");
            return false;
        }
        File newSourceFile = new File(this.getPackage().getPath(), newName + ".java");
        File oldSourceFile = this.getSourceFile();
        if (FileUtility.copyFile(oldSourceFile, newSourceFile)) {
            this.getPackage().updateTargetIdentifier(this, this.getIdentifierName(), newName);
            this.getEditor().changeName(newName, newSourceFile.getPath());
            this.role.prepareFilesForRemoval(this, oldSourceFile.getPath(), this.getClassFile().getPath(), this.getContextFile().getPath());
            this.setIdentifierName(newName);
            this.setDisplayName(newName);
            this.updateSize();
            return true;
        }
        return false;
    }

    private boolean nameEqualsIgnoreCase(String newName) {
        return this.getBaseName().equalsIgnoreCase(newName);
    }

    private void doPackageNameChange(String newName) {
        Project proj = this.getPackage().getProject();
        Package dstPkg = proj.getPackage(newName);
        if (dstPkg == null) {
            DialogManager.showError(null, "package-name-invalid");
        } else if (dstPkg.getTarget(this.getBaseName()) != null) {
            DialogManager.showError(null, "package-name-clash");
        } else if (DialogManager.askQuestion(null, "package-name-changed") == 0) {
            dstPkg.importFile(this.getSourceFile());
            this.prepareForRemoval();
            this.getPackage().removeTarget(this);
            this.close();
            return;
        }
        try {
            this.enforcePackage(this.getPackage().getQualifiedName());
            this.getEditor().reloadFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private void updateSize() {
        int width = ClassTarget.calculateWidth(this.getDisplayName());
        this.setSize(width, this.getHeight());
        this.repaint();
    }

    public void popupMenu(int x, int y) {
        Class cl = null;
        PackageEditor editor = this.getPackage().getEditor();
        if (this.state == 0) {
            try {
                cl = this.getPackage().loadClass(this.getQualifiedName());
            }
            catch (LinkageError le) {
                Debug.message(le.toString());
                if (this.hasSourceCode()) {
                    this.getClassFile().delete();
                    this.invalidate();
                }
                cl = null;
            }
        }
        if (this.menu != null) {
            editor.remove(this.menu);
        }
        if (this.state == 0) {
            this.menu = this.createMenu(cl);
            editor.add(this.menu);
        } else {
            this.menu = this.createMenu(null);
            editor.add(this.menu);
        }
        if (this.menu != null) {
            this.menu.show(editor, x, y);
        }
    }

    protected JPopupMenu createMenu(Class cl) {
        JPopupMenu menu = new JPopupMenu(this.getBaseName() + " operations");
        this.role.createRoleMenu(menu, this, cl, this.state);
        if (cl != null && this.role.createClassConstructorMenu(menu, this, cl)) {
            menu.addSeparator();
        }
        if (cl != null && this.role.createClassStaticMenu(menu, this, cl)) {
            menu.addSeparator();
        }
        this.role.addMenuItem(menu, new EditAction(), this.hasSourceCode());
        this.role.addMenuItem(menu, new CompileAction(), this.hasSourceCode());
        this.role.addMenuItem(menu, new InspectAction(), cl != null);
        this.role.addMenuItem(menu, new RemoveAction(), true);
        this.role.createRoleMenuEnd(menu, this, this.state);
        MenuManager menuManager = new MenuManager(menu);
        menuManager.setAttachedObject(this);
        menuManager.addExtensionMenu(this.getPackage().getProject());
        return menu;
    }

    public void doubleClick(MouseEvent evt) {
        this.open();
    }

    public int getGhostX() {
        return this.ghostX;
    }

    public int getGhostY() {
        return this.ghostY;
    }

    public int getGhostWidth() {
        return this.ghostWidth;
    }

    public int getGhostHeight() {
        return this.ghostHeight;
    }

    public void setGhostPosition(int deltaX, int deltaY) {
        this.ghostX = this.getX() + deltaX;
        this.ghostY = this.getY() + deltaY;
    }

    public void setGhostSize(int deltaX, int deltaY) {
        this.ghostWidth = Math.max(this.getWidth() + deltaX, 60);
        this.ghostHeight = Math.max(this.getHeight() + deltaY, 30);
    }

    public void setPositionToGhost() {
        super.setPos(this.ghostX, this.ghostY);
        this.setSize(this.ghostWidth, this.ghostHeight);
        this.isDragging = false;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.setGhostPosition(0, 0);
    }

    public void setSize(int width, int height) {
        super.setSize(Math.max(width, 60), Math.max(height, 30));
        this.setGhostSize(0, 0);
    }

    private void prepareForRemoval() {
        if (this.editor != null) {
            this.editor.close();
        }
        Iterator it = this.getPackage().getVertices();
        while (it.hasNext()) {
            DependentTarget d;
            Object o = it.next();
            if (!(o instanceof DependentTarget) || !this.equals((d = (DependentTarget)o).getAssociation())) continue;
            d.setAssociation(null);
        }
        this.invalidate();
        this.removeAllInDependencies();
        this.removeAllOutDependencies();
        this.prepareFilesForRemoval();
    }

    public void prepareFilesForRemoval() {
        File[] files;
        if (this.getSourceFile().exists() && (files = this.getPackage().getPath().listFiles(this.getInnerClassFiles())) != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        this.getRole().prepareFilesForRemoval(this, this.getSourceFile().getPath(), this.getClassFile().getPath(), this.getContextFile().getPath());
    }

    public void generateDoc() {
        this.getPackage().generateDocumentation(this);
    }

    public void remove() {
        this.prepareForRemoval();
        this.getPackage().removeClass(this);
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public void setIsMoveable(boolean isMoveable) {
        this.isMoveable = isMoveable;
    }

    public void executeMethod(MethodView mv) {
        this.getPackage().getEditor().raiseMethodCallEvent(this, mv);
    }

    public void callConstructor(ConstructorView cv) {
        this.getPackage().getEditor().raiseMethodCallEvent(this, cv);
    }

    private class InspectAction
    extends AbstractAction {
        public InspectAction() {
            this.putValue("Name", inspectStr);
        }

        public void actionPerformed(ActionEvent e) {
            ClassTarget.this.inspect();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", removeStr);
        }

        public void actionPerformed(ActionEvent e) {
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(ClassTarget.this.getPackage());
            if (pmf.askRemoveClass()) {
                ClassTarget.this.getPackage().getEditor().raiseRemoveTargetEvent(ClassTarget.this);
            }
        }
    }

    private class CompileAction
    extends AbstractAction {
        public CompileAction() {
            this.putValue("Name", compileStr);
        }

        public void actionPerformed(ActionEvent e) {
            ClassTarget.this.getPackage().compile(ClassTarget.this);
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", editStr);
        }

        public void actionPerformed(ActionEvent e) {
            ClassTarget.this.open();
        }
    }

    public class CreateTestAction
    extends AbstractAction {
        public CreateTestAction() {
            this.putValue("Name", createTestStr);
        }

        public void actionPerformed(ActionEvent e) {
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(ClassTarget.this.getPackage());
            if (pmf != null) {
                String testClassName = ClassTarget.this.getIdentifierName() + "Test";
                pmf.createNewClass(testClassName, "unittest", true);
                Target target = ClassTarget.this.getPackage().getTarget(testClassName);
                ClassTarget ct = null;
                if (target instanceof ClassTarget && (ct = (ClassTarget)target) != null && ct.isUnitTest()) {
                    ClassTarget.this.setAssociation((DependentTarget)ClassTarget.this.getPackage().getTarget(ClassTarget.this.getIdentifierName() + "Test"));
                }
                ClassTarget.this.updateAssociatePosition();
                ClassTarget.this.getPackage().getEditor().revalidate();
                ClassTarget.this.getPackage().getEditor().repaint();
            }
        }
    }

    class InnerClassFileFilter
    implements FileFilter {
        InnerClassFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().startsWith(ClassTarget.this.getBaseName() + "$");
        }
    }
}

