/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.Config;
import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;

public class ClassTargetPainter {
    private static final int HANDLE_SIZE = 20;
    private static final String STEREOTYPE_OPEN = "<<";
    private static final String STEREOTYPE_CLOSE = ">>";
    private static final Color textcolor = Config.getItemColour("colour.text.fg");
    private static final Color borderColor = Config.getItemColour("colour.target.border");
    private static final Color compileColor = Config.getItemColour("colour.target.bg.compiling");
    private static final Color stripeColor = Config.getItemColour("colour.target.stripes");
    private static final Image brokenImage = Config.getImageAsIcon("image.class.broken").getImage();
    private static final Font targetFont = PrefMgr.getTargetFont();
    private static final int TEXT_HEIGHT = GraphPainterStdImpl.TEXT_HEIGHT;
    private static final int TEXT_BORDER = 4;
    private static final Color[] shadowColours = GraphPainterStdImpl.shadowColours;
    private static final AlphaComposite alphaComposite = GraphPainterStdImpl.alphaComposite;
    private static Composite oldComposite;

    public void paint(Graphics2D g, ClassTarget classTarget, boolean hasFocus) {
        g.translate(classTarget.getX(), classTarget.getY());
        int width = classTarget.getWidth();
        int height = classTarget.getHeight();
        this.drawSkeleton(g, classTarget, width, height);
        this.drawShadow(g, width, height);
        this.drawUMLStyle(g, classTarget, hasFocus, width, height);
        g.translate(-classTarget.getX(), -classTarget.getY());
    }

    public void paintGhost(Graphics2D g, Target target, boolean hasFocus) {
        ClassTarget classTarget = (ClassTarget)target;
        oldComposite = g.getComposite();
        g.translate(classTarget.getGhostX(), classTarget.getGhostY());
        int width = classTarget.getGhostWidth();
        int height = classTarget.getGhostHeight();
        g.setComposite(alphaComposite);
        this.drawSkeleton(g, classTarget, width, height);
        this.drawUMLStyle(g, classTarget, hasFocus, width, height);
        g.setComposite(oldComposite);
        g.translate(-classTarget.getGhostX(), -classTarget.getGhostY());
    }

    private void drawSkeleton(Graphics2D g, ClassTarget classTarget, int width, int height) {
        g.setColor(this.getBackgroundColour(classTarget));
        g.fillRect(0, 0, width, height);
    }

    private void drawUMLStyle(Graphics2D g, ClassTarget classTarget, boolean hasFocus, int width, int height) {
        String stereotype = classTarget.getRole().getStereotypeLabel();
        g.setColor(textcolor);
        int currentTextPosY = 2;
        if (stereotype != null) {
            String stereotypeLabel = STEREOTYPE_OPEN + stereotype + STEREOTYPE_CLOSE;
            Font stereotypeFont = targetFont.deriveFont((float)(targetFont.getSize() - 2));
            g.setFont(stereotypeFont);
            Utility.drawCentredText(g, stereotypeLabel, 4, currentTextPosY, width - 8, TEXT_HEIGHT);
            currentTextPosY += TEXT_HEIGHT - 2;
        }
        g.setFont(targetFont);
        Utility.drawCentredText(g, classTarget.getDisplayName(), 4, currentTextPosY, width - 8, TEXT_HEIGHT);
        this.drawWarnings(g, classTarget, width, height);
        g.setColor(borderColor);
        g.drawLine(0, currentTextPosY += TEXT_HEIGHT, width, currentTextPosY);
        boolean drawSelected = classTarget.isSelected() && hasFocus;
        this.drawBorder(g, drawSelected, width, height);
    }

    private void drawWarnings(Graphics2D g, ClassTarget classTarget, int width, int height) {
        String stereotype = classTarget.getRole().getStereotypeLabel();
        if (classTarget.getState() != 0) {
            g.setColor(stripeColor);
            int divider = stereotype == null ? 19 : 33;
            Utility.stripeRect(g, 0, divider, width, height - divider, 8, 3);
        }
        if (!classTarget.hasSourceCode()) {
            g.setColor(textcolor);
            g.setFont(targetFont.deriveFont((float)(targetFont.getSize() - 2)));
            Utility.drawCentredText(g, "(no source)", 4, height - 18, width - 8, TEXT_HEIGHT);
        } else if (!classTarget.getSourceInfo().isValid()) {
            g.drawImage(brokenImage, 4, height - 22, null);
        }
    }

    private void drawBorder(Graphics2D g, boolean selected, int width, int height) {
        int thickness = 1;
        if (selected) {
            thickness = 2;
            g.drawLine(width - 20 - 2, height, width, height - 20 - 2);
            g.drawLine(width - 20 + 2, height, width, height - 20 + 2);
        }
        Utility.drawThickRect(g, 0, 0, width, height, thickness);
    }

    private void drawShadow(Graphics2D g, int width, int height) {
        g.setColor(shadowColours[3]);
        g.drawLine(3, height + 1, width, height + 1);
        g.setColor(shadowColours[2]);
        g.drawLine(4, height + 2, width, height + 2);
        g.drawLine(width + 1, height + 2, width + 1, 3);
        g.setColor(shadowColours[1]);
        g.drawLine(5, height + 3, width + 1, height + 3);
        g.drawLine(width + 2, height + 3, width + 2, 4);
        g.setColor(shadowColours[0]);
        g.drawLine(6, height + 4, width + 2, height + 4);
        g.drawLine(width + 3, height + 3, width + 3, 5);
    }

    private Color getBackgroundColour(ClassTarget classTarget) {
        if (classTarget.getState() == 2) {
            return compileColor;
        }
        return classTarget.getRole().getBackgroundColour();
    }
}

