/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class ObjectInspector
extends Inspector {
    protected static final String inspectTitle = Config.getString("debugger.inspector.object.title");
    protected DebuggerObject obj;
    protected String objName;
    protected boolean queryArrayElementSelected = false;
    protected TreeSet arraySet = null;
    protected List indexToSlotList = null;
    private static final int VISIBLE_ARRAY_START = 40;
    private static final int VISIBLE_ARRAY_TAIL = 5;
    private static final int ARRAY_QUERY_SLOT_VALUE = -2;
    private static final int ARRAY_LENGTH_SLOT_VALUE = -1;

    public ObjectInspector(DebuggerObject obj, InspectorManager inspectorManager, String name, Package pkg, InvokerRecord ir, final JFrame parent) {
        super(inspectorManager, pkg, ir);
        this.obj = obj;
        this.objName = name == null ? "" : name;
        final ObjectInspector thisInspector = this;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ObjectInspector.this.makeFrame();
                ObjectInspector.this.pack();
                if (parent instanceof Inspector) {
                    DialogManager.tileWindow(thisInspector, parent);
                } else {
                    DialogManager.centreWindow(thisInspector, parent);
                }
            }
        });
    }

    protected void makeFrame() {
        this.setTitle(inspectTitle);
        this.setBorder(BlueJTheme.roundedShadowBorder);
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        String className = this.obj.getStrippedGenClassName();
        String fullTitle = this.objName + " : " + className;
        JLabel headerLabel = new JLabel(fullTitle, 0){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                int ascent = g.getFontMetrics().getAscent() + 1;
                g.drawLine(0, ascent, this.getWidth(), ascent);
            }
        };
        headerLabel.setAlignmentX(0.5f);
        header.add(headerLabel);
        header.add(Box.createVerticalStrut(5));
        header.add(new JSeparator());
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setOpaque(false);
        JScrollPane scrollPane = this.createFieldListScrollPane();
        mainPanel.add((Component)scrollPane, "Center");
        JPanel inspectAndGetButtons = this.createInspectAndGetButtons();
        mainPanel.add((Component)inspectAndGetButtons, "East");
        Insets insets = BlueJTheme.generalBorderWithStatusBar.getBorderInsets(mainPanel);
        mainPanel.setBorder(new EmptyBorder(insets));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        JButton button = this.createCloseButton();
        buttonPanel.add((Component)button, "East");
        JButton classButton = new JButton(showClassLabel);
        classButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectInspector.this.showClass();
            }
        });
        buttonPanel.add((Component)classButton, "West");
        bottomPanel.add(buttonPanel);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)header, "North");
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.getRootPane().setDefaultButton(button);
    }

    protected Object[] getListData() {
        if (this.obj.isArray()) {
            return this.compressArrayList(this.obj.getInstanceFields(true)).toArray(new Object[0]);
        }
        return this.obj.getInstanceFields(true).toArray(new Object[0]);
    }

    protected void listElementSelected(int slot) {
        if (this.obj.isArray() && (slot = this.indexToSlot(slot)) == -1) {
            this.setCurrentObj(null, null);
            this.setButtonsEnabled(false, false);
            return;
        }
        boolean bl = this.queryArrayElementSelected = slot == -2;
        if (this.queryArrayElementSelected) {
            this.setCurrentObj(null, null);
            if (this.obj.instanceFieldIsObject(0)) {
                this.setButtonsEnabled(true, false);
            } else {
                this.setButtonsEnabled(false, false);
            }
        } else if (this.obj.instanceFieldIsObject(slot)) {
            String newInspectedName = this.objName != null && !this.obj.isArray() ? this.objName + "." + this.obj.getInstanceFieldName(slot) : (this.objName != null && this.obj.isArray() ? this.objName + this.obj.getInstanceFieldName(slot) : this.obj.getInstanceFieldName(slot));
            this.setCurrentObj(this.obj.getInstanceFieldObject(slot), newInspectedName);
            if (this.obj.instanceFieldIsPublic(slot)) {
                this.setButtonsEnabled(true, true);
            } else {
                this.setButtonsEnabled(true, false);
            }
        } else {
            this.setCurrentObj(null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    protected void showClass() {
        this.inspectorManager.getClassInspectorInstance(this.obj.getClassRef(), this.pkg, this);
    }

    protected void prepareInspection() {
        if (this.queryArrayElementSelected) {
            this.selectArrayElement();
        }
    }

    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.obj);
        }
    }

    private void selectArrayElement() {
        block7: {
            String response = DialogManager.askString(this, "ask-index");
            if (response != null) {
                try {
                    int slot = Integer.parseInt(response);
                    if (slot >= 0 && slot < this.obj.getInstanceFieldCount()) {
                        if (this.obj.instanceFieldIsObject(slot)) {
                            this.setCurrentObj(this.obj.getInstanceFieldObject(slot), this.obj.getInstanceFieldName(slot));
                            this.setButtonsEnabled(true, false);
                        } else {
                            this.setButtonsEnabled(false, false);
                            this.update();
                        }
                        break block7;
                    }
                    DialogManager.showError(this, "out-of-bounds");
                }
                catch (NumberFormatException e) {
                    this.setCurrentObj(null, null);
                    DialogManager.showError(this, "cannot-access-element");
                }
            } else {
                this.setCurrentObj(null, null);
            }
        }
    }

    private List compressArrayList(List fullArrayFieldList) {
        fullArrayFieldList.add(0, "int length = " + fullArrayFieldList.size());
        this.indexToSlotList = new LinkedList();
        this.indexToSlotList.add(0, new Integer(-1));
        if (fullArrayFieldList.size() > 47) {
            int i;
            ArrayList newArray = new ArrayList();
            for (i = 0; i <= 40; ++i) {
                newArray.add(fullArrayFieldList.get(i));
                if (i >= 40) continue;
                this.indexToSlotList.add(new Integer(i));
            }
            newArray.add("[...]");
            this.indexToSlotList.add(new Integer(-2));
            for (i = 5; i > 0; --i) {
                newArray.add(fullArrayFieldList.get(fullArrayFieldList.size() - i));
                this.indexToSlotList.add(new Integer(fullArrayFieldList.size() - (i + 1)));
            }
            return newArray;
        }
        for (int i = 0; i < fullArrayFieldList.size(); ++i) {
            this.indexToSlotList.add(new Integer(i));
        }
        return fullArrayFieldList;
    }

    private int indexToSlot(int listIndexPosition) {
        Integer slot = (Integer)this.indexToSlotList.get(listIndexPosition);
        return slot;
    }

    protected int getPreferredRows() {
        return 8;
    }
}

