/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.testmgr.record.InvokerRecord;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AssertPanel
extends JPanel {
    private static final String equalToLabel = Config.getString("debugger.assert.equalTo");
    private static final String sameAsLabel = Config.getString("debugger.assert.sameAs");
    private static final String notSameAsLabel = Config.getString("debugger.assert.notSameAs");
    private static final String notNullLabel = Config.getString("debugger.assert.notNull");
    private static final String assertNullLabel = Config.getString("debugger.assert.null");
    private static final String equalToFloatingPointLabel = Config.getString("debugger.assert.equalToFloatingPoint");
    private static final String nullLabel = Config.getString("debugger.null");
    private JPanel standardPanel;
    private JPanel freeformPanel;
    private JLabel assertLabel;
    private JLabel deltaLabel;
    private JTextField assertData;
    private JTextField deltaData;
    private JComboBox assertCombo;
    protected JCheckBox assertCheckbox;
    private boolean userInput = false;
    private String[] labels = new String[]{equalToLabel, sameAsLabel, notSameAsLabel, notNullLabel, assertNullLabel, equalToFloatingPointLabel};
    private boolean[] firstLabelFieldNeeded = new boolean[]{true, true, true, false, false, true};
    private boolean[] secondFieldNeeded = new boolean[]{false, false, false, false, false, true};
    private String[] labelsAssertStatement = new String[]{"assertEquals", "assertSame", "assertNotSame", "assertNotNull", "assertNull", "assertEquals"};

    public AssertPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.assertCheckbox = new JCheckBox(Config.getString("debugger.assert.assertThat"), true);
        this.assertCheckbox.setAlignmentX(0.0f);
        this.assertCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                AssertPanel.this.signalUserInput();
                boolean isSelected = ie.getStateChange() == 1;
                AssertPanel.this.assertCombo.setEnabled(isSelected);
                AssertPanel.this.assertData.setEnabled(isSelected);
                AssertPanel.this.assertLabel.setEnabled(isSelected);
                AssertPanel.this.deltaData.setEnabled(isSelected);
                AssertPanel.this.deltaLabel.setEnabled(isSelected);
            }
        });
        this.standardPanel = new JPanel();
        this.standardPanel.setBorder(BlueJTheme.generalBorder);
        this.standardPanel.setLayout(new BoxLayout(this.standardPanel, 0));
        this.standardPanel.setAlignmentX(0.0f);
        this.assertLabel = new JLabel(Config.getString("debugger.assert.resultIs"));
        this.standardPanel.add(this.assertLabel);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.assertCombo = new JComboBox<String>(this.labels);
        this.assertCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                int index;
                AssertPanel.this.signalUserInput();
                if (ie.getStateChange() == 1 && (index = AssertPanel.this.findItemIndex((String)ie.getItem())) >= 0) {
                    boolean firstNeeded = AssertPanel.this.firstLabelFieldNeeded[index] && AssertPanel.this.assertCheckbox.isSelected();
                    boolean secondNeeded = AssertPanel.this.secondFieldNeeded[index] && AssertPanel.this.assertCheckbox.isSelected();
                    AssertPanel.this.assertData.setEnabled(firstNeeded);
                    AssertPanel.this.deltaLabel.setVisible(AssertPanel.this.secondFieldNeeded[index]);
                    AssertPanel.this.deltaData.setVisible(AssertPanel.this.secondFieldNeeded[index]);
                    AssertPanel.this.deltaLabel.setEnabled(secondNeeded);
                    AssertPanel.this.deltaData.setEnabled(secondNeeded);
                }
            }
        });
        this.assertData = new JTextField(14);
        this.assertData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AssertPanel.this.signalUserInput();
            }
        });
        this.deltaData = new JTextField(6);
        this.deltaData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AssertPanel.this.signalUserInput();
            }
        });
        this.standardPanel.add(this.assertCombo);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.deltaLabel = new JLabel(Config.getString("debugger.assert.delta"));
        this.standardPanel.add(this.assertData);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.standardPanel.add(this.deltaLabel);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.standardPanel.add(this.deltaData);
        this.deltaData.setVisible(false);
        this.deltaLabel.setVisible(false);
        this.assertCombo.setEnabled(true);
        this.assertData.setEnabled(true);
        this.assertLabel.setEnabled(true);
        this.deltaData.setEnabled(true);
        this.deltaLabel.setEnabled(true);
        this.add(this.assertCheckbox);
        this.add(this.standardPanel);
    }

    public void updateWithResultData(String resultString) {
        if (this.userInput) {
            return;
        }
        String[] tokens = new String[3];
        StringTokenizer st = new StringTokenizer(resultString);
        int i = 0;
        while (st.hasMoreTokens() && i < 3) {
            tokens[i++] = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            int startIndex = resultString.indexOf(tokens[2]);
            tokens[2] = resultString.substring(startIndex);
        }
        if (tokens[0].equals("float") || tokens[0].equals("double")) {
            this.assertCombo.setSelectedIndex(this.findItemIndex(equalToFloatingPointLabel));
            this.assertData.setText(tokens[2]);
            double delta = Double.parseDouble(tokens[2]);
            this.deltaData.setText(Double.toString(Math.abs(delta * 0.01)));
        } else if (tokens[2].equals(nullLabel)) {
            this.assertCombo.setSelectedIndex(this.findItemIndex(assertNullLabel));
        } else if (tokens[2].equals("<object")) {
            this.assertCombo.setSelectedIndex(this.findItemIndex(notNullLabel));
        } else {
            this.assertData.setText(tokens[2]);
            this.assertCombo.setSelectedIndex(this.findItemIndex(equalToLabel));
        }
    }

    private int findItemIndex(String item) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    private void signalUserInput() {
        if (!this.userInput) {
            // empty if block
        }
        this.userInput = true;
    }

    public boolean isAssertEnabled() {
        return this.assertCheckbox != null ? this.assertCheckbox.isSelected() : false;
    }

    public boolean isAssertComplete() {
        int index = this.assertCombo.getSelectedIndex();
        if (this.secondFieldNeeded[index] && this.deltaData.getText().length() == 0) {
            return false;
        }
        return !this.firstLabelFieldNeeded[index] || this.assertData.getText().length() != 0;
    }

    public String getAssertStatement() {
        int index = this.assertCombo.getSelectedIndex();
        if (this.secondFieldNeeded[index]) {
            return InvokerRecord.makeAssertionStatement(this.labelsAssertStatement[index], this.assertData.getText(), this.deltaData.getText());
        }
        if (this.firstLabelFieldNeeded[index]) {
            return InvokerRecord.makeAssertionStatement(this.labelsAssertStatement[index], this.assertData.getText());
        }
        return InvokerRecord.makeAssertionStatement(this.labelsAssertStatement[index]);
    }
}

