/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.EventqueueCompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.TextType;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallDialogWatcher;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.MethodDialog;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.ConstructionInvokerRecord;
import bluej.testmgr.record.ExpressionInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.MethodInvokerRecord;
import bluej.testmgr.record.StaticVoidMainMethodInvokerRecord;
import bluej.testmgr.record.VoidMethodInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.awt.EventQueue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Invoker
implements CompileObserver,
CallDialogWatcher {
    private static final String creating = Config.getString("pkgmgr.creating");
    private static final String createDone = Config.getString("pkgmgr.createDone");
    public static final int OBJ_NAME_LENGTH = 8;
    public static final String SHELLNAME = "__SHELL";
    private static int shellNumber = 0;
    private static Map methods = new HashMap();
    private PkgMgrFrame pmf;
    private Package pkg;
    private ResultWatcher watcher;
    private CallableView member;
    private String shellName;
    private String objName;
    private Map typeMap;
    private ValueCollection localVars;
    private String imports;
    private String instanceName;
    private CallDialog dialog;
    private boolean constructing;
    private String commandString;
    private int numberCompiling = 0;
    private ExecutionEvent executionEvent;
    private InvokerRecord ir;

    private static final synchronized String getShellName() {
        return SHELLNAME + shellNumber++;
    }

    public Invoker(PkgMgrFrame pmf, ValueCollection localVars, String command, ResultWatcher watcher) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (watcher == null) {
            throw new NullPointerException("Invoker: watcher == null");
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.watcher = watcher;
        this.member = null;
        this.shellName = Invoker.getShellName();
        this.objName = null;
        this.instanceName = null;
        this.localVars = localVars;
        this.constructing = false;
        this.executionEvent = new ExecutionEvent(this.pkg);
        this.commandString = command;
    }

    public Invoker(PkgMgrFrame pmf, CallableView member, ResultWatcher watcher) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (watcher == null) {
            throw new NullPointerException("Invoker: watcher == null");
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.member = member;
        this.watcher = watcher;
        this.shellName = Invoker.getShellName();
        if (member instanceof ConstructorView) {
            this.objName = pmf.getProject().getDebugger().guessNewName(member.getClassName());
            this.constructing = true;
            this.executionEvent = new ExecutionEvent(member.getClassName(), null);
        } else if (member instanceof MethodView) {
            if (((MethodView)member).isStatic()) {
                this.objName = JavaNames.stripPrefix(member.getClassName());
                this.executionEvent = new ExecutionEvent(member.getClassName(), null);
            } else {
                this.executionEvent = new ExecutionEvent(member.getClassName(), this.objName);
            }
            this.constructing = false;
        } else {
            Debug.reportError("illegal member type in invocation");
        }
        this.executionEvent.setPackage(this.pkg);
    }

    public Invoker(PkgMgrFrame pmf, MethodView member, ObjectWrapper objWrapper, ResultWatcher watcher) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (watcher == null) {
            throw new NullPointerException("Invoker: watcher == null");
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.member = member;
        this.watcher = watcher;
        this.shellName = Invoker.getShellName();
        this.objName = objWrapper.getName();
        this.typeMap = objWrapper.getObject().getGenType().mapToSuper(member.getClassName()).getMap();
        this.executionEvent = new ExecutionEvent(member.getClassName(), this.objName);
        this.constructing = false;
        this.executionEvent.setPackage(this.pkg);
    }

    public void setImports(String importStatements) {
        this.imports = importStatements;
    }

    public void invokeInteractive() {
        if (this.constructing && Config.isGreenfoot()) {
            this.instanceName = this.objName;
        }
        if (!(this.constructing && !Config.isGreenfoot() || this.member.hasParameters())) {
            this.dialog = null;
            this.doInvocation(null, (JavaType[])null, null);
        } else {
            MethodDialog mDialog = (MethodDialog)methods.get(this.member);
            if (mDialog == null) {
                mDialog = new MethodDialog(this.pmf, this.objName, this.member, this.typeMap);
                methods.put(this.member, mDialog);
                mDialog.setVisible(true);
            } else {
                mDialog.setInstanceInfo(this.objName, this.typeMap);
            }
            mDialog.setEnabled(true);
            mDialog.setWatcher(this);
            this.dialog = mDialog;
        }
    }

    public synchronized void tryAgain() {
        this.doFreeFormInvocation(null);
    }

    public void callDialogEvent(CallDialog dlg, int event) {
        if (event == 1) {
            dlg.setVisible(false);
        } else if (event == 0) {
            if (dlg instanceof MethodDialog) {
                MethodView mv;
                MethodDialog mDialog = (MethodDialog)dlg;
                mDialog.setEnabled(false);
                this.instanceName = mDialog.getNewInstanceName();
                String[] actualTypeParams = mDialog.getTypeParams();
                if (this.member instanceof MethodView && (mv = (MethodView)this.member).isMain()) {
                    this.pmf.getProject().removeClassLoader();
                    this.pmf.getProject().newRemoteClassLoaderLeavingBreakpoints();
                }
                this.pmf.setWaitCursor(true);
                this.doInvocation(mDialog.getArgs(), mDialog.getArgGenTypes(true), actualTypeParams);
                if (this.constructing) {
                    this.pkg.setStatus(creating);
                }
            }
        } else {
            Debug.reportError("Invoker: Unknown CallDialog event");
        }
    }

    public void invokeDirect(String[] params) {
        if (this.instanceName == null) {
            this.instanceName = this.objName;
        }
        JavaType[] argTypes = this.member.getParamTypes(false);
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = argTypes[i].mapTparsToTypes(this.typeMap);
        }
        this.doInvocation(params, argTypes, null);
    }

    protected void doInvocation(String[] args, JavaType[] argTypes, String[] typeParams) {
        int numArgs = args == null ? 0 : args.length;
        String[] argTypeStrings = argTypes != null ? new String[argTypes.length] : null;
        if (!this.member.isGeneric() || this.member.isConstructor()) {
            for (int i = 0; i < numArgs; ++i) {
                JavaType argType = argTypes[i];
                if (argType instanceof GenTypeWildcard) {
                    GenTypeSolid[] ubounds = ((GenTypeWildcard)argType).getUpperBounds();
                    argType = ubounds.length != 0 ? ubounds[0] : new TextType("java.lang.Object");
                }
                argTypeStrings[i] = argType.toString(new CleverQualifyTypeNameTransform(this.pkg));
            }
        }
        this.executionEvent.setParameters(argTypes, args);
        if (this.constructing) {
            this.executionEvent.setObjectName(this.instanceName);
        } else {
            this.executionEvent.setMethodName(((MethodView)this.member).getName());
        }
        this.doInvocation(args, argTypeStrings, typeParams);
    }

    private void doInvocation(String[] args, String[] argTypes, String[] typeParams) {
        String command;
        int numArgs = args == null ? 0 : args.length;
        final String className = this.member.getClassName();
        boolean isGenericMethod = this.member.isGeneric() && !this.member.isConstructor();
        StringBuffer buffer = new StringBuffer();
        if (!isGenericMethod) {
            for (int i = 0; i < numArgs; ++i) {
                buffer.append(argTypes[i]);
                buffer.append(" __bluej_param" + i);
                buffer.append(" = " + args[i]);
                buffer.append(";" + Config.nl);
            }
        }
        String paramInit = buffer.toString();
        buffer.setLength(0);
        StringBuffer argBuffer = new StringBuffer();
        this.buildArgStrings(buffer, argBuffer, args);
        String argString = buffer.toString();
        String actualArgString = argBuffer.toString();
        if (isGenericMethod) {
            argString = actualArgString;
        }
        buffer.setLength(0);
        boolean isVoid = false;
        String constype = null;
        if (this.constructing) {
            constype = Invoker.cleverQualifyTypeName(this.pkg, className);
            if (typeParams != null && typeParams.length > 0) {
                constype = constype + "<";
                for (int i = 0; i < typeParams.length; ++i) {
                    String typeParam = typeParams[i];
                    constype = constype + typeParam;
                    if (i >= typeParams.length - 1) continue;
                    constype = constype + ",";
                }
                constype = constype + ">";
            }
            command = "new " + constype;
            this.ir = new ConstructionInvokerRecord(constype, this.instanceName, command + actualArgString, args);
        } else {
            MethodView method = (MethodView)this.member;
            isVoid = method.isVoid();
            command = method.isStatic() ? Invoker.cleverQualifyTypeName(this.pkg, className) + "." + method.getName() : this.objName + "." + method.getName();
            if (isVoid) {
                this.ir = method.isMain() ? new StaticVoidMainMethodInvokerRecord() : new VoidMethodInvokerRecord(command + actualArgString, args);
                this.instanceName = null;
            } else {
                this.ir = new MethodInvokerRecord(method.getReturnType().getViewClass(), command + actualArgString, args);
                this.instanceName = "result";
            }
        }
        if (this.constructing && numArgs == 0 && (typeParams == null || typeParams.length == 0)) {
            this.commandString = command + actualArgString;
            BlueJEvent.raiseEvent(3, this.commandString);
            new Thread(){

                public void run() {
                    final DebuggerObject result = Invoker.this.pkg.getProject().getDebugger().instantiateClass(className);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            int status = Invoker.this.pkg.getDebugger().getExitStatus();
                            if (status == 0) {
                                Invoker.this.watcher.putResult(result, Invoker.this.instanceName, Invoker.this.ir);
                                Invoker.this.executionEvent.setResultObject(result);
                                Invoker.this.executionEvent.setResult("Normal exit");
                                BlueJEvent.raiseEvent(5, Invoker.this.executionEvent);
                            } else {
                                Invoker.this.handleResult("");
                            }
                            Invoker.this.closeCallDialog();
                            Invoker.this.pmf.setWaitCursor(false);
                            Invoker.this.pkg.getProject().updateInspectors();
                        }
                    });
                }
            }.start();
        } else {
            if (isVoid) {
                argString = argString + ';';
            }
            File shell = this.writeInvocationFile(paramInit, command + argString, isVoid, constype);
            this.commandString = command + actualArgString;
            this.compileInvocationFile(shell);
        }
    }

    protected void buildArgStrings(StringBuffer buffer, StringBuffer argBuffer, String[] args) {
        int numArgs = args == null ? 0 : args.length;
        buffer.append("(");
        argBuffer.append("(");
        if (numArgs > 0) {
            buffer.append("__bluej_param0");
            argBuffer.append(args[0]);
        }
        for (int i = 1; i < numArgs; ++i) {
            buffer.append(",__bluej_param" + i);
            argBuffer.append(", ");
            argBuffer.append(args[i]);
        }
        buffer.append(")");
        argBuffer.append(")");
    }

    public void doFreeFormInvocation(String resultType) {
        boolean hasResult;
        boolean bl = hasResult = resultType != null;
        if (hasResult) {
            if (resultType.equals("")) {
                resultType = null;
            }
            this.instanceName = "result";
            this.ir = new ExpressionInvokerRecord(this.commandString);
        } else {
            this.instanceName = null;
            this.ir = new VoidMethodInvokerRecord(this.commandString, null);
        }
        File shell = this.writeInvocationFile("", this.commandString, !hasResult, resultType);
        this.executionEvent.setCommand(this.commandString);
        this.compileInvocationFile(shell);
    }

    private File writeInvocationFile(String paramInit, String callString, boolean isVoid, String constype) {
        String packageLine = this.pkg.isUnnamedPackage() ? "" : "package " + this.pkg.getQualifiedName() + ";";
        StringBuffer buffer = new StringBuffer();
        if (!isVoid) {
            if (this.constructing) {
                buffer.append("public static ");
                buffer.append(constype);
            } else {
                buffer.append("public static Object");
            }
            buffer.append(" __bluej_runtime_result;");
            buffer.append(Config.nl);
        }
        String scopeId = Utility.quoteString(this.pkg.getId());
        Iterator wrappers = this.pmf.getObjectBench().getValueIterator();
        CleverQualifyTypeNameTransform cqtTransform = new CleverQualifyTypeNameTransform(this.pkg);
        if (wrappers.hasNext() || this.localVars != null) {
            buffer.append("final static java.util.Map __bluej_runtime_scope = getScope(\"" + scopeId + "\");" + Config.nl);
            this.writeVariables("", buffer, true, wrappers, cqtTransform);
        }
        String vardecl = buffer.toString();
        buffer = new StringBuffer();
        if (this.localVars != null && constype == null) {
            this.writeVariables("lv:", buffer, false, this.localVars.getValueIterator(), cqtTransform);
        }
        if (this.constructing) {
            buffer.append(this.shellName);
            buffer.append(".__bluej_runtime_result = ");
            buffer.append(callString);
        } else {
            if (!isVoid) {
                buffer.append(this.shellName);
                if (constype == null) {
                    buffer.append(".__bluej_runtime_result = makeObj(");
                } else {
                    buffer.append(".__bluej_runtime_result = new Object() { ");
                    buffer.append(constype + " result;");
                    if (this.localVars != null) {
                        buffer.append("{ ");
                        this.writeVariables("lv:", buffer, false, this.localVars.getValueIterator(), cqtTransform);
                        buffer.append("this.result = ");
                    }
                }
            }
            buffer.append(callString);
            if (!isVoid && constype == null) {
                buffer.append(")");
            }
        }
        if (!isVoid && !callString.endsWith(";")) {
            buffer.append(";");
        }
        buffer.append(Config.nl);
        String invocation = buffer.toString();
        buffer = new StringBuffer();
        if (this.localVars != null) {
            Iterator i = this.localVars.getValueIterator();
            while (i.hasNext()) {
                NamedValue wrapper = (NamedValue)i.next();
                if (wrapper.isFinal() && wrapper.isInitialized()) continue;
                String instname = wrapper.getName();
                buffer.append("__bluej_runtime_scope.put(\"lv:" + instname + "\", ");
                this.wrapValue(buffer, instname, wrapper.getGenType());
                buffer.append(");" + Config.nl);
            }
        }
        String scopeSave = buffer.toString();
        File shellFile = new File(this.pkg.getPath(), this.shellName + ".java");
        try {
            BufferedWriter shell = new BufferedWriter(new FileWriter(shellFile));
            shell.write(packageLine);
            shell.newLine();
            if (this.imports != null) {
                shell.write(this.imports);
                shell.newLine();
            }
            shell.write("public class ");
            shell.write(this.shellName);
            shell.write(" extends bluej.runtime.Shell {");
            shell.newLine();
            shell.write(vardecl);
            shell.newLine();
            shell.write("public static void run() throws Throwable {");
            shell.newLine();
            shell.write(paramInit);
            shell.write(invocation);
            shell.write(scopeSave);
            if (!isVoid && constype != null && !this.constructing) {
                shell.write("} };");
            }
            shell.newLine();
            shell.write("}}");
            shell.close();
        }
        catch (IOException e) {
            DialogManager.showError(this.pmf, "could-not-write-shell-file");
        }
        return shellFile;
    }

    private void writeVariables(String scopePx, StringBuffer buffer, boolean isStatic, Iterator i, NameTransform nt) {
        while (i.hasNext()) {
            NamedValue wrapper = (NamedValue)i.next();
            if (!wrapper.isInitialized()) continue;
            String type = wrapper.getGenType().toString(nt);
            String instname = wrapper.getName();
            if (wrapper.isFinal()) {
                buffer.append("final ");
            }
            if (isStatic) {
                buffer.append("static ");
            }
            buffer.append(type);
            buffer.append(" " + instname + " = ");
            this.extractValue(buffer, scopePx, instname, wrapper.getGenType(), type);
            buffer.append(Config.nl);
        }
    }

    private void extractValue(StringBuffer buffer, String scopePx, String instname, JavaType type, String typeStr) {
        if (type.isPrimitive()) {
            String extractMethod;
            String castType;
            if (type.typeIs(JavaType.JT_BOOLEAN)) {
                castType = "java.lang.Boolean";
                extractMethod = "booleanValue";
            } else if (type.typeIs(JavaType.JT_CHAR)) {
                castType = "java.lang.Character";
                extractMethod = "charValue";
            } else if (type.typeIs(JavaType.JT_BYTE)) {
                castType = "java.lang.Byte";
                extractMethod = "byteValue";
            } else if (type.typeIs(JavaType.JT_SHORT)) {
                castType = "java.lang.Short";
                extractMethod = "shortValue";
            } else if (type.typeIs(JavaType.JT_INT)) {
                castType = "java.lang.Integer";
                extractMethod = "intValue";
            } else if (type.typeIs(JavaType.JT_LONG)) {
                castType = "java.lang.Long";
                extractMethod = "longValue";
            } else if (type.typeIs(JavaType.JT_FLOAT)) {
                castType = "java.lang.Float";
                extractMethod = "floatValue";
            } else if (type.typeIs(JavaType.JT_DOUBLE)) {
                castType = "java.lang.Double";
                extractMethod = "doubleValue";
            } else {
                throw new UnsupportedOperationException("unhandled primitive type");
            }
            buffer.append("((" + castType + ")__bluej_runtime_scope.get(\"");
            buffer.append(scopePx + instname + "\"))." + extractMethod + "();");
        } else {
            buffer.append("(" + typeStr);
            buffer.append(")__bluej_runtime_scope.get(\"");
            buffer.append(scopePx + instname + "\");" + Config.nl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void wrapValue(StringBuffer buffer, String name, JavaType type) {
        if (type.isPrimitive()) {
            if (type.typeIs(JavaType.JT_BOOLEAN)) {
                buffer.append("java.lang.Boolean.valueOf(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_BYTE)) {
                buffer.append("new java.lang.Byte(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_CHAR)) {
                buffer.append("new java.lang.Character(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_DOUBLE)) {
                buffer.append("new java.lang.Double(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_FLOAT)) {
                buffer.append("new java.lang.Float(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_LONG)) {
                buffer.append("new java.lang.Long(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_INT)) {
                buffer.append("new java.lang.Integer(" + name + ")");
                return;
            } else {
                if (!type.typeIs(JavaType.JT_SHORT)) throw new UnsupportedOperationException("unhandled primitive type.");
                buffer.append("new java.lang.Short(" + name + ")");
            }
            return;
        } else {
            buffer.append(name);
        }
    }

    private void compileInvocationFile(File shellFile) {
        File[] files = new File[]{shellFile};
        ++this.numberCompiling;
        JobQueue.getJobQueue().addJob(files, new EventqueueCompileObserver(this), this.pkg.getProject().getClassLoader(), this.pkg.getProject().getProjectDir(), true);
    }

    public void startCompile(File[] sources) {
    }

    public void errorMessage(String filename, int lineNo, String message) {
        if (this.dialog != null) {
            this.dialog.setErrorMessage("Error: " + message);
        }
        this.watcher.putError(message);
    }

    public synchronized void endCompile(File[] sources, boolean successful) {
        if (this.dialog != null) {
            this.dialog.setWaitCursor(false);
            if (successful) {
                this.closeCallDialog();
            }
        }
        this.pmf.setWaitCursor(false);
        if (successful) {
            this.startClass();
        } else {
            this.finishCall(false);
        }
    }

    private void finishCall(boolean successful) {
        if (this.constructing && successful) {
            this.pkg.setStatus(createDone);
        } else {
            this.pkg.setStatus(" ");
        }
        --this.numberCompiling;
        if (this.numberCompiling == 0) {
            this.deleteShellFiles();
        }
        if (!successful && this.dialog != null) {
            this.dialog.setEnabled(true);
        }
    }

    private void closeCallDialog() {
        if (this.dialog != null) {
            this.dialog.setWaitCursor(false);
            this.dialog.setVisible(false);
            if (this.dialog instanceof MethodDialog) {
                ((MethodDialog)this.dialog).updateParameters();
            }
        }
    }

    private void deleteShellFiles() {
        File srcFile = new File(this.pkg.getPath(), this.shellName + ".java");
        srcFile.delete();
        File classFile = new File(this.pkg.getPath(), this.shellName + ".class");
        classFile.delete();
    }

    public void startClass() {
        BlueJEvent.raiseEvent(3, this.commandString);
        final String shellClassName = this.pkg.getQualifiedName(this.shellName);
        new Thread(){

            public void run() {
                try {
                    Invoker.this.pkg.getProject().getDebugger().runClassMain(shellClassName);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            Invoker.this.handleResult(shellClassName);
                            Invoker.this.pkg.getProject().updateInspectors();
                            Invoker.this.finishCall(true);
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    public void handleResult(String shellClassName) {
        try {
            int status = this.pkg.getDebugger().getExitStatus();
            switch (status) {
                case 0: {
                    try {
                        DebuggerObject result = this.pkg.getDebugger().getStaticValue(shellClassName, "__bluej_runtime_result");
                        this.watcher.putResult(result, this.instanceName, this.ir);
                        this.executionEvent.setResultObject(result);
                        this.executionEvent.setResult("Normal exit");
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.watcher.putError("Terminated");
                        this.executionEvent.setResult("User terminated");
                        return;
                    }
                }
                case 1: {
                    String excMsg = this.pkg.getDebugger().getException().getText();
                    if (this.instanceName != null) {
                        this.pkg.reportExit(excMsg);
                        this.watcher.putException(excMsg);
                    } else if (!"0".equals(excMsg)) {
                        this.pkg.reportExit(excMsg);
                    }
                    this.executionEvent.setResult("Forced exit");
                    break;
                }
                case 2: {
                    ExceptionDescription exc = this.pkg.getDebugger().getException();
                    String msg = exc.getText();
                    String text = exc.getClassName();
                    if (text != null) {
                        text = JavaNames.stripPrefix(text) + ":\n" + msg;
                        this.pkg.exceptionMessage(exc.getStack(), text);
                        this.watcher.putException(text);
                    } else {
                        this.pkg.reportException(msg);
                        this.watcher.putException(msg);
                    }
                    this.executionEvent.setResult("An exception occurred");
                    break;
                }
                case 3: {
                    this.watcher.putVMTerminated();
                    this.executionEvent.setResult("User terminated");
                }
            }
            BlueJEvent.raiseEvent(5, this.executionEvent);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    private static String cleverQualifyTypeName(Package p, String typeName) {
        int firstDollar;
        if (!p.isUnnamedPackage()) {
            String pkgName = p.getQualifiedName();
            int firstDot = pkgName.indexOf(".");
            if (firstDot >= 0) {
                pkgName = pkgName.substring(0, firstDot);
            }
            if (p.getTarget(pkgName) != null) {
                typeName = JavaNames.getBase(typeName);
            }
        }
        if ((firstDollar = typeName.indexOf(36)) != -1) {
            StringBuffer sb = new StringBuffer(typeName);
            for (int i = firstDollar; i < sb.length() - 1; ++i) {
                if (sb.charAt(i) != '$' || Character.isDigit(sb.charAt(i + 1))) continue;
                sb.setCharAt(i, '.');
            }
            typeName = sb.toString();
        }
        return JavaNames.typeName(typeName);
    }

    static class CleverQualifyTypeNameTransform
    implements NameTransform {
        Package mypackage;

        public CleverQualifyTypeNameTransform(Package p) {
            this.mypackage = p;
        }

        public String transform(String n) {
            return Invoker.cleverQualifyTypeName(this.mypackage, n);
        }
    }
}

