/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiArrayReflective;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import bluej.utility.JavaNames;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;

public class JdiArray
extends JdiObject {
    private JavaType componentType;

    protected JdiArray(ArrayReference obj) {
        this.obj = obj;
    }

    protected JdiArray(ArrayReference obj, JavaType expectedType) {
        this.obj = obj;
        if (expectedType instanceof GenTypeArray) {
            String ctypestr = obj.referenceType().signature();
            JavaType genericType = expectedType;
            int level = 0;
            while (genericType instanceof GenTypeArray) {
                GenTypeArray genericArray = (GenTypeArray)genericType;
                genericType = genericArray.getArrayComponent();
                ctypestr = ctypestr.substring(1);
                ++level;
            }
            if (ctypestr.charAt(0) == '[') {
                return;
            }
            if (genericType.isPrimitive()) {
                return;
            }
            if (genericType instanceof GenTypeWildcard) {
                GenTypeSolid[] upperBounds = ((GenTypeWildcard)genericType).getUpperBounds();
                if (upperBounds.length != 0) {
                    genericType = ((GenTypeWildcard)genericType).getUpperBounds()[0];
                }
            } else if (genericType instanceof GenTypeClass) {
                String compName = ctypestr.substring(1, ctypestr.length() - 1);
                compName = compName.replace('/', '.');
                JdiReflective compReflective = new JdiReflective(compName, obj.referenceType());
                GenTypeClass component = ((GenTypeClass)genericType).mapToDerived(compReflective);
                while (level > 1) {
                    component = new GenTypeArray(component, new JdiArrayReflective(component, obj.referenceType()));
                    --level;
                }
                this.componentType = component;
            }
        }
    }

    public String getClassName() {
        return this.obj.referenceType().name();
    }

    public String getGenClassName() {
        if (this.componentType == null) {
            return this.getClassName();
        }
        return this.componentType.toString() + "[]";
    }

    public String getStrippedGenClassName() {
        if (this.componentType == null) {
            return JavaNames.stripPrefix(this.getClassName());
        }
        return this.componentType.toString(true) + "[]";
    }

    public GenTypeClass getGenType() {
        if (this.componentType != null) {
            JdiArrayReflective r = new JdiArrayReflective(this.componentType, this.obj.referenceType());
            return new GenTypeArray(this.componentType, r);
        }
        return super.getGenType();
    }

    public boolean isArray() {
        return true;
    }

    public boolean isNullObject() {
        return this.obj == null;
    }

    public int getStaticFieldCount() {
        return 0;
    }

    public int getInstanceFieldCount() {
        return ((ArrayReference)this.obj).length();
    }

    public String getStaticFieldName(int slot) {
        throw new UnsupportedOperationException("getStaticFieldName");
    }

    public String getInstanceFieldName(int slot) {
        return "[" + String.valueOf(slot) + "]";
    }

    public DebuggerObject getStaticFieldObject(int slot) {
        throw new UnsupportedOperationException("getStaticFieldObject");
    }

    public DebuggerObject getInstanceFieldObject(int slot) {
        Value val = ((ArrayReference)this.obj).getValue(slot);
        if (this.componentType != null) {
            return JdiObject.getDebuggerObject((ObjectReference)val, this.componentType);
        }
        return JdiObject.getDebuggerObject((ObjectReference)val);
    }

    public List getStaticFields(boolean includeModifiers) {
        throw new UnsupportedOperationException("getStaticFields");
    }

    public List getInstanceFields(boolean includeModifiers) {
        List<Object> values = ((ArrayReference)this.obj).length() > 0 ? ((ArrayReference)this.obj).getValues() : new ArrayList();
        ArrayList<String> fields = new ArrayList<String>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            Value val = (Value)values.get(i);
            String valString = JdiUtils.getJdiUtils().getValueString(val);
            fields.add("[" + i + "]" + " = " + valString);
        }
        return fields;
    }

    public boolean staticFieldIsPublic(int slot) {
        throw new UnsupportedOperationException("getStaticFieldObject");
    }

    public boolean instanceFieldIsPublic(int slot) {
        return true;
    }

    public boolean staticFieldIsObject(int slot) {
        throw new UnsupportedOperationException("getStaticFieldObject");
    }

    public boolean instanceFieldIsObject(int slot) {
        Value val = ((ArrayReference)this.obj).getValue(slot);
        if (val == null) {
            return false;
        }
        return val instanceof ObjectReference;
    }
}

