/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import org.bluej.extensions.submitter.transport.SocketSession;
import org.bluej.extensions.submitter.transport.TransportSession;

public class SmtpSession
extends TransportSession {
    private String boundaryString;
    private final DateFormat rfc822date = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private int fileCounter;

    public SmtpSession(URL url, Properties environment) {
        super(url, environment);
        this.result = "Not sent";
        String boundary = "";
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            boundary = boundary + (char)SocketSession.encode((byte)random.nextInt(62));
        }
        this.boundaryString = "part_boundary_" + boundary;
        this.fileCounter = 0;
    }

    public void connect() throws IOException {
        String smtpHost = this.urlProps.getProperty("smtphost");
        if (smtpHost == null || smtpHost.length() == 0) {
            throw new IllegalArgumentException("SMTP Host has not been set");
        }
        String userAddress = this.urlProps.getProperty("useraddr");
        if (userAddress == null || userAddress.indexOf(64) < 1 || userAddress.indexOf(64) == userAddress.length() - 1) {
            throw new IllegalArgumentException("User Email address invalid");
        }
        String sendAddress = this.url.getPath();
        String subject = this.urlProps.getProperty("subject");
        String body = this.urlProps.getProperty("body");
        this.reportEvent("Connecting to host " + smtpHost + "...");
        int port = 25;
        if (this.url.getPort() != -1) {
            port = this.url.getPort();
        }
        this.connection = new SocketSession(smtpHost, port);
        this.reportEvent("Sending message...");
        this.connection.setTransportReport(this.transportReport);
        this.connection.expect("220 ", "421 ");
        this.connection.sendln("HELO " + this.connection.getLocalHost());
        this.connection.expect(new String[]{"250 "}, new String[]{"500", "501", "504", "421"});
        this.connection.sendln("MAIL FROM:<" + userAddress + ">");
        this.connection.expect(new String[]{"250 "}, new String[]{"552", "451", "452", "500", "501", "421"});
        this.connection.sendln("RCPT TO:<" + sendAddress + ">");
        this.connection.expect(new String[]{"250 ", "251 "}, new String[]{"550", "551", "552", "553", "450", "451", "452", "500", "501", "503", "421"});
        this.connection.sendln("DATA");
        this.connection.expect(new String[]{"354 "}, new String[]{"451", "554", "500", "501", "503", "421"});
        this.connection.flush();
        this.connection.sendln("Date: " + this.rfc822date.format(new Date()));
        this.connection.sendln("From: " + userAddress);
        this.connection.sendln("To: " + sendAddress);
        this.connection.sendln("To: " + sendAddress);
        this.connection.sendln("Message-ID: " + System.currentTimeMillis() + userAddress);
        if (subject == null) {
            this.connection.sendln("Subject: BlueJ Submission");
        } else {
            this.connection.sendln("Subject: " + subject);
        }
        this.sendMimeHeaders();
        if (body != null) {
            this.sendBoundary(false);
            this.connection.sendln("Content-Type: text/plain");
            this.connection.sendln("Content-Transfer-Encoding: 7bit");
            this.connection.sendln("");
            StringReader aReader = new StringReader(body);
            this.sendStreamToServer(aReader);
        }
        this.reportEvent("OK");
    }

    public void send(InputStream is, String name, boolean binary) throws IOException {
        String packageName = name.replace('/', '_');
        this.sendBoundary(false);
        if (binary) {
            this.sendMimeBinaryFile(is, packageName);
        } else {
            this.sendMimeTextFile(is, packageName);
        }
        ++this.fileCounter;
    }

    public void disconnect() throws IOException {
        this.reportEvent("Disconnecting...");
        this.sendBoundary(true);
        this.connection.sendln(".");
        this.connection.expect(new String[]{"250 "}, new String[]{"552", "554", "451", "452"});
        this.connection.sendln("QUIT");
        this.connection.expect("221 ");
        this.connection.close();
        this.connection = null;
        this.reportEvent("Sent.");
        this.result = null;
    }

    private void sendMimeHeaders() throws IOException {
        this.connection.sendln("MIME-Version: 1.0 (produced automatically by BlueJ)");
        this.connection.sendln("Content-Type: multipart/mixed; boundary=\"" + this.boundaryString + "\"");
        this.connection.sendln("");
        this.connection.sendln("This is a multi-part message in MIME format.");
    }

    private void sendMimeText(String theText) throws IOException {
        this.connection.sendln("Content-Type: text/plain");
        this.connection.sendln("Content-Transfer-Encoding: 7bit");
        this.connection.sendln("");
        StringReader aReader = new StringReader(theText);
        this.sendStreamToServer(aReader);
    }

    private void sendMimeBinaryFile(InputStream is, String name) throws IOException {
        this.connection.sendln("Content-Type: application/octet-stream; name=\"" + name + "\"");
        this.connection.sendln("Content-Transfer-Encoding: base64");
        this.connection.sendln("Content-Disposition: attachment; filename=\"" + name + "\"");
        this.connection.sendln("");
        this.connection.sendMimeStream(is);
        this.reportLog("===> sent binary file " + name);
    }

    private void sendMimeTextFile(InputStream is, String name) throws IOException {
        this.connection.sendln("Content-Type: text/plain; name=\"" + name + "\"");
        this.connection.sendln("Content-Transfer-Encoding: 7bit");
        this.connection.sendln("Content-Disposition: attachment; filename=\"" + name + "\"");
        this.connection.sendln("");
        int lineCount = this.sendStreamToServer(new InputStreamReader(is));
        this.reportLog("===> sent text file " + name + " lineCount=" + lineCount);
    }

    private void sendBoundary(boolean end) throws IOException {
        this.connection.nologSendln("");
        this.connection.sendln("--" + this.boundaryString + (end ? "--" : ""));
    }

    private int sendStreamToServer(Reader inputReader) throws IOException {
        String oneLine;
        int lineCount = 0;
        if (inputReader == null) {
            return 0;
        }
        BufferedReader aReader = new BufferedReader(inputReader);
        while ((oneLine = aReader.readLine()) != null) {
            if (oneLine.startsWith(".")) {
                this.connection.send(".");
            }
            this.connection.nologSendln(oneLine);
            ++lineCount;
        }
        this.connection.flush();
        return lineCount;
    }
}

