/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BObject;
import bluej.extensions.InvocationArgumentException;
import bluej.extensions.InvocationErrorException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.views.CallableView;
import bluej.views.MethodView;

class DirectInvoker {
    private final PkgMgrFrame pkgFrame;
    private final CallableView callable;
    private String resultName;

    DirectInvoker(PkgMgrFrame i_pkgFrame, CallableView i_callable) {
        this.pkgFrame = i_pkgFrame;
        this.callable = i_callable;
    }

    DebuggerObject invokeConstructor(Object[] args) throws InvocationArgumentException, InvocationErrorException {
        if (!this.paramsAlmostMatch(args, this.callable.getParameters())) {
            throw new InvocationArgumentException("invokeConstructor: bad arglist");
        }
        DirectResultWatcher watcher = new DirectResultWatcher();
        Invoker invoker = new Invoker(this.pkgFrame, this.callable, (ResultWatcher)watcher);
        invoker.invokeDirect(this.convObjToString(args));
        DebuggerObject result = watcher.getResult();
        if (watcher.isFailed()) {
            throw new InvocationErrorException("invokeConstructor: Error=" + watcher.getError());
        }
        if (result == null) {
            throw new InvocationErrorException("invokeConstructor: ERROR: result==null");
        }
        this.resultName = watcher.getResultName();
        return result;
    }

    DebuggerObject invokeMethod(ObjectWrapper onThisObjectInstance, Object[] args) throws InvocationArgumentException, InvocationErrorException {
        if (!this.paramsAlmostMatch(args, this.callable.getParameters())) {
            throw new InvocationArgumentException("invokeMethod: bad arglist");
        }
        DirectResultWatcher watcher = new DirectResultWatcher();
        Invoker invoker = ((MethodView)this.callable).isStatic() ? new Invoker(this.pkgFrame, this.callable, (ResultWatcher)watcher) : new Invoker(this.pkgFrame, (MethodView)this.callable, onThisObjectInstance, (ResultWatcher)watcher);
        invoker.invokeDirect(this.convObjToString(args));
        DebuggerObject result = watcher.getResult();
        if (watcher.isFailed()) {
            throw new InvocationErrorException("invokeMethod: Error=" + watcher.getError());
        }
        if (result == null) {
            throw new InvocationErrorException("invokeMethod: ERROR: result==null");
        }
        this.resultName = watcher.getResultName();
        return result;
    }

    String getResultName() {
        return this.resultName;
    }

    private String[] convObjToString(Object[] i_array) {
        if (i_array == null) {
            return null;
        }
        if (i_array.length <= 0) {
            return new String[0];
        }
        String[] o_array = new String[i_array.length];
        for (int index = 0; index < i_array.length; ++index) {
            o_array[index] = this.convOneObj(i_array[index]);
        }
        return o_array;
    }

    private String convOneObj(Object i_obj) {
        if (i_obj == null) {
            return null;
        }
        if (i_obj instanceof String) {
            return "\"" + i_obj + "\"";
        }
        if (i_obj instanceof BObject) {
            return ((BObject)i_obj).getInstanceName();
        }
        return i_obj.toString();
    }

    private boolean paramsAlmostMatch(Object[] params, Class[] paramClass) {
        if (params != null && params.length < 1) {
            params = null;
        }
        if (paramClass != null && paramClass.length < 1) {
            paramClass = null;
        }
        if (params == null && paramClass == null) {
            return true;
        }
        if (params == null || paramClass == null) {
            return false;
        }
        return params.length == paramClass.length;
    }

    class DirectResultWatcher
    implements ResultWatcher {
        private boolean resultReady = false;
        private boolean isFailed = false;
        private DebuggerObject result = null;
        private String errorMsg = null;
        private String resultName;

        public synchronized DebuggerObject getResult() {
            while (!this.resultReady) {
                try {
                    this.wait();
                }
                catch (InterruptedException exc) {
                    this.isFailed = true;
                    this.errorMsg = "getResult: Interrupt: Exception=" + exc.getMessage();
                    return null;
                }
            }
            return this.result;
        }

        public synchronized boolean isFailed() {
            return this.isFailed;
        }

        public synchronized void putResult(DebuggerObject aResult, String anObjectName, InvokerRecord ir) {
            this.result = aResult;
            this.resultName = anObjectName;
            this.resultReady = true;
            this.notifyAll();
        }

        public synchronized void putError(String error) {
            this.errorMsg = "Invocation: Error=" + error;
            this.isFailed = true;
            this.resultReady = true;
            this.notifyAll();
        }

        public void putException(String msg) {
            this.putError(msg);
        }

        public void putVMTerminated() {
            this.putError("Terminated");
        }

        public String getError() {
            return this.errorMsg;
        }

        public String getResultName() {
            return this.resultName;
        }

        public ExpressionInformation getExpressionInformation() {
            return null;
        }
    }
}

