/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.debugger.gentype.GenType;
import bluej.views.Comment;
import bluej.views.FormattedPrintWriter;
import bluej.views.MemberView;
import bluej.views.View;

public abstract class CallableView
extends MemberView {
    public CallableView(View view) {
        super(view);
    }

    public abstract boolean hasParameters();

    public abstract boolean isVarArgs();

    private String createVarArg(String typeName) {
        String lastArrayStripped = typeName.substring(0, typeName.length() - 2);
        return lastArrayStripped + " ...";
    }

    public int getParameterCount() {
        return this.getParameters().length;
    }

    public abstract Class[] getParameters();

    public abstract GenType[] getParamTypes(boolean var1);

    public String[] getParamNames() {
        Comment c = this.getComment();
        if (c == null) {
            return null;
        }
        return c.getParamNames();
    }

    public abstract String[] getParamTypeStrings();

    public void print(FormattedPrintWriter out) {
        this.print(out, 0);
    }

    public void print(FormattedPrintWriter out, int indents) {
        Comment comment = this.getComment();
        if (comment != null) {
            comment.print(out, indents);
        }
        out.setItalic(false);
        out.setBold(true);
        for (int i = 0; i < indents; ++i) {
            out.indentLine();
        }
        out.println(this.getLongDesc());
    }
}

