/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaUtils;
import java.util.ArrayList;
import java.util.List;

public class JavaReflective
extends Reflective {
    private Class c;

    public JavaReflective(Class c) {
        this.c = c;
    }

    public String getName() {
        return this.c.getName();
    }

    public boolean isInterface() {
        return this.c.isInterface();
    }

    public List getTypeParams() {
        return JavaUtils.getJavaUtils().getTypeParams(this.c);
    }

    public Reflective getArrayOf() {
        String rname = this.c.isArray() ? "[" + this.c.getName() : "[L" + this.c.getName() + ";";
        try {
            Class<?> arrClass = this.c.getClassLoader().loadClass(rname);
            return new JavaReflective(arrClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public List getSuperTypesR() {
        ArrayList<JavaReflective> l = new ArrayList<JavaReflective>();
        Class superclass = this.c.getSuperclass();
        if (superclass != null) {
            l.add(new JavaReflective(superclass));
        }
        Class<?>[] interfaces = this.c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            l.add(new JavaReflective(interfaces[i]));
        }
        return l;
    }

    public List getSuperTypes() {
        ArrayList<GenTypeClass> l = new ArrayList<GenTypeClass>();
        GenTypeClass superclass = JavaUtils.getJavaUtils().getSuperclass(this.c);
        if (superclass != null) {
            l.add(superclass);
        }
        GenTypeClass[] interfaces = JavaUtils.getJavaUtils().getInterfaces(this.c);
        for (int i = 0; i < interfaces.length; ++i) {
            l.add(interfaces[i]);
        }
        return l;
    }

    public Class getUnderlyingClass() {
        return this.c;
    }

    public boolean isAssignableFrom(Reflective r) {
        if (r instanceof JavaReflective) {
            return this.c.isAssignableFrom(((JavaReflective)r).getUnderlyingClass());
        }
        return false;
    }
}

