/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class VersionCheckDialog
extends EscapeDialog
implements ActionListener {
    private static final String close = Config.getString("close");
    private static final String check = Config.getString("pkgmgr.versionDlg.check");
    private static final String dialogTitle = Config.getString("pkgmgr.versionDlg.title");
    private static final String helpLine1 = Config.getString("pkgmgr.versionDlg.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.versionDlg.helpLine2");
    private static final String versionURL = Config.getPropString("bluej.url.versionCheck");
    private JTextArea textArea;
    private JButton closeButton;
    private String newVersion = null;
    private Thread versionThread = null;
    private boolean isClosed = false;

    public VersionCheckDialog(PkgMgrFrame parent) {
        super(parent, dialogTitle, true);
        this.makeDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (check.equals(cmd)) {
            this.doVersionCheck();
            this.getRootPane().setDefaultButton(this.closeButton);
        } else if (close.equals(cmd)) {
            this.doClose();
        }
    }

    private void doClose() {
        this.isClosed = true;
        this.setVisible(false);
    }

    private void doVersionCheck() {
        this.versionThread = new VersionChecker();
        this.versionThread.start();
    }

    private void makeDialog() {
        this.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        JLabel helpText1 = new JLabel(helpLine1);
        mainPanel.add(helpText1);
        JLabel helpText2 = new JLabel(helpLine2);
        mainPanel.add(helpText2);
        Font smallFont = helpText1.getFont().deriveFont(10);
        helpText1.setFont(smallFont);
        helpText2.setFont(smallFont);
        mainPanel.add(Box.createVerticalStrut(5));
        this.textArea = new JTextArea(14, 46);
        this.textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        mainPanel.add(scrollPane);
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton checkButton = new JButton(check);
        checkButton.addActionListener(this);
        this.closeButton = new JButton(close);
        this.closeButton.addActionListener(this);
        buttonPanel.add(checkButton);
        buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(checkButton);
        checkButton.requestFocus();
        this.closeButton.setPreferredSize(new Dimension(checkButton.getPreferredSize().width, this.closeButton.getPreferredSize().height));
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    private class VersionChecker
    extends Thread {
        public void run() {
            VersionCheckDialog.this.textArea.setText(Config.getString("pkgmgr.checkingVersion"));
            try {
                InputStream is = new URL(versionURL).openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                if (this.isOutOfDate(reader)) {
                    if (!VersionCheckDialog.this.isClosed) {
                        this.displayNewVersionInfo(reader);
                    }
                } else if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.textArea.setText(Config.getString("pkgmgr.versionDlg.upToDate"));
                }
            }
            catch (IOException exc) {
                if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.textArea.setText("Error: could not access remote version information");
                }
                Debug.reportError("IO error when trying to access URL\n" + exc);
            }
        }

        private boolean isOutOfDate(BufferedReader versionReader) {
            try {
                VersionCheckDialog.this.newVersion = versionReader.readLine();
                if (VersionCheckDialog.this.newVersion != null) {
                    VersionCheckDialog.this.newVersion = VersionCheckDialog.this.newVersion.trim();
                }
            }
            catch (IOException exc) {
                VersionCheckDialog.this.textArea.setText("Error: could not read remote version information");
                Debug.reportError("IO error when reading remote version info\n" + exc);
            }
            return !"2.0.4".equals(VersionCheckDialog.this.newVersion);
        }

        private void displayNewVersionInfo(BufferedReader versionReader) {
            if (VersionCheckDialog.this.newVersion == null) {
                VersionCheckDialog.this.textArea.setText("Error: could not read remote version info");
            } else {
                VersionCheckDialog.this.textArea.setText(Config.getString("pkgmgr.versionDlg.currentVersion"));
                VersionCheckDialog.this.textArea.append(" ");
                VersionCheckDialog.this.textArea.append("2.0.4");
                VersionCheckDialog.this.textArea.append("\n");
                VersionCheckDialog.this.textArea.append(Config.getString("pkgmgr.versionDlg.newVersion"));
                VersionCheckDialog.this.textArea.append(" ");
                VersionCheckDialog.this.textArea.append(VersionCheckDialog.this.newVersion);
                VersionCheckDialog.this.textArea.append("\n");
                try {
                    String line = versionReader.readLine();
                    while (line != null) {
                        VersionCheckDialog.this.textArea.append(line);
                        VersionCheckDialog.this.textArea.append("\n");
                        line = versionReader.readLine();
                    }
                }
                catch (IOException exc) {
                    Debug.reportError("IO error when reading from version file");
                }
                VersionCheckDialog.this.textArea.setCaretPosition(0);
            }
        }
    }
}

