/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.LibraryCallDialog;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.debugmgr.texteval.TextEvalArea;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.MenuManager;
import bluej.parser.ClassParser;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.AboutBlue;
import bluej.pkgmgr.ExportManager;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.ImportFailedDialog;
import bluej.pkgmgr.ImportMismatchDialog;
import bluej.pkgmgr.MachineIcon;
import bluej.pkgmgr.NewClassDialog;
import bluej.pkgmgr.NewPackageDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageEditorEvent;
import bluej.pkgmgr.PackageEditorListener;
import bluej.pkgmgr.PackagePrintManager;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectPrintDialog;
import bluej.pkgmgr.actions.AddClassAction;
import bluej.pkgmgr.actions.CancelTestRecordAction;
import bluej.pkgmgr.actions.CheckExtensionsAction;
import bluej.pkgmgr.actions.CheckVersionAction;
import bluej.pkgmgr.actions.CloseProjectAction;
import bluej.pkgmgr.actions.CompileAction;
import bluej.pkgmgr.actions.CompileSelectedAction;
import bluej.pkgmgr.actions.EndTestRecordAction;
import bluej.pkgmgr.actions.ExportProjectAction;
import bluej.pkgmgr.actions.GenerateDocsAction;
import bluej.pkgmgr.actions.HelpAboutAction;
import bluej.pkgmgr.actions.ImportProjectAction;
import bluej.pkgmgr.actions.NewClassAction;
import bluej.pkgmgr.actions.NewInheritsAction;
import bluej.pkgmgr.actions.NewPackageAction;
import bluej.pkgmgr.actions.NewProjectAction;
import bluej.pkgmgr.actions.NewUsesAction;
import bluej.pkgmgr.actions.OpenNonBlueJAction;
import bluej.pkgmgr.actions.OpenProjectAction;
import bluej.pkgmgr.actions.PageSetupAction;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.pkgmgr.actions.PreferencesAction;
import bluej.pkgmgr.actions.PrintAction;
import bluej.pkgmgr.actions.QuitAction;
import bluej.pkgmgr.actions.RebuildAction;
import bluej.pkgmgr.actions.RemoveAction;
import bluej.pkgmgr.actions.RestartVMAction;
import bluej.pkgmgr.actions.RunTestsAction;
import bluej.pkgmgr.actions.SaveProjectAction;
import bluej.pkgmgr.actions.SaveProjectAsAction;
import bluej.pkgmgr.actions.ShowCopyrightAction;
import bluej.pkgmgr.actions.ShowDebuggerAction;
import bluej.pkgmgr.actions.ShowInheritsAction;
import bluej.pkgmgr.actions.ShowTerminalAction;
import bluej.pkgmgr.actions.ShowTestResultsAction;
import bluej.pkgmgr.actions.ShowTextEvalAction;
import bluej.pkgmgr.actions.ShowUsesAction;
import bluej.pkgmgr.actions.StandardAPIHelpAction;
import bluej.pkgmgr.actions.TutorialAction;
import bluej.pkgmgr.actions.UseLibraryAction;
import bluej.pkgmgr.actions.WebsiteAction;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.MethodInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PkgMgrFrame
extends JFrame
implements BlueJEventListener,
MouseListener,
PackageEditorListener,
FocusListener {
    public Font PkgMgrFont = PrefMgr.getStandardFont();
    static final int DEFAULT_WIDTH = 560;
    static final int DEFAULT_HEIGHT = 400;
    private static Application macApplication = PkgMgrFrame.prepareMacOSApp();
    private static boolean testToolsShown = PkgMgrFrame.wantToSeeTestingTools();
    private JPanel buttonPanel;
    private JPanel testPanel;
    private JCheckBoxMenuItem showUsesMenuItem;
    private JCheckBoxMenuItem showExtendsMenuItem;
    private AbstractButton imgExtendsButton;
    private AbstractButton imgDependsButton;
    private AbstractButton runButton;
    private JLabel statusbar;
    private JLabel testStatusMessage;
    private JLabel recordingLabel;
    private AbstractButton endTestButton;
    private AbstractButton cancelTestButton;
    private JMenuItem endTestMenuItem;
    private JMenuItem cancelTestMenuItem;
    private ClassTarget testTarget = null;
    private String testTargetMethod;
    private JMenuBar menubar = null;
    private JMenu recentProjectsMenu;
    private JMenu testingMenu;
    private MenuManager menuManager;
    private JMenuItem showTestResultsItem;
    private List itemsToDisable;
    private List actionsToDisable;
    private List testItems;
    private MachineIcon machineIcon;
    private JScrollPane classScroller = null;
    private Package pkg = null;
    private PackageEditor editor = null;
    private ObjectBench objbench;
    private TextEvalArea textEvaluator;
    private JSplitPane splitPane;
    private JSplitPane objectBenchSplitPane;
    private boolean showingTextEvaluator = false;
    private LibraryCallDialog libraryCallDialog = null;
    private ProjectPrintDialog projectPrintDialog = null;
    private static PageFormat pageFormat = null;
    private static List frames = new ArrayList();
    private static ExtensionsManager extMgr = ExtensionsManager.getInstance();

    private static Application prepareMacOSApp() {
        Application macApp = new Application();
        macApp.setEnabledPreferencesMenu(true);
        macApp.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent e) {
                HelpAboutAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
                e.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent e) {
                PreferencesAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
                e.setHandled(true);
            }

            public void handleQuit(ApplicationEvent e) {
                QuitAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
            }
        });
        return macApp;
    }

    public static PkgMgrFrame createFrame() {
        PkgMgrFrame frame = new PkgMgrFrame();
        frames.add(frame);
        BlueJEvent.addListener(frame);
        return frame;
    }

    public static PkgMgrFrame createFrame(Package pkg) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
        if (pmf == null) {
            if (frames.size() == 1) {
                pmf = (PkgMgrFrame)frames.get(0);
            }
            if (pmf == null || !pmf.isEmptyFrame()) {
                pmf = PkgMgrFrame.createFrame();
            }
            pmf.openPackage(pkg);
        }
        return pmf;
    }

    public static void closeFrame(PkgMgrFrame frame) {
        if (!frame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        frames.remove(frame);
        BlueJEvent.removeListener(frame);
        PrefMgr.setFlag("bluej.startWithTextEval", frame.showingTextEvaluator);
        frame.dispose();
    }

    public static PkgMgrFrame findFrame(Package pkg) {
        Iterator i = frames.iterator();
        while (i.hasNext()) {
            PkgMgrFrame pmf = (PkgMgrFrame)i.next();
            if (pmf.isEmptyFrame() || pmf.getPackage() != pkg) continue;
            return pmf;
        }
        return null;
    }

    public static int frameCount() {
        return frames.size();
    }

    public static PkgMgrFrame[] getAllFrames() {
        PkgMgrFrame[] openFrames = new PkgMgrFrame[frames.size()];
        frames.toArray(openFrames);
        return openFrames;
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj) {
        return PkgMgrFrame.getAllProjectFrames(proj, "");
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj, String pkgPrefix) {
        ArrayList<PkgMgrFrame> list = new ArrayList<PkgMgrFrame>();
        String pkgPrefixWithDot = pkgPrefix + ".";
        Iterator i = frames.iterator();
        while (i.hasNext()) {
            PkgMgrFrame pmf = (PkgMgrFrame)i.next();
            if (pmf.isEmptyFrame() || pmf.getProject() != proj) continue;
            String fullName = pmf.getPackage().getQualifiedName();
            if (fullName.startsWith(pkgPrefixWithDot)) {
                list.add(pmf);
                continue;
            }
            if (!fullName.equals(pkgPrefix) && pkgPrefix.length() != 0) continue;
            list.add(pmf);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new PkgMgrFrame[list.size()]);
    }

    public static PkgMgrFrame getMostRecent() {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllFrames();
        if (frames.length < 1) {
            return null;
        }
        PkgMgrFrame mostRecent = frames[0];
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].getFocusOwner() == null) continue;
            mostRecent = frames[i];
        }
        return mostRecent;
    }

    public static void updateTestingStatus() {
        if (testToolsShown != PkgMgrFrame.wantToSeeTestingTools()) {
            Iterator i = frames.iterator();
            while (i.hasNext()) {
                ((PkgMgrFrame)i.next()).showTestingTools(!testToolsShown);
            }
            testToolsShown = !testToolsShown;
        }
    }

    private static boolean wantToSeeTestingTools() {
        return PrefMgr.getFlag("bluej.testing.showtools");
    }

    public static void displayMessage(String message) {
        Iterator i = frames.iterator();
        while (i.hasNext()) {
            PkgMgrFrame frame = (PkgMgrFrame)i.next();
            frame.setStatus(message);
        }
    }

    public static void displayMessage(Package sourcePkg, String message) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            pmf.setStatus(message);
        }
    }

    public static void displayMessage(Project sourceProj, String message) {
        PkgMgrFrame[] pmf = PkgMgrFrame.getAllProjectFrames(sourceProj);
        if (pmf != null) {
            for (int i = 0; i < pmf.length; ++i) {
                if (pmf[i] == null) continue;
                pmf[i].setStatus(message);
            }
        }
    }

    public static void showError(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showError(pmf, msgId);
        }
    }

    public static void showMessage(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessage(pmf, msgId);
        }
    }

    public static void showMessageWithText(Package sourcePkg, String msgId, String text) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessageWithText(pmf, msgId, text);
        }
    }

    private PkgMgrFrame() {
        this.setupActionDisableSet();
        this.makeFrame();
        this.updateWindowTitle();
        this.setStatus("BlueJ 2.0.4");
    }

    public void openPackage(Package pkg) {
        if (pkg == null) {
            throw new NullPointerException();
        }
        if (this.pkg != null) {
            this.closePackage();
        }
        this.pkg = pkg;
        this.editor = new PackageEditor(pkg);
        this.editor.setFocusable(true);
        this.editor.addMouseListener(this);
        this.editor.addFocusListener(this);
        this.editor.startMouseListening();
        this.pkg.editor = this.editor;
        this.classScroller.setViewportView(this.editor);
        this.editor.addPackageEditorListener(this);
        Properties p = pkg.getLastSavedProperties();
        try {
            String width_str = p.getProperty("package.editor.width", Integer.toString(560));
            String height_str = p.getProperty("package.editor.height", Integer.toString(400));
            this.classScroller.setPreferredSize(new Dimension(Integer.parseInt(width_str), Integer.parseInt(height_str)));
            String x_str = p.getProperty("package.editor.x", "30");
            String y_str = p.getProperty("package.editor.y", "30");
            int x = Integer.parseInt(x_str);
            int y = Integer.parseInt(y_str);
            if (x > Config.screenBounds.width - 80) {
                x = Config.screenBounds.width - 80;
            }
            if (y > Config.screenBounds.height - 80) {
                y = Config.screenBounds.height - 80;
            }
            this.setLocation(x, y);
        }
        catch (NumberFormatException e) {
            Debug.reportError("Could not read preferred project screen position");
        }
        String uses_str = p.getProperty("package.showUses", "true");
        String extends_str = p.getProperty("package.showExtends", "true");
        this.showUsesMenuItem.setSelected(uses_str.equals("true"));
        this.showExtendsMenuItem.setSelected(extends_str.equals("true"));
        this.updateShowUsesInPackage();
        this.updateShowExtendsInPackage();
        this.pack();
        this.editor.revalidate();
        this.editor.requestFocus();
        Runnable enableUI = new Runnable(){

            public void run() {
                PkgMgrFrame.this.enableFunctions(true);
                PkgMgrFrame.this.updateWindowTitle();
                PkgMgrFrame.this.show();
            }
        };
        SwingUtilities.invokeLater(enableUI);
        this.menuManager.setAttachedObject(pkg);
        this.menuManager.addExtensionMenu(pkg.getProject());
        extMgr.packageOpened(pkg);
    }

    public void closePackage() {
        if (this.isEmptyFrame()) {
            return;
        }
        extMgr.packageClosing(this.pkg);
        this.classScroller.setViewportView(null);
        this.classScroller.setBorder(Config.normalBorder);
        this.editor.removePackageEditorListener(this);
        this.editor.removeMouseListener(this);
        this.editor.removeFocusListener(this);
        this.getObjectBench().removeAllObjects(this.getProject().getUniqueId());
        this.clearTextEval();
        this.getPackage().closeAllEditors();
        Project proj = this.getProject();
        this.editor = null;
        this.pkg = null;
        this.menuManager.setAttachedObject(this.pkg);
        if (PkgMgrFrame.getAllProjectFrames(proj) == null) {
            Project.cleanUp(proj);
        }
    }

    public void show() {
        super.show();
        this.setState(0);
        this.toFront();
    }

    public Package getPackage() {
        return this.pkg;
    }

    public Project getProject() {
        return this.pkg == null ? null : this.pkg.getProject();
    }

    public boolean isEmptyFrame() {
        return this.pkg == null;
    }

    protected String updateWindowTitle() {
        if (this.isEmptyFrame()) {
            this.setTitle("BlueJ");
            return "BlueJ";
        }
        String title = Config.getString("pkgmgr.title") + this.getProject().getProjectName();
        if (!this.getPackage().isUnnamedPackage()) {
            title = title + "  [" + this.getPackage().getQualifiedName() + "]";
        }
        this.setTitle(title);
        return title;
    }

    public void setStatus(String status) {
        if (this.statusbar != null) {
            this.statusbar.setText(status);
        }
    }

    public void clearStatus() {
        if (this.statusbar != null) {
            this.statusbar.setText(" ");
        }
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public ObjectBench getObjectBench() {
        return this.objbench;
    }

    public void mousePressed(MouseEvent evt) {
        this.clearStatus();
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void focusGained(FocusEvent e) {
        this.classScroller.setBorder(Config.focusBorder);
        this.editor.setHasFocus(true);
    }

    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.classScroller.setBorder(Config.normalBorder);
            this.editor.setHasFocus(false);
        }
    }

    public void targetEvent(PackageEditorEvent e) {
        int evtId = e.getID();
        switch (evtId) {
            case 1: {
                this.callMethod(e.getCallable());
                break;
            }
            case 2: {
                ((Target)e.getSource()).remove();
                break;
            }
            case 3: {
                this.openPackageTarget(e.getName());
                break;
            }
            case 4: {
                ClassTarget ct = (ClassTarget)e.getSource();
                ct.getRole().run(this, ct, e.getName());
                break;
            }
            case 5: {
                this.objectBenchToTestFixture((ClassTarget)e.getSource());
                break;
            }
            case 6: {
                this.testFixtureToObjectBench((ClassTarget)e.getSource());
                break;
            }
            case 7: {
                this.makeTestCase((ClassTarget)e.getSource());
                break;
            }
            case 8: {
                DebuggerObject gotObj = e.getDebuggerObject();
                boolean tryAgain = true;
                do {
                    String newObjectName;
                    if ((newObjectName = DialogManager.askString((Component)e.getSource(), "getobject-new-name", this.getProject().getDebugger().guessNewName(gotObj))) == null) {
                        tryAgain = false;
                        continue;
                    }
                    if (JavaNames.isIdentifier(newObjectName)) {
                        this.putObjectOnBench(newObjectName, e.getDebuggerObject(), e.getInvokerRecord());
                        tryAgain = false;
                        continue;
                    }
                    DialogManager.showError((Component)e.getSource(), "must-be-identifier");
                } while (tryAgain);
            }
        }
    }

    public boolean newProject(String dirName) {
        if (Project.createNewProject(dirName)) {
            Project proj = Project.openProject(dirName);
            if (this.isEmptyFrame()) {
                this.openPackage(proj.getPackage(""));
            } else {
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(proj.getPackage(""));
                DialogManager.tileWindow(pmf, this);
                pmf.show();
            }
            return true;
        }
        return false;
    }

    public File[] importProjectDir(File dir, boolean showFailureDialog) {
        Object[] fails = FileUtility.recursiveCopyFile(dir, this.getPackage().getPath());
        if (fails != null && showFailureDialog) {
            ImportFailedDialog ifd = new ImportFailedDialog(this, fails);
            ifd.show();
        }
        List dirsToConvert = Import.findInterestingDirectories(this.getPackage().getPath());
        Import.convertDirectory(dirsToConvert);
        this.getProject().reloadAll();
        return fails;
    }

    public boolean createNewClass(String name, String template, boolean showErr) {
        if (this.pkg.getTarget(name) != null) {
            DialogManager.showError(this, "duplicate-name");
            return false;
        }
        ClassTarget target = null;
        target = new ClassTarget(this.pkg, name, template);
        target.generateSkeleton(template);
        this.pkg.findSpaceForVertex(target);
        this.pkg.addTarget(target);
        this.editor.revalidate();
        this.editor.scrollRectToVisible(target.getRectangle());
        this.editor.repaint();
        if (target.getRole() instanceof UnitTestClassRole) {
            this.pkg.compileQuiet(target);
        }
        return true;
    }

    public boolean doNewProject() {
        String newname = FileUtility.getFileName(this, Config.getString("pkgmgr.newPkg.title"), Config.getString("pkgmgr.newPkg.buttonLabel"), false, null, true);
        if (newname == null) {
            return false;
        }
        if (!this.newProject(newname)) {
            DialogManager.showError(null, "directory-exists");
            return false;
        }
        return true;
    }

    public void doOpen() {
        File dirName = FileUtility.getPackageName(this);
        if (dirName != null) {
            this.openProject(dirName.getAbsolutePath());
        }
    }

    private boolean openProject(String projectPath) {
        Package pkg;
        PkgMgrFrame pmf;
        Project openProj = Project.openProject(projectPath);
        if (openProj == null) {
            return false;
        }
        if (openProj.isReadOnly()) {
            DialogManager.showMessage(this, "project-is-readonly");
        }
        if ((pmf = PkgMgrFrame.findFrame(pkg = openProj.getPackage(openProj.getInitialPackageName()))) == null) {
            if (this.isEmptyFrame()) {
                pmf = this;
                this.openPackage(pkg);
            } else {
                pmf = PkgMgrFrame.createFrame(pkg);
                DialogManager.tileWindow(pmf, this);
            }
        }
        pmf.show();
        return true;
    }

    public void doOpenNonBlueJ() {
        File dirName = FileUtility.getNonBlueJDirectoryName(this);
        if (dirName == null) {
            return;
        }
        if (dirName != null) {
            File absDirName = dirName.getAbsoluteFile();
            if (Project.isProject(absDirName.getPath())) {
                DialogManager.showError(this, "open-non-bluej-already-bluej");
                return;
            }
            List interestingDirs = Import.findInterestingDirectories(absDirName);
            if (interestingDirs.size() == 0) {
                DialogManager.showError(this, "open-non-bluej-no-java");
                return;
            }
            List javaFiles = Import.findJavaFiles(interestingDirs);
            ArrayList<File> mismatchFiles = new ArrayList<File>();
            ArrayList<String> mismatchPackagesOriginal = new ArrayList<String>();
            ArrayList<String> mismatchPackagesChanged = new ArrayList<String>();
            Iterator it = javaFiles.iterator();
            while (it.hasNext()) {
                File f = (File)it.next();
                try {
                    ClassInfo info = ClassParser.parse(f);
                    String qf = JavaNames.convertFileToQualifiedName(absDirName, f);
                    if (JavaNames.getPrefix(qf).equals(info.getPackage())) continue;
                    mismatchFiles.add(f);
                    mismatchPackagesOriginal.add(info.getPackage());
                    mismatchPackagesChanged.add(qf);
                }
                catch (Exception e) {}
            }
            if (mismatchFiles.size() > 0) {
                ImportMismatchDialog imd = new ImportMismatchDialog(this, mismatchFiles, mismatchPackagesOriginal, mismatchPackagesChanged);
                imd.show();
                if (!imd.getResult()) {
                    return;
                }
            }
            Import.convertDirectory(interestingDirs);
            Project openProj = Project.openProject(absDirName.getPath());
            if (openProj == null) {
                return;
            }
            Package pkg = openProj.getPackage(openProj.getInitialPackageName());
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
            if (pmf == null) {
                if (this.isEmptyFrame()) {
                    pmf = this;
                    this.openPackage(pkg);
                } else {
                    pmf = PkgMgrFrame.createFrame(pkg);
                    DialogManager.tileWindow(pmf, this);
                }
            }
            pmf.show();
        }
    }

    public void doClose(boolean keepLastFrame) {
        this.doSave();
        if (PkgMgrFrame.frameCount() == 1) {
            if (keepLastFrame) {
                this.closePackage();
                this.updateWindowTitle();
                this.updateRecentProjects();
                Runnable disableUI = new Runnable(){

                    public void run() {
                        PkgMgrFrame.this.enableFunctions(false);
                        PkgMgrFrame.this.updateWindowTitle();
                    }
                };
                SwingUtilities.invokeLater(disableUI);
            } else {
                this.doQuit();
            }
        } else {
            this.closePackage();
            PkgMgrFrame.closeFrame(this);
        }
    }

    public void wantToQuit() {
        int answer = 0;
        if (Project.getOpenProjectCount() > 1) {
            answer = DialogManager.askQuestion(this, "quit-all");
        }
        if (answer == 0) {
            this.doQuit();
        }
    }

    private void doQuit() {
        PkgMgrFrame[] pkgFrames = PkgMgrFrame.getAllFrames();
        this.handleOrphanPackages(pkgFrames);
        for (int i = pkgFrames.length - 1; i >= 0; --i) {
            PkgMgrFrame aFrame = pkgFrames[i];
            aFrame.doSave();
            aFrame.closePackage();
            PkgMgrFrame.closeFrame(aFrame);
        }
        extMgr.unloadExtensions();
        Main.exit();
    }

    private void handleOrphanPackages(PkgMgrFrame[] openFrames) {
        if (PkgMgrFrame.hadOrphanPackages()) {
            this.removeOrphanPackageList();
        }
        for (int i = 0; i < openFrames.length; ++i) {
            PkgMgrFrame aFrame = openFrames[i];
            if (aFrame.isEmptyFrame()) continue;
            Config.putPropString("bluej.openPackage" + (i + 1), aFrame.getPackage().getPath().toString());
        }
    }

    public static boolean hadOrphanPackages() {
        return Config.getPropString("bluej.openPackage1", null) != null;
    }

    private void removeOrphanPackageList() {
        String exists = "";
        int i = 1;
        while (exists != null) {
            exists = Config.removeProperty("bluej.openPackage" + i);
            ++i;
        }
    }

    protected void doSave() {
        if (this.isEmptyFrame()) {
            return;
        }
        Properties p = new Properties();
        Dimension d = this.classScroller.getSize(null);
        p.put("package.editor.width", Integer.toString(d.width));
        p.put("package.editor.height", Integer.toString(d.height));
        Point point = this.getLocation();
        p.put("package.editor.x", Integer.toString(point.x));
        p.put("package.editor.y", Integer.toString(point.y));
        p.put("package.showUses", new Boolean(this.isShowUses()).toString());
        p.put("package.showExtends", new Boolean(this.isShowExtends()).toString());
        this.pkg.save(p);
        this.setStatus(Config.getString("pkgmgr.packageSaved"));
    }

    public void doImport() {
        String importName = FileUtility.getFileName(this, Config.getString("pkgmgr.importPkg.title"), Config.getString("pkgmgr.importPkg.buttonLabel"), true, null, false);
        if (importName == null) {
            return;
        }
        File importDir = new File(importName);
        if (!importDir.isDirectory()) {
            return;
        }
        if (this.isEmptyFrame()) {
            return;
        }
        this.importProjectDir(new File(importName), true);
    }

    public void doAddFromFile() {
        File[] classes = FileUtility.getMultipleFiles(this, Config.getString("pkgmgr.addClass.title"), Config.getString("pkgmgr.addClass.buttonLabel"), FileUtility.getJavaSourceFilter());
        if (classes == null) {
            return;
        }
        block7: for (int i = 0; i < classes.length; ++i) {
            int result = this.pkg.importFile(classes[i]);
            switch (result) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    DialogManager.showErrorWithText(this, "file-does-not-exist", classes[i].getName());
                    continue block7;
                }
                case 2: {
                    DialogManager.showErrorWithText(this, "cannot-import", classes[i].getName());
                    continue block7;
                }
                case 4: {
                    DialogManager.showErrorWithText(this, "duplicate-name", classes[i].getName());
                    continue block7;
                }
                case 3: {
                    DialogManager.showErrorWithText(this, "error-in-import", classes[i].getName());
                }
            }
        }
    }

    public void doExport() {
        ExportManager exporter = new ExportManager(this);
        exporter.export();
    }

    public void doPageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pfmt = job.pageDialog(PkgMgrFrame.getPageFormat());
        PkgMgrFrame.setPageFormat(pfmt);
    }

    public static PageFormat getPageFormat() {
        if (pageFormat == null) {
            pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        return pageFormat;
    }

    public static void setPageFormat(PageFormat page) {
        pageFormat = page;
    }

    public void doPrint() {
        if (this.projectPrintDialog == null) {
            this.projectPrintDialog = new ProjectPrintDialog(this);
        }
        if (this.projectPrintDialog.display()) {
            PackagePrintManager printManager = new PackagePrintManager(this.getPackage(), PkgMgrFrame.getPageFormat(), this.projectPrintDialog);
            printManager.start();
        }
    }

    public void showPreferences() {
        PrefMgrDialog.showDialog();
    }

    public void aboutBlueJ() {
        AboutBlue about = new AboutBlue(this, "2.0.4");
        about.setVisible(true);
    }

    public void showCopyright() {
        JOptionPane.showMessageDialog(this, new String[]{"BlueJ \u00a9 2000-2004 Michael K\u00f6lling, John Rosenberg.", " ", Config.getString("menu.help.copyright.line1"), Config.getString("menu.help.copyright.line2"), Config.getString("menu.help.copyright.line3"), Config.getString("menu.help.copyright.line4")}, Config.getString("menu.help.copyright.title"), 1);
    }

    private void callMethod(CallableView cv) {
        ResultWatcher watcher = null;
        if (cv instanceof ConstructorView) {
            watcher = new ResultWatcher(){

                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    if (name == null || name.length() == 0) {
                        name = "result";
                    }
                    if (result != null) {
                        ObjectWrapper wrapper = ObjectWrapper.getWrapper(PkgMgrFrame.this, PkgMgrFrame.this.getObjectBench(), result, name);
                        PkgMgrFrame.this.getObjectBench().addObject(wrapper);
                        PkgMgrFrame.this.getPackage().getDebugger().addObject(wrapper.getName(), result);
                        PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    }
                }

                public void putError(String msg) {
                }

                public ExpressionInformation getExpressionInformation() {
                    return null;
                }
            };
        } else if (cv instanceof MethodView) {
            final MethodView mv = (MethodView)cv;
            watcher = new ResultWatcher(){
                private ExpressionInformation expressionInformation;
                {
                    this.expressionInformation = new ExpressionInformation(mv, PkgMgrFrame.this.getName());
                }

                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    if (name == null) {
                        return;
                    }
                    if (result == null) {
                        return;
                    }
                    ResultInspector viewer = ResultInspector.getInstance(result, name, PkgMgrFrame.this.getPackage(), ir, this.expressionInformation, PkgMgrFrame.this);
                    BlueJEvent.raiseEvent(3, viewer.getResult());
                }

                public void putError(String msg) {
                }

                public ExpressionInformation getExpressionInformation() {
                    return this.expressionInformation;
                }
            };
        }
        new Invoker(this, cv, watcher).invokeInteractive();
    }

    private void openPackageTarget(String newname) {
        Package p = this.getPackage().getProject().getPackage(newname);
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(p);
        if (pmf == null) {
            pmf = PkgMgrFrame.createFrame(p);
            DialogManager.tileWindow(pmf, this);
        }
        pmf.show();
    }

    private void objectBenchToTestFixture(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doBenchToFixture(this, target);
        }
    }

    private void testFixtureToObjectBench(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doFixtureToBench(this, target);
        }
    }

    private void makeTestCase(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            if (!testToolsShown) {
                this.showTestingTools(true);
            }
            utcr.doMakeTestCase(this, target);
        }
    }

    public void putObjectOnBench(String newInstanceName, DebuggerObject object, InvokerRecord ir) {
        if (!object.isNullObject()) {
            ObjectWrapper wrapper = ObjectWrapper.getWrapper(this, this.getObjectBench(), object, newInstanceName);
            this.getObjectBench().addObject(wrapper);
            this.getPackage().getDebugger().addObject(wrapper.getName(), object);
            if (ir instanceof MethodInvokerRecord) {
                MethodInvokerRecord mir = (MethodInvokerRecord)ir;
                mir.setBenchName(newInstanceName, wrapper.getObject().getClassName());
            }
        }
    }

    public void doCreateNewClass() {
        NewClassDialog dlg = new NewClassDialog(this);
        boolean okay = dlg.display();
        if (okay) {
            String name = dlg.getClassName();
            String template = dlg.getTemplateName();
            this.createNewClass(name, template, true);
        }
    }

    public void doCreateNewPackage() {
        NewPackageDialog dlg = new NewPackageDialog(this);
        boolean okay = dlg.display();
        if (!okay) {
            return;
        }
        String name = dlg.getPackageName();
        if (name.length() == 0) {
            return;
        }
        this.createNewPackage(name, true);
    }

    public boolean createNewPackage(String name, boolean showErrDialog) {
        Package newPackage;
        String fullName = name.indexOf(46) > -1 ? name : this.getPackage().getQualifiedName(name);
        if (this.getProject().getPackage(fullName) != null) {
            if (showErrDialog) {
                DialogManager.showError(this, "duplicate-name");
            }
            return false;
        }
        String prefix = JavaNames.getPrefix(fullName);
        String base = JavaNames.getBase(fullName);
        Package basePkg = this.getProject().getPackage(prefix);
        if (basePkg != null && basePkg.getTarget(base) != null) {
            if (showErrDialog) {
                DialogManager.showError(this, "duplicate-name");
            }
            return false;
        }
        this.getProject().createPackageDirectory(fullName);
        if (newPackage == null) {
            Debug.reportError("creation of new package failed unexpectedly");
            return false;
        }
        for (newPackage = this.getProject().getPackage(fullName); newPackage != null; newPackage = newPackage.getParent()) {
            newPackage.reload();
        }
        return true;
    }

    public void doRemove() {
        Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (permanentFocusOwner == this.editor) {
            if (!this.doRemoveTargets() && !this.doRemoveDependency()) {
                DialogManager.showError(this, "no-class-selected");
            }
        } else if (permanentFocusOwner == this.objbench) {
            this.objbench.removeSelectedObject(this.pkg.getId());
        }
    }

    private boolean doRemoveTargets() {
        Target[] targets = this.pkg.getSelectedTargets();
        if (targets.length <= 0) {
            return false;
        }
        if (this.askRemoveClass()) {
            for (int i = 0; i < targets.length; ++i) {
                targets[i].remove();
            }
        }
        return true;
    }

    private boolean doRemoveDependency() {
        Dependency dependency = this.pkg.getSelectedDependency();
        if (dependency == null) {
            return false;
        }
        dependency.remove();
        return true;
    }

    public void doNewUses() {
        this.pkg.setState(1);
        this.setStatus(Config.getString("pkgmgr.chooseUsesFrom"));
        this.pkg.getEditor().clearSelection();
    }

    public void doNewInherits() {
        this.pkg.setState(3);
        this.setStatus(Config.getString("pkgmgr.chooseInhFrom"));
        this.pkg.getEditor().clearSelection();
    }

    public void doTest() {
        this.runButton.setEnabled(false);
        List l = this.pkg.getTestTargets();
        final Iterator it = l.iterator();
        TestDisplayFrame.getTestDisplay().startMultipleTests();
        Thread thr = new Thread(){

            public void run() {
                while (it.hasNext()) {
                    ClassTarget ct = (ClassTarget)it.next();
                    if (!ct.isCompiled() || !ct.isUnitTest()) continue;
                    UnitTestClassRole utcr = (UnitTestClassRole)ct.getRole();
                    utcr.doRunTest(PkgMgrFrame.this, ct, null);
                }
                TestDisplayFrame.getTestDisplay().endMultipleTests();
                EventQueue.invokeLater(new Runnable(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        PkgMgrFrame.access$100(6.access$000(this.this$1)).setEnabled(true);
                    }
                });
            }

            static /* synthetic */ PkgMgrFrame access$000(6 x0) {
                return x0.PkgMgrFrame.this;
            }
        };
        thr.start();
    }

    public void doEndTest() {
        if (this.testTarget != null) {
            this.testRecordingEnded();
            if (this.testTarget.getRole() instanceof UnitTestClassRole) {
                UnitTestClassRole utcr = (UnitTestClassRole)this.testTarget.getRole();
                utcr.doEndMakeTestCase(this, this.testTarget, this.testTargetMethod);
            }
            this.getProject().removeLocalClassLoader();
            this.getProject().newRemoteClassLoader();
            this.getPackage().compileQuiet(this.testTarget);
            this.testTarget = null;
        }
    }

    public void doCancelTest() {
        this.testRecordingEnded();
        this.getProject().removeLocalClassLoader();
        this.getProject().newRemoteClassLoader();
        this.testTarget = null;
    }

    public void testRecordingStarted(String message) {
        this.recordingLabel.setEnabled(true);
        this.testStatusMessage.setText(message);
        this.endTestButton.setEnabled(true);
        this.endTestMenuItem.setEnabled(true);
        this.cancelTestButton.setEnabled(true);
        this.cancelTestMenuItem.setEnabled(true);
        this.getProject().setTestMode(true);
    }

    private void testRecordingEnded() {
        this.recordingLabel.setEnabled(false);
        this.testStatusMessage.setText("");
        this.endTestButton.setEnabled(false);
        this.endTestMenuItem.setEnabled(false);
        this.cancelTestButton.setEnabled(false);
        this.cancelTestMenuItem.setEnabled(false);
        this.getProject().setTestMode(false);
    }

    public void setTestInfo(String testName, ClassTarget testClass) {
        this.testTargetMethod = testName;
        this.testTarget = testClass;
    }

    public boolean askRemoveClass() {
        int response = DialogManager.askQuestion(this, "really-remove-class");
        return response == 0;
    }

    public boolean askRemovePackage(PackageTarget removableTarget) {
        String name = removableTarget.getQualifiedName();
        PkgMgrFrame[] f = PkgMgrFrame.getAllProjectFrames(this.getProject(), name);
        if (f != null) {
            DialogManager.showError(this, "remove-package-open");
            return false;
        }
        int response = DialogManager.askQuestion(this, "really-remove-package");
        return response == 0;
    }

    public void compileSelected() {
        Target[] targets = this.pkg.getSelectedTargets();
        if (targets.length > 0) {
            for (int i = 0; i < targets.length; ++i) {
                ClassTarget t;
                if (!(targets[i] instanceof ClassTarget) || !(t = (ClassTarget)targets[i]).hasSourceCode()) continue;
                this.pkg.compile(t);
            }
        } else {
            DialogManager.showError(this, "no-class-selected-compile");
        }
    }

    public void callLibraryClass() {
        if (this.libraryCallDialog == null) {
            this.libraryCallDialog = new LibraryCallDialog(this);
        }
        this.libraryCallDialog.setVisible(true);
    }

    public void generateProjectDocumentation() {
        String message = this.pkg.generateDocumentation();
        if (message != "") {
            DialogManager.showText(this, message);
        }
    }

    public void showDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().getExecControls().showHide(true);
        }
    }

    public void restartDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().restartVM();
        }
    }

    public void updateShowUsesInPackage() {
        this.pkg.setShowUses(this.isShowUses());
        this.editor.repaint();
    }

    public void updateShowExtendsInPackage() {
        this.pkg.setShowExtends(this.isShowExtends());
        this.editor.repaint();
    }

    public boolean isShowUses() {
        return this.showUsesMenuItem.isSelected();
    }

    public boolean isShowExtends() {
        return this.showExtendsMenuItem.isSelected();
    }

    public void showTestingTools(boolean show) {
        Iterator it = this.testItems.iterator();
        while (it.hasNext()) {
            JComponent component = (JComponent)it.next();
            component.setVisible(show);
        }
    }

    public boolean isTextEvalVisible() {
        return this.showingTextEvaluator;
    }

    public void showHideTextEval(boolean show) {
        if (this.showingTextEvaluator == show) {
            return;
        }
        if (show) {
            this.addTextEvaluatorPane();
            this.textEvaluator.requestFocus();
        } else {
            this.removeTextEvaluatorPane();
            this.editor.requestFocus();
        }
        this.pack();
        this.showingTextEvaluator = show;
    }

    public void clearTextEval() {
        if (this.textEvaluator != null) {
            this.textEvaluator.clear();
        }
    }

    public void blueJEvent(int eventId, Object arg) {
        switch (eventId) {
            case 0: {
                this.setStatus(Config.getString("pkgmgr.creatingVM"));
                break;
            }
            case 2: {
                this.setStatus(Config.getString("pkgmgr.creatingVMDone"));
                break;
            }
            case 6: {
                this.setStatus(Config.getString("pkgmgr.generatingDocu"));
                break;
            }
            case 7: {
                this.setStatus(Config.getString("pkgmgr.docuGenerated"));
                break;
            }
            case 8: {
                this.setStatus(Config.getString("pkgmgr.docuAborted"));
                break;
            }
            case 1: {
                DialogManager.showError(this, "error-create-vm");
                this.doQuit();
            }
        }
    }

    public void setDebuggerState(int state) {
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                this.machineIcon.setIdle();
                this.getProject().getTerminal().activate(false);
                break;
            }
            case 3: {
                this.machineIcon.setRunning();
                this.getProject().getTerminal().activate(true);
                break;
            }
            case 4: {
                this.machineIcon.setStopped();
            }
        }
    }

    public String toString() {
        String str = "PkgMgrFrame(): ";
        str = this.isEmptyFrame() ? str + "empty" : str + this.getPackage().toString() + " " + this.getProject().toString();
        return str;
    }

    public void showWebPage(String url) {
        if (Utility.openWebBrowser(url)) {
            this.setStatus(Config.getString("pkgmgr.webBrowserMsg"));
        } else {
            this.setStatus(Config.getString("pkgmgr.webBrowserError"));
        }
    }

    private void makeFrame() {
        this.setFont(this.PkgMgrFont);
        this.setIconImage(BlueJTheme.getIconImage());
        this.testItems = new ArrayList();
        this.setupMenus();
        Container contentPane = this.getContentPane();
        ((JPanel)contentPane).setBorder(BlueJTheme.generalBorderWithStatusBar);
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        PkgMgrAction action = RestartVMAction.getInstance();
        mainPanel.getInputMap(2).put((KeyStroke)action.getValue("AcceleratorKey"), "restartVM");
        mainPanel.getActionMap().put("restartVM", action);
        JPanel toolPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        action = NewClassAction.getInstance();
        AbstractButton button = this.createButton(action, false, false, 4, 4);
        this.buttonPanel.add(button);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        action = NewUsesAction.getInstance();
        this.imgDependsButton = this.createButton(action, true, false, 4, 4);
        this.buttonPanel.add(this.imgDependsButton);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        action = NewInheritsAction.getInstance();
        this.imgExtendsButton = this.createButton(action, true, false, 4, 4);
        this.buttonPanel.add(this.imgExtendsButton);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        action = CompileAction.getInstance();
        button = this.createButton(action, false, false, 4, 4);
        this.buttonPanel.add(button);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        this.buttonPanel.setAlignmentX(0.5f);
        this.testPanel = new JPanel();
        this.testPanel.setLayout(new BoxLayout(this.testPanel, 1));
        this.testPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 14, 5));
        action = RunTestsAction.getInstance();
        this.runButton = this.createButton(action, false, false, 2, 4);
        this.runButton.setText(Config.getString("pkgmgr.test.run"));
        this.runButton.setAlignmentX(0.15f);
        this.testPanel.add(this.runButton);
        this.testPanel.add(Box.createVerticalStrut(8));
        this.recordingLabel = new JLabel(Config.getString("pkgmgr.test.record"), Config.getImageAsIcon("image.test.recording"), 10);
        this.recordingLabel.setFont(this.PkgMgrFont);
        this.recordingLabel.setEnabled(false);
        this.recordingLabel.setAlignmentX(0.15f);
        this.testPanel.add(this.recordingLabel);
        this.testPanel.add(Box.createVerticalStrut(3));
        action = EndTestRecordAction.getInstance();
        this.endTestButton = this.createButton(action, false, false, 2, 4);
        this.endTestButton.setText(Config.getString("pkgmgr.test.end"));
        this.endTestButton.setEnabled(false);
        this.testPanel.add(this.endTestButton);
        this.testPanel.add(Box.createVerticalStrut(3));
        action = CancelTestRecordAction.getInstance();
        this.cancelTestButton = this.createButton(action, false, false, 2, 4);
        this.cancelTestButton.setText(Config.getString("cancel"));
        this.cancelTestButton.setEnabled(false);
        this.testPanel.add(this.cancelTestButton);
        this.testPanel.setAlignmentX(0.5f);
        this.testItems.add(this.testPanel);
        this.machineIcon = new MachineIcon();
        this.machineIcon.setAlignmentX(0.5f);
        this.itemsToDisable.add(this.machineIcon);
        toolPanel.setLayout(new BoxLayout(toolPanel, 1));
        toolPanel.add(this.buttonPanel);
        toolPanel.add(Box.createVerticalGlue());
        toolPanel.add(this.testPanel);
        toolPanel.add(this.machineIcon);
        mainPanel.add((Component)toolPanel, "West");
        this.classScroller = new JScrollPane();
        this.classScroller.setBorder(Config.normalBorder);
        this.classScroller.setPreferredSize(new Dimension(560, 400));
        this.classScroller.setSize(new Dimension(560, 400));
        this.classScroller.setFocusable(false);
        this.classScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.classScroller.getHorizontalScrollBar().setUnitIncrement(20);
        mainPanel.add((Component)this.classScroller, "Center");
        this.objbench = new ObjectBench();
        this.itemsToDisable.add(this.objbench);
        this.splitPane = new JSplitPane(0, mainPanel, this.objbench);
        this.splitPane.setBorder(null);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(5);
        contentPane.add((Component)this.splitPane, "Center");
        JPanel statusArea = new JPanel(new BorderLayout());
        statusArea.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 6));
        this.statusbar = new JLabel(" ");
        this.statusbar.setFont(this.PkgMgrFont);
        statusArea.add((Component)this.statusbar, "Center");
        this.testStatusMessage = new JLabel(" ");
        this.testStatusMessage.setFont(this.PkgMgrFont);
        statusArea.add((Component)this.testStatusMessage, "West");
        contentPane.add((Component)statusArea, "South");
        if (!testToolsShown) {
            this.showTestingTools(false);
        }
        if (PrefMgr.getFlag("bluej.startWithTextEval")) {
            this.addTextEvaluatorPane();
        }
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                PkgMgrFrame pmf = (PkgMgrFrame)E.getWindow();
                pmf.doClose(false);
            }
        });
        if (this.isEmptyFrame()) {
            this.enableFunctions(false);
        }
    }

    private void addTextEvaluatorPane() {
        this.classScroller.setPreferredSize(this.classScroller.getSize());
        if (this.textEvaluator == null) {
            this.textEvaluator = new TextEvalArea(this, this.PkgMgrFont);
            this.objectBenchSplitPane = new JSplitPane(1, this.objbench, this.textEvaluator);
            this.objectBenchSplitPane.setBorder(null);
            this.objectBenchSplitPane.setResizeWeight(1.0);
            this.objectBenchSplitPane.setDividerSize(5);
            this.itemsToDisable.add(this.textEvaluator);
        } else {
            this.objectBenchSplitPane.setLeftComponent(this.objbench);
        }
        this.splitPane.setBottomComponent(this.objectBenchSplitPane);
        this.showingTextEvaluator = true;
    }

    private void removeTextEvaluatorPane() {
        this.textEvaluator.setPreferredSize(this.textEvaluator.getSize());
        this.classScroller.setPreferredSize(this.classScroller.getSize());
        this.splitPane.setBottomComponent(this.objbench);
        this.showingTextEvaluator = false;
    }

    private AbstractButton createButton(Action action, boolean notext, boolean toggle, int hSpacing, int vSpacing) {
        AbstractButton button = toggle ? new JToggleButton(action) : new JButton(action);
        button.setFont(this.PkgMgrFont);
        button.putClientProperty("JButton.buttonType", "toolbar");
        button.setFocusable(false);
        if (notext) {
            button.setText(null);
        }
        Dimension pref = button.getMinimumSize();
        pref.width = Integer.MAX_VALUE;
        button.setMaximumSize(pref);
        button.setMargin(new Insets(vSpacing, hSpacing, vSpacing, hSpacing));
        return button;
    }

    private void setupMenus() {
        this.menubar = new JMenuBar();
        this.itemsToDisable = new ArrayList();
        JMenu menu = new JMenu(Config.getString("menu.package"));
        int mnemonic = Config.getMnemonicKey("menu.package");
        menu.setMnemonic(mnemonic);
        this.menubar.add(menu);
        this.createMenuItem(NewProjectAction.getInstance(), menu);
        this.createMenuItem(OpenProjectAction.getInstance(), menu);
        this.recentProjectsMenu = new JMenu(Config.getString("menu.package.openRecent"));
        menu.add(this.recentProjectsMenu);
        this.createMenuItem(OpenNonBlueJAction.getInstance(), menu);
        this.createMenuItem(CloseProjectAction.getInstance(), menu);
        this.createMenuItem(SaveProjectAction.getInstance(), menu);
        this.createMenuItem(SaveProjectAsAction.getInstance(), menu);
        menu.addSeparator();
        this.createMenuItem(ImportProjectAction.getInstance(), menu);
        this.createMenuItem(ExportProjectAction.getInstance(), menu);
        menu.addSeparator();
        this.createMenuItem(PageSetupAction.getInstance(), menu);
        this.createMenuItem(PrintAction.getInstance(), menu);
        if (!Config.usingMacScreenMenubar()) {
            menu.addSeparator();
            this.createMenuItem(QuitAction.getInstance(), menu);
        }
        menu = new JMenu(Config.getString("menu.edit"));
        menu.setMnemonic(Config.getMnemonicKey("menu.edit"));
        this.menubar.add(menu);
        this.createMenuItem(NewClassAction.getInstance(), menu);
        this.createMenuItem(NewPackageAction.getInstance(), menu);
        this.createMenuItem(AddClassAction.getInstance(), menu);
        this.createMenuItem(RemoveAction.getInstance(), menu);
        menu.addSeparator();
        this.createMenuItem(NewUsesAction.getInstance(), menu);
        this.createMenuItem(NewInheritsAction.getInstance(), menu);
        menu = new JMenu(Config.getString("menu.tools"));
        menu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        this.menubar.add(menu);
        this.createMenuItem(CompileAction.getInstance(), menu);
        this.createMenuItem(CompileSelectedAction.getInstance(), menu);
        this.createMenuItem(RebuildAction.getInstance(), menu);
        menu.addSeparator();
        this.createMenuItem(UseLibraryAction.getInstance(), menu);
        this.createMenuItem(GenerateDocsAction.getInstance(), menu);
        this.testingMenu = new JMenu(Config.getString("menu.tools.testing"));
        this.testingMenu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        this.createMenuItem(RunTestsAction.getInstance(), this.testingMenu);
        this.endTestMenuItem = this.createMenuItem(EndTestRecordAction.getInstance(), this.testingMenu);
        this.cancelTestMenuItem = this.createMenuItem(CancelTestRecordAction.getInstance(), this.testingMenu);
        this.endTestMenuItem.setEnabled(false);
        this.cancelTestMenuItem.setEnabled(false);
        this.testItems.add(this.testingMenu);
        menu.add(this.testingMenu);
        if (!Config.usingMacScreenMenubar()) {
            menu.addSeparator();
            this.createMenuItem(PreferencesAction.getInstance(), menu);
        }
        this.menuManager = new MenuManager(menu.getPopupMenu());
        if (frames.size() <= 1) {
            this.menuManager.addExtensionMenu(null);
        }
        menu = new JMenu(Config.getString("menu.view"));
        menu.setMnemonic(Config.getMnemonicKey("menu.view"));
        this.menubar.add(menu);
        this.showUsesMenuItem = this.createCheckboxMenuItem(ShowUsesAction.getInstance(), menu, true);
        this.showExtendsMenuItem = this.createCheckboxMenuItem(ShowInheritsAction.getInstance(), menu, true);
        menu.addSeparator();
        this.createCheckboxMenuItem(ShowDebuggerAction.getInstance(), menu, false);
        this.createCheckboxMenuItem(ShowTerminalAction.getInstance(), menu, false);
        this.createCheckboxMenuItem(ShowTextEvalAction.getInstance(), menu, false);
        JSeparator testSeparator = new JSeparator();
        this.testItems.add(testSeparator);
        menu.add(testSeparator);
        this.showTestResultsItem = this.createCheckboxMenuItem(ShowTestResultsAction.getInstance(), menu, false);
        this.testItems.add(this.showTestResultsItem);
        menu = new JMenu(Config.getString("menu.help"));
        menu.setMnemonic(Config.getMnemonicKey("menu.help"));
        this.menubar.add(Box.createHorizontalGlue());
        this.menubar.add(menu);
        if (!Config.usingMacScreenMenubar()) {
            this.createMenuItem(HelpAboutAction.getInstance(), menu);
        }
        this.createMenuItem(CheckVersionAction.getInstance(), menu);
        this.createMenuItem(CheckExtensionsAction.getInstance(), menu);
        this.createMenuItem(ShowCopyrightAction.getInstance(), menu);
        menu.addSeparator();
        this.createMenuItem(WebsiteAction.getInstance(), menu);
        this.createMenuItem(TutorialAction.getInstance(), menu);
        this.createMenuItem(StandardAPIHelpAction.getInstance(), menu);
        this.addUserHelpItems(menu);
        this.updateRecentProjects();
        this.setJMenuBar(this.menubar);
    }

    private JMenuItem createMenuItem(Action action, JMenu menu) {
        JMenuItem item = menu.add(action);
        item.setIcon(null);
        return item;
    }

    private JCheckBoxMenuItem createCheckboxMenuItem(PkgMgrAction action, JMenu menu, boolean selected) {
        ButtonModel bmodel = action.getToggleModel(this);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        if (bmodel != null) {
            item.setModel(action.getToggleModel(this));
        } else {
            item.setState(selected);
        }
        menu.add(item);
        return item;
    }

    public void menuCall() {
        if (!this.isEmptyFrame()) {
            this.pkg.setState(0);
        }
        this.clearStatus();
    }

    private void setupActionDisableSet() {
        this.actionsToDisable = new ArrayList();
        this.actionsToDisable.add(CloseProjectAction.getInstance());
        this.actionsToDisable.add(SaveProjectAction.getInstance());
        this.actionsToDisable.add(SaveProjectAsAction.getInstance());
        this.actionsToDisable.add(ImportProjectAction.getInstance());
        this.actionsToDisable.add(ExportProjectAction.getInstance());
        this.actionsToDisable.add(PageSetupAction.getInstance());
        this.actionsToDisable.add(PrintAction.getInstance());
        this.actionsToDisable.add(NewClassAction.getInstance());
        this.actionsToDisable.add(NewPackageAction.getInstance());
        this.actionsToDisable.add(AddClassAction.getInstance());
        this.actionsToDisable.add(RemoveAction.getInstance());
        this.actionsToDisable.add(NewUsesAction.getInstance());
        this.actionsToDisable.add(NewInheritsAction.getInstance());
        this.actionsToDisable.add(CompileAction.getInstance());
        this.actionsToDisable.add(CompileSelectedAction.getInstance());
        this.actionsToDisable.add(RebuildAction.getInstance());
        this.actionsToDisable.add(UseLibraryAction.getInstance());
        this.actionsToDisable.add(GenerateDocsAction.getInstance());
        this.actionsToDisable.add(ShowUsesAction.getInstance());
        this.actionsToDisable.add(ShowInheritsAction.getInstance());
        this.actionsToDisable.add(ShowDebuggerAction.getInstance());
        this.actionsToDisable.add(ShowTerminalAction.getInstance());
        this.actionsToDisable.add(ShowTextEvalAction.getInstance());
        this.actionsToDisable.add(RunTestsAction.getInstance());
    }

    private void addUserHelpItems(JMenu menu) {
        String helpItems = Config.getPropString("bluej.help.items", "");
        if (helpItems != null && helpItems.length() > 0) {
            menu.addSeparator();
            URLDisplayer urlDisplayer = new URLDisplayer();
            StringTokenizer t = new StringTokenizer(helpItems);
            while (t.hasMoreTokens()) {
                String itemID = t.nextToken();
                String itemName = Config.getPropString("bluej.help." + itemID + ".label");
                String itemURL = Config.getPropString("bluej.help." + itemID + ".url");
                JMenuItem item = new JMenuItem(itemName);
                item.setActionCommand(itemURL);
                item.addActionListener(urlDisplayer);
                menu.add(item);
            }
        }
    }

    private void updateRecentProjects() {
        ProjectOpener opener = new ProjectOpener();
        this.recentProjectsMenu.removeAll();
        List projects = PrefMgr.getRecentProjects();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            JMenuItem item = this.recentProjectsMenu.add((String)it.next());
            item.addActionListener(opener);
        }
    }

    protected void enableFunctions(boolean enable) {
        Iterator it = this.itemsToDisable.iterator();
        while (it.hasNext()) {
            JComponent component = (JComponent)it.next();
            component.setEnabled(enable);
        }
        it = this.actionsToDisable.iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            action.setEnabled(enable);
        }
    }

    static /* synthetic */ AbstractButton access$100(PkgMgrFrame x0) {
        return x0.runButton;
    }

    class ProjectOpener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String project = evt.getActionCommand();
            if (!PkgMgrFrame.this.openProject(project)) {
                PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.error.open"));
            }
        }
    }

    class URLDisplayer
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String url = evt.getActionCommand();
            PkgMgrFrame.this.showWebPage(url);
        }
    }
}

