/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassDef;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.SymbolTable;
import bluej.parser.symtab.TypedDef;
import bluej.parser.symtab.VariableDef;
import java.util.Enumeration;

class MethodDef
extends ScopedDef
implements TypedDef {
    private String comment;
    private Definition type = null;
    private JavaVector parameters;
    private JavaVector exceptions;
    private String genericTypeArgument;

    MethodDef(String name, Occurrence occ, ClassDef type, ScopedDef parentScope, String typeArgument) {
        super(name, occ, parentScope);
        this.type = type;
        this.genericTypeArgument = typeArgument;
    }

    void add(ClassDef excep) {
        if (this.exceptions == null) {
            this.exceptions = new JavaVector();
        }
        this.exceptions.addElement(excep);
    }

    void add(VariableDef param) {
        if (this.parameters == null) {
            this.parameters = new JavaVector();
        }
        this.parameters.addElement(param);
    }

    int getParamCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public Definition getType() {
        return this.type;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    Definition lookup(String name, int numParams) {
        if (numParams == -1) {
            Definition d = super.lookup(name, numParams);
            if (d != null) {
                return d;
            }
            if (this.parameters != null) {
                Enumeration e = this.parameters.elements();
                while (e.hasMoreElements()) {
                    d = (Definition)e.nextElement();
                    if (!d.getName().equals(name)) continue;
                    return d;
                }
            }
        }
        return null;
    }

    public void getInfo(ClassInfo info, SymbolTable symbolTable) {
        int lastchar;
        StringBuffer target = new StringBuffer();
        if (this.genericTypeArgument != null) {
            target.append(this.genericTypeArgument);
            target.append(" ");
        }
        if (this.type != null) {
            info.addUsed(this.type.getQualifiedName());
            target.append(this.type.getName());
            target.append(" ");
        }
        target.append(this.getName());
        target.append("(");
        StringBuffer paramnames = new StringBuffer();
        if (this.parameters != null) {
            Enumeration e = this.parameters.elements();
            while (e.hasMoreElements()) {
                VariableDef vd = (VariableDef)e.nextElement();
                paramnames.append(vd.getName());
                paramnames.append(" ");
                vd.getInfo(info, symbolTable);
                target.append(vd.getType().getName());
                for (int i = 0; i < vd.getArrayLevel(); ++i) {
                    target.append("[]");
                }
                if (vd.isVarargs()) {
                    target.append(" ...");
                }
                target.append(",");
            }
        }
        if ((lastchar = paramnames.length() - 1) >= 0 && paramnames.charAt(lastchar) == ' ') {
            paramnames.deleteCharAt(lastchar);
        }
        if (target.charAt(lastchar = target.length() - 1) == ',') {
            target.deleteCharAt(lastchar);
        }
        target.append(")");
        if (this.exceptions != null) {
            Enumeration e = this.exceptions.elements();
            while (e.hasMoreElements()) {
                info.addUsed(((ClassDef)e.nextElement()).getQualifiedName());
            }
        }
        info.addComment(target.toString(), this.comment, paramnames.toString());
        super.getInfo(info, symbolTable);
    }

    void resolveTypes(SymbolTable symbolTable) {
        Definition newType;
        if (this.parameters != null) {
            this.parameters.resolveTypes(symbolTable);
        }
        if (this.exceptions != null) {
            this.exceptions.resolveTypes(symbolTable);
        }
        if (this.type != null && this.type instanceof DummyClass && (newType = symbolTable.lookupDummy(this.type)) != null) {
            newType.addReference(this.type.getOccurrence());
            this.type = newType;
        }
        super.resolveTypes(symbolTable);
    }

    void setExceptions(JavaVector exceptions) {
        this.exceptions = exceptions;
    }
}

