/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.Reportable;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.SymbolTable;

abstract class Definition
implements Reportable {
    private Occurrence definition;
    private ScopedDef parentScope;
    private JavaVector references;
    private String name;

    Definition(String name, Occurrence occ, ScopedDef parentScope) {
        this.definition = occ;
        this.parentScope = parentScope;
        this.name = name;
        this.references = new JavaVector();
    }

    void addReference(Occurrence occ) {
        this.references.addElement(occ);
    }

    String getDef() {
        if (this.definition != null) {
            return this.definition.getLocation();
        }
        return "";
    }

    String getName() {
        if (this.name == null) {
            return "~NO NAME~";
        }
        return this.name;
    }

    Occurrence getOccurrence() {
        return this.definition;
    }

    ScopedDef getParentScope() {
        return this.parentScope;
    }

    String getQualifiedName() {
        String nameToUse = this.name;
        if (this.name == null) {
            nameToUse = "~NO NAME~";
        }
        if (this.getParentScope() != null && !this.getParentScope().isDefaultOrBaseScope()) {
            return this.getParentScope().getQualifiedName() + "." + nameToUse;
        }
        return nameToUse;
    }

    boolean isSuperClassOf(Definition def) {
        return false;
    }

    Definition lookup(String name) {
        return this.lookup(name, -1);
    }

    Definition lookup(String name, int numParams) {
        throw new IllegalArgumentException("Can't lookup in a " + this.getClass());
    }

    public void getInfo(ClassInfo info, SymbolTable symbolTable) {
    }

    void resolveTypes(SymbolTable symbolTable) {
    }

    void setParentScope(ScopedDef parentScope) {
        this.parentScope = parentScope;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getQualifiedName() + "]";
    }
}

