/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.ast;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.collections.AST;
import bluej.parser.ast.gen.JavaLexer;
import bluej.parser.ast.gen.JavaRecognizer;
import bluej.parser.ast.gen.UnitTestParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class JavaParser {
    private ASTFactory factory;
    private AST root;
    private long delta = 0L;

    public JavaParser() {
        this.setupTree();
    }

    public AST getTree() {
        System.out.println("parsing took " + this.getParseSeconds() + " seconds");
        return this.root;
    }

    public double getParseSeconds() {
        return (double)this.delta / 1000.0;
    }

    private void setupTree() {
        this.factory = new ASTFactory();
        this.root = this.factory.create(0, "AST Root");
    }

    public void parseFiles(File root, String[] files) throws FileNotFoundException {
        for (int i = 0; i < files.length; ++i) {
            this.doFile(new File(root, files[i]));
        }
    }

    public void doFile(File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            this.parseFiles(file, file.list());
        } else if (JavaParser.isJavaFile(file)) {
            // empty if block
        }
    }

    private JavaLexer makeLexer(InputStream stream, String path) {
        JavaLexer result = new JavaLexer(stream);
        return result;
    }

    private JavaRecognizer makeRecognizer(TokenStreamHiddenTokenFilter filter, String path) {
        JavaRecognizer result = new JavaRecognizer((TokenStream)filter);
        return result;
    }

    public static boolean isJavaFile(File file) {
        return file.getName().length() > 5 && file.getName().substring(file.getName().length() - 5).equals(".java");
    }

    private void doTreeAction(File file, AST tree, String[] tokenNames) {
        if (tree != null) {
            this.addToTree(file, tree, tokenNames);
        }
    }

    private void addToTree(File file, AST tree, String[] tokenNames) {
    }

    public static Class parseExpression(String expr) {
        StringReader sr = new StringReader(expr);
        try {
            return null;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static AST parseFile(Reader r) throws Exception {
        try {
            JavaLexer lexer = new JavaLexer(r);
            lexer.setTokenObjectClass("bluej.parser.ast.LocatableToken");
            lexer.setTabSize(1);
            TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
            filter.hide(166);
            filter.hide(167);
            JavaRecognizer parser = new JavaRecognizer((TokenStream)filter);
            parser.setASTNodeClass("bluej.parser.ast.LocatableAST");
            parser.compilationUnit();
            ASTFactory factory = new ASTFactory();
            AST root = factory.create(0, "AST ROOT");
            CommonAST t = (CommonAST)parser.getAST();
            UnitTestParser tparse = new UnitTestParser();
            tparse.setASTNodeClass("bluej.parser.ast.LocatableAST");
            try {
                tparse.compilationUnit((AST)t);
            }
            catch (RecognitionException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            root.setFirstChild(tparse.getAST());
            return root;
        }
        catch (Exception e) {
            System.err.println("parser exception: " + e);
            e.printStackTrace();
            return null;
        }
    }

    public static void doTreeAction(AST t, String[] tokenNames) {
        if (t == null) {
            return;
        }
    }
}

