/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.Config;
import bluej.graph.Graph;
import bluej.graph.GraphPainter;
import bluej.graph.MarqueePainter;
import bluej.graph.RubberBand;
import bluej.graph.SelectableGraphElement;
import bluej.graph.SelectionController;
import bluej.pkgmgr.actions.NewClassAction;
import bluej.pkgmgr.actions.NewPackageAction;
import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintGraphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class GraphEditor
extends JComponent
implements MouseMotionListener {
    protected static final Color background = Config.getItemColour("colour.graph.background");
    protected final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    private static final Cursor handCursor = new Cursor(12);
    private static final Cursor defaultCursor = new Cursor(0);
    private static final Cursor resizeCursor = new Cursor(5);
    public static final int GRID_SIZE = 10;
    private Graph graph;
    private GraphPainter graphPainter;
    private MarqueePainter marqueePainter;
    private SelectionController selectionController;
    private Cursor currentCursor = defaultCursor;
    private boolean hasFocus;

    public GraphEditor(Graph graph) {
        this.graph = graph;
        this.marqueePainter = new MarqueePainter();
        this.graphPainter = GraphPainterStdImpl.getInstance();
        this.selectionController = new SelectionController(this);
    }

    public void startMouseListening() {
        this.addMouseMotionListener(this);
        this.addMouseMotionListener(this.selectionController);
        this.addMouseListener(this.selectionController);
        this.addKeyListener(this.selectionController);
    }

    public Dimension getPreferredSize() {
        return this.graph.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.graph.getMinimumSize();
    }

    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (!(g2D instanceof PrintGraphics)) {
            Dimension d = this.getSize();
            g2D.setColor(background);
            g2D.fillRect(0, 0, d.width, d.height);
        }
        this.graphPainter.paint(g2D, this);
        this.marqueePainter.paint(g2D, this.selectionController.getMarquee());
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        SelectableGraphElement element = this.graph.findGraphElement(x, y);
        Cursor newCursor = defaultCursor;
        if (element != null) {
            newCursor = element.isResizable() && element.isHandle(x, y) ? resizeCursor : handCursor;
        }
        if (this.currentCursor != newCursor) {
            this.setCursor(newCursor);
            this.currentCursor = newCursor;
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.isPopupTrigger()) {
            this.selectionController.handlePopupTrigger(evt);
        }
    }

    public void clearSelection() {
        this.selectionController.clearSelection();
    }

    public void removeFromSelection(SelectableGraphElement element) {
        this.selectionController.removeFromSelection(element);
    }

    public RubberBand getRubberBand() {
        return this.selectionController.getRubberBand();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void popupMenu(int x, int y) {
        JPopupMenu menu = this.createMenu();
        if (menu != null) {
            menu.show(this, x, y);
        }
    }

    private JPopupMenu createMenu() {
        JPopupMenu menu = new JPopupMenu();
        NewClassAction newClassAction = NewClassAction.getInstance();
        this.addMenuItem(menu, newClassAction);
        NewPackageAction newPackageAction = NewPackageAction.getInstance();
        this.addMenuItem(menu, newPackageAction);
        return menu;
    }

    private void addMenuItem(JPopupMenu menu, Action action) {
        JMenuItem item = menu.add(action);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(this.envOpColour);
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void setHasFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }
}

