/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.texteval;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.collections.AST;
import bluej.Config;
import bluej.debugger.gentype.GenArray;
import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypePrimitive;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.parser.ast.gen.JavaLexer;
import bluej.parser.ast.gen.JavaRecognizer;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class TextParser {
    private ClassLoader classLoader;
    private String packageScope;
    private ObjectBench objectBench;
    private static JavaUtils jutils = JavaUtils.getJavaUtils();
    private static boolean java15 = Config.isJava15();

    TextParser(ClassLoader classLoader, String packageScope, ObjectBench ob) {
        this.classLoader = classLoader;
        this.packageScope = packageScope;
        this.objectBench = ob;
    }

    String parseCommand(String command) {
        AST rootAST;
        boolean parsedOk = false;
        JavaRecognizer parser = TextParser.getParser("{" + command + "};;;;;");
        try {
            parser.compoundStatement();
            rootAST = parser.getAST();
            parsedOk = true;
        }
        catch (RecognitionException re) {
        }
        catch (TokenStreamException tse) {
            // empty catch block
        }
        if (!parsedOk) {
            parser = TextParser.getParser(command + ";;;;;");
            try {
                parser.expression();
                rootAST = parser.getAST();
                parsedOk = true;
                GenType t = this.getExpressionType(rootAST).getType();
                if (t == null) {
                    return "";
                }
                return t.toString();
            }
            catch (RecognitionException re) {
            }
            catch (SemanticException se) {
            }
            catch (TokenStreamException tse) {
                // empty catch block
            }
            return "";
        }
        return null;
    }

    private GenType questionOperator14(AST node) throws RecognitionException, SemanticException {
        GenType falseAltType;
        AST trueAlt = node.getFirstChild().getNextSibling();
        AST falseAlt = trueAlt.getNextSibling();
        ExprValue trueAltEv = this.getExpressionType(trueAlt);
        ExprValue falseAltEv = this.getExpressionType(falseAlt);
        GenType trueAltType = trueAltEv.getType();
        if (trueAltType.equals(falseAltType = falseAltEv.getType())) {
            return trueAltType;
        }
        if (trueAltType.isNumeric() && falseAltType.isNumeric()) {
            int fval;
            if (trueAltType.typeIs(GenType.GT_SHORT) && falseAltType.typeIs(GenType.GT_BYTE)) {
                return GenTypePrimitive.getShort();
            }
            if (falseAltType.typeIs(GenType.GT_SHORT) && trueAltType.typeIs(GenType.GT_BYTE)) {
                return GenTypePrimitive.getShort();
            }
            if (falseAltType.typeIs(GenType.GT_INT) && falseAltEv.knownValue()) {
                fval = falseAltEv.intValue();
                if (TextParser.isMinorInteger(trueAltType) && trueAltType.couldHold(fval)) {
                    return trueAltType;
                }
            }
            if (trueAltType.typeIs(GenType.GT_INT) && trueAltEv.knownValue()) {
                fval = trueAltEv.intValue();
                if (TextParser.isMinorInteger(falseAltType) && falseAltType.couldHold(fval)) {
                    return falseAltType;
                }
            }
            return this.binaryNumericPromotion(trueAltType, falseAltType);
        }
        if (trueAltType.isAssignableFrom(falseAltType)) {
            return trueAltType;
        }
        if (falseAltType.isAssignableFrom(trueAltType)) {
            return falseAltType;
        }
        throw new SemanticException();
    }

    private static boolean isMinorInteger(GenType a) {
        return a.typeIs(GenType.GT_BYTE) || a.typeIs(GenType.GT_CHAR) || a.typeIs(GenType.GT_SHORT);
    }

    private GenType questionOperator15(AST node) throws RecognitionException, SemanticException {
        AST trueAlt = node.getFirstChild().getNextSibling();
        AST falseAlt = trueAlt.getNextSibling();
        ExprValue trueAltEv = this.getExpressionType(trueAlt);
        ExprValue falseAltEv = this.getExpressionType(falseAlt);
        GenType trueAltType = trueAltEv.getType();
        GenType falseAltType = falseAltEv.getType();
        if (trueAltType == null || falseAltType == null) {
            return null;
        }
        if (trueAltType.isVoid() || falseAltType.isVoid()) {
            throw new SemanticException();
        }
        if (trueAltType.equals(falseAltType)) {
            return trueAltType;
        }
        GenType trueUnboxed = this.unBox(trueAltType);
        GenType falseUnboxed = this.unBox(falseAltType);
        if (trueUnboxed.typeIs(GenType.GT_BOOLEAN) && falseUnboxed.typeIs(GenType.GT_BOOLEAN)) {
            return trueUnboxed;
        }
        if (trueAltType.typeIs(GenType.GT_NULL)) {
            return this.boxType(falseAltType);
        }
        if (falseAltType.typeIs(GenType.GT_NULL)) {
            return this.boxType(trueAltType);
        }
        if (trueUnboxed.isNumeric() && falseUnboxed.isNumeric()) {
            int kval;
            if (trueUnboxed.typeIs(GenType.GT_BYTE) && falseUnboxed.typeIs(GenType.GT_SHORT)) {
                return falseUnboxed;
            }
            if (falseUnboxed.typeIs(GenType.GT_BYTE) && trueUnboxed.typeIs(GenType.GT_SHORT)) {
                return trueUnboxed;
            }
            if (TextParser.isMinorInteger(trueUnboxed) && falseAltType.typeIs(GenType.GT_INT) && falseAltEv.knownValue() && trueUnboxed.couldHold(kval = falseAltEv.intValue())) {
                return trueUnboxed;
            }
            if (TextParser.isMinorInteger(falseUnboxed) && trueAltType.typeIs(GenType.GT_INT) && trueAltEv.knownValue() && falseUnboxed.couldHold(kval = trueAltEv.intValue())) {
                return falseUnboxed;
            }
            return this.binaryNumericPromotion(trueAltType, falseAltType);
        }
        trueAltType = this.boxType(trueAltType);
        falseAltType = this.boxType(falseAltType);
        if (trueAltType instanceof GenTypeParameterizable && falseAltType instanceof GenTypeParameterizable) {
            GenTypeSolid[] trueUbounds = ((GenTypeParameterizable)trueAltType).getUpperBounds();
            GenTypeSolid[] falseUbounds = ((GenTypeParameterizable)falseAltType).getUpperBounds();
            GenTypeClass[] ctypes = new GenTypeClass[]{trueUbounds[0].asClass(), falseUbounds[0].asClass()};
            return this.lub(ctypes).getUpperBounds()[0];
        }
        return null;
    }

    private GenTypeParameterizable lub(GenTypeClass[] ubounds) {
        Stack btstack = new Stack();
        return this.lub(ubounds, btstack);
    }

    private GenTypeParameterizable lub(GenTypeClass[] ubounds, Stack lubBt) {
        Iterator si = lubBt.iterator();
        while (si.hasNext()) {
            int i;
            GenTypeClass[] sbounds = (GenTypeClass[])si.next();
            for (i = 0; i < sbounds.length && sbounds[i].equals(ubounds[i]); ++i) {
            }
            if (i != sbounds.length) continue;
            return new GenTypeUnbounded();
        }
        lubBt.push(ubounds);
        ArrayList<GenTypeClass> l = new ArrayList<GenTypeClass>();
        Reflective[] mec = this.MinimalErasedCandidateSet(ubounds);
        for (int i = 0; i < mec.length; ++i) {
            l.add(this.Candidate(mec[i], ubounds, lubBt));
        }
        lubBt.pop();
        GenTypeSolid[] lbounds = new GenTypeSolid[]{};
        GenTypeSolid[] rubounds = l.toArray(lbounds);
        return new GenTypeWildcard(rubounds, lbounds);
    }

    private GenTypeClass Candidate(Reflective t, GenTypeClass[] ubounds, Stack lubBt) {
        if (t.getTypeParams().isEmpty()) {
            return new GenTypeClass(t);
        }
        GenTypeClass[] ri = this.relevantInvocations(t, ubounds);
        return this.leastContainingInvocation(ri, lubBt);
    }

    private GenTypeClass leastContainingInvocation(GenTypeClass[] types, Stack lubBt) {
        GenTypeClass rtype = types[0];
        for (int i = 1; i < types.length; ++i) {
            rtype = this.leastContainingInvocation(rtype, types[i], lubBt);
        }
        return rtype;
    }

    private GenTypeClass leastContainingInvocation(GenTypeClass a, GenTypeClass b, Stack lubBt) {
        if (!a.getReflective().getName().equals(b.getReflective().getName())) {
            throw new IllegalArgumentException("Class types must be the same.");
        }
        Map ma = a.getMap();
        Map mb = b.getMap();
        if (ma == null || mb == null) {
            return new GenTypeClass(a.getReflective());
        }
        HashMap rmap = new HashMap();
        Iterator i = ma.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry mentry = i.next();
            GenTypeParameterizable atype = (GenTypeParameterizable)mentry.getValue();
            GenTypeParameterizable btype = (GenTypeParameterizable)mb.get(mentry.getKey());
            GenTypeParameterizable rtype = this.leastContainingTypeArgument(atype, btype, lubBt);
            rmap.put(mentry.getKey(), rtype);
        }
        return new GenTypeClass(a.getReflective(), rmap);
    }

    private GenTypeParameterizable leastContainingTypeArgument(GenTypeParameterizable a, GenTypeParameterizable b, Stack lubBt) {
        GenTypeClass ac = a.asClass();
        GenTypeClass bc = b.asClass();
        if (ac != null && bc != null) {
            if (ac.equals(bc)) {
                return ac;
            }
            return this.lub(new GenTypeClass[]{ac, bc}, lubBt);
        }
        if (ac != null || bc != null) {
            GenTypeSolid[] lbounds;
            if (ac == null) {
                ac = bc;
                b = a;
            }
            if ((lbounds = b.getLowerBounds()).length != 0) {
                GenTypeSolid[] newlbounds = new GenTypeSolid[lbounds.length + 1];
                System.arraycopy(lbounds, 0, newlbounds, 1, lbounds.length);
                newlbounds[0] = ac;
                return new GenTypeWildcard(new GenTypeSolid[0], newlbounds);
            }
        }
        GenTypeSolid[] lboundsa = a.getLowerBounds();
        GenTypeSolid[] lboundsb = b.getLowerBounds();
        if (lboundsa != null && lboundsb != null) {
            GenTypeSolid[] newlbounds = new GenTypeSolid[lboundsa.length + lboundsb.length];
            System.arraycopy(lboundsa, 0, newlbounds, 0, lboundsa.length);
            System.arraycopy(lboundsb, 0, newlbounds, lboundsa.length, lboundsb.length);
            return new GenTypeWildcard(new GenTypeSolid[0], newlbounds);
        }
        if (lboundsa != null || lboundsb != null) {
            GenTypeSolid[] ubounds;
            if (lboundsa == null) {
                lboundsa = lboundsb;
                ubounds = a.getUpperBounds();
            } else {
                ubounds = b.getUpperBounds();
            }
            for (int i = 0; i < lboundsa.length; ++i) {
                for (int j = 0; j < ubounds.length; ++j) {
                    if (!lboundsa[i].equals(ubounds[j])) continue;
                    return lboundsa[i];
                }
            }
            return new GenTypeUnbounded();
        }
        GenTypeSolid[] uboundsa = a.getUpperBounds();
        GenTypeSolid[] uboundsb = b.getUpperBounds();
        GenTypeClass[] args = new GenTypeClass[uboundsa.length + uboundsb.length];
        System.arraycopy(uboundsa, 0, args, 0, uboundsa.length);
        System.arraycopy(uboundsb, 0, args, uboundsa.length, uboundsb.length);
        return this.lub(args);
    }

    private GenTypeSolid[] glb(GenTypeSolid[] args) throws SemanticException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isInterface()) continue;
            for (int j = 0; j < args.length; ++j) {
                if (i == j || args[j].isInterface() || args[i].isAssignableFrom(args[j]) || args[j].isAssignableFrom(args[i])) continue;
                throw new SemanticException();
            }
        }
        return args;
    }

    private GenTypeClass[] relevantInvocations(Reflective r, GenTypeClass[] ubounds) {
        GenTypeClass[] rlist = new GenTypeClass[ubounds.length];
        for (int i = 0; i < ubounds.length; ++i) {
            Map m = ubounds[i].mapToSuper(r.getName());
            rlist[i] = new GenTypeClass(r, m);
        }
        return rlist;
    }

    private void ErasedSuperTypes(Reflective r, Map rmap) {
        String rname = r.getName();
        if (!rmap.containsKey(rname)) {
            rmap.put(rname, r);
            List supertypes = r.getSuperTypesR();
            Iterator i = supertypes.iterator();
            while (i.hasNext()) {
                this.ErasedSuperTypes((Reflective)i.next(), rmap);
            }
        }
    }

    private Reflective[] MinimalErasedCandidateSet(GenTypeClass[] types) {
        Iterator j;
        HashMap rmap = new HashMap();
        this.ErasedSuperTypes(types[0].getReflective(), rmap);
        for (int i = 1; i < types.length; ++i) {
            HashMap rmap2 = new HashMap();
            this.ErasedSuperTypes(types[i].getReflective(), rmap2);
            j = rmap2.keySet().iterator();
            while (j.hasNext()) {
                if (rmap.containsKey(j.next())) continue;
                j.remove();
            }
            rmap = rmap2;
        }
        Set entryset = rmap.entrySet();
        Iterator i = entryset.iterator();
        block2: while (i.hasNext()) {
            j = entryset.iterator();
            Map.Entry ielem = i.next();
            while (j.hasNext()) {
                Reflective ji;
                Reflective ri;
                Map.Entry jelem = j.next();
                if (ielem == jelem || !(ri = (Reflective)ielem.getValue()).isAssignableFrom(ji = (Reflective)jelem.getValue())) continue;
                i.remove();
                continue block2;
            }
        }
        Reflective[] rval = new Reflective[rmap.values().size()];
        rmap.values().toArray(rval);
        return rval;
    }

    private GenType binaryNumericPromotion(GenType a, GenType b) throws SemanticException {
        GenType ua = this.unBox(a);
        GenType ub = this.unBox(b);
        if (a.typeIs(GenType.GT_DOUBLE) || b.typeIs(GenType.GT_DOUBLE)) {
            return GenTypePrimitive.getDouble();
        }
        if (a.typeIs(GenType.GT_FLOAT) || b.typeIs(GenType.GT_FLOAT)) {
            return GenTypePrimitive.getFloat();
        }
        if (a.typeIs(GenType.GT_LONG) || b.typeIs(GenType.GT_LONG)) {
            return GenTypePrimitive.getLong();
        }
        if (a.isNumeric() && b.isNumeric()) {
            return GenTypePrimitive.getInt();
        }
        throw new SemanticException();
    }

    private ExprValue getCharLiteral(AST node) throws RecognitionException {
        String x = node.getText();
        x = x.substring(1, x.length() - 1);
        GenTypePrimitive charType = GenTypePrimitive.getChar();
        if (!x.startsWith("\\")) {
            if (x.length() != 1) {
                throw new RecognitionException();
            }
            return new NumValue(charType, new Integer(x.charAt(0)));
        }
        if (x.equals("\\b")) {
            return new NumValue(charType, new Integer(8));
        }
        if (x.equals("\\t")) {
            return new NumValue(charType, new Integer(9));
        }
        if (x.equals("\\n")) {
            return new NumValue(charType, new Integer(10));
        }
        if (x.equals("\\f")) {
            return new NumValue(charType, new Integer(12));
        }
        if (x.equals("\\r")) {
            return new NumValue(charType, new Integer(13));
        }
        if (x.equals("\\\"")) {
            return new NumValue(charType, new Integer(34));
        }
        if (x.equals("\\'")) {
            return new NumValue(charType, new Integer(39));
        }
        if (x.equals("\\\\")) {
            return new NumValue(charType, new Integer(92));
        }
        if (x.startsWith("\\u")) {
            if (x.length() != 6) {
                throw new RecognitionException();
            }
            int val = 0;
            for (int i = 0; i < 4; ++i) {
                char digit = x.charAt(i + 2);
                int digVal = Character.digit(digit, 16);
                if (digVal == -1) {
                    throw new RecognitionException();
                }
                val = (char)(val * 16 + digVal);
            }
            return new NumValue(charType, new Integer(val));
        }
        int xlen = x.length();
        if (xlen < 2 || xlen > 4) {
            throw new RecognitionException();
        }
        int val = 0;
        for (int i = 0; i < xlen - 1; ++i) {
            char digit = x.charAt(i + 1);
            int digVal = Character.digit(digit, 8);
            if (digVal == -1) {
                throw new RecognitionException();
            }
            val = (char)(val * 8 + digVal);
        }
        return new NumValue(charType, new Integer(val));
    }

    private ExprValue getIntLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Integer val = Integer.decode(x);
            return new NumValue(GenTypePrimitive.getInt(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private ExprValue getLongLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Long val = Long.decode(x);
            return new NumValue(GenTypePrimitive.getLong(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private ExprValue getFloatLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Float val = Float.valueOf(x);
            return new NumValue(GenTypePrimitive.getFloat(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private ExprValue getDoubleLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Double val = Double.valueOf(x);
            return new NumValue(GenTypePrimitive.getDouble(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private Class loadUnqualifiedClass(String className) throws ClassNotFoundException {
        boolean qualified = false;
        boolean index = false;
        try {
            if (this.packageScope.length() != 0) {
                return this.classLoader.loadClass(this.packageScope + "." + className);
            }
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            return this.classLoader.loadClass("java.lang." + className);
        }
    }

    private GenType getType(AST node) throws RecognitionException, SemanticException {
        if (node.getType() == 67) {
            List params = this.getTParams(node.getFirstChild());
            try {
                Class c = this.loadUnqualifiedClass(node.getText());
                JavaReflective r = new JavaReflective(c);
                return new GenTypeClass((Reflective)r, params);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }
        if (node.getType() == 68) {
            AST packageNode = node.getFirstChild();
            PackageOrClass porc = this.getPackageOrClass(packageNode);
            AST classNode = packageNode.getNextSibling();
            List params = this.getTParams(classNode.getNextSibling());
            PackageOrClass nodePorC = porc.getPackageOrClassMember(classNode.getText());
            GenTypeClass nodeClass = (GenTypeClass)nodePorC.getType();
            return new GenTypeClass(nodeClass.getReflective(), params);
        }
        throw new RecognitionException();
    }

    private List getTParams(AST node) throws RecognitionException, SemanticException {
        LinkedList<GenType> params = new LinkedList<GenType>();
        while (node != null && node.getType() == 55) {
            GenType tparType = this.getType(node.getFirstChild());
            params.add(tparType);
            node = node.getNextSibling();
        }
        return params;
    }

    String combineDotNames(AST node, char seperator) throws RecognitionException {
        if (node.getType() == 67) {
            return node.getText();
        }
        if (node.getType() == 68) {
            AST fchild = node.getFirstChild();
            AST nchild = fchild.getNextSibling();
            if (nchild.getType() != 67) {
                throw new RecognitionException();
            }
            return this.combineDotNames(fchild, seperator) + seperator + nchild.getText();
        }
        throw new RecognitionException();
    }

    GenType getInnerType(AST node, Reflective outer) throws SemanticException, RecognitionException {
        if (node.getType() == 67) {
            List params = this.getTParams(node.getFirstChild());
            String name = outer.getName() + '$' + node.getText();
            try {
                Class<?> theClass = this.classLoader.loadClass(name);
                JavaReflective r = new JavaReflective(theClass);
                return new GenTypeClass((Reflective)r, params);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }
        if (node.getType() == 68) {
            AST packageNode = node.getFirstChild();
            String dotnames = this.combineDotNames(packageNode, '$');
            AST classNode = packageNode.getNextSibling();
            List params = this.getTParams(classNode.getNextSibling());
            String name = outer.getName() + '$' + dotnames + '$' + node.getText();
            try {
                Class<?> c = this.classLoader.loadClass(name);
                JavaReflective r = new JavaReflective(c);
                return new GenTypeClass((Reflective)r, params);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }
        throw new RecognitionException();
    }

    Entity getEntity(AST node) throws SemanticException, RecognitionException {
        AST firstChild;
        AST secondChild;
        if (node.getType() == 67) {
            String nodeText = node.getText();
            ObjectWrapper ow = this.objectBench.getObject(nodeText);
            if (ow != null) {
                return new ValueEntity(ow.getGenType());
            }
            try {
                Class c = this.loadUnqualifiedClass(nodeText);
                return new ClassEntity(c);
            }
            catch (ClassNotFoundException cnfe) {
                return new PackageEntity(nodeText);
            }
        }
        if (node.getType() == 68 && (secondChild = (firstChild = node.getFirstChild()).getNextSibling()).getType() == 67) {
            Entity firstpart = this.getEntity(firstChild);
            return firstpart.getSubentity(secondChild.getText());
        }
        GenType exprType = this.getExpressionType(node).getType();
        return new ValueEntity(exprType);
    }

    private PackageOrClass getPackageOrClass(AST node) throws SemanticException {
        AST firstChild;
        AST secondChild;
        if (node.getType() == 67) {
            String nodeText = node.getText();
            try {
                Class c = this.loadUnqualifiedClass(nodeText);
                return new ClassEntity(c);
            }
            catch (ClassNotFoundException cnfe) {
                return new PackageEntity(nodeText);
            }
        }
        if (node.getType() == 68 && (secondChild = (firstChild = node.getFirstChild()).getNextSibling()).getType() == 67) {
            PackageOrClass firstpart = this.getPackageOrClass(firstChild);
            return firstpart.getPackageOrClassMember(secondChild.getText());
        }
        throw new SemanticException();
    }

    private GenType[] getExpressionList(AST node) throws SemanticException, RecognitionException {
        int num = node.getNumberOfChildren();
        GenType[] r = new GenType[num];
        AST child = node.getFirstChild();
        for (int i = 0; i < num; ++i) {
            r[i] = this.getExpressionType(child).getType();
            child = child.getNextSibling();
        }
        return r;
    }

    private MethodCallDesc isMethodApplicable(GenTypeClass targetType, Map tpars, Method m, GenType[] args) throws RecognitionException {
        GenType[] mparams = JavaUtils.getJavaUtils().getParamGenTypes(m, targetType.isRaw());
        if (mparams.length != args.length) {
            return null;
        }
        List tparams = JavaUtils.getJavaUtils().getTypeParams(m);
        if (!tpars.isEmpty() && tpars.size() != tparams.size()) {
            return null;
        }
        if (!tparams.isEmpty()) {
            throw new RecognitionException();
        }
        Map targetTpars = targetType.getMap();
        if (targetTpars != null) {
            Iterator i = tparams.iterator();
            while (i.hasNext()) {
                targetTpars.remove(((GenTypeDeclTpar)i.next()).getTparName());
            }
        }
        for (int i = 0; i < args.length; ++i) {
            GenType formalArg = mparams[i];
            GenType givenParam = args[i];
            formalArg = formalArg.mapTparsToTypes(targetTpars);
            if ((formalArg = formalArg.mapTparsToTypes(tpars)).isAssignableFrom(givenParam)) continue;
            return null;
        }
        GenType rType = jutils.getReturnType(m).mapTparsToTypes(targetType.getMap());
        return new MethodCallDesc(m, Arrays.asList(mparams), false, false, rType);
    }

    private GenType getMethodCallReturnType(AST node) throws RecognitionException, SemanticException {
        JavaUtils jutils = JavaUtils.getJavaUtils();
        AST firstArg = node.getFirstChild();
        AST secondArg = firstArg.getNextSibling();
        if (secondArg.getType() != 34) {
            throw new RecognitionException();
        }
        if (firstArg.getType() == 68) {
            AST targetNode = firstArg.getFirstChild();
            Entity callTarget = this.getEntity(targetNode);
            GenType targetType = callTarget.getType();
            ArrayList<GenType> typeArgs = new ArrayList<GenType>(5);
            GenType[] argumentTypes = this.getExpressionList(secondArg);
            String methodName = null;
            for (AST searchNode = targetNode.getNextSibling(); searchNode != null; searchNode = searchNode.getNextSibling()) {
                int nodeType = searchNode.getType();
                if (nodeType != 55) {
                    if (nodeType != 67) break;
                    methodName = searchNode.getText();
                    break;
                }
                GenType taType = this.getType(searchNode.getFirstChild());
                typeArgs.add(taType);
            }
            if (methodName == null) {
                throw new RecognitionException();
            }
            if (targetType instanceof GenTypeClass) {
                GenTypeClass targetClass = (GenTypeClass)targetType;
                try {
                    Class<?> c = this.classLoader.loadClass(targetClass.rawName());
                    Method[] methods = c.getMethods();
                    ArrayList<MethodCallDesc> suitableMethods = new ArrayList<MethodCallDesc>();
                    for (int i = 0; i < methods.length; ++i) {
                        if (jutils.isBridge(methods[i]) || !methods[i].getName().equals(methodName)) continue;
                        Class<?> declClass = methods[i].getDeclaringClass();
                        Map m = targetClass.mapToSuper(declClass.getName());
                        MethodCallDesc mcd = this.isMethodApplicable(targetClass, new HashMap(), methods[i], argumentTypes);
                        if (mcd == null) continue;
                        boolean replaced = false;
                        for (int j = 0; j < suitableMethods.size(); ++j) {
                            MethodCallDesc mc = (MethodCallDesc)suitableMethods.get(j);
                            int compare = mcd.compareSpecificity(mc);
                            if (compare == 1) {
                                suitableMethods.remove(j);
                                --j;
                                continue;
                            }
                            if (compare != -1) continue;
                            replaced = true;
                            break;
                        }
                        if (replaced) continue;
                        suitableMethods.add(mcd);
                    }
                    if (suitableMethods.size() == 1) {
                        MethodCallDesc mcd = (MethodCallDesc)suitableMethods.get(0);
                        return mcd.retType;
                    }
                    throw new SemanticException();
                }
                catch (ClassNotFoundException cnfe) {
                    return null;
                }
            }
            throw new SemanticException();
        }
        return null;
    }

    GenType getTypeFromTypeNode(AST node) throws RecognitionException, SemanticException {
        GenType baseType;
        AST firstChild = node.getFirstChild();
        switch (firstChild.getType()) {
            case 80: {
                baseType = GenTypePrimitive.getChar();
                break;
            }
            case 79: {
                baseType = GenTypePrimitive.getByte();
                break;
            }
            case 78: {
                baseType = GenTypePrimitive.getBoolean();
                break;
            }
            case 81: {
                baseType = GenTypePrimitive.getShort();
                break;
            }
            case 82: {
                baseType = GenTypePrimitive.getInt();
                break;
            }
            case 84: {
                baseType = GenTypePrimitive.getLong();
                break;
            }
            case 83: {
                baseType = GenTypePrimitive.getFloat();
                break;
            }
            case 85: {
                baseType = GenTypePrimitive.getDouble();
                break;
            }
            default: {
                baseType = this.getType(firstChild);
            }
        }
        for (AST arrayNode = firstChild.getNextSibling(); arrayNode != null && arrayNode.getType() == 17; arrayNode = arrayNode.getFirstChild()) {
            baseType = new GenArray(baseType);
        }
        return baseType;
    }

    private GenType unBox(GenType b) {
        if (b instanceof GenTypeClass) {
            GenTypeClass c = (GenTypeClass)b;
            String cName = c.rawName();
            if (c.equals("java.lang.Integer")) {
                return GenTypePrimitive.getInt();
            }
            if (c.equals("java.lang.Long")) {
                return GenTypePrimitive.getLong();
            }
            if (c.equals("java.lang.Short")) {
                return GenTypePrimitive.getShort();
            }
            if (c.equals("java.lang.Byte")) {
                return GenTypePrimitive.getByte();
            }
            if (c.equals("java.lang.Character")) {
                return GenTypePrimitive.getChar();
            }
            if (c.equals("java.lang.Float")) {
                return GenTypePrimitive.getFloat();
            }
            if (c.equals("java.lang.Double")) {
                return GenTypePrimitive.getDouble();
            }
            if (c.equals("java.lang.Boolean")) {
                return GenTypePrimitive.getBoolean();
            }
            return b;
        }
        return b;
    }

    private GenType boxType(GenType u) {
        if (u instanceof GenTypePrimitive) {
            if (u.typeIs(GenType.GT_INT)) {
                return new GenTypeClass(new JavaReflective(Integer.class));
            }
            if (u.typeIs(GenType.GT_LONG)) {
                return new GenTypeClass(new JavaReflective(Long.class));
            }
            if (u.typeIs(GenType.GT_SHORT)) {
                return new GenTypeClass(new JavaReflective(Short.class));
            }
            if (u.typeIs(GenType.GT_BYTE)) {
                return new GenTypeClass(new JavaReflective(Byte.class));
            }
            if (u.typeIs(GenType.GT_CHAR)) {
                return new GenTypeClass(new JavaReflective(Character.class));
            }
            if (u.typeIs(GenType.GT_FLOAT)) {
                return new GenTypeClass(new JavaReflective(Float.class));
            }
            if (u.typeIs(GenType.GT_DOUBLE)) {
                return new GenTypeClass(new JavaReflective(Double.class));
            }
            if (u.typeIs(GenType.GT_BOOLEAN)) {
                return new GenTypeClass(new JavaReflective(Boolean.class));
            }
            return u;
        }
        return u;
    }

    public static boolean isBoxedBoolean(GenType t) {
        GenTypeClass ct = t.asClass();
        if (ct != null) {
            return ct.rawName().equals("java.lang.Boolean");
        }
        return false;
    }

    private GenType maybeBox(GenType u, boolean box) {
        if (box) {
            return this.boxType(u);
        }
        return u;
    }

    ExprValue getExpressionType(AST node) throws RecognitionException, SemanticException {
        AST fcNode = node.getType() == 28 ? node.getFirstChild() : node;
        switch (fcNode.getType()) {
            case 158: {
                return new ExprValue(this.getTypeFromTypeNode(fcNode));
            }
            case 68: {
                AST firstDotArg = fcNode.getFirstChild();
                AST secondDotArg = firstDotArg.getNextSibling();
                if (secondDotArg.getType() == 158) {
                    GenType fpType = this.getExpressionType(firstDotArg).getType();
                    if (fpType instanceof GenTypeClass) {
                        GenType type = this.getInnerType(secondDotArg.getFirstChild(), ((GenTypeClass)fpType).getReflective());
                        return new ExprValue(type);
                    }
                    if (fpType == null) {
                        return null;
                    }
                    throw new SemanticException();
                }
                if (secondDotArg.getType() == 67) {
                    Entity entity = this.getEntity(firstDotArg);
                    entity = entity.getSubentity(secondDotArg.getText());
                    return new ExprValue(entity.getType());
                }
                if (secondDotArg.getType() == 101) {
                    if (!Config.isJava15()) {
                        return new ExprValue(new GenTypeClass(new JavaReflective(Class.class)));
                    }
                    return new ExprValue(new GenTypeClass(new JavaReflective(Class.class)));
                }
            }
            case 27: {
                return new ExprValue(this.getMethodCallReturnType(fcNode));
            }
            case 67: {
                String objectName = fcNode.getText();
                ObjectWrapper ow = this.objectBench.getObject(objectName);
                if (ow == null) {
                    throw new SemanticException();
                }
                return new ExprValue(ow.getGenType());
            }
            case 23: {
                return new ExprValue(this.getTypeFromTypeNode(fcNode.getFirstChild()));
            }
            case 24: {
                GenType t = this.getExpressionType(fcNode.getFirstChild()).getType();
                GenType componentType = t.getArrayComponent();
                if (componentType != null) {
                    return new ExprValue(componentType);
                }
                throw new SemanticException();
            }
            case 161: {
                return new ExprValue(new GenTypeClass(new JavaReflective(String.class)));
            }
            case 160: {
                return this.getCharLiteral(fcNode);
            }
            case 159: {
                return this.getIntLiteral(fcNode, false);
            }
            case 163: {
                return this.getLongLiteral(fcNode, false);
            }
            case 162: {
                return this.getFloatLiteral(fcNode, false);
            }
            case 164: {
                return this.getDoubleLiteral(fcNode, false);
            }
            case 145: 
            case 155: 
            case 156: {
                return new ExprValue(GenTypePrimitive.getBoolean());
            }
            case 157: {
                return new ExprValue(GenTypePrimitive.getNull());
            }
            case 32: {
                return this.getExpressionType(fcNode.getFirstChild());
            }
            case 31: {
                AST negExpr = fcNode.getFirstChild();
                switch (negExpr.getType()) {
                    case 159: {
                        return this.getIntLiteral(negExpr, true);
                    }
                    case 163: {
                        return this.getLongLiteral(negExpr, true);
                    }
                    case 162: {
                        return this.getFloatLiteral(negExpr, true);
                    }
                    case 164: {
                        return this.getFloatLiteral(negExpr, true);
                    }
                }
                return this.getExpressionType(negExpr);
            }
            case 72: 
            case 74: 
            case 137: 
            case 138: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 154: {
                return new ExprValue(GenTypePrimitive.getBoolean());
            }
            case 75: 
            case 76: 
            case 146: {
                GenType rtype = this.unBox(this.getExpressionType(fcNode.getFirstChild()).getType());
                if (TextParser.isMinorInteger(rtype)) {
                    rtype = GenTypePrimitive.getInt();
                }
                return new ExprValue(rtype);
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                return this.getExpressionType(fcNode.getFirstChild());
            }
            case 86: 
            case 104: 
            case 139: 
            case 140: 
            case 148: 
            case 149: 
            case 150: {
                int ntype;
                AST leftNode = fcNode.getFirstChild();
                AST rightNode = leftNode.getNextSibling();
                GenType leftType = this.unBox(this.getExpressionType(leftNode).getType());
                GenType rightType = this.unBox(this.getExpressionType(rightNode).getType());
                if (leftType.typeIs(GenType.GT_BOOLEAN) && rightType.typeIs(GenType.GT_BOOLEAN) && ((ntype = fcNode.getType()) == 104 || ntype == 139 || ntype == 140)) {
                    return new ExprValue(GenTypePrimitive.getBoolean());
                }
                return new ExprValue(this.binaryNumericPromotion(leftType, rightType));
            }
            case 147: {
                AST leftNode = fcNode.getFirstChild();
                AST rightNode = leftNode.getNextSibling();
                GenType leftType = this.unBox(this.getExpressionType(leftNode).getType());
                GenType rightType = this.unBox(this.getExpressionType(rightNode).getType());
                if (leftType == null || rightType == null) {
                    return null;
                }
                if (leftType.toString().equals("java.lang.String")) {
                    return new ExprValue(leftType);
                }
                if (rightType.toString().equals("java.lang.String")) {
                    return new ExprValue(rightType);
                }
                return new ExprValue(this.binaryNumericPromotion(leftType, rightType));
            }
            case 25: 
            case 26: 
            case 151: 
            case 152: {
                return new ExprValue(this.unBox(this.getExpressionType(fcNode.getFirstChild()).getType()));
            }
            case 153: {
                ExprValue oval = this.getExpressionType(fcNode.getFirstChild());
                GenType ntype = this.unBox(oval.getType());
                if (!ntype.isIntegralType()) {
                    throw new SemanticException();
                }
                if (!oval.knownValue()) {
                    if (ntype.typeIs(GenType.GT_LONG)) {
                        return new ExprValue(ntype);
                    }
                    return new ExprValue(GenTypePrimitive.getInt());
                }
                if (ntype.typeIs(GenType.GT_LONG)) {
                    long newval = oval.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                    return new NumValue(ntype, new Long(newval));
                }
                int newval = ~oval.intValue();
                return new NumValue(GenTypePrimitive.getInt(), new Integer(newval));
            }
            case 69: {
                if (Config.usingJava15()) {
                    return new ExprValue(this.questionOperator15(fcNode));
                }
                return new ExprValue(this.questionOperator14(fcNode));
            }
        }
        return null;
    }

    static JavaRecognizer getParser(String s) {
        StringReader r = new StringReader(s);
        JavaLexer lexer = new JavaLexer(r);
        lexer.setTokenObjectClass("bluej.parser.ast.LocatableToken");
        lexer.setTabSize(1);
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
        filter.hide(166);
        filter.hide(167);
        JavaRecognizer parser = new JavaRecognizer((TokenStream)filter);
        parser.setASTNodeClass("bluej.parser.ast.LocatableAST");
        return parser;
    }

    class NumValue
    extends ExprValue {
        private Number val;

        NumValue(GenType type, Number val) {
            super(type);
            this.val = val;
        }

        public boolean knownValue() {
            return true;
        }

        public int intValue() {
            return this.val.intValue();
        }

        public long longValue() {
            return this.val.longValue();
        }

        public float floatValue() {
            return this.val.floatValue();
        }

        public double doubleValue() {
            return this.val.doubleValue();
        }
    }

    class ExprValue {
        public GenType type;

        public ExprValue(GenType type) {
            this.type = type;
        }

        public GenType getType() {
            return this.type;
        }

        public boolean knownValue() {
            return false;
        }

        public int intValue() {
            throw new UnsupportedOperationException();
        }

        public long longValue() {
            throw new UnsupportedOperationException();
        }

        public float floatValue() {
            throw new UnsupportedOperationException();
        }

        public double doubleValue() {
            throw new UnsupportedOperationException();
        }

        public boolean booleanValue() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueEntity
    extends Entity {
        GenType type;

        ValueEntity(GenType type) {
            this.type = type;
        }

        int entityType() {
            return 2;
        }

        GenType getType() {
            return this.type;
        }

        Entity getSubentity(String name) throws SemanticException {
            Class<?> c;
            if (!(this.type instanceof GenTypeClass)) {
                throw new SemanticException();
            }
            GenTypeClass thisClass = (GenTypeClass)this.type;
            Reflective r = thisClass.getReflective();
            try {
                c = TextParser.this.classLoader.loadClass(r.getName());
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
            Field f = null;
            try {
                GenType fieldType;
                f = c.getField(name);
                Class<?> declarer = f.getDeclaringClass();
                Map tparMap = thisClass.mapToSuper(declarer.getName());
                if (tparMap != null) {
                    fieldType = JavaUtils.getJavaUtils().getFieldType(f);
                    fieldType = fieldType.mapTparsToTypes(tparMap);
                } else {
                    fieldType = JavaUtils.getJavaUtils().getRawFieldType(f);
                }
                return new ValueEntity(fieldType);
            }
            catch (NoSuchFieldException nsfe) {
                throw new SemanticException();
            }
        }
    }

    class ClassEntity
    extends PackageOrClass {
        Class thisClass;

        ClassEntity(Class c) {
            this.thisClass = c;
        }

        int entityType() {
            return 1;
        }

        GenType getType() throws SemanticException {
            return new GenTypeClass(new JavaReflective(this.thisClass));
        }

        Entity getSubentity(String name) throws SemanticException {
            Field f = null;
            try {
                f = this.thisClass.getField(name);
                GenType fieldType = JavaUtils.getJavaUtils().getFieldType(f);
                return new ValueEntity(fieldType);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return this.getPackageOrClassMember(name);
            }
        }

        PackageOrClass getPackageOrClassMember(String name) throws SemanticException {
            try {
                Class<?> c = TextParser.this.classLoader.loadClass(this.thisClass.getName() + '$' + name);
                return new ClassEntity(c);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }
    }

    class PackageEntity
    extends PackageOrClass {
        String packageName;

        PackageEntity(String pname) {
            this.packageName = pname;
        }

        int entityType() {
            return 0;
        }

        GenType getType() throws SemanticException {
            throw new SemanticException();
        }

        Entity getSubentity(String name) throws SemanticException {
            try {
                Class<?> c = TextParser.this.classLoader.loadClass(this.packageName + '.' + name);
                return new ClassEntity(c);
            }
            catch (ClassNotFoundException cnfe) {
                return new PackageEntity(this.packageName + '.' + name);
            }
        }

        PackageOrClass getPackageOrClassMember(String name) throws SemanticException {
            return (PackageOrClass)this.getSubentity(name);
        }

        public String toString() {
            return "package: " + this.packageName;
        }
    }

    abstract class PackageOrClass
    extends Entity {
        PackageOrClass() {
        }

        abstract PackageOrClass getPackageOrClassMember(String var1) throws SemanticException;
    }

    abstract class Entity {
        static final int ENTITY_PACKAGE = 0;
        static final int ENTITY_CLASS = 1;
        static final int ENTITY_VALUE = 2;

        Entity() {
        }

        abstract int entityType();

        abstract GenType getType() throws SemanticException;

        abstract Entity getSubentity(String var1) throws SemanticException;
    }

    class SemanticException
    extends Exception {
        SemanticException() {
        }
    }

    private class MethodCallDesc {
        public Method method;
        public List argTypes;
        public boolean vararg;
        public boolean autoboxing;
        public GenType retType;

        public MethodCallDesc(Method m, List argTypes, boolean vararg, boolean autoboxing, GenType retType) {
            this.method = m;
            this.argTypes = argTypes;
            this.vararg = vararg;
            this.autoboxing = autoboxing;
            this.retType = retType;
        }

        public int compareSpecificity(MethodCallDesc other) {
            if (other.vararg && !this.vararg) {
                return 1;
            }
            if (!other.vararg && this.vararg) {
                return -1;
            }
            Iterator i = this.argTypes.iterator();
            Iterator j = other.argTypes.iterator();
            int upCount = 0;
            int downCount = 0;
            while (i.hasNext()) {
                GenType otherArg;
                GenType myArg = (GenType)i.next();
                if (myArg.isAssignableFrom(otherArg = (GenType)j.next())) {
                    if (otherArg.isAssignableFrom(myArg)) continue;
                    ++upCount;
                    continue;
                }
                if (!otherArg.isAssignableFrom(myArg)) continue;
                ++downCount;
            }
            if (upCount > 0 && downCount == 0) {
                return -1;
            }
            if (downCount > 0 && upCount == 0) {
                return 1;
            }
            if (this.method.getDeclaringClass().isInterface() && !other.method.getDeclaringClass().isInterface()) {
                return -1;
            }
            if (!this.method.getDeclaringClass().isInterface() && other.method.getDeclaringClass().isInterface()) {
                return 1;
            }
            return 0;
        }
    }
}

