/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.NameTransform;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallDialogWatcher;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.MethodDialog;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.ConstructionInvokerRecord;
import bluej.testmgr.record.ExpressionInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.MethodInvokerRecord;
import bluej.testmgr.record.StaticVoidMainMethodInvokerRecord;
import bluej.testmgr.record.VoidMethodInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.TypeParamView;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Invoker
implements CompileObserver,
CallDialogWatcher {
    private static final String creating = Config.getString("pkgmgr.creating");
    private static final String createDone = Config.getString("pkgmgr.createDone");
    public static final int OBJ_NAME_LENGTH = 8;
    public static final String SHELLNAME = "__SHELL";
    private static int shellNumber = 0;
    private static Map methods = new HashMap();
    private PkgMgrFrame pmf;
    private Package pkg;
    private ResultWatcher watcher;
    private CallableView member;
    private String shellName;
    private String objName;
    private Map typeMap;
    private Map instanceMap;
    private String instanceName;
    private CallDialog dialog;
    private boolean constructing;
    private String commandString;
    private int numberCompiling = 0;
    private ExecutionEvent executionEvent;
    private InvokerRecord ir;

    private static final synchronized String getShellName() {
        return SHELLNAME + shellNumber++;
    }

    public Invoker(PkgMgrFrame pmf, String command, ResultWatcher watcher, String retType) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (watcher == null) {
            throw new NullPointerException("Invoker: watcher == null");
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.watcher = watcher;
        this.member = null;
        this.shellName = Invoker.getShellName();
        this.objName = null;
        this.instanceName = null;
        this.constructing = false;
        this.executionEvent = new ExecutionEvent(this.pkg);
        this.commandString = command;
        this.doFreeFormInvocation(retType);
    }

    public Invoker(PkgMgrFrame pmf, CallableView member, ResultWatcher watcher) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (watcher == null) {
            throw new NullPointerException("Invoker: watcher == null");
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.member = member;
        this.watcher = watcher;
        this.shellName = Invoker.getShellName();
        if (member instanceof ConstructorView) {
            this.objName = pmf.getProject().getDebugger().guessNewName(member.getClassName());
            this.constructing = true;
            this.executionEvent = new ExecutionEvent(member.getClassName(), null);
        } else if (member instanceof MethodView) {
            if (((MethodView)member).isStatic()) {
                this.objName = JavaNames.stripPrefix(member.getClassName());
                this.executionEvent = new ExecutionEvent(member.getClassName(), null);
            } else {
                this.executionEvent = new ExecutionEvent(member.getClassName(), this.objName);
            }
            this.constructing = false;
        } else {
            Debug.reportError("illegal member type in invocation");
        }
        this.executionEvent.setPackage(this.pkg);
    }

    public Invoker(PkgMgrFrame pmf, MethodView member, ObjectWrapper objWrapper, ResultWatcher watcher) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (watcher == null) {
            throw new NullPointerException("Invoker: watcher == null");
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.member = member;
        this.watcher = watcher;
        this.shellName = Invoker.getShellName();
        this.objName = objWrapper.getName();
        this.instanceMap = this.typeMap = objWrapper.getObject().getGenType().mapToSuper(member.getClassName());
        if (this.typeMap == null) {
            this.typeMap = new HashMap();
        }
        JavaReflective superRefl = new JavaReflective(member.getDeclaringView().getViewClass());
        GenTypeClass.addDefaultParamBases(this.typeMap, superRefl);
        this.executionEvent = new ExecutionEvent(member.getClassName(), this.objName);
        this.constructing = false;
        this.executionEvent.setPackage(this.pkg);
    }

    public void invokeInteractive() {
        if (!this.constructing && !this.member.hasParameters()) {
            this.dialog = null;
            this.doInvocation(null, null, null);
        } else {
            MethodDialog mDialog = (MethodDialog)methods.get(this.member);
            if (mDialog == null) {
                mDialog = new MethodDialog(this.pmf, this.objName, this.member, this.instanceMap);
                methods.put(this.member, mDialog);
                mDialog.setVisible(true);
            } else {
                mDialog.setInstanceInfo(this.objName, this.instanceMap);
            }
            mDialog.setEnabled(true);
            mDialog.setWatcher(this);
            this.dialog = mDialog;
        }
    }

    public synchronized void tryAgain() {
        this.doFreeFormInvocation(null);
    }

    public void callDialogEvent(CallDialog dlg, int event) {
        if (event == 1) {
            dlg.setVisible(false);
        } else if (event == 0) {
            if (dlg instanceof MethodDialog) {
                MethodView mv;
                MethodDialog mDialog = (MethodDialog)dlg;
                mDialog.setEnabled(false);
                this.instanceName = mDialog.getNewInstanceName();
                String[] actualTypeParams = mDialog.getTypeParams();
                if (this.constructing) {
                    int len;
                    TypeParamView[] formalTypeParamViews = mDialog.getFormalTypeParams();
                    int n = len = formalTypeParamViews == null ? 0 : formalTypeParamViews.length;
                    if (len > actualTypeParams.length) {
                        len = 0;
                    }
                    for (int i = 0; i < len; ++i) {
                        TypeParamView view = formalTypeParamViews[i];
                        GenTypeDeclTpar formalType = view.getParamType();
                        GenTypeTpar actualType = new GenTypeTpar(actualTypeParams[i]);
                        if (this.typeMap == null) {
                            this.typeMap = new HashMap();
                        }
                        this.typeMap.put(formalType.getTparName(), actualType);
                    }
                } else if (this.member instanceof MethodView && (mv = (MethodView)this.member).isMain()) {
                    this.pmf.getProject().removeLocalClassLoader();
                    this.pmf.getProject().newRemoteClassLoaderLeavingBreakpoints();
                }
                this.doInvocation(mDialog.getArgs(), mDialog.getArgGenTypes(true, this.instanceMap == null), actualTypeParams);
                this.pmf.setWaitCursor(true);
                if (this.constructing) {
                    this.pkg.setStatus(creating);
                }
            }
        } else {
            Debug.reportError("Invoker: Unknown CallDialog event");
        }
    }

    public void invokeDirect(String[] params) {
        if (this.instanceName == null) {
            this.instanceName = this.objName;
        }
        this.doInvocation(params, this.member.getParamTypes(false), null);
    }

    protected void doInvocation(String[] args, GenType[] argTypes, String[] typeParams) {
        String command;
        MethodView method;
        ExpressionInformation info = this.watcher.getExpressionInformation();
        if (info != null) {
            info.setArgumentValues(args);
        }
        this.executionEvent.setParameters(argTypes, args);
        if (this.constructing) {
            this.executionEvent.setObjectName(this.instanceName);
        } else {
            this.executionEvent.setMethodName(((MethodView)this.member).getName());
        }
        int numArgs = args == null ? 0 : args.length;
        String className = this.member.getClassName();
        boolean isGenericMethod = false;
        if (!this.constructing && (method = (MethodView)this.member).isGeneric()) {
            isGenericMethod = true;
        }
        StringBuffer buffer = new StringBuffer();
        if (!isGenericMethod) {
            for (int i = 0; i < numArgs; ++i) {
                GenType argType = this.typeMap != null ? argTypes[i].mapTparsToTypes(this.typeMap) : argTypes[i];
                if (argType instanceof GenTypeWildcard) {
                    GenTypeSolid[] ubounds = ((GenTypeWildcard)argType).getUpperBounds();
                    if (ubounds.length != 0) {
                        buffer.append(ubounds[0].toString(new CleverQualifyTypeNameTransform(this.pkg)));
                    } else {
                        buffer.append("Object");
                    }
                } else if (argType instanceof GenTypeParameterizable) {
                    buffer.append(((GenTypeParameterizable)argType).toString(new CleverQualifyTypeNameTransform(this.pkg)));
                } else {
                    buffer.append(argType.toString());
                }
                buffer.append(" __bluej_param" + i);
                buffer.append(" = " + args[i]);
                buffer.append(";" + Config.nl);
            }
        }
        String paramInit = buffer.toString();
        buffer = new StringBuffer("(");
        StringBuffer argBuffer = new StringBuffer("(");
        if (numArgs > 0) {
            buffer.append("__bluej_param0");
            argBuffer.append(args[0]);
        }
        for (int i = 1; i < numArgs; ++i) {
            buffer.append(",__bluej_param" + i);
            argBuffer.append(", ");
            argBuffer.append(args[i]);
        }
        buffer.append(")");
        argBuffer.append(")");
        String argString = buffer.toString();
        String actualArgString = argBuffer.toString();
        if (isGenericMethod) {
            argString = actualArgString;
        }
        buffer = new StringBuffer();
        boolean isVoid = false;
        String constype = null;
        if (this.constructing) {
            constype = Invoker.cleverQualifyTypeName(this.pkg, className);
            if (typeParams != null && typeParams.length > 0) {
                constype = constype + "<";
                for (int i = 0; i < typeParams.length; ++i) {
                    String typeParam = typeParams[i];
                    constype = constype + typeParam;
                    if (i >= typeParams.length - 1) continue;
                    constype = constype + ",";
                }
                constype = constype + ">";
            }
            command = "new " + constype;
            this.ir = new ConstructionInvokerRecord(constype, this.instanceName, command + actualArgString);
        } else {
            MethodView method2 = (MethodView)this.member;
            isVoid = method2.isVoid();
            command = method2.isStatic() ? Invoker.cleverQualifyTypeName(this.pkg, className) + "." + method2.getName() : this.objName + "." + method2.getName();
            if (isVoid) {
                this.ir = method2.isMain() ? new StaticVoidMainMethodInvokerRecord() : new VoidMethodInvokerRecord(command + actualArgString);
                this.instanceName = null;
            } else {
                this.ir = new MethodInvokerRecord(method2.getReturnType().getViewClass(), command + actualArgString);
                this.instanceName = "result";
            }
        }
        File shell = this.writeInvocationFile(this.pkg, paramInit, command + argString, this.constructing, isVoid, constype);
        this.commandString = command + actualArgString;
        this.compileInvocationFile(shell);
    }

    protected void doFreeFormInvocation(String resultType) {
        boolean hasResult;
        boolean bl = hasResult = resultType != null;
        if (hasResult) {
            if (resultType.equals("")) {
                resultType = null;
            }
            this.instanceName = "result";
            this.ir = new ExpressionInvokerRecord(this.commandString);
        } else {
            this.instanceName = null;
            this.ir = new VoidMethodInvokerRecord(this.commandString);
        }
        File shell = this.writeInvocationFile(this.pkg, "", this.commandString, false, !hasResult, resultType);
        this.executionEvent.setCommand(this.commandString);
        this.compileInvocationFile(shell);
    }

    private File writeInvocationFile(Package pkg, String paramInit, String callString, boolean constructing, boolean isVoid, String constype) {
        String packageLine = pkg.isUnnamedPackage() ? "" : "package " + pkg.getQualifiedName() + ";";
        StringBuffer buffer = new StringBuffer();
        if (!isVoid) {
            if (constructing) {
                buffer.append("public static ");
                buffer.append(constype);
            } else {
                buffer.append("public static Object");
            }
            buffer.append(" __bluej_runtime_result;");
        }
        String vardecl = buffer.toString();
        buffer = new StringBuffer();
        String scopeId = Utility.quoteSloshes(pkg.getId());
        List wrappers = this.pmf.getObjectBench().getObjects();
        if (wrappers.size() > 0) {
            buffer.append("java.util.Map __bluej_runtime_scope = getScope(\"" + scopeId + "\");" + Config.nl);
        }
        Iterator i = wrappers.iterator();
        while (i.hasNext()) {
            ObjectWrapper wrapper = (ObjectWrapper)i.next();
            String type = wrapper.getGenType().toString(new CleverQualifyTypeNameTransform(pkg));
            String instname = wrapper.getName();
            buffer.append("final ");
            buffer.append(type);
            buffer.append(" " + instname + " = ");
            buffer.append("(" + type);
            buffer.append(")__bluej_runtime_scope.get(\"");
            buffer.append(instname + "\");" + Config.nl);
        }
        String scopeInit = buffer.toString();
        buffer = new StringBuffer();
        if (constructing) {
            buffer.append("__bluej_runtime_result = ");
            buffer.append(callString);
        } else {
            if (!isVoid) {
                if (constype == null) {
                    buffer.append("__bluej_runtime_result = makeObj(");
                } else {
                    buffer.append("__bluej_runtime_result = new Object() {");
                    buffer.append(" " + constype + " result = ");
                }
            }
            buffer.append(callString);
            if (!isVoid) {
                if (constype == null) {
                    buffer.append(")");
                }
                if (constype != null) {
                    buffer.append("; }");
                }
            }
        }
        if (!callString.endsWith(";")) {
            buffer.append(";");
        }
        buffer.append(Config.nl);
        String invocation = buffer.toString();
        File shellFile = new File(pkg.getPath(), this.shellName + ".java");
        try {
            BufferedWriter shell = new BufferedWriter(new FileWriter(shellFile));
            shell.write(packageLine);
            shell.newLine();
            shell.write("public class ");
            shell.write(this.shellName);
            shell.write(" extends bluej.runtime.Shell {");
            shell.newLine();
            shell.write(vardecl);
            shell.newLine();
            shell.write("public static void run() throws Throwable {");
            shell.newLine();
            shell.write(scopeInit);
            shell.write(paramInit);
            shell.write(invocation);
            shell.newLine();
            shell.write("}}");
            shell.close();
        }
        catch (IOException e) {
            DialogManager.showError(this.pmf, "could-not-write-shell-file");
        }
        return shellFile;
    }

    private void compileInvocationFile(File shellFile) {
        File[] files = new File[]{shellFile};
        ++this.numberCompiling;
        JobQueue.getJobQueue().addJob(files, this, this.pkg.getProject().getClassPath(), this.pkg.getProject().getProjectDir(), true);
    }

    public void startCompile(File[] sources) {
    }

    public void checkTarget(String sources) {
    }

    public void errorMessage(String filename, int lineNo, String message, boolean invalidate) {
        if (this.dialog != null) {
            this.dialog.setErrorMessage("Error: " + message);
        }
        this.watcher.putError(message);
    }

    public synchronized void endCompile(File[] sources, boolean successful) {
        if (this.dialog != null) {
            this.dialog.setWaitCursor(false);
            if (successful) {
                this.dialog.setVisible(false);
                if (this.dialog instanceof MethodDialog) {
                    ((MethodDialog)this.dialog).updateParameters();
                }
            }
        }
        this.pmf.setWaitCursor(false);
        if (successful) {
            this.startClass();
        }
        if (this.constructing && successful) {
            this.pkg.setStatus(createDone);
        } else {
            this.pkg.setStatus(" ");
        }
        --this.numberCompiling;
        if (this.numberCompiling == 0) {
            this.deleteShellFiles();
        }
        if (!successful && this.dialog != null) {
            this.dialog.setEnabled(true);
        }
    }

    private void deleteShellFiles() {
        File srcFile = new File(this.pkg.getPath(), this.shellName + ".java");
        srcFile.delete();
        File classFile = new File(this.pkg.getPath(), this.shellName + ".class");
        classFile.delete();
    }

    public void startClass() {
        BlueJEvent.raiseEvent(3, this.commandString);
        try {
            String shellClassName = this.pkg.getQualifiedName(this.shellName);
            this.pkg.getProject().getDebugger().runClassMain(shellClassName);
            this.handleResult(shellClassName);
            Inspector.updateInspectors();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    public void handleResult(String shellClassName) {
        try {
            int status = this.pkg.getDebugger().getExitStatus();
            switch (status) {
                case 0: {
                    try {
                        DebuggerObject result = this.pkg.getDebugger().getStaticValue(shellClassName, "__bluej_runtime_result");
                        this.watcher.putResult(result, this.instanceName, this.ir);
                        this.executionEvent.setResultObject(result);
                        this.executionEvent.setResult("Normal exit");
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.watcher.putError("Terminated");
                        this.executionEvent.setResult("User terminated");
                        return;
                    }
                }
                case 1: {
                    String excMsg = this.pkg.getDebugger().getException().getText();
                    if (this.instanceName != null) {
                        this.pkg.reportExit(excMsg);
                        this.watcher.putError(excMsg);
                    } else if (!"0".equals(excMsg)) {
                        this.pkg.reportExit(excMsg);
                    }
                    this.executionEvent.setResult("Forced exit");
                    break;
                }
                case 2: {
                    ExceptionDescription exc = this.pkg.getDebugger().getException();
                    String msg = exc.getText();
                    String text = exc.getClassName();
                    if (text != null) {
                        text = JavaNames.stripPrefix(text) + ":\n" + msg;
                        this.pkg.exceptionMessage(exc.getStack(), text, false);
                        this.watcher.putError(text);
                    } else {
                        this.pkg.reportException(msg);
                        this.watcher.putError(msg);
                    }
                    this.executionEvent.setResult("An exception occurred");
                    break;
                }
                case 3: {
                    this.watcher.putError("Terminated");
                    this.executionEvent.setResult("User terminated");
                }
            }
            BlueJEvent.raiseEvent(5, this.executionEvent);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    private static String cleverQualifyTypeName(Package p, String typeName) {
        int firstDollar;
        if (!p.isUnnamedPackage()) {
            String pkgName = p.getQualifiedName();
            int firstDot = pkgName.indexOf(".");
            if (firstDot >= 0) {
                pkgName = pkgName.substring(0, firstDot);
            }
            if (p.getTarget(pkgName) != null) {
                typeName = JavaNames.getBase(typeName);
            }
        }
        if ((firstDollar = typeName.indexOf(36)) != -1) {
            StringBuffer sb = new StringBuffer(typeName);
            for (int i = firstDollar; i < sb.length() - 1; ++i) {
                if (sb.charAt(i) != '$' || Character.isDigit(sb.charAt(i + 1))) continue;
                sb.setCharAt(i, '.');
            }
            typeName = sb.toString();
        }
        return JavaNames.typeName(typeName);
    }

    static class CleverQualifyTypeNameTransform
    implements NameTransform {
        Package mypackage;

        public CleverQualifyTypeNameTransform(Package p) {
            this.mypackage = p;
        }

        public String transform(String n) {
            return Invoker.cleverQualifyTypeName(this.mypackage, n);
        }
    }
}

