/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Config;
import bluej.classmgr.ClassMgr;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugger.jdi.JdiDebugger;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.VMEventHandler;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class VMReference {
    static final String SERVER_CLASSNAME = "bluej.runtime.ExecServer";
    static final String SERVER_STARTED_METHOD_NAME = "vmStarted";
    static final String SERVER_SUSPEND_METHOD_NAME = "vmSuspend";
    private JdiDebugger owner = null;
    private VirtualMachine machine = null;
    private Process remoteVMprocess = null;
    private VMEventHandler eventHandler = null;
    private ClassType serverClass = null;
    private ThreadReference serverThread = null;
    private boolean serverThreadStarted = false;
    private Object serverThreadLock = new Object();
    private ThreadReference workerThread = null;
    private boolean workerThreadReady = false;
    private IOHandlerThread inputStreamRedirector = null;
    private IOHandlerThread outputStreamRedirector = null;
    private IOHandlerThread errorStreamRedirector = null;
    private ClassLoaderReference currentLoader = null;
    private int exitStatus;
    private ExceptionDescription lastException;
    private static int shmCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine localhostSocketLaunch(File initDir, DebuggerTerminal term, VirtualMachineManager mgr) {
        int CONNECT_TRIES = 10;
        int CONNECT_WAIT = 500;
        String allClassPath = ClassMgr.getClassMgr().getAllClassPath().toString();
        ArrayList<String> paramList = new ArrayList<String>(10);
        paramList.add(Config.getJDKExecutablePath("this.key.must.not.exist", "java"));
        List configArgs = Config.getDebugVMArgs();
        if (!configArgs.isEmpty()) {
            paramList.addAll(configArgs);
        }
        paramList.add("-classpath");
        paramList.add(allClassPath);
        paramList.add("-Xdebug");
        paramList.add("-Xnoagent");
        if (!PrefMgr.getFlag("bluej.vm.optimize")) {
            paramList.add("-Xint");
        }
        if (Config.isMacOS()) {
            paramList.add("-Xdock:icon=" + Config.getBlueJIconPath() + "/vm.icns");
            paramList.add("-Xdock:name=BlueJ Virtual Machine");
        }
        paramList.add("-Xrunjdwp:transport=dt_socket,server=y");
        paramList.add(SERVER_CLASSNAME);
        String[] launchParams = paramList.toArray(new String[0]);
        String transport = Config.getPropString("bluej.vm.transport");
        AttachingConnector tcpipConnector = null;
        AttachingConnector shmemConnector = null;
        Throwable tcpipFailureReason = null;
        Throwable shmemFailureReason = null;
        List<AttachingConnector> connectors = mgr.attachingConnectors();
        AttachingConnector connector = null;
        Iterator<AttachingConnector> it = connectors.iterator();
        while (it.hasNext()) {
            AttachingConnector c = it.next();
            if (c.transport().name().equals("dt_socket")) {
                tcpipConnector = c;
                continue;
            }
            if (!c.transport().name().equals("dt_shmem")) continue;
            shmemConnector = c;
        }
        connector = tcpipConnector;
        if (transport.equals("dt_shmem") && shmemConnector != null) {
            connector = null;
        }
        if (connector != null) {
            try {
                final StringBuffer listenMessage = new StringBuffer();
                this.remoteVMprocess = this.launchVM(initDir, launchParams, listenMessage, term);
                int portNumber = this.extractPortNumber(listenMessage.toString());
                if (portNumber == -1) {
                    this.closeIO();
                    this.remoteVMprocess.destroy();
                    this.remoteVMprocess = null;
                    throw new Exception(){

                        public void printStackTrace() {
                            Debug.message("Could not find port number to connect to debugger");
                            Debug.message("Line received from debugger was: " + listenMessage);
                        }
                    };
                }
                Map<String, Connector.Argument> arguments = connector.defaultArguments();
                Connector.Argument hostnameArg = arguments.get("hostname");
                Connector.Argument portArg = arguments.get("port");
                if (hostnameArg == null || portArg == null) {
                    throw new Exception(){

                        public void printStackTrace() {
                            Debug.message("incompatible JPDA socket launch connector");
                        }
                    };
                }
                hostnameArg.setValue("127.0.0.1");
                portArg.setValue(Integer.toString(portNumber));
                for (int i = 0; i < 10; ++i) {
                    try {
                        VirtualMachine m = connector.attach(arguments);
                        Debug.log("Connected to debug VM via dt_socket transport.");
                        return m;
                    }
                    catch (Exception ce) {
                        if (i == 9) {
                            throw ce;
                        }
                        try {
                            VMReference vMReference = this;
                            synchronized (vMReference) {
                                this.wait(500L);
                            }
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                this.closeIO();
                this.remoteVMprocess.destroy();
                this.remoteVMprocess = null;
            }
            catch (Throwable t) {
                tcpipFailureReason = t;
            }
        }
        if ((connector = shmemConnector) != null) {
            try {
                Map<String, Connector.Argument> arguments = connector.defaultArguments();
                Connector.Argument addressArg = arguments.get("name");
                if (addressArg == null) {
                    throw new Exception(){

                        public void printStackTrace() {
                            Debug.message("Shared memory connector is incompatible - no 'name' argument");
                        }
                    };
                }
                String shmName = "bluej" + shmCount++;
                addressArg.setValue(shmName);
                launchParams[launchParams.length - 2] = "-Xrunjdwp:transport=dt_shmem,address=" + shmName + ",server=y,suspend=y";
                StringBuffer listenMessage = new StringBuffer();
                this.remoteVMprocess = this.launchVM(initDir, launchParams, listenMessage, term);
                VirtualMachine m = connector.attach(arguments);
                Debug.log("Connected to debug VM via dt_shmem transport.");
                return m;
            }
            catch (Throwable t) {
                shmemFailureReason = t;
            }
        }
        Debug.message("Failed to connect to debug VM. Reasons follow:");
        if (tcpipConnector != null && tcpipFailureReason != null) {
            Debug.message("dt_socket transport:");
            tcpipFailureReason.printStackTrace();
        }
        if (shmemConnector != null && shmemFailureReason != null) {
            Debug.message("dt_shmem transport:");
            tcpipFailureReason.printStackTrace();
        }
        if (shmemConnector == null && tcpipConnector == null) {
            Debug.message(" No suitable transports available.");
        }
        return null;
    }

    private Process launchVM(File initDir, String[] params, StringBuffer line, DebuggerTerminal term) throws IOException {
        Process vmProcess = Runtime.getRuntime().exec(params, null, initDir);
        String listenMessage = new BufferedReader(new InputStreamReader(vmProcess.getInputStream())).readLine();
        line.append(listenMessage);
        this.errorStreamRedirector = this.redirectIOStream(new InputStreamReader(vmProcess.getErrorStream()), term.getErrorWriter(), false);
        this.outputStreamRedirector = this.redirectIOStream(new InputStreamReader(vmProcess.getInputStream()), term.getWriter(), false);
        this.inputStreamRedirector = this.redirectIOStream(term.getReader(), new OutputStreamWriter(vmProcess.getOutputStream()), false);
        return vmProcess;
    }

    private int extractPortNumber(String msg) {
        int colonIndex = msg.indexOf(":");
        int val = -1;
        try {
            if (colonIndex > -1) {
                val = Integer.parseInt(msg.substring(colonIndex + 1).trim());
            }
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        return val;
    }

    public VMReference(JdiDebugger owner, DebuggerTerminal term, File initialDirectory) throws JdiVmCreationException {
        this.owner = owner;
        this.machine = this.localhostSocketLaunch(initialDirectory, term, Bootstrap.virtualMachineManager());
        if (this.machine == null) {
            throw new JdiVmCreationException();
        }
        EventRequestManager erm = this.machine.eventRequestManager();
        erm.createExceptionRequest(null, false, true).enable();
        erm.createClassPrepareRequest().enable();
        erm.createThreadStartRequest().enable();
        erm.createThreadDeathRequest().enable();
        this.eventHandler = new VMEventHandler(this, this.machine);
    }

    public synchronized void waitForStartup() {
        this.serverThreadStartWait();
        this.setupServerConnection(this.machine);
    }

    public synchronized void close() {
        if (this.machine != null) {
            this.closeIO();
            try {
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(4));
                this.machine.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void closeIO() {
        if (this.inputStreamRedirector != null) {
            this.inputStreamRedirector.close();
            this.inputStreamRedirector.interrupt();
        }
        if (this.errorStreamRedirector != null) {
            this.errorStreamRedirector.close();
            this.errorStreamRedirector.interrupt();
        }
        if (this.outputStreamRedirector != null) {
            this.outputStreamRedirector.close();
            this.outputStreamRedirector.interrupt();
        }
    }

    void serverClassPrepared() {
        EventRequestManager erm = this.machine.eventRequestManager();
        List<ClassPrepareRequest> list = erm.classPrepareRequests();
        if (list.size() != 1) {
            Debug.reportError("oops - found more than one prepare request!");
        }
        ClassPrepareRequest cpreq = list.get(0);
        erm.deleteEventRequest(cpreq);
        try {
            this.serverClass = (ClassType)this.findClassByName(SERVER_CLASSNAME, null);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("can't find class bluej.runtime.ExecServer in debug virtual machine");
        }
        this.serverClassAddBreakpoints();
    }

    private void serverClassAddBreakpoints() {
        EventRequestManager erm = this.machine.eventRequestManager();
        Method startedMethod = this.findMethodByName(this.serverClass, SERVER_STARTED_METHOD_NAME);
        if (startedMethod == null) {
            throw new IllegalStateException("can't find method bluej.runtime.ExecServer.vmStarted");
        }
        Location loc = startedMethod.location();
        BreakpointRequest bpreq = erm.createBreakpointRequest(loc);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty(SERVER_STARTED_METHOD_NAME, "yes");
        bpreq.putProperty("dontResume", "yes");
        bpreq.enable();
        Method suspendMethod = this.findMethodByName(this.serverClass, SERVER_SUSPEND_METHOD_NAME);
        if (suspendMethod == null) {
            throw new IllegalStateException("can't find method bluej.runtime.ExecServer.vmSuspend");
        }
        loc = suspendMethod.location();
        bpreq = erm.createBreakpointRequest(loc);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty(SERVER_SUSPEND_METHOD_NAME, "yes");
        bpreq.putProperty("dontResume", "yes");
        bpreq.enable();
    }

    private boolean setupServerConnection(VirtualMachine vm) {
        if (this.serverClass == null) {
            Debug.reportError("server class not initialised!");
            return false;
        }
        this.workerThread = (ThreadReference)this.getStaticFieldObject(this.serverClass, "workerThread");
        if (this.serverThread == null || this.workerThread == null) {
            Debug.reportError("Cannot find fields on remote VM");
            return false;
        }
        return true;
    }

    int getStatus() {
        if (this.serverThread.isSuspended()) {
            return 4;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoaderReference newClassLoader(String classPath) {
        Object loader = null;
        Object[] args = new Object[]{classPath};
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(3));
            this.setStaticFieldObject(this.serverClass, "classPath", classPath);
            this.workerThreadReady = false;
            this.workerThread.resume();
            this.workerThreadReadyWait();
            this.currentLoader = (ClassLoaderReference)this.getStaticFieldObject(this.serverClass, "workerReturn");
            return this.currentLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceType loadClass(String className) throws ClassNotFoundException {
        Object v = null;
        Object[] args = new Object[]{className};
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(2));
            this.setStaticFieldObject(this.serverClass, "className", className);
            this.workerThreadReady = false;
            this.workerThread.resume();
            this.workerThreadReadyWait();
            ClassObjectReference robject = (ClassObjectReference)this.getStaticFieldObject(this.serverClass, "workerReturn");
            if (robject == null) {
                throw new ClassNotFoundException(className);
            }
            return robject.reflectedType();
        }
    }

    public void runShellClass(String className) throws ClassNotFoundException {
        try {
            this.exitStatus = 0;
            this.owner.raiseStateChangeEvent(3);
            this.invokeShell(className);
        }
        catch (VMDisconnectedException e) {
            this.exitStatus = 3;
            return;
        }
        catch (Exception e) {
            Debug.reportError("starting shell class failed: " + e);
            e.printStackTrace();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error: unexpected exception in remote VM\n" + e);
        }
        this.owner.raiseStateChangeEvent(2);
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    public void vmStartEvent(VMStartEvent vmse) {
        this.serverThreadStarted = false;
    }

    public void vmExitEvent() {
        this.owner.vmExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmDisconnectEvent() {
        this.exitStatus = 3;
        Object object = this;
        synchronized (object) {
            if (!this.serverThreadStarted) {
                this.notifyAll();
            }
        }
        object = this.workerThread;
        synchronized (object) {
            if (!this.workerThreadReady) {
                this.workerThread.notifyAll();
            }
        }
        this.owner.vmDisconnect();
    }

    public void threadStartEvent(ThreadStartEvent tse) {
        this.owner.threadStart(tse.thread());
    }

    public void threadDeathEvent(ThreadDeathEvent tde) {
        ThreadReference tr = tde.thread();
        this.owner.threadDeath(tr);
    }

    public void exceptionEvent(ExceptionEvent exc) {
        Field msgField;
        ObjectReference remoteException = exc.exception();
        StringReference msgVal = (StringReference)remoteException.getValue(msgField = remoteException.referenceType().fieldByName("detailMessage"));
        String exceptionText = msgVal == null ? null : msgVal.value();
        String excClass = exc.exception().type().name();
        List stack = JdiThread.getStack(exc.thread());
        this.exitStatus = 2;
        this.lastException = new ExceptionDescription(excClass, exceptionText, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value safeInvoke(ObjectReference o, Method m, List args) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            Value v = null;
            try {
                v = o.invokeMethod(this.workerThread, m, args, 1);
            }
            catch (ClassNotLoadedException cnle) {
            }
            catch (InvalidTypeException ite) {
            }
            catch (IncompatibleThreadStateException itse) {
            }
            catch (InvocationException ie) {
                // empty catch block
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionEvent(InvocationException exc) {
        LinkedList empty = new LinkedList();
        ObjectReference remoteException = exc.exception();
        Field msgField = remoteException.referenceType().fieldByName("detailMessage");
        StringReference msgVal = (StringReference)remoteException.getValue(msgField);
        String exceptionText = msgVal == null ? null : msgVal.value();
        String excClass = exc.exception().type().name();
        ReferenceType remoteType = exc.exception().referenceType();
        List<Method> getStackTraceMethods = remoteType.methodsByName("getStackTrace");
        Method getStackTrace = getStackTraceMethods.get(0);
        ArrayReference stackValue = (ArrayReference)this.safeInvoke(exc.exception(), getStackTrace, empty);
        ObjectReference[] stackt = stackValue.getValues().toArray(new ObjectReference[0]);
        LinkedList<SourceLocation> stack = new LinkedList<SourceLocation>();
        if (stackt.length > 0) {
            ReferenceType StackTraceElementType = (ReferenceType)stackt[0].type();
            Method getClassName = StackTraceElementType.methodsByName("getClassName").get(0);
            Method getFileName = StackTraceElementType.methodsByName("getFileName").get(0);
            Method getLineNum = StackTraceElementType.methodsByName("getLineNumber").get(0);
            Method getMethodName = StackTraceElementType.methodsByName("getMethodName").get(0);
            for (int i = 0; i < stackt.length; ++i) {
                Value classNameV = this.safeInvoke(stackt[i], getClassName, empty);
                Value fileNameV = this.safeInvoke(stackt[i], getFileName, empty);
                Value methodNameV = this.safeInvoke(stackt[i], getMethodName, empty);
                Value lineNumV = this.safeInvoke(stackt[i], getLineNum, empty);
                String className = ((StringReference)classNameV).value();
                String fileName = ((StringReference)fileNameV).value();
                String methodName = ((StringReference)methodNameV).value();
                int lineNumber = ((IntegerValue)lineNumV).value();
                stack.add(new SourceLocation(className, fileName, methodName, lineNumber));
            }
        }
        this.exitStatus = 2;
        this.lastException = new ExceptionDescription(excClass, exceptionText, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointEvent(LocatableEvent event, boolean breakpoint) {
        String fileName;
        if (event.request().getProperty(SERVER_STARTED_METHOD_NAME) != null) {
            VMReference vMReference = this;
            synchronized (vMReference) {
                this.serverThreadStarted = true;
                this.serverThread = event.thread();
                this.notifyAll();
            }
        }
        if (event.request().getProperty(SERVER_SUSPEND_METHOD_NAME) != null) {
            if (this.workerThread == null) {
                this.workerThread = event.thread();
            }
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReady = true;
                this.workerThread.notify();
            }
        }
        if (this.serverThread.equals(event.thread())) {
            this.owner.raiseStateChangeEvent(4);
        }
        Location location = event.location();
        try {
            fileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            fileName = null;
        }
        if (fileName == null || !fileName.startsWith("__SHELL")) {
            this.owner.breakpoint(event.thread(), breakpoint);
        }
    }

    private Location loadClassesAndFindLine(String className, int line) {
        ReferenceType remoteClass = null;
        try {
            remoteClass = this.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        ArrayList allTypesInFile = new ArrayList();
        this.buildNestedTypes(remoteClass, allTypesInFile);
        Iterator it = allTypesInFile.iterator();
        while (it.hasNext()) {
            ReferenceType r = (ReferenceType)it.next();
            try {
                List<Location> list = r.locationsOfLine(line);
                if (list.size() <= 0) continue;
                return list.get(0);
            }
            catch (AbsentInformationException aie) {
            }
        }
        return null;
    }

    private void buildNestedTypes(ReferenceType rootType, List l) {
        l.add(rootType);
        List<ReferenceType> nestedTypes = rootType.nestedTypes();
        Iterator<ReferenceType> it = nestedTypes.iterator();
        while (it.hasNext()) {
            ReferenceType r = it.next();
            this.buildNestedTypes(r, l);
        }
    }

    String setBreakpoint(String className, int line) {
        Location location = this.loadClassesAndFindLine(className, line);
        if (location == null) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
        EventRequestManager erm = this.machine.eventRequestManager();
        BreakpointRequest bpreq = erm.createBreakpointRequest(location);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty("dontResume", "yes");
        bpreq.enable();
        return null;
    }

    String clearBreakpoint(String className, int line) {
        Location location = this.loadClassesAndFindLine(className, line);
        if (location == null) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
        EventRequestManager erm = this.machine.eventRequestManager();
        boolean found = false;
        List<BreakpointRequest> list = erm.breakpointRequests();
        for (int i = 0; i < list.size(); ++i) {
            BreakpointRequest bp = list.get(i);
            if (!((Object)bp.location()).equals(location)) continue;
            erm.deleteEventRequest(bp);
            found = true;
        }
        if (found) {
            return null;
        }
        return Config.getString("debugger.jdiDebugger.noBreakpointMsg");
    }

    public ObjectReference getStaticValue(String className, String fieldName) throws ClassNotFoundException {
        ReferenceType cl = this.loadClass(className);
        Field resultField = cl.fieldByName(fieldName);
        if (resultField == null) {
            return null;
        }
        return (ObjectReference)cl.getValue(resultField);
    }

    public List getBreakpoints() {
        EventRequestManager erm = this.machine.eventRequestManager();
        LinkedList<Location> breaks = new LinkedList<Location>();
        List<BreakpointRequest> allBreakpoints = erm.breakpointRequests();
        Iterator<BreakpointRequest> it = allBreakpoints.iterator();
        while (it.hasNext()) {
            BreakpointRequest bp = it.next();
            if (bp.location().declaringType().classLoader() != this.currentLoader) continue;
            breaks.add(bp.location());
        }
        return breaks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreBreakpoints(List saved) {
        EventRequestManager erm = this.machine.eventRequestManager();
        ArrayList<Location> newSaved = new ArrayList<Location>();
        Iterator savedIterator = saved.iterator();
        while (savedIterator.hasNext()) {
            Location oldLocation = (Location)savedIterator.next();
            Location newLocation = this.loadClassesAndFindLine(oldLocation.declaringType().name(), oldLocation.lineNumber());
            if (newLocation == null) continue;
            newSaved.add(newLocation);
        }
        Object object = this.serverThreadLock;
        synchronized (object) {
            this.serverThreadStartWait();
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReadyWait();
                erm.deleteAllBreakpoints();
                this.serverClassAddBreakpoints();
                Iterator it = newSaved.iterator();
                while (it.hasNext()) {
                    Location l = (Location)it.next();
                    BreakpointRequest bpreq = erm.createBreakpointRequest(l);
                    bpreq.setSuspendPolicy(1);
                    bpreq.putProperty("dontResume", "yes");
                    bpreq.enable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverThreadStartWait() {
        VMReference vMReference = this;
        synchronized (vMReference) {
            try {
                while (!this.serverThreadStarted) {
                    if (this.exitStatus == 3) {
                        throw new VMDisconnectedException();
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void workerThreadReadyWait() {
        try {
            while (!this.workerThreadReady) {
                if (this.exitStatus == 3) {
                    throw new VMDisconnectedException();
                }
                this.workerThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value invokeShell(String cl) {
        Object object = this.serverThreadLock;
        synchronized (object) {
            ObjectReference exception;
            this.serverThreadStartWait();
            this.setStaticFieldObject(this.serverClass, "classToRun", cl);
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(0));
            this.serverThreadStarted = false;
            this.serverThread.resume();
            this.serverThreadStartWait();
            ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
            if (rval == null && (exception = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
                this.exceptionEvent(new InvocationException(exception));
            }
            return rval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invokeTestSetup(String cl) throws InvocationException {
        Object object = this.serverThreadLock;
        synchronized (object) {
            ObjectReference e;
            this.serverThreadStartWait();
            this.setStaticFieldObject(this.serverClass, "classToRun", cl);
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(1));
            this.serverThreadStarted = false;
            this.serverThread.resume();
            this.serverThreadStartWait();
            ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
            if (rval == null && (e = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
                this.exceptionEvent(new InvocationException(e));
                throw new InvocationException(e);
            }
            return rval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invokeRunTest(String cl, String method) throws InvocationException {
        Object object = this.serverThreadLock;
        synchronized (object) {
            ObjectReference e;
            this.serverThreadStartWait();
            this.setStaticFieldObject(this.serverClass, "classToRun", cl);
            this.setStaticFieldObject(this.serverClass, "methodToRun", method);
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(2));
            this.serverThreadStarted = false;
            this.serverThread.resume();
            this.serverThreadStartWait();
            ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
            if (rval == null && (e = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
                this.exceptionEvent(new InvocationException(e));
                throw new InvocationException(e);
            }
            return rval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeWindows() {
        Object object = this.serverThreadLock;
        synchronized (object) {
            this.serverThreadStartWait();
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(3));
            this.serverThreadStarted = false;
            this.serverThread.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObject(String instanceName, ObjectReference object) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(1));
            this.setStaticFieldObject(this.serverClass, "objectName", instanceName);
            this.setStaticFieldValue(this.serverClass, "object", object);
            this.workerThreadReady = false;
            this.workerThread.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeObject(String instanceName) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            try {
                this.workerThreadReadyWait();
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(0));
                this.setStaticFieldObject(this.serverClass, "objectName", instanceName);
                this.workerThreadReady = false;
                this.workerThread.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    static boolean isAtMainBreakpoint(ThreadReference tr) {
        try {
            return tr.isAtBreakpoint() && SERVER_CLASSNAME.equals(tr.frame(0).location().declaringType().name());
        }
        catch (IncompatibleThreadStateException e) {
            return false;
        }
    }

    ObjectReference getStaticFieldObject(ClassType cl, String fieldName) {
        Field resultField = cl.fieldByName(fieldName);
        if (resultField == null) {
            throw new IllegalArgumentException("getting field " + fieldName + " resulted in no fields");
        }
        return (ObjectReference)cl.getValue(resultField);
    }

    void setStaticFieldValue(ClassType cl, String fieldName, Value value) {
        Field field = cl.fieldByName(fieldName);
        try {
            cl.setValue(field, value);
        }
        catch (InvalidTypeException ite) {
        }
        catch (ClassNotLoadedException cnle) {
            // empty catch block
        }
    }

    void setStaticFieldObject(ClassType cl, String fieldName, String value) {
        try {
            StringReference s = this.machine.mirrorOf(value);
            s.disableCollection();
            this.setStaticFieldValue(cl, fieldName, s);
            s.enableCollection();
        }
        catch (ObjectCollectedException oce) {
            this.machine.suspend();
            StringReference s = this.machine.mirrorOf(value);
            this.setStaticFieldValue(cl, fieldName, s);
            this.machine.resume();
        }
    }

    private ReferenceType findClassByName(String className, ClassLoaderReference clr) throws ClassNotFoundException {
        List<ReferenceType> list = this.machine.classesByName(className);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            Iterator<ReferenceType> iter = list.iterator();
            while (iter.hasNext()) {
                ReferenceType cl = iter.next();
                if (cl.classLoader() != clr) continue;
                return cl;
            }
        }
        throw new ClassNotFoundException(className);
    }

    public ReferenceType findClassByName(String className) throws ClassNotFoundException {
        return this.findClassByName(className, this.currentLoader);
    }

    Method findMethodByName(ClassType type, String methodName) {
        List<Method> list = type.methodsByName(methodName);
        if (list.size() != 1) {
            throw new IllegalArgumentException("getting method " + methodName + " resulted in " + list.size() + " methods");
        }
        return list.get(0);
    }

    private IOHandlerThread redirectIOStream(Reader reader, Writer writer, boolean buffered) {
        IOHandlerThread thr = new IOHandlerThread(reader, writer, buffered);
        thr.setPriority(9);
        thr.start();
        return thr;
    }

    public void dumpBreakpoints() {
        List<BreakpointRequest> l = this.machine.eventRequestManager().breakpointRequests();
        Iterator<BreakpointRequest> it = l.iterator();
        while (it.hasNext()) {
            BreakpointRequest bp = it.next();
            Debug.message(bp + " " + bp.location().declaringType().classLoader());
        }
    }

    public void dumpThreadInfo() {
        Debug.message("threads:");
        Debug.message("--------");
        List<ThreadReference> threads = this.machine.allThreads();
        if (threads == null) {
            Debug.message("cannot get thread info!");
        } else {
            for (int i = 0; i < threads.size(); ++i) {
                JdiThread thread = (JdiThread)((Object)threads.get(i));
                String status = thread.getStatus();
                Debug.message(thread.getName() + " [" + status + "]");
                try {
                    Debug.message("  group: " + thread.getRemoteThread().threadGroup());
                    Debug.message("  suspend count: " + thread.getRemoteThread().suspendCount());
                    Debug.message("  monitor: " + thread.getRemoteThread().currentContendedMonitor());
                    continue;
                }
                catch (Exception e) {
                    Debug.message("  monitor: exc: " + e);
                }
            }
        }
    }

    private class IOHandlerThread
    extends Thread {
        private Reader reader;
        private Writer writer;
        private boolean buffered;
        private volatile boolean keepRunning;

        IOHandlerThread(Reader reader, Writer writer, boolean buffered) {
            super("BlueJ I/O Handler " + (buffered ? "(buffered)" : "(unbuffered)"));
            this.keepRunning = true;
            this.reader = reader;
            this.writer = writer;
            this.buffered = buffered;
        }

        public void close() {
            this.keepRunning = false;
        }

        public void run() {
            try {
                if (this.buffered) {
                    String line;
                    BufferedReader in = new BufferedReader(this.reader);
                    while (this.keepRunning && (line = in.readLine()) != null) {
                        line = line + '\n';
                        if (!this.keepRunning) continue;
                        this.writer.write(line.toCharArray(), 0, line.length());
                        this.writer.flush();
                    }
                } else {
                    int ch;
                    while (this.keepRunning && (ch = this.reader.read()) != -1) {
                        if (!this.keepRunning) continue;
                        this.writer.write(ch);
                        this.writer.flush();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

