/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerTestResult;
import bluej.debugger.SourceLocation;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class JdiTestResult
extends DebuggerTestResult {
    protected String className;
    protected String methodName;
    protected String exceptionMsg;
    protected String traceMsg;

    JdiTestResult(String className, String methodName) {
        if (className == null || methodName == null) {
            throw new NullPointerException("constructing JdiTestResult");
        }
        this.className = className;
        this.methodName = methodName;
        this.exceptionMsg = null;
        this.traceMsg = null;
    }

    public String getExceptionMessage() {
        throw new IllegalStateException("getting Exception message from successful test");
    }

    public String getName() {
        return this.className + "." + this.methodName;
    }

    public String getTrace() {
        throw new IllegalStateException("getting stack trace from successful test");
    }

    public SourceLocation getExceptionLocation() {
        throw new IllegalStateException("getting stack trace from successful test");
    }

    public boolean isError() {
        return false;
    }

    public boolean isFailure() {
        return false;
    }

    public boolean isSuccess() {
        return true;
    }

    public static String getFilteredTrace(String stack) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (JdiTestResult.filterLine(line)) continue;
                pw.println(line);
            }
        }
        catch (Exception IOException2) {
            return stack;
        }
        return sw.toString();
    }

    static boolean filterLine(String line) {
        String[] patterns = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "sun.reflect.", "bluej.", "java.lang.reflect.Method.invoke("};
        for (int i = 0; i < patterns.length; ++i) {
            if (line.indexOf(patterns[i]) <= 0) continue;
            return true;
        }
        return false;
    }
}

