/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.gentype.GenArray;
import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypePrimitive;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.Reflective;
import bluej.debugger.jdi.JdiArrayReflective;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiUtils;
import bluej.utility.Debug;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JdiReflective
extends Reflective {
    private ReferenceType rclass = null;
    protected String name = null;
    private ClassLoaderReference sourceLoader = null;
    private VirtualMachine sourceVM = null;

    public JdiReflective(ReferenceType rclass) {
        this.rclass = rclass;
        if (rclass == null) {
            Debug.message("JdiReflective: null ReferenceType?");
            throw new NullPointerException();
        }
    }

    public JdiReflective(String name, ReferenceType sourceType) {
        this.name = name;
        this.sourceLoader = sourceType.classLoader();
        this.sourceVM = sourceType.virtualMachine();
    }

    public JdiReflective(String name, ClassLoaderReference classLoader, VirtualMachine vm) {
        this.name = name;
        this.sourceLoader = classLoader;
        this.sourceVM = vm;
    }

    protected void checkLoaded() {
        if (this.rclass == null) {
            this.rclass = JdiReflective.findClass(this.name, this.sourceLoader, this.sourceVM);
            if (this.rclass == null) {
                Debug.message("Attempt to use unloaded type: " + this.name);
            }
            this.name = null;
            this.sourceLoader = null;
            this.sourceVM = null;
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.rclass.name();
    }

    public boolean isInterface() {
        this.checkLoaded();
        return this.rclass instanceof InterfaceType;
    }

    public Reflective getArrayOf() {
        if (this.rclass != null) {
            return new JdiArrayReflective(new GenTypeClass(this), this.rclass);
        }
        return new JdiArrayReflective(new GenTypeClass(this), this.sourceLoader, this.sourceVM);
    }

    public List getTypeParams() {
        this.checkLoaded();
        ArrayList<GenTypeDeclTpar> rlist = new ArrayList<GenTypeDeclTpar>();
        String gensig = JdiUtils.getJdiUtils().genericSignature(this.rclass);
        if (gensig == null) {
            return rlist;
        }
        StringIterator s = new StringIterator(gensig);
        char c = s.next();
        if (c != '<') {
            return rlist;
        }
        while (c != '>') {
            String paramName = JdiReflective.readClassName(s);
            if (s.current() != ':') {
                Debug.message("getTypeParams : no ':' following type parameter name in super signature?? got " + s.current());
                Debug.message("signature was: " + gensig);
                return null;
            }
            if (s.peek() == ':') {
                s.next();
            }
            ArrayList<GenType> bounds = new ArrayList<GenType>(3);
            while (s.current() == ':') {
                bounds.add(JdiReflective.fromSignature(s, null, this.rclass));
                if (s.peek() != ':') continue;
                s.next();
            }
            rlist.add(new GenTypeDeclTpar(paramName, bounds.toArray(new GenTypeSolid[0])));
            c = s.peek();
        }
        return rlist;
    }

    public List getSuperTypesR() {
        this.checkLoaded();
        if (this.rclass instanceof ClassType) {
            LinkedList<JdiReflective> l = new LinkedList<JdiReflective>();
            Iterator<InterfaceType> i = ((ClassType)this.rclass).interfaces().iterator();
            while (i.hasNext()) {
                l.add(new JdiReflective(i.next()));
            }
            if (((ClassType)this.rclass).superclass() != null) {
                l.add(new JdiReflective(((ClassType)this.rclass).superclass()));
            }
            return l;
        }
        if (this.rclass instanceof InterfaceType) {
            LinkedList<JdiReflective> l = new LinkedList<JdiReflective>();
            Iterator<InterfaceType> i = ((InterfaceType)this.rclass).superinterfaces().iterator();
            while (i.hasNext()) {
                l.add(new JdiReflective(i.next()));
            }
            return l;
        }
        return new LinkedList();
    }

    public List getSuperTypes() {
        this.checkLoaded();
        ArrayList<GenTypeClass> rlist = new ArrayList<GenTypeClass>();
        if (JdiUtils.getJdiUtils().genericSignature(this.rclass) == null) {
            if (this.rclass instanceof ClassType) {
                ClassType ctClass = (ClassType)this.rclass;
                JdiReflective r = new JdiReflective(ctClass.superclass());
                rlist.add(new GenTypeClass(r));
                List<InterfaceType> interfaces = ctClass.interfaces();
                Iterator<InterfaceType> i = interfaces.iterator();
                while (i.hasNext()) {
                    r = new JdiReflective(i.next());
                    rlist.add(new GenTypeClass(r));
                }
                return rlist;
            }
            InterfaceType itClass = (InterfaceType)this.rclass;
            List<InterfaceType> interfaces = itClass.superinterfaces();
            Iterator<InterfaceType> i = interfaces.iterator();
            while (i.hasNext()) {
                JdiReflective r = new JdiReflective(i.next());
                rlist.add(new GenTypeClass(r));
            }
            return rlist;
        }
        StringIterator s = new StringIterator(JdiUtils.getJdiUtils().genericSignature(this.rclass));
        if (s.peek() == '<') {
            s.next();
            int lbCount = 1;
            while (lbCount > 0) {
                char c = s.next();
                if (c == '<') {
                    ++lbCount;
                    continue;
                }
                if (c != '>') continue;
                --lbCount;
            }
        }
        while (s.hasNext()) {
            if (s.next() != 'L') {
                Debug.message("getSuperTypes: inherit from non reference type?");
                return rlist;
            }
            String bName = JdiReflective.readClassName(s);
            ReferenceType bType = JdiReflective.findClass(bName, this.rclass.classLoader(), this.rclass.virtualMachine());
            if (bType == null) {
                Debug.message("getSuperTypes: Couldn't find type: " + bName);
            }
            JdiReflective bReflective = new JdiReflective(bType);
            char c = s.current();
            if (c == ';') {
                rlist.add(new GenTypeClass((Reflective)bReflective, (List)null));
                continue;
            }
            if (c != '<') {
                Debug.message("mapGenericParamsToBase: didn't see '<' at end of base-of-super?? (got " + c + ")");
                return rlist;
            }
            ArrayList<GenType> bParams = new ArrayList<GenType>();
            while (c != '>') {
                GenType sParamType = JdiReflective.fromSignature(s, null, this.rclass);
                bParams.add(sParamType);
                c = s.peek();
            }
            s.next();
            s.next();
            rlist.add(new GenTypeClass((Reflective)bReflective, bParams));
        }
        return rlist;
    }

    public boolean isAssignableFrom(Reflective r) {
        if (this.equals(r)) {
            return true;
        }
        if (this.getName().equals("java.lang.Object")) {
            return true;
        }
        if (r instanceof JdiReflective) {
            JdiReflective jr = (JdiReflective)r;
            jr.checkLoaded();
            return JdiReflective.checkAssignability(this.rclass, jr.rclass);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static boolean checkAssignability(ReferenceType a, ReferenceType b) {
        List<InterfaceType> l;
        block12: {
            while (true) {
                if (a instanceof ClassType) {
                    if (b instanceof InterfaceType) {
                        l = ((ClassType)a).allInterfaces();
                        return l.contains(b);
                    }
                    break;
                }
                if (a instanceof InterfaceType) {
                    if (!(b instanceof InterfaceType)) {
                        return false;
                    }
                    break block12;
                }
                if (!(a instanceof ArrayType)) return false;
                if (!(b instanceof ArrayType)) {
                    return false;
                }
                try {
                    Type an = ((ArrayType)a).componentType();
                    Type bn = ((ArrayType)b).componentType();
                    if (!(an instanceof ReferenceType)) return false;
                    if (!(bn instanceof ReferenceType)) return false;
                    a = (ReferenceType)an;
                    b = (ReferenceType)bn;
                }
                catch (ClassNotLoadedException cnle) {
                    return false;
                }
            }
            if (!(b instanceof ClassType)) return false;
            ClassType classType = (ClassType)a;
            while (classType != null) {
                if (((Object)b).equals(classType)) {
                    return true;
                }
                classType = classType.superclass();
            }
            return false;
        }
        l = new LinkedList<InterfaceType>();
        l.addAll(((InterfaceType)a).superinterfaces());
        while (!l.isEmpty()) {
            InterfaceType it = l.get(0);
            if (((Object)a).equals(it)) {
                return true;
            }
            l.addAll(it.superinterfaces());
            l.remove(0);
        }
        return false;
    }

    private static ReferenceType findClass(String name, ClassLoaderReference cl, VirtualMachine vm) {
        ReferenceType ct;
        Iterator<ReferenceType> i;
        if (cl != null) {
            i = cl.visibleClasses().iterator();
            while (i.hasNext()) {
                ct = i.next();
                if (!ct.name().equals(name)) continue;
                return ct;
            }
        }
        i = vm.classesByName(name).iterator();
        while (i.hasNext()) {
            ct = i.next();
            if (!ct.name().equals(name)) continue;
            return ct;
        }
        return null;
    }

    private static String readClassName(StringIterator i) {
        char c = i.next();
        String r = new String();
        while (c != '<' && c != ';' && c != ':') {
            r = c == '/' ? r + '.' : r + c;
            c = i.next();
        }
        return r;
    }

    private static GenType fromSignature(StringIterator i, Map tparams, ReferenceType parent) {
        char c = i.next();
        if (c == '*') {
            return new GenTypeUnbounded();
        }
        if (c == '+') {
            GenTypeSolid t = (GenTypeSolid)JdiReflective.fromSignature(i, null, parent);
            if (tparams != null) {
                return new GenTypeExtends(t).mapTparsToTypes(tparams);
            }
            return new GenTypeExtends(t);
        }
        if (c == '-') {
            GenTypeSolid t = (GenTypeSolid)JdiReflective.fromSignature(i, null, parent);
            if (tparams != null) {
                return new GenTypeSuper(t).mapTparsToTypes(tparams);
            }
            return new GenTypeSuper(t);
        }
        if (c == '[') {
            GenType t = JdiReflective.fromSignature(i, tparams, parent);
            t = new GenArray(t);
            return t;
        }
        if (c == 'T') {
            String tname = JdiReflective.readClassName(i);
            if (tparams != null && tparams.get(tname) != null) {
                return (GenType)tparams.get(tname);
            }
            return new GenTypeTpar(tname);
        }
        if (c == 'I') {
            return GenTypePrimitive.getInt();
        }
        if (c == 'C') {
            return GenTypePrimitive.getChar();
        }
        if (c == 'Z') {
            return GenTypePrimitive.getBoolean();
        }
        if (c == 'B') {
            return GenTypePrimitive.getByte();
        }
        if (c == 'S') {
            return GenTypePrimitive.getShort();
        }
        if (c == 'J') {
            return GenTypePrimitive.getLong();
        }
        if (c == 'F') {
            return GenTypePrimitive.getFloat();
        }
        if (c == 'D') {
            return GenTypePrimitive.getDouble();
        }
        if (c != 'L') {
            Debug.message("Generic signature begins without 'L'?? (got " + c + ")");
        }
        String basename = JdiReflective.readClassName(i);
        JdiReflective reflective = new JdiReflective(basename, parent);
        c = i.current();
        if (c == ';') {
            return new GenTypeClass((Reflective)reflective, (List)null);
        }
        ArrayList<GenType> params = new ArrayList<GenType>();
        if (c != '<') {
            Debug.message("Generic signature: expected '<', got '" + c + "' ??");
            return null;
        }
        do {
            GenType ptype;
            if ((ptype = JdiReflective.fromSignature(i, tparams, parent)) == null) {
                return null;
            }
            params.add(ptype);
        } while (i.peek() != '>');
        i.next();
        i.next();
        return new GenTypeClass((Reflective)reflective, params);
    }

    private static GenType getNonGenericType(String typeName, Type t, ClassLoaderReference clr, VirtualMachine vm) {
        JdiReflective ref;
        if (t instanceof BooleanType) {
            return GenTypePrimitive.getBoolean();
        }
        if (t instanceof ByteType) {
            return GenTypePrimitive.getByte();
        }
        if (t instanceof CharType) {
            return GenTypePrimitive.getChar();
        }
        if (t instanceof DoubleType) {
            return GenTypePrimitive.getDouble();
        }
        if (t instanceof FloatType) {
            return GenTypePrimitive.getFloat();
        }
        if (t instanceof IntegerType) {
            return GenTypePrimitive.getInt();
        }
        if (t instanceof LongType) {
            return GenTypePrimitive.getLong();
        }
        if (t instanceof ShortType) {
            return GenTypePrimitive.getShort();
        }
        if (t == null) {
            ref = new JdiReflective(typeName, clr, vm);
        } else {
            ReferenceType rt = JdiReflective.findClass(t.name(), clr, vm);
            ref = new JdiReflective(rt);
        }
        return new GenTypeClass((Reflective)ref, (List)null);
    }

    public static GenType fromField(Field f, JdiObject parent) {
        Type t;
        block4: {
            t = null;
            Value v = parent.obj.getValue(f);
            try {
                t = f.type();
            }
            catch (ClassNotLoadedException cnle) {
                t = JdiReflective.findClass(f.typeName(), parent.obj.referenceType().classLoader(), parent.obj.virtualMachine());
                if (t != null || v == null) break block4;
                t = v.type();
            }
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(f);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(f.typeName(), t, parent.obj.referenceType().classLoader(), parent.obj.virtualMachine());
        }
        Map tparams = parent.getGenericParams();
        JdiReflective r = new JdiReflective(parent.obj.referenceType());
        if (tparams == null) {
            tparams = new HashMap();
        }
        GenTypeClass.addDefaultParamBases(tparams, r);
        GenTypeClass genType = new GenTypeClass((Reflective)r, tparams);
        tparams = genType.mapToSuper(f.declaringType().name());
        StringIterator iterator = new StringIterator(gensig);
        return JdiReflective.fromSignature(iterator, tparams, parent.obj.referenceType());
    }

    public static GenType fromField(Field f, ReferenceType parent) {
        Type t;
        block3: {
            t = null;
            Value v = parent.getValue(f);
            try {
                t = f.type();
            }
            catch (ClassNotLoadedException cnle) {
                t = JdiReflective.findClass(f.typeName(), parent.classLoader(), parent.virtualMachine());
                if (t != null || v == null) break block3;
                t = v.type();
            }
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(f);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(f.typeName(), t, parent.classLoader(), parent.virtualMachine());
        }
        StringIterator iterator = new StringIterator(gensig);
        return JdiReflective.fromSignature(iterator, null, parent);
    }

    public static GenType fromLocalVar(StackFrame sf, LocalVariable var) {
        ReferenceType declType;
        Type t;
        block3: {
            t = null;
            Value v = sf.getValue(var);
            Location l = sf.location();
            declType = l.declaringType();
            try {
                t = var.type();
            }
            catch (ClassNotLoadedException cnle) {
                t = JdiReflective.findClass(var.typeName(), declType.classLoader(), declType.virtualMachine());
                if (t != null || v == null) break block3;
                t = v.type();
            }
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(var);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(var.typeName(), t, declType.classLoader(), declType.virtualMachine());
        }
        StringIterator iterator = new StringIterator(gensig);
        HashMap tparams = new HashMap();
        GenTypeClass.addDefaultParamBases(tparams, new JdiReflective(declType));
        return JdiReflective.fromSignature(iterator, tparams, declType);
    }

    static class StringIterator {
        int i = 0;
        String s;

        public StringIterator(String s) {
            this.s = s;
            if (s == null) {
                Debug.message("StringIterator with null string??");
            }
        }

        public char current() {
            return this.s.charAt(this.i - 1);
        }

        public char next() {
            return this.s.charAt(this.i++);
        }

        public char peek() {
            return this.s.charAt(this.i);
        }

        public boolean hasNext() {
            return this.i < this.s.length();
        }
    }
}

