/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.debugger.jdi.JdiReflective;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;

public class JdiArrayReflective
extends JdiReflective {
    private GenType componentType;

    public JdiArrayReflective(GenType t, ReferenceType srctype) {
        super(null, srctype);
        this.componentType = t;
    }

    public JdiArrayReflective(GenType t, ClassLoaderReference classLoader, VirtualMachine vm) {
        super(null, classLoader, vm);
    }

    public String getName() {
        this.checkLoaded();
        return super.getName();
    }

    protected void checkLoaded() {
        this.name = "[" + this.componentName();
        super.checkLoaded();
    }

    private String componentName() {
        if (this.componentType.typeIs(GenType.GT_BOOLEAN)) {
            return "Z";
        }
        if (this.componentType.typeIs(GenType.GT_BYTE)) {
            return "B";
        }
        if (this.componentType.typeIs(GenType.GT_CHAR)) {
            return "C";
        }
        if (this.componentType.typeIs(GenType.GT_DOUBLE)) {
            return "D";
        }
        if (this.componentType.typeIs(GenType.GT_FLOAT)) {
            return "F";
        }
        if (this.componentType.typeIs(GenType.GT_INT)) {
            return "I";
        }
        if (this.componentType.typeIs(GenType.GT_LONG)) {
            return "J";
        }
        if (this.componentType.typeIs(GenType.GT_SHORT)) {
            return "S";
        }
        if (this.componentType instanceof GenTypeArray) {
            Reflective r = ((GenTypeArray)this.componentType).getReflective();
            return r.getName();
        }
        GenTypeClass gtc = (GenTypeClass)this.componentType;
        return "L" + gtc.rawName() + ";";
    }
}

