/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.NameTransform;
import bluej.utility.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class GenTypeWildcard
extends GenTypeParameterizable {
    protected static final GenTypeSolid[] noBounds = new GenTypeSolid[0];
    GenTypeSolid[] upperBounds;
    GenTypeSolid[] lowerBounds;

    public GenTypeWildcard(GenTypeSolid upper, GenTypeSolid lower) {
        this.upperBounds = upper != null ? new GenTypeSolid[]{upper} : noBounds;
        this.lowerBounds = lower != null ? new GenTypeSolid[]{lower} : noBounds;
    }

    public GenTypeWildcard(GenTypeSolid[] uppers, GenTypeSolid[] lowers) {
        this.upperBounds = uppers;
        this.lowerBounds = lowers;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean stripPrefix) {
        if (this.lowerBounds.length != 0) {
            return "? super " + this.lowerBounds[0].toString(stripPrefix);
        }
        if (this.upperBounds.length != 0) {
            if (this.upperBounds[0] instanceof GenTypeClass && ((GenTypeClass)this.upperBounds[0]).rawName().equals("java.lang.Object")) {
                return "?";
            }
            return "? extends " + this.upperBounds[0].toString(stripPrefix);
        }
        return "?";
    }

    public String toString(NameTransform nt) {
        if (this.lowerBounds.length != 0) {
            return "? super " + this.lowerBounds[0].toString(nt);
        }
        if (this.upperBounds.length != 0) {
            if (this.upperBounds[0] instanceof GenTypeClass && ((GenTypeClass)this.upperBounds[0]).rawName().equals("java.lang.Object")) {
                return "?";
            }
            return "? extends " + this.upperBounds[0].toString(nt);
        }
        return "?";
    }

    public GenTypeParameterizable precisify(GenTypeParameterizable other) {
        ArrayList<GenTypeParameterizable> lbounds = new ArrayList<GenTypeParameterizable>(this.lowerBounds.length);
        lbounds.addAll(Arrays.asList(this.lowerBounds));
        ArrayList<GenTypeParameterizable> ubounds = new ArrayList<GenTypeParameterizable>(this.upperBounds.length);
        ubounds.addAll(Arrays.asList(this.upperBounds));
        if (other instanceof GenTypeWildcard) {
            GenTypeParameterizable precis;
            int j;
            int i;
            GenTypeWildcard otherwc = (GenTypeWildcard)other;
            for (i = 0; i < otherwc.lowerBounds.length; ++i) {
                for (j = 0; j < this.lowerBounds.length; ++j) {
                    precis = otherwc.lowerBounds[i].precisify((GenTypeParameterizable)lbounds.get(j));
                    if (precis == null) continue;
                    lbounds.set(j, precis);
                    break;
                }
                if (j != this.lowerBounds.length) continue;
                lbounds.add(otherwc.lowerBounds[i]);
            }
            for (i = 0; i < otherwc.upperBounds.length; ++i) {
                for (j = 0; j < this.upperBounds.length; ++j) {
                    precis = otherwc.upperBounds[i].precisify((GenTypeParameterizable)ubounds.get(j));
                    if (precis == null) continue;
                    ubounds.set(j, precis);
                    break;
                }
                if (j != this.upperBounds.length) continue;
                ubounds.add(otherwc.lowerBounds[i]);
            }
            Iterator i2 = ubounds.iterator();
            while (i2.hasNext()) {
                Iterator j2 = lbounds.iterator();
                while (j2.hasNext()) {
                    GenTypeParameterizable lbound;
                    GenTypeParameterizable ubound = (GenTypeParameterizable)i2.next();
                    if (!ubound.equals(lbound = (GenTypeParameterizable)j2.next())) continue;
                    return ubound;
                }
            }
            return new GenTypeWildcard(ubounds.toArray(noBounds), lbounds.toArray(noBounds));
        }
        if (other instanceof GenTypeClass) {
            Map m;
            GenTypeClass bound;
            int i;
            GenTypeClass otherClass = (GenTypeClass)other;
            for (i = 0; i < this.upperBounds.length; ++i) {
                if (!(this.upperBounds[i] instanceof GenTypeClass)) continue;
                bound = (GenTypeClass)this.upperBounds[i];
                m = bound.mapToDerived(bound.getReflective());
                otherClass = (GenTypeClass)new GenTypeClass(bound.getReflective(), m).precisify(otherClass);
                if (otherClass != null) continue;
                return null;
            }
            for (i = 0; i < this.lowerBounds.length; ++i) {
                if (!(this.lowerBounds[i] instanceof GenTypeClass)) continue;
                bound = (GenTypeClass)this.lowerBounds[i];
                m = bound.mapToSuper(otherClass.getReflective().getName());
                otherClass = (GenTypeClass)new GenTypeClass(bound.getReflective(), m).precisify(otherClass);
                if (otherClass != null) continue;
                return null;
            }
            return otherClass;
        }
        return null;
    }

    public GenType mapTparsToTypes(Map tparams) {
        int j;
        GenTypeWildcard newWcBound;
        GenTypeParameterizable newBound;
        int i;
        ArrayList<GenTypeParameterizable> newUpper = new ArrayList<GenTypeParameterizable>();
        ArrayList<GenTypeSolid> newLower = new ArrayList<GenTypeSolid>();
        for (i = 0; i < this.upperBounds.length; ++i) {
            newBound = (GenTypeParameterizable)this.upperBounds[i].mapTparsToTypes(tparams);
            if (newBound instanceof GenTypeWildcard) {
                newWcBound = (GenTypeWildcard)newBound;
                for (j = 0; j < newWcBound.upperBounds.length; ++j) {
                    newUpper.add(newWcBound.upperBounds[j]);
                }
                continue;
            }
            newUpper.add(newBound);
        }
        for (i = 0; i < this.lowerBounds.length; ++i) {
            newBound = (GenTypeParameterizable)this.lowerBounds[i].mapTparsToTypes(tparams);
            if (!(newBound instanceof GenTypeWildcard)) continue;
            newWcBound = (GenTypeWildcard)newBound;
            for (j = 0; j < newWcBound.lowerBounds.length; ++j) {
                newLower.add(newWcBound.lowerBounds[j]);
            }
        }
        return this.optimize(newUpper, newLower);
    }

    private GenTypeParameterizable optimize(ArrayList ubounds, ArrayList lbounds) {
        GenTypeClass mapped;
        Map m;
        GenTypeClass bClass;
        GenTypeClass aClass;
        GenTypeSolid b;
        GenTypeSolid a;
        int j;
        int i;
        for (i = 0; i < ubounds.size() - 1; ++i) {
            for (j = i + 1; j < ubounds.size(); ++j) {
                a = (GenTypeSolid)ubounds.get(i);
                if (a.isAssignableFromRaw(b = (GenTypeSolid)ubounds.get(j))) {
                    if (a instanceof GenTypeClass && b instanceof GenTypeClass) {
                        aClass = (GenTypeClass)a;
                        bClass = (GenTypeClass)b;
                        m = aClass.mapToDerived(bClass.getReflective());
                        mapped = new GenTypeClass(bClass.getReflective(), m);
                        mapped = (GenTypeClass)mapped.precisify(bClass);
                        ubounds.set(i, mapped);
                    } else {
                        ubounds.set(i, b);
                    }
                    ubounds.remove(j);
                    --j;
                    continue;
                }
                if (!b.isAssignableFromRaw(a)) continue;
                if (a instanceof GenTypeClass && b instanceof GenTypeClass) {
                    aClass = (GenTypeClass)a;
                    bClass = (GenTypeClass)b;
                    m = bClass.mapToDerived(aClass.getReflective());
                    mapped = new GenTypeClass(aClass.getReflective(), m);
                    mapped = (GenTypeClass)mapped.precisify(aClass);
                    ubounds.set(i, mapped);
                }
                ubounds.remove(j);
                --j;
            }
        }
        for (i = 0; i < lbounds.size() - 1; ++i) {
            for (j = i + 1; j < ubounds.size(); ++j) {
                a = (GenTypeSolid)lbounds.get(i);
                if (a.isAssignableFromRaw(b = (GenTypeSolid)lbounds.get(j))) {
                    if (a instanceof GenTypeClass && b instanceof GenTypeClass) {
                        aClass = (GenTypeClass)a;
                        bClass = (GenTypeClass)b;
                        m = bClass.mapToSuper(aClass.rawName());
                        mapped = new GenTypeClass(aClass.getReflective(), m);
                        mapped = (GenTypeClass)mapped.precisify(aClass);
                        lbounds.set(i, mapped);
                    }
                    lbounds.remove(j);
                    --j;
                    continue;
                }
                if (!b.isAssignableFrom(a)) continue;
                if (a instanceof GenTypeClass && b instanceof GenTypeClass) {
                    aClass = (GenTypeClass)a;
                    bClass = (GenTypeClass)b;
                    m = aClass.mapToSuper(bClass.rawName());
                    mapped = new GenTypeClass(bClass.getReflective(), m);
                    mapped = (GenTypeClass)mapped.precisify(bClass);
                    lbounds.set(i, mapped);
                } else {
                    lbounds.set(i, b);
                }
                lbounds.remove(j);
                --j;
            }
        }
        for (i = 0; i < ubounds.size(); ++i) {
            for (j = 0; j < lbounds.size(); ++j) {
                GenTypeSolid l;
                GenTypeSolid u = (GenTypeSolid)ubounds.get(i);
                if (u.equals(l = (GenTypeSolid)lbounds.get(j))) {
                    return u;
                }
                if (!(u instanceof GenTypeClass) || !(l instanceof GenTypeClass)) continue;
                GenTypeClass uClass = (GenTypeClass)u;
                GenTypeClass lClass = (GenTypeClass)l;
                if (!uClass.rawName().equals(lClass.rawName())) continue;
                return uClass.precisify(lClass);
            }
        }
        GenTypeSolid[] uboundsA = ubounds.toArray(noBounds);
        GenTypeSolid[] lboundsA = lbounds.toArray(noBounds);
        return new GenTypeWildcard(uboundsA, lboundsA);
    }

    public boolean equals(GenTypeParameterizable other) {
        GenTypeParameterizable x;
        ListIterator j;
        boolean matched;
        int i;
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenTypeWildcard)) {
            return false;
        }
        GenTypeWildcard bOther = (GenTypeWildcard)other;
        if (bOther.lowerBounds.length != this.lowerBounds.length || bOther.upperBounds.length != this.upperBounds.length) {
            return false;
        }
        LinkedList<GenTypeSolid> oLowerBounds = new LinkedList<GenTypeSolid>(Arrays.asList(bOther.lowerBounds));
        LinkedList<GenTypeSolid> oUpperBounds = new LinkedList<GenTypeSolid>(Arrays.asList(bOther.upperBounds));
        for (i = 0; i < this.lowerBounds.length; ++i) {
            matched = false;
            j = oLowerBounds.listIterator();
            while (j.hasNext()) {
                x = (GenTypeParameterizable)j.next();
                if (!x.equals(this.lowerBounds[i])) continue;
                matched = true;
                j.remove();
                break;
            }
            if (matched) continue;
            return false;
        }
        for (i = 0; i < this.upperBounds.length; ++i) {
            matched = false;
            j = oUpperBounds.listIterator();
            while (j.hasNext()) {
                x = (GenTypeParameterizable)j.next();
                if (!x.equals(this.upperBounds[i])) continue;
                matched = true;
                j.remove();
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    protected void getParamsFromTemplate(Map map, GenTypeParameterizable template) {
        Debug.reportError("getParamsFromTemplate called on GenTypeWildcard.");
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isAssignableFrom(GenType t) {
        return false;
    }

    public boolean isAssignableFromRaw(GenType t) {
        return false;
    }

    public GenTypeSolid[] getUpperBounds() {
        GenTypeSolid[] r = new GenTypeSolid[this.upperBounds.length];
        System.arraycopy(this.upperBounds, 0, r, 0, r.length);
        return r;
    }

    public GenTypeSolid[] getLowerBounds() {
        GenTypeSolid[] r = new GenTypeSolid[this.lowerBounds.length];
        System.arraycopy(this.lowerBounds, 0, r, 0, r.length);
        return r;
    }
}

