/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenType;
import java.util.Map;

public class GenTypePrimitive
extends GenType {
    private static GenTypePrimitive[] primitiveTypes = new GenTypePrimitive[GenType.GT_MAX + 1];
    private static String[] typeNames = new String[]{"void", "java.lang.Object", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static int[][] assignableFrom = new int[GT_MAX + 1][];
    private int myIndex;

    protected GenTypePrimitive(int index) {
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_VOID] = new int[0];
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_NULL] = new int[0];
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_BOOLEAN] = new int[]{GT_BOOLEAN};
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_CHAR] = new int[]{GT_CHAR};
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_BYTE] = new int[]{GT_BYTE};
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_SHORT] = new int[]{GT_SHORT, GT_BYTE};
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_INT] = new int[]{GT_INT, GT_BYTE, GT_SHORT, GT_CHAR};
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_LONG] = new int[]{GT_LONG, GT_BYTE, GT_SHORT, GT_CHAR, GT_INT};
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_FLOAT] = new int[]{GT_FLOAT, GT_LONG, GT_BYTE, GT_SHORT, GT_CHAR, GT_INT, GT_LONG};
        GenTypePrimitive.assignableFrom[GenTypePrimitive.GT_DOUBLE] = new int[]{GT_DOUBLE, GT_LONG, GT_BYTE, GT_SHORT, GT_CHAR, GT_INT, GT_LONG, GT_FLOAT};
        this.myIndex = index;
    }

    private static GenTypePrimitive getType(int v) {
        if (primitiveTypes[v] == null) {
            GenTypePrimitive.primitiveTypes[v] = new GenTypePrimitive(v);
        }
        return primitiveTypes[v];
    }

    public static GenTypePrimitive getVoid() {
        return GenTypePrimitive.getType(GT_VOID);
    }

    public static GenTypePrimitive getNull() {
        return GenTypePrimitive.getType(GT_NULL);
    }

    public static GenTypePrimitive getBoolean() {
        return GenTypePrimitive.getType(GT_BOOLEAN);
    }

    public static GenTypePrimitive getByte() {
        return GenTypePrimitive.getType(GT_BYTE);
    }

    public static GenTypePrimitive getChar() {
        return GenTypePrimitive.getType(GT_CHAR);
    }

    public static GenTypePrimitive getShort() {
        return GenTypePrimitive.getType(GT_SHORT);
    }

    public static GenTypePrimitive getInt() {
        return GenTypePrimitive.getType(GT_INT);
    }

    public static GenTypePrimitive getLong() {
        return GenTypePrimitive.getType(GT_LONG);
    }

    public static GenTypePrimitive getFloat() {
        return GenTypePrimitive.getType(GT_FLOAT);
    }

    public static GenTypePrimitive getDouble() {
        return GenTypePrimitive.getType(GT_DOUBLE);
    }

    public String toString() {
        return typeNames[this.myIndex];
    }

    public boolean isAssignableFrom(GenType o) {
        int[] assignables = assignableFrom[this.myIndex];
        for (int i = 0; i < assignables.length; ++i) {
            if (!o.typeIs(assignables[i])) continue;
            return true;
        }
        return false;
    }

    public boolean couldHold(int n) {
        if (this.myIndex >= GT_INT) {
            return true;
        }
        if (this.myIndex == GT_BYTE) {
            return n >= -128 && n <= 127;
        }
        if (this.myIndex == GT_CHAR) {
            return n >= 0 && n <= 65535;
        }
        if (this.myIndex == GT_SHORT) {
            return n >= Short.MIN_VALUE && n <= Short.MAX_VALUE;
        }
        return false;
    }

    public boolean fitsType(int gtype) {
        if (this.myIndex == GT_CHAR) {
            return gtype != GT_BYTE && gtype != GT_SHORT;
        }
        return gtype >= this.myIndex;
    }

    public boolean isAssignableFromRaw(GenType t) {
        return this.isAssignableFrom(t);
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isNumeric() {
        return this.myIndex >= GT_LOWEST_NUMERIC;
    }

    public boolean isIntegralType() {
        return this.myIndex >= GT_CHAR && this.myIndex <= GT_LONG;
    }

    public boolean typeIs(int v) {
        return this.myIndex == v;
    }

    public GenType mapTparsToTypes(Map tparams) {
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof GenType) {
            GenType gto = (GenType)other;
            return gto.typeIs(this.myIndex);
        }
        return false;
    }

    protected final int getMyIndex() {
        return this.myIndex;
    }

    public GenType opBNot() {
        if (this.myIndex >= GT_CHAR && this.myIndex <= GT_LONG) {
            return this;
        }
        return null;
    }
}

