/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.BadInheritanceChainException;
import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaNames;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class GenTypeClass
extends GenTypeSolid {
    protected List params = null;
    protected Reflective reflective = null;

    public GenTypeClass(Reflective r) {
        this.reflective = r;
    }

    public GenTypeClass(Reflective r, List params) {
        this.reflective = r;
        if (params != null && !params.isEmpty()) {
            this.params = params;
        }
    }

    public GenTypeClass(Reflective r, Map mparams) {
        this.reflective = r;
        if (mparams == null) {
            return;
        }
        this.params = new ArrayList();
        Iterator declParmsI = r.getTypeParams().iterator();
        while (declParmsI.hasNext()) {
            GenTypeDeclTpar next = (GenTypeDeclTpar)declParmsI.next();
            if (mparams.get(next.getTparName()) == null) {
                this.params.add(new GenTypeExtends(next.getBound()));
                continue;
            }
            this.params.add(mparams.get(next.getTparName()));
        }
        if (this.params.isEmpty()) {
            this.params = null;
        }
    }

    public GenTypeClass asClass() {
        return this;
    }

    public String rawName() {
        return this.reflective.getName();
    }

    public String getParamString() {
        if (this.params == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        Iterator i = this.params.iterator();
        while (i.hasNext()) {
            GenType next = (GenType)i.next();
            sb.append(next.toString());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(">");
        return sb.toString();
    }

    public boolean isGeneric() {
        return this.params != null;
    }

    public boolean isRaw() {
        return this.getMap() == null;
    }

    public boolean isInterface() {
        return this.reflective.isInterface();
    }

    public String toString(boolean stripPrefix) {
        String baseClass = this.rawName();
        if (stripPrefix) {
            baseClass = JavaNames.stripPrefix(baseClass);
        }
        if (this.params == null) {
            return baseClass;
        }
        String r = baseClass + '<';
        Iterator i = this.params.iterator();
        while (i.hasNext()) {
            r = r + ((GenTypeParameterizable)i.next()).toString(stripPrefix);
            if (!i.hasNext()) continue;
            r = r + ',';
        }
        r = r + '>';
        return r;
    }

    public String toString(NameTransform nt) {
        String baseClass = nt.transform(this.rawName());
        if (this.params == null) {
            return baseClass;
        }
        String r = baseClass + '<';
        Iterator i = this.params.iterator();
        while (i.hasNext()) {
            r = r + ((GenTypeParameterizable)i.next()).toString(nt);
            if (!i.hasNext()) continue;
            r = r + ',';
        }
        r = r + '>';
        return r;
    }

    public boolean equals(GenTypeParameterizable other) {
        if (other == this) {
            return true;
        }
        if (other.getClass() != GenTypeClass.class) {
            return false;
        }
        GenTypeClass oClass = (GenTypeClass)other;
        if (!this.rawName().equals(oClass.rawName())) {
            return false;
        }
        if (this.params == null && oClass.params == null) {
            return true;
        }
        if (this.params == null && oClass.params != null) {
            return false;
        }
        if (this.params != null && oClass.params == null) {
            return false;
        }
        Iterator i = this.params.iterator();
        Iterator j = oClass.params.iterator();
        while (i.hasNext()) {
            GenTypeParameterizable jNext;
            if (!j.hasNext()) {
                return false;
            }
            GenTypeParameterizable iNext = (GenTypeParameterizable)i.next();
            if (iNext.equals(jNext = (GenTypeParameterizable)j.next())) continue;
            return false;
        }
        return !j.hasNext();
    }

    public Reflective getReflective() {
        return this.reflective;
    }

    public boolean isAssignableFrom(GenType t) {
        if (!(t instanceof GenTypeClass)) {
            return false;
        }
        GenTypeClass c = (GenTypeClass)t;
        Reflective r = c.reflective;
        if (GenTypeClass.getInheritanceChain(r, this.reflective.getName()) != null) {
            if (this.isRaw() || c.isRaw()) {
                return true;
            }
            Map m = c.mapToSuper(this.reflective.getName());
            GenTypeClass other = new GenTypeClass(this.reflective, m);
            GenTypeClass precise = (GenTypeClass)this.precisify(other);
            if (precise == null) {
                return false;
            }
            if (other.equals(precise)) {
                return true;
            }
        }
        return false;
    }

    public boolean isAssignableFromRaw(GenType t) {
        if (!(t instanceof GenTypeClass)) {
            return false;
        }
        GenTypeClass c = (GenTypeClass)t;
        Reflective r = c.reflective;
        return GenTypeClass.getInheritanceChain(r, this.reflective.getName()) != null;
    }

    public Map mapToSuper(String basename) {
        String bname;
        Map tparams = this.getMap();
        if (tparams == null) {
            return null;
        }
        if (this.rawName().equals(basename)) {
            return tparams;
        }
        Stack inheritanceStack = GenTypeClass.getInheritanceChain(this.reflective, basename);
        if (inheritanceStack == null) {
            throw new BadInheritanceChainException();
        }
        Iterator i = inheritanceStack.iterator();
        i.next();
        Reflective subType = this.reflective;
        do {
            Reflective baseType = (Reflective)i.next();
            bname = baseType.getName();
            tparams = GenTypeClass.mapGenericParamsToDirectBase(tparams, subType, baseType);
            subType = baseType;
        } while (tparams != null && !bname.equals(basename));
        return tparams;
    }

    private static Map mapGenericParamsToDirectBase(Map tparams, Reflective subType, Reflective baseType) {
        GenTypeClass baseClass = subType.superTypeByName(baseType.getName());
        if (baseClass.isRaw()) {
            return null;
        }
        baseClass = (GenTypeClass)baseClass.mapTparsToTypes(tparams);
        tparams.clear();
        tparams.putAll(baseClass.getMap());
        return tparams;
    }

    public GenType mapTparsToTypes(Map tparams) {
        if (this.params == null) {
            return this;
        }
        Iterator i = this.params.iterator();
        ArrayList<GenType> retlist = new ArrayList<GenType>();
        while (i.hasNext()) {
            retlist.add(((GenTypeParameterizable)i.next()).mapTparsToTypes(tparams));
        }
        return new GenTypeClass(this.reflective, retlist);
    }

    public Map mapToDerived(Reflective derivedType) {
        if (derivedType.getTypeParams().isEmpty() || !this.isGeneric()) {
            return new HashMap();
        }
        HashMap r = this.getMap();
        if (r == null) {
            r = new HashMap();
        }
        LinkedList<String> l = new LinkedList<String>();
        Iterator i = this.reflective.getTypeParams().iterator();
        while (i.hasNext()) {
            String paramName = ((GenTypeTpar)i.next()).getTparName();
            l.add(paramName);
        }
        if (derivedType.getName().equals(this.rawName())) {
            return r;
        }
        Stack classes = GenTypeClass.getInheritanceChain(derivedType, this.rawName());
        if (classes == null) {
            return null;
        }
        Reflective curBase = (Reflective)classes.pop();
        while (!classes.empty()) {
            Reflective curSubtype = (Reflective)classes.pop();
            HashMap newMap = new HashMap();
            LinkedList<String> newList = new LinkedList<String>();
            Iterator i2 = curSubtype.getTypeParams().iterator();
            while (i2.hasNext()) {
                String paramName = ((GenTypeTpar)i2.next()).getTparName();
                newList.add(paramName);
            }
            GenTypeClass baseDecl = curSubtype.superTypeByName(curBase.getName());
            if (baseDecl.params == null) {
                return new HashMap();
            }
            Iterator i3 = l.iterator();
            Iterator baseDeclI = baseDecl.params.iterator();
            while (i3.hasNext()) {
                GenTypeParameterizable argType = (GenTypeParameterizable)baseDeclI.next();
                GenTypeParameterizable srcType = (GenTypeParameterizable)r.get(i3.next());
                if (srcType == null) continue;
                argType.getParamsFromTemplate(newMap, srcType);
            }
            r = newMap;
            l = newList;
            curBase = curSubtype;
        }
        return r;
    }

    public Map getMap() {
        List formalParams = this.reflective.getTypeParams();
        if (this.params == null && !formalParams.isEmpty()) {
            return null;
        }
        HashMap<String, GenType> r = new HashMap<String, GenType>();
        if (this.params == null) {
            return r;
        }
        Iterator paramIterator = this.params.iterator();
        Iterator formalIterator = formalParams.iterator();
        while (paramIterator.hasNext()) {
            GenType paramType = (GenType)paramIterator.next();
            GenTypeDeclTpar formalType = (GenTypeDeclTpar)formalIterator.next();
            String paramName = formalType.getTparName();
            r.put(paramName, paramType);
        }
        return r;
    }

    private static Stack getInheritanceChain(Reflective top, String bottom) {
        Stack<Reflective> r = new Stack<Reflective>();
        r.push(top);
        if (top.getName().equals(bottom)) {
            return r;
        }
        List l = top.getSuperTypesR();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Reflective next = (Reflective)i.next();
            Stack r2 = GenTypeClass.getInheritanceChain(next, bottom);
            if (r2 == null) continue;
            r.addAll(r2);
            return r;
        }
        return null;
    }

    public void getParamsFromTemplate(Map r, GenTypeParameterizable template) {
        block5: {
            block4: {
                if (!(template instanceof GenTypeClass)) break block4;
                GenTypeClass classTemplate = (GenTypeClass)template;
                if (!classTemplate.rawName().equals(this.rawName())) break block5;
                Iterator i = this.params.iterator();
                Iterator j = classTemplate.params.iterator();
                while (i.hasNext() && j.hasNext()) {
                    GenTypeParameterizable ip = (GenTypeParameterizable)i.next();
                    GenTypeParameterizable jp = (GenTypeParameterizable)j.next();
                    ip.getParamsFromTemplate(r, jp);
                }
                break block5;
            }
            if (template instanceof GenTypeWildcard) {
                Map m;
                int i;
                GenTypeWildcard wildcardTemplate = (GenTypeWildcard)template;
                GenTypeSolid[] ubounds = wildcardTemplate.getUpperBounds();
                GenTypeSolid[] lbounds = wildcardTemplate.getLowerBounds();
                for (i = 0; i < ubounds.length; ++i) {
                    if (!(ubounds[i] instanceof GenTypeClass)) continue;
                    GenTypeClass uboundClass = (GenTypeClass)ubounds[i];
                    m = uboundClass.mapToDerived(this.reflective);
                    this.getParamsFromTemplate(r, new GenTypeClass(this.reflective, m));
                }
                for (i = 0; i < lbounds.length; ++i) {
                    if (!(lbounds[i] instanceof GenTypeClass)) continue;
                    GenTypeClass lboundClass = (GenTypeClass)lbounds[i];
                    m = lboundClass.mapToSuper(this.reflective.getName());
                    this.getParamsFromTemplate(r, new GenTypeClass(this.reflective, m));
                }
            }
        }
    }

    public GenTypeParameterizable precisify(GenTypeParameterizable other) {
        if (!(other instanceof GenTypeClass)) {
            return other.precisify(this);
        }
        if (this.params == null) {
            return other;
        }
        LinkedList<GenTypeParameterizable> l = new LinkedList<GenTypeParameterizable>();
        Iterator i = this.params.iterator();
        Iterator j = ((GenTypeClass)other).params.iterator();
        while (i.hasNext()) {
            l.add(((GenTypeParameterizable)i.next()).precisify((GenTypeParameterizable)j.next()));
        }
        return new GenTypeClass(this.reflective, l);
    }

    public static void addDefaultParamBases(Map tparams, Reflective declaringType) {
        Iterator i = declaringType.getTypeParams().iterator();
        while (i.hasNext()) {
            GenTypeDeclTpar tpar = (GenTypeDeclTpar)i.next();
            String paramName = tpar.getTparName();
            GenTypeSolid bound = tpar.getBound();
            GenTypeExtends type = new GenTypeExtends(bound);
            if (tparams.containsKey(paramName)) continue;
            tparams.put(paramName, type);
        }
    }

    public GenTypeClass[] getUpperBoundsC() {
        return new GenTypeClass[]{this};
    }

    public GenTypeSolid[] getLowerBounds() {
        return new GenTypeSolid[]{this};
    }
}

