/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.NameTransform;
import java.util.Map;

public class GenArray
extends GenTypeParameterizable {
    private GenType componentType;

    public GenArray(GenType componentType) {
        this.componentType = componentType;
    }

    public GenType getArrayComponent() {
        return this.componentType;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean stripPrefix) {
        return this.componentType.toString(stripPrefix) + "[]";
    }

    public String toString(NameTransform nt) {
        return this.componentType.toString(nt) + "[]";
    }

    public GenType mapTparsToTypes(Map tparams) {
        GenType mappedComponent = this.componentType.mapTparsToTypes(tparams);
        if (mappedComponent == this.componentType) {
            return this;
        }
        return new GenArray(mappedComponent);
    }

    public boolean equals(GenTypeParameterizable other) {
        if (this == other) {
            return true;
        }
        GenType otherComponent = other.getArrayComponent();
        if (otherComponent != null) {
            return this.componentType.equals(otherComponent);
        }
        return false;
    }

    protected void getParamsFromTemplate(Map map, GenTypeParameterizable template) {
        GenType otherComponent = template.getArrayComponent();
        if (this.componentType instanceof GenTypeParameterizable) {
            GenTypeParameterizable pcomponentType = (GenTypeParameterizable)this.componentType;
            if (otherComponent instanceof GenTypeParameterizable) {
                pcomponentType.getParamsFromTemplate(map, (GenTypeParameterizable)otherComponent);
            }
        }
    }

    public GenTypeParameterizable precisify(GenTypeParameterizable other) {
        return this;
    }

    public GenTypeSolid[] getUpperBounds() {
        return new GenTypeSolid[0];
    }

    public GenTypeSolid[] getLowerBounds() {
        return new GenTypeSolid[0];
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isAssignableFrom(GenType t) {
        if (t instanceof GenTypeArray) {
            return this.componentType.isAssignableFrom(((GenArray)t).componentType);
        }
        return false;
    }

    public boolean isAssignableFromRaw(GenType t) {
        if (t instanceof GenTypeArray) {
            return this.componentType.isAssignableFromRaw(((GenArray)t).componentType);
        }
        return false;
    }
}

