/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.classmgr.ClassPath;
import bluej.classmgr.JarFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ProjectClassLoader
extends URLClassLoader {
    public static final String projectLibDirName = "+libs";
    private File[] libsJars;

    public ProjectClassLoader(File projectDir) {
        this(projectDir, ClassLoader.getSystemClassLoader());
    }

    public ProjectClassLoader(File projectDir, ClassLoader parent) {
        super(ProjectClassLoader.getDirectoryAsURL(projectDir), parent);
        this.setDefaultAssertionStatus(true);
        File libsDirectory = new File(projectDir, projectLibDirName);
        if (libsDirectory.isDirectory()) {
            this.libsJars = libsDirectory.listFiles(new JarFilter());
        }
        if (this.libsJars == null) {
            this.libsJars = new File[0];
        }
        for (int i = 0; i < this.libsJars.length; ++i) {
            try {
                this.addURL(this.libsJars[i].toURI().toURL());
                continue;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
    }

    public ClassPath getAsClassPath() {
        return new ClassPath(this.getURLs());
    }

    public File[] getProjectLibs() {
        return this.libsJars;
    }

    private static URL[] getDirectoryAsURL(File projectDir) {
        if (!projectDir.isDirectory()) {
            throw new IllegalArgumentException("project directory was not a directory");
        }
        try {
            URL[] urls = new URL[]{projectDir.toURI().toURL()};
            return urls;
        }
        catch (MalformedURLException mue) {
            URL[] blankUrls = new URL[]{};
            return blankUrls;
        }
    }
}

