/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class BlueJTheme
extends DefaultMetalTheme {
    private final FontUIResource controlFont = new FontUIResource(PrefMgr.getStandardFont());
    private final FontUIResource systemFont = new FontUIResource(this.controlFont);
    private final FontUIResource userFont = new FontUIResource(this.controlFont);
    private final FontUIResource menuFont = new FontUIResource(PrefMgr.getStandardMenuFont());
    private static Image iconImage = null;
    private static String okayLabel;
    private static String cancelLabel;
    private static String continueLabel;
    private static Dimension okCancelDimension;
    public static final int splitPaneDividerWidth = 3;
    public static final int generalSpacingWidth = 5;
    public static final Border generalBorder;
    public static final Border generalBorderWithStatusBar;
    public static final Border dialogBorder;
    public static final Border roundedShadowBorder;
    public static final Border shadowBorder;
    public static final int commandButtonSpacing = 5;
    public static final int commandButtonPadding = 12;
    public static final int componentSpacingSmall = 5;
    public static final int componentSpacingLarge = 11;
    public static final int dialogCommandButtonsVertical = 17;

    public String getName() {
        return "BlueJTheme";
    }

    public FontUIResource getControlTextFont() {
        return this.controlFont;
    }

    public FontUIResource getSystemTextFont() {
        return this.systemFont;
    }

    public FontUIResource getUserTextFont() {
        return this.userFont;
    }

    public FontUIResource getMenuTextFont() {
        return this.menuFont;
    }

    public static Image getIconImage() {
        if (iconImage == null) {
            iconImage = Config.getImageAsIcon("image.icon").getImage();
        }
        return iconImage;
    }

    public static String getOkLabel() {
        if (okayLabel == null) {
            okayLabel = Config.getString("okay");
        }
        return okayLabel;
    }

    public static String getCancelLabel() {
        if (cancelLabel == null) {
            cancelLabel = Config.getString("cancel");
        }
        return cancelLabel;
    }

    public static String getContinueLabel() {
        if (continueLabel == null) {
            continueLabel = Config.getString("continue");
        }
        return continueLabel;
    }

    public static JButton getOkButton() {
        BlueJTheme.computeButtonWidths();
        JButton okButton = new JButton(BlueJTheme.getOkLabel());
        okButton.setPreferredSize(okCancelDimension);
        return okButton;
    }

    public static JButton getCancelButton() {
        BlueJTheme.computeButtonWidths();
        JButton cancelButton = new JButton(BlueJTheme.getCancelLabel());
        cancelButton.setPreferredSize(okCancelDimension);
        return cancelButton;
    }

    public static JButton getContinueButton() {
        BlueJTheme.computeButtonWidths();
        JButton continueButton = new JButton(BlueJTheme.getContinueLabel());
        continueButton.setPreferredSize(okCancelDimension);
        return continueButton;
    }

    private static void computeButtonWidths() {
        if (okCancelDimension != null) {
            return;
        }
        JButton okButton = new JButton(BlueJTheme.getOkLabel());
        JButton cancelButton = new JButton(BlueJTheme.getCancelLabel());
        JButton continueButton = new JButton(BlueJTheme.getContinueLabel());
        int maxWidth = Math.max(cancelButton.getPreferredSize().width, okButton.getPreferredSize().width);
        maxWidth = Math.max(maxWidth, continueButton.getPreferredSize().width);
        okCancelDimension = new Dimension(maxWidth, okButton.getPreferredSize().height);
    }

    static {
        generalBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        generalBorderWithStatusBar = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        dialogBorder = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        roundedShadowBorder = new RoundedShadowBorder();
        shadowBorder = new ShadowBorder();
    }

    private static class ShadowBorder
    extends AbstractBorder {
        private Insets insets;
        private Color shadowColor = new Color(145, 145, 145);
        private Color backgroundColor = Color.white;
        private Color borderColor = Color.black;
        private int backgroundThickness = 5;

        public ShadowBorder() {
            this.insets = new Insets(4 + this.backgroundThickness, 4 + this.backgroundThickness, 4 + this.backgroundThickness, 4 + this.backgroundThickness);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = this.insets.bottom;
            insets.top = this.insets.top;
            insets.left = this.insets.left;
            insets.right = this.insets.right;
            return insets;
        }

        public Insets getBorderInsets(Component c) {
            return (Insets)this.insets.clone();
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.borderColor);
            g.drawLine((x += this.backgroundThickness) + (width -= 2 * this.backgroundThickness) - 4, y += this.backgroundThickness, x + width - 4, y + (height -= 2 * this.backgroundThickness));
            g.setColor(this.shadowColor);
            g.drawLine(x + width - 3, y, x + width - 3, y + height);
            g.drawLine(x + width - 2, y, x + width - 2, y + height);
            g.setColor(this.backgroundColor);
            g.drawLine(x + width - 1, y, x + width - 1, y + height);
            g.fillRect(x + width - 3, y, x + width, y + 5);
            g.setColor(this.borderColor);
            g.drawLine(x + 3, y + height - 4, x + width - 4, y + height - 4);
            g.setColor(this.shadowColor);
            g.drawLine(x, y + height - 3, x + width - 2, y + height - 3);
            g.drawLine(x, y + height - 2, x + width - 2, y + height - 2);
            g.setColor(this.backgroundColor);
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
            g.fillRect(x, y + height - 3, x + 5, y + height);
            g.setColor(this.backgroundColor);
            g.drawLine(x, y, x + width, y);
            g.drawLine(x, y + 1, x + width, y + 1);
            g.drawLine(x, y + 2, x + width, y + 2);
            g.setColor(this.borderColor);
            g.drawLine(x, y + 3, x + width - 4, y + 3);
            g.setColor(this.backgroundColor);
            g.drawLine(x, y, x, y + height);
            g.drawLine(x + 1, y, x + 1, y + height);
            g.drawLine(x + 2, y, x + 2, y + height);
            g.setColor(this.borderColor);
            g.drawLine(x + 3, y + 3, x + 3, y + height - 4);
            g.setColor(this.backgroundColor);
            for (int i = 0; i < this.backgroundThickness + 1; ++i) {
                g.drawRect(x - i, y - i, width - 1 + 2 * i, height - 1 + 2 * i);
            }
        }
    }

    private static class RoundedShadowBorder
    extends AbstractBorder {
        private Insets insets;
        private ImageIcon topLeftCorner = Config.getImageAsIcon("image.border.topleft");
        private ImageIcon topRightCorner = Config.getImageAsIcon("image.border.topright");
        private ImageIcon bottomLeftCorner = Config.getImageAsIcon("image.border.bottomleft");
        private ImageIcon bottomRightCorner = Config.getImageAsIcon("image.border.bottomright");
        private Color shadowColor = new Color(145, 145, 145);
        private Color backgroundColor = Color.white;
        private Color borderColor = Color.black;
        private int backgroundThickness = 5;

        public RoundedShadowBorder() {
            this.insets = new Insets(0, 0, 0, 0);
            this.insets.bottom = this.bottomLeftCorner.getIconHeight() + this.backgroundThickness;
            this.insets.top = this.topLeftCorner.getIconHeight() + this.backgroundThickness;
            this.insets.left = this.topLeftCorner.getIconHeight() + this.backgroundThickness;
            this.insets.right = this.topRightCorner.getIconHeight() + this.backgroundThickness;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = this.insets.bottom;
            insets.top = this.insets.top;
            insets.left = this.insets.left;
            insets.right = this.insets.right;
            return insets;
        }

        public Insets getBorderInsets(Component c) {
            return (Insets)this.insets.clone();
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            height -= 2 * this.backgroundThickness;
            g.setColor(this.backgroundColor);
            g.drawLine(x += this.backgroundThickness, y += this.backgroundThickness, x + (width -= 2 * this.backgroundThickness), y);
            g.drawLine(x, y + 1, x + width, y + 1);
            g.drawLine(x, y + 2, x + width, y + 2);
            g.setColor(this.borderColor);
            g.drawLine(x, y + 3, x + width, y + 3);
            g.setColor(this.borderColor);
            g.drawLine(x, y + height - 4, x + width, y + height - 4);
            g.setColor(this.shadowColor);
            g.drawLine(x, y + height - 3, x + width, y + height - 3);
            g.drawLine(x, y + height - 2, x + width, y + height - 2);
            g.setColor(this.backgroundColor);
            g.drawLine(x, y, x, y + height);
            g.drawLine(x + 1, y, x + 1, y + height);
            g.drawLine(x + 2, y, x + 2, y + height);
            g.setColor(this.borderColor);
            g.drawLine(x + 3, y, x + 3, y + height);
            g.setColor(this.borderColor);
            g.drawLine(x + width - 4, y, x + width - 4, y + height);
            g.setColor(this.shadowColor);
            g.drawLine(x + width - 3, y, x + width - 3, y + height);
            g.drawLine(x + width - 2, y, x + width - 2, y + height);
            g.setColor(this.backgroundColor);
            for (int i = 0; i < this.backgroundThickness + 1; ++i) {
                g.drawRect(x - i, y - i, width - 1 + 2 * i, height - 1 + 2 * i);
            }
            this.topLeftCorner.paintIcon(c, g, x, y);
            this.topRightCorner.paintIcon(c, g, x + (width += this.backgroundThickness) - this.insets.right, y);
            this.bottomLeftCorner.paintIcon(c, g, x, y + (height += this.backgroundThickness) - this.insets.bottom);
            this.bottomRightCorner.paintIcon(c, g, x + width - this.insets.right, y + height - this.insets.bottom);
        }
    }
}

