/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.SyntaxUtilities;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class PHPTokenMarker
extends TokenMarker {
    public static final byte SCRIPT = 100;
    private static KeywordMap keywords = new KeywordMap(false);
    private int lastOffset;
    private int lastKeyword;

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block28: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    backslash = false;
                    switch (c) {
                        case '<': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i++;
                            if (SyntaxUtilities.regionMatches(false, line, i1, "!--")) {
                                i += 3;
                                token = 1;
                                break;
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "?php")) {
                                this.addToken(5, (byte)6);
                                this.lastOffset = this.lastKeyword = (i += 4) + 1;
                                token = (byte)100;
                                break;
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "?")) {
                                this.addToken(2, (byte)6);
                                this.lastOffset = this.lastKeyword = i + 1;
                                token = (byte)100;
                                break;
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "script>")) {
                                this.addToken(8, (byte)6);
                                this.lastOffset = this.lastKeyword = (i += 7) + 1;
                                token = (byte)100;
                                break;
                            }
                            token = (byte)7;
                            break;
                        }
                        case '&': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)8;
                        }
                    }
                    continue block28;
                }
                case 7: {
                    backslash = false;
                    if (c != '>') continue block28;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block28;
                }
                case 8: {
                    backslash = false;
                    if (c != ';') continue block28;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block28;
                }
                case 1: {
                    backslash = false;
                    if (!SyntaxUtilities.regionMatches(false, line, i, "-->")) continue block28;
                    this.addToken(i + 3 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = (i += 2) + 1;
                    token = 0;
                    continue block28;
                }
                case 100: {
                    switch (c) {
                        case '<': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (SyntaxUtilities.regionMatches(true, line, i1, "/script>")) {
                                this.addToken(i - this.lastOffset, (byte)9);
                                this.addToken(9, (byte)6);
                                this.lastOffset = this.lastKeyword = (i += 8) + 1;
                                token = 0;
                                break;
                            }
                            this.addToken(i - this.lastOffset, (byte)9);
                            this.addToken(1, (byte)10);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        case '?': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (array[i1] == '>') {
                                this.addToken(i - this.lastOffset, (byte)9);
                                this.addToken(2, (byte)6);
                                this.lastOffset = this.lastKeyword = ++i + 1;
                                token = 0;
                                break;
                            }
                            this.addToken(i - this.lastOffset, (byte)9);
                            this.addToken(1, (byte)10);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        case '\"': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, (byte)9);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)4;
                            break;
                        }
                        case '\'': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, (byte)9);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)13;
                            break;
                        }
                        case '#': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, (byte)9);
                            this.addToken(length - i, (byte)2);
                            this.lastOffset = this.lastKeyword = length;
                            break block28;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i > 1) {
                                this.addToken(i - this.lastOffset, (byte)9);
                                this.lastOffset = this.lastKeyword = i;
                                if (array[i1] == '/') {
                                    this.addToken(length - i, (byte)2);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block28;
                                }
                                if (array[i1] == '*') {
                                    token = (byte)2;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, (byte)9);
                                this.addToken(1, (byte)10);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            this.addToken(i - this.lastOffset, (byte)9);
                            this.addToken(1, (byte)10);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue block28;
                            this.doKeyword(line, i, c);
                            if (c == ' ') continue block28;
                            this.addToken(i - this.lastOffset, (byte)9);
                            this.addToken(1, (byte)10);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                    }
                    continue block28;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block28;
                    }
                    if (c != '\"') continue block28;
                    this.addToken(i1 - this.lastOffset, (byte)4);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)100;
                    continue block28;
                }
                case 13: {
                    if (backslash) {
                        backslash = false;
                        continue block28;
                    }
                    if (c != '\'') continue block28;
                    this.addToken(i1 - this.lastOffset, (byte)4);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)100;
                    continue block28;
                }
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block28;
                    this.addToken(i + 2 - this.lastOffset, (byte)2);
                    this.lastOffset = this.lastKeyword = ++i + 1;
                    token = (byte)100;
                    continue block28;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 4: {
                this.addToken(length - this.lastOffset, (byte)4);
                break;
            }
            case 13: {
                this.addToken(length - this.lastOffset, (byte)13);
                break;
            }
            case 8: {
                this.addToken(length - this.lastOffset, (byte)11);
                token = 0;
                break;
            }
            case 100: {
                this.doKeyword(line, length, '\u0000');
                this.addToken(length - this.lastOffset, (byte)9);
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)9);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }

    static {
        keywords.add("function", (byte)8);
        keywords.add("class", (byte)8);
        keywords.add("var", (byte)8);
        keywords.add("require", (byte)8);
        keywords.add("include", (byte)8);
        keywords.add("else", (byte)7);
        keywords.add("elseif", (byte)7);
        keywords.add("do", (byte)7);
        keywords.add("for", (byte)7);
        keywords.add("if", (byte)7);
        keywords.add("endif", (byte)7);
        keywords.add("in", (byte)7);
        keywords.add("new", (byte)7);
        keywords.add("return", (byte)7);
        keywords.add("while", (byte)7);
        keywords.add("endwhile", (byte)7);
        keywords.add("with", (byte)7);
        keywords.add("break", (byte)7);
        keywords.add("switch", (byte)7);
        keywords.add("case", (byte)7);
        keywords.add("continue", (byte)7);
        keywords.add("default", (byte)7);
        keywords.add("echo", (byte)7);
        keywords.add("false", (byte)7);
        keywords.add("this", (byte)7);
        keywords.add("true", (byte)7);
        keywords.add("array", (byte)7);
        keywords.add("extends", (byte)7);
    }
}

