/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class CTokenMarker
extends TokenMarker {
    private KeywordMap keywords;

    public CTokenMarker(KeywordMap keywords) {
        this.keywords = keywords;
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int len;
        byte id;
        int offset;
        char[] array = line.array;
        int lastOffset = offset = line.offset;
        int lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block13: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (c) {
                case '\\': {
                    backslash = !backslash;
                    continue block13;
                }
                case '*': {
                    if (token != 1 && token != 2 && token != 3 || length - i <= 1) continue block13;
                    backslash = false;
                    if (length - i <= 1 || array[i1] != '/') continue block13;
                    this.addToken(++i + 1 - lastOffset, token);
                    token = 0;
                    lastKeyword = lastOffset = i + 1;
                    continue block13;
                }
                case '#': {
                    backslash = false;
                    continue block13;
                }
                case '/': {
                    backslash = false;
                    if (token != 0 || length - i <= 1) continue block13;
                    switch (array[i1]) {
                        case '*': {
                            this.addToken(i - lastOffset, token);
                            lastKeyword = lastOffset = i;
                            if (length - i > 2 && array[i + 2] == '*') {
                                token = (byte)2;
                                break;
                            }
                            if (length - i > 2 && array[i + 2] == '#') {
                                token = (byte)3;
                                break;
                            }
                            token = 1;
                            break;
                        }
                        case '/': {
                            this.addToken(i - lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            lastKeyword = lastOffset = length;
                            break block13;
                        }
                    }
                    continue block13;
                }
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        continue block13;
                    }
                    if (token == 0) {
                        token = (byte)4;
                        this.addToken(i - lastOffset, (byte)0);
                        lastKeyword = lastOffset = i;
                        continue block13;
                    }
                    if (token != 4) continue block13;
                    token = 0;
                    this.addToken(i1 - lastOffset, (byte)4);
                    lastKeyword = lastOffset = i1;
                    continue block13;
                }
                case '\'': {
                    if (backslash) {
                        backslash = false;
                        continue block13;
                    }
                    if (token == 0) {
                        token = (byte)5;
                        this.addToken(i - lastOffset, (byte)0);
                        lastKeyword = lastOffset = i;
                        continue block13;
                    }
                    if (token != 5) continue block13;
                    token = 0;
                    this.addToken(i1 - lastOffset, (byte)4);
                    lastKeyword = lastOffset = i1;
                    continue block13;
                }
                case ':': {
                    if (token == 0 && lastKeyword == offset) {
                        backslash = false;
                        this.addToken(i1 - lastOffset, (byte)6);
                        lastKeyword = lastOffset = i1;
                        continue block13;
                    }
                }
                default: {
                    backslash = false;
                    if (token != 0 || c == '_' || Character.isLetter(c)) continue block13;
                    int len2 = i - lastKeyword;
                    byte id2 = this.keywords.lookup(line, lastKeyword, len2);
                    if (id2 != 0) {
                        if (lastKeyword != lastOffset) {
                            this.addToken(lastKeyword - lastOffset, (byte)0);
                        }
                        this.addToken(len2, id2);
                        lastOffset = i;
                    }
                    lastKeyword = i1;
                }
            }
        }
        if (token == 0 && (id = this.keywords.lookup(line, lastKeyword, len = length - lastKeyword)) != 0) {
            if (lastKeyword != lastOffset) {
                this.addToken(lastKeyword - lastOffset, (byte)0);
            }
            this.addToken(len, id);
            lastOffset = length;
        }
        if (lastOffset != length) {
            if (token == 4 || token == 5) {
                this.addToken(length - lastOffset, (byte)11);
                token = 0;
            } else {
                this.addToken(length - lastOffset, token);
            }
        }
        if (token == 8 && !backslash) {
            token = 0;
        }
        return token;
    }
}

