/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextUtilities {
    /*
     * WARNING - void declaration
     */
    public static int findMatchingBracket(Document doc, int offset) throws BadLocationException {
        void var3_3;
        void var4_4;
        if (doc.getLength() == 0) {
            return -1;
        }
        char c = doc.getText(offset, 1).charAt(0);
        switch (c) {
            case '(': {
                int cprime = 41;
                boolean direction = false;
                break;
            }
            case ')': {
                int cprime = 40;
                boolean direction = true;
                break;
            }
            case '[': {
                int cprime = 93;
                boolean direction = false;
                break;
            }
            case ']': {
                int cprime = 91;
                boolean direction = true;
                break;
            }
            case '{': {
                int cprime = 125;
                boolean direction = false;
                break;
            }
            case '}': {
                int cprime = 123;
                boolean direction = true;
                break;
            }
            default: {
                return -1;
            }
        }
        if (var4_4 != false) {
            int count = 1;
            String text = doc.getText(0, offset);
            for (int i = offset - 1; i >= 0; --i) {
                char x = text.charAt(i);
                if (x == c) {
                    ++count;
                    continue;
                }
                if (x != var3_3 || --count != 0) continue;
                return i;
            }
        } else {
            int count = 1;
            int len = doc.getLength() - ++offset;
            String text = doc.getText(offset, len);
            for (int i = 0; i < len; ++i) {
                char x = text.charAt(i);
                if (x == c) {
                    ++count;
                    continue;
                }
                if (x != var3_3 || --count != 0) continue;
                return i + offset;
            }
        }
        return -1;
    }

    public static int findWordStart(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos - 1);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordStart = 0;
        for (int i = pos - 1; i >= 0; --i) {
            ch = line.charAt(i);
            if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
            wordStart = i + 1;
            break;
        }
        return wordStart;
    }

    public static int findWordEnd(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordEnd = line.length();
        for (int i = pos; i < line.length(); ++i) {
            ch = line.charAt(i);
            if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
            wordEnd = i;
            break;
        }
        return wordEnd;
    }
}

