/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.Debug;
import com.apple.eio.FileManager;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Shape;
import java.io.IOException;
import java.util.ArrayList;

public class Utility {
    public static void drawThickRect(Graphics g, int x, int y, int width, int height, int thickness) {
        for (int i = 0; i < thickness; ++i) {
            g.drawRect(x + i, y + i, width - 2 * i, height - 2 * i);
        }
    }

    public static void stripeRect(Graphics g, int x, int y, int width, int height, int separation, int thickness) {
        for (int offset = 0; offset < width + height; offset += separation) {
            int i = 0;
            while (i < thickness) {
                int y2;
                int x2;
                int y1;
                int x1;
                if (offset < height) {
                    x1 = x;
                    y1 = y + offset;
                } else {
                    x1 = x + offset - height;
                    y1 = y + height;
                }
                if (offset < width) {
                    x2 = x + offset;
                    y2 = y;
                } else {
                    x2 = x + width;
                    y2 = y + offset - width;
                }
                g.drawLine(x1, y1, x2, y2);
                ++i;
                ++offset;
            }
        }
    }

    public static void drawCentredText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        int xOffset = (width - fm.stringWidth(str)) / 2;
        if (xOffset < 0) {
            xOffset = 0;
        }
        int yOffset = (height + fm.getAscent()) / 2;
        g.drawString(str, x + xOffset, y + yOffset);
        g.setClip(oldClip);
    }

    public static void drawRightText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        g.drawString(str, x + width - fm.stringWidth(str), y + (height + fm.getAscent()) / 2);
        g.setClip(oldClip);
    }

    public static String[] split(String str, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        int len = str.length();
        int dlen = delimiter.length();
        int offset = str.lastIndexOf(delimiter);
        if (dlen < 1) {
            return null;
        }
        if (offset < 0) {
            String[] result = new String[]{str};
            return result;
        }
        if (len > offset + dlen) {
            str = str + delimiter;
            len += dlen;
        }
        do {
            offset = str.indexOf(delimiter, start);
            strings.add(str.substring(start, offset));
        } while ((start = offset + dlen) < len && offset != -1);
        String[] result = new String[strings.size()];
        strings.toArray(result);
        return result;
    }

    public static String[] splitLines(String str) {
        return str == null ? null : Utility.split(str, "\n");
    }

    public static String quoteSloshes(String src) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            if (src.charAt(i) == '\\') {
                buf.append('\\');
            }
            buf.append(src.charAt(i));
        }
        return buf.toString();
    }

    public static String quoteSpaces(String src, String quote) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            if (src.charAt(i) == ' ') {
                buf.append(quote);
            }
            buf.append(src.charAt(i));
        }
        return buf.toString();
    }

    public static void showClassDocumentation(String classname, String suffix) {
        int lastSlash;
        classname = classname.replace('.', '/');
        String docURL = Config.getPropString("bluej.url.javaStdLib");
        if (docURL.endsWith(".html") && (lastSlash = docURL.lastIndexOf(47)) != -1) {
            docURL = docURL.substring(0, lastSlash + 1);
        }
        Utility.openWebBrowser(docURL + classname + ".html" + suffix);
    }

    public static boolean openWebBrowser(String url) {
        if (Config.isMacOS()) {
            try {
                url = !url.startsWith("http:") && !url.startsWith("file:") ? Utility.encodeURLSpaces("file://" + url) : Utility.encodeURLSpaces(url);
                FileManager.openURL((String)url);
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser. exc: " + e);
                return false;
            }
        }
        if (Config.osname.startsWith("Windows")) {
            String cmd = Config.osname.startsWith("Windows 9") || Config.osname.equals("Windows Me") ? "command.com" : "cmd.exe";
            try {
                if (Config.osname.startsWith("Windows 98")) {
                    Process p = Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", '\"' + url + '\"'});
                }
                Process p = Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", "\"\"", '\"' + url + '\"'});
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser. exc: " + e);
                return false;
            }
        } else {
            url = !url.startsWith("http:") && !url.startsWith("file:") ? Utility.encodeURLSpaces("file://" + url) : Utility.encodeURLSpaces(url);
            String cmd = Utility.mergeStrings(Config.getPropString("browserCmd1"), url);
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                int exitCode = p.waitFor();
                cmd = Config.getPropString("browserCmd2");
                if (exitCode != 0 && cmd != null && cmd.length() > 0) {
                    cmd = Utility.mergeStrings(cmd, url);
                    p = Runtime.getRuntime().exec(cmd);
                }
            }
            catch (InterruptedException e) {
                Debug.reportError("cannot start web browser: " + cmd);
                Debug.reportError("caught exc " + e);
                return false;
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser.  exc: " + e);
                return false;
            }
        }
        return true;
    }

    public static void bringToFront(Frame frame) {
        Debug.message("activate " + frame);
    }

    public static String mergeStrings(String s1, String s2) {
        int pos = s1.indexOf(36);
        if (pos == -1) {
            return s1;
        }
        return s1.substring(0, pos) + s2 + s1.substring(pos + 1);
    }

    public static String mergeStrings(String s1, String[] s2) {
        for (int current = 0; current < s2.length; ++current) {
            s1 = Utility.mergeStrings(s1, s2[current]);
        }
        return s1;
    }

    public static String encodeURLSpaces(String url) {
        if (url.indexOf(32) != -1) {
            StringBuffer buffer = new StringBuffer(url);
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != ' ') continue;
                buffer.deleteCharAt(i);
                buffer.insert(i, "%20");
            }
            return buffer.toString();
        }
        return url;
    }

    public static String convertTabsToSpaces(String originalString, int tabSize) {
        if (originalString.indexOf(9) != -1) {
            StringBuffer buffer = new StringBuffer(originalString);
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != '\t') continue;
                buffer.deleteCharAt(i);
                int numberOfSpaces = tabSize - i % tabSize;
                for (int j = 0; j < numberOfSpaces; ++j) {
                    buffer.insert(i, ' ');
                }
            }
            return buffer.toString();
        }
        return originalString;
    }
}

