/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeBool;
import bluej.debugger.gentype.GenTypeByte;
import bluej.debugger.gentype.GenTypeChar;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDouble;
import bluej.debugger.gentype.GenTypeFloat;
import bluej.debugger.gentype.GenTypeInt;
import bluej.debugger.gentype.GenTypeLong;
import bluej.debugger.gentype.GenTypeShort;
import bluej.debugger.gentype.GenTypeVoid;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JavaUtils14
extends JavaUtils {
    public String getSignature(Method method) {
        String name = JavaUtils14.getTypeName(method.getReturnType()) + " " + method.getName();
        Class[] params = method.getParameterTypes();
        return this.makeSignature(name, params);
    }

    public String getShortDesc(Method method, String[] paramnames) {
        String name = JavaUtils14.getTypeName(method.getReturnType()) + " " + method.getName();
        String[] paramTypes = this.getParameterTypes(method);
        return JavaUtils14.makeDescription(name, paramTypes, paramnames, false, false);
    }

    public String getShortDesc(Method method, String[] paramnames, Map tparams) {
        return this.getShortDesc(method, paramnames);
    }

    public String getLongDesc(Method method, String[] paramnames) {
        String name = JavaUtils14.getTypeName(method.getReturnType()) + " " + method.getName();
        String[] paramTypes = this.getParameterTypes(method);
        return JavaUtils14.makeDescription(name, paramTypes, paramnames, true, false);
    }

    public String getLongDesc(Method method, String[] paramnames, Map tparams) {
        return this.getLongDesc(method, paramnames);
    }

    public String getLongDesc(Constructor constructor, String[] paramnames) {
        String name = constructor.getName();
        String[] paramTypes = this.getParameterTypes(constructor);
        return JavaUtils14.makeDescription(name, paramTypes, paramnames, true, false);
    }

    public String getShortDesc(Constructor constructor, String[] paramnames) {
        String name = constructor.getName();
        String[] paramTypes = this.getParameterTypes(constructor);
        return JavaUtils14.makeDescription(name, paramTypes, paramnames, false, false);
    }

    public String getSignature(Constructor cons) {
        String name = JavaNames.getBase(cons.getName());
        Class[] params = cons.getParameterTypes();
        return this.makeSignature(name, params);
    }

    public boolean isVarArgs(Constructor cons) {
        return false;
    }

    public boolean isVarArgs(Method method) {
        return false;
    }

    public boolean isBridge(Method method) {
        return false;
    }

    public boolean isEnum(Class cl) {
        return false;
    }

    public GenType getReturnType(Method method) {
        Class<?> retType = method.getReturnType();
        return JavaUtils14.genTypeFromClass(retType);
    }

    public GenType getRawReturnType(Method method) {
        return this.getReturnType(method);
    }

    public List getTypeParams(Method method) {
        return Collections.EMPTY_LIST;
    }

    public List getTypeParams(Class cl) {
        return Collections.EMPTY_LIST;
    }

    public GenTypeClass getSuperclass(Class cl) {
        Class sc = cl.getSuperclass();
        if (sc == null) {
            return null;
        }
        return (GenTypeClass)JavaUtils14.genTypeFromClass(sc);
    }

    public GenTypeClass[] getInterfaces(Class cl) {
        Class<?>[] classes = cl.getInterfaces();
        GenTypeClass[] gentypes = new GenTypeClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            gentypes[i] = (GenTypeClass)JavaUtils14.genTypeFromClass(classes[i]);
        }
        return gentypes;
    }

    public String[] getParameterTypes(Method method) {
        Class[] params = method.getParameterTypes();
        return JavaUtils14.getParameterTypes(params);
    }

    public GenType[] getParamGenTypes(Method method, boolean raw) {
        Class<?>[] params = method.getParameterTypes();
        GenType[] gentypes = new GenType[params.length];
        for (int i = 0; i < params.length; ++i) {
            gentypes[i] = JavaUtils14.genTypeFromClass(params[i]);
        }
        return gentypes;
    }

    public String[] getParameterTypes(Constructor constructor) {
        Class[] params = constructor.getParameterTypes();
        return JavaUtils14.getParameterTypes(params);
    }

    public GenType[] getParamGenTypes(Constructor constructor) {
        Class<?>[] params = constructor.getParameterTypes();
        GenType[] gentypes = new GenType[params.length];
        for (int i = 0; i < params.length; ++i) {
            gentypes[i] = JavaUtils14.genTypeFromClass(params[i]);
        }
        return gentypes;
    }

    static String[] getParameterTypes(Class[] params) {
        String[] parameterTypes = new String[params.length];
        for (int j = 0; j < params.length; ++j) {
            String typeName;
            parameterTypes[j] = typeName = JavaUtils14.getTypeName(params[j]);
        }
        return parameterTypes;
    }

    public static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> primtype = type;
                int dimensions = 0;
                while (primtype.isArray()) {
                    ++dimensions;
                    primtype = primtype.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(JavaNames.stripPrefix(primtype.getName()));
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return JavaNames.stripPrefix(type.getName());
    }

    private String makeSignature(String name, Class[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        for (int j = 0; j < params.length; ++j) {
            String typeName = JavaUtils14.getTypeName(params[j]);
            sb.append(typeName);
            if (j >= params.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static GenType genTypeFromClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return new GenTypeBool();
            }
            if (c == Character.TYPE) {
                return new GenTypeChar();
            }
            if (c == Byte.TYPE) {
                return new GenTypeByte();
            }
            if (c == Short.TYPE) {
                return new GenTypeShort();
            }
            if (c == Integer.TYPE) {
                return new GenTypeInt();
            }
            if (c == Long.TYPE) {
                return new GenTypeLong();
            }
            if (c == Float.TYPE) {
                return new GenTypeFloat();
            }
            if (c == Double.TYPE) {
                return new GenTypeDouble();
            }
            if (c == Void.TYPE) {
                return new GenTypeVoid();
            }
            Debug.message("getReturnType: Unknown primitive type");
        }
        if (c.isArray()) {
            GenType componentT = JavaUtils14.genTypeFromClass(c.getComponentType());
            return new GenTypeArray(componentT, new JavaReflective(c));
        }
        return new GenTypeClass(new JavaReflective(c));
    }
}

