/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MiscPrefPanel
extends JPanel
implements PrefPanelListener {
    static final String jdkURLPropertyName = "bluej.url.javaStdLib";
    private JTextField jdkURLField;
    private JCheckBox linkToLibBox;
    private JCheckBox optimiseBox;
    private JCheckBox showTestBox;
    private boolean optimiseMessageShown = false;

    public MiscPrefPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.generalBorder);
        this.add(Box.createVerticalGlue());
        JPanel docPanel = new JPanel();
        docPanel.setLayout(new BoxLayout(docPanel, 1));
        String docTitle = Config.getString("prefmgr.misc.documentation.title");
        docPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle), BlueJTheme.generalBorder));
        docPanel.setAlignmentX(0.0f);
        JPanel urlPanel = new JPanel(new BorderLayout(5, 0));
        urlPanel.add((Component)new JLabel(Config.getString("prefmgr.misc.jdkurlpath")), "West");
        this.jdkURLField = new JTextField(32);
        urlPanel.add((Component)this.jdkURLField, "Center");
        urlPanel.setAlignmentX(0.0f);
        docPanel.add(urlPanel);
        docPanel.add(Box.createVerticalStrut(5));
        this.linkToLibBox = new JCheckBox(Config.getString("prefmgr.misc.linkToLib"));
        this.linkToLibBox.setAlignmentX(0.0f);
        docPanel.add(this.linkToLibBox);
        docPanel.add(Box.createVerticalStrut(5));
        JLabel linkToLibNoteLine1 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine1"));
        Font smallFont = linkToLibNoteLine1.getFont().deriveFont(10);
        linkToLibNoteLine1.setFont(smallFont);
        linkToLibNoteLine1.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine1);
        JLabel linkToLibNoteLine2 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine2"));
        linkToLibNoteLine2.setFont(smallFont);
        linkToLibNoteLine2.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine2);
        this.add(docPanel);
        this.add(Box.createVerticalStrut(5));
        JPanel testPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        testPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.testing.title")), BlueJTheme.generalBorder));
        testPanel.setAlignmentX(0.0f);
        this.showTestBox = new JCheckBox(Config.getString("prefmgr.misc.showTesting"));
        testPanel.add(this.showTestBox);
        this.add(testPanel);
        this.add(Box.createVerticalStrut(5));
        JPanel vmPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        vmPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.vm.title")), BlueJTheme.generalBorder));
        vmPanel.setAlignmentX(0.0f);
        this.optimiseBox = new JCheckBox(Config.getString("prefmgr.misc.optimiseVM"));
        this.optimiseBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiscPrefPanel.this.optimiseToggled();
            }
        });
        vmPanel.add(this.optimiseBox);
        this.add(vmPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalGlue());
    }

    public void beginEditing() {
        this.linkToLibBox.setSelected(PrefMgr.getFlag("doctool.linkToStandardLib"));
        this.jdkURLField.setText(Config.getPropString(jdkURLPropertyName));
        this.showTestBox.setSelected(PrefMgr.getFlag("bluej.testing.showtools"));
        this.optimiseBox.setSelected(PrefMgr.getFlag("bluej.vm.optimize"));
    }

    public void revertEditing() {
    }

    public void commitEditing() {
        PrefMgr.setFlag("doctool.linkToStandardLib", this.linkToLibBox.isSelected());
        PrefMgr.setFlag("bluej.testing.showtools", this.showTestBox.isSelected());
        PrefMgr.setFlag("bluej.vm.optimize", this.optimiseBox.isSelected());
        PkgMgrFrame.updateTestingStatus();
        String jdkURL = this.jdkURLField.getText();
        if (Config.getDefaultPropString(jdkURLPropertyName, "") == jdkURL) {
            Config.removeProperty(jdkURLPropertyName);
        } else {
            Config.putPropString(jdkURLPropertyName, jdkURL);
        }
    }

    private void optimiseToggled() {
        if (!this.optimiseMessageShown) {
            DialogManager.showMessage(this, "pref-optimise-no-effect");
            this.optimiseMessageShown = true;
        }
    }
}

