/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.Config;
import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;

public class PackageTargetPainter {
    private static final int TAB_HEIGHT = 12;
    private static final int HANDLE_SIZE = 20;
    private static final Color defaultbg = Config.getItemColour("colour.package.bg.default");
    private static final Color bordercolour = Config.getItemColour("colour.target.border");
    private static final int TEXT_HEIGHT = GraphPainterStdImpl.TEXT_HEIGHT;
    private static final int TEXT_BORDER = 4;
    private static final Color[] shadowColours = GraphPainterStdImpl.shadowColours;
    private static final AlphaComposite alphaComposite = GraphPainterStdImpl.alphaComposite;
    private static Composite oldComposite;
    private int tabWidth;

    public void paint(Graphics2D g, Target target, boolean hasFocus) {
        PackageTarget packageTarget = (PackageTarget)target;
        g.translate(packageTarget.getX(), packageTarget.getY());
        int width = packageTarget.getWidth();
        int height = packageTarget.getHeight();
        this.drawUMLStyle(g, packageTarget, hasFocus, width, height);
        g.translate(-packageTarget.getX(), -packageTarget.getY());
    }

    public void paintGhost(Graphics2D g, Target target, boolean hasFocus) {
        PackageTarget packageTarget = (PackageTarget)target;
        oldComposite = g.getComposite();
        g.translate(packageTarget.getGhostX(), packageTarget.getGhostY());
        int width = packageTarget.getGhostWidth();
        int height = packageTarget.getGhostHeight();
        g.setComposite(alphaComposite);
        this.drawUMLStyle(g, packageTarget, hasFocus, width, height);
        g.setComposite(oldComposite);
        g.translate(-packageTarget.getGhostX(), -packageTarget.getGhostY());
    }

    private void drawUMLStyle(Graphics2D g, PackageTarget packageTarget, boolean hasFocus, int width, int height) {
        this.tabWidth = packageTarget.getWidth() / 3;
        g.setColor(defaultbg);
        g.fillRect(0, 0, this.tabWidth, 12);
        g.fillRect(0, 12, width, height - 12);
        this.drawShadow(g, packageTarget, width, height);
        g.setColor(bordercolour);
        g.setFont(this.getFont(packageTarget));
        Utility.drawCentredText(g, packageTarget.getDisplayName(), 4, 16, width - 8, TEXT_HEIGHT);
        this.drawUMLBorders(g, packageTarget, hasFocus, width, height);
    }

    private void drawUMLBorders(Graphics2D g, PackageTarget packageTarget, boolean hasFocus, int width, int height) {
        boolean isSelected;
        int thickness = 1;
        boolean bl = isSelected = packageTarget.isSelected() && hasFocus;
        if (isSelected) {
            thickness = 2;
        }
        Utility.drawThickRect(g, 0, 0, this.tabWidth, 12, thickness);
        Utility.drawThickRect(g, 0, 12, width, height - 12, thickness);
        if (!isSelected) {
            return;
        }
        g.drawLine(width - 20 - 2, height, width, height - 20 - 2);
        g.drawLine(width - 20 + 2, height, width, height - 20 + 2);
    }

    private void drawShadow(Graphics2D g, PackageTarget packageTarget, int width, int height) {
        g.setColor(shadowColours[3]);
        g.drawLine(3, height + 1, width, height + 1);
        g.setColor(shadowColours[2]);
        g.drawLine(4, height + 2, width, height + 2);
        g.drawLine(width + 1, height + 2, width + 1, 15);
        g.drawLine(this.tabWidth + 1, 3, this.tabWidth + 1, 12);
        g.setColor(shadowColours[1]);
        g.drawLine(5, height + 3, width + 1, height + 3);
        g.drawLine(width + 2, height + 3, width + 2, 16);
        g.drawLine(this.tabWidth + 2, 4, this.tabWidth + 2, 12);
        g.setColor(shadowColours[0]);
        g.drawLine(6, height + 4, width + 2, height + 4);
        g.drawLine(width + 3, height + 3, width + 3, 17);
        g.drawLine(this.tabWidth + 3, 5, this.tabWidth + 3, 12);
    }

    private Font getFont(PackageTarget packageTarget) {
        return packageTarget.getState() == 1 ? PrefMgr.getStandoutFont() : PrefMgr.getStandardFont();
    }
}

