/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.classmgr.ClassMgr;
import bluej.classmgr.ClassPath;
import bluej.classmgr.ProjectClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerThread;
import bluej.debugmgr.ExecControls;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.DocuGenerator;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.Terminal;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.views.View;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Project
implements DebuggerListener {
    private static Map projects = new HashMap();
    private File projectDir;
    private Map packages;
    private ProjectClassLoader loader;
    private Debugger debugger;
    private ExecControls execControls = null;
    private Terminal terminal = null;
    private DocuGenerator docuGenerator;
    private String initialPackageName = "";
    private boolean inTestMode = false;
    public static final int NEW_PACKAGE_DONE = 0;
    public static final int NEW_PACKAGE_EXIST = 1;
    public static final int NEW_PACKAGE_BAD_NAME = 2;
    public static final int NEW_PACKAGE_NO_PARENT = 3;

    public static boolean isProject(String projectPath) {
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            return false;
        }
        if (startingDir == null) {
            return false;
        }
        return Package.isBlueJPackage(startingDir);
    }

    public static Project openProject(String projectPath) {
        String startingPackageName;
        File lastDir;
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            Debug.message("could not resolve directory " + projectPath);
            return null;
        }
        if (startingDir == null) {
            return null;
        }
        if (Package.isBlueJPackage(startingDir)) {
            lastDir = null;
            startingPackageName = "";
            for (File curDir = startingDir; curDir != null && Package.isBlueJPackage(curDir); curDir = curDir.getParentFile()) {
                if (lastDir != null) {
                    startingPackageName = "." + lastDir.getName() + startingPackageName;
                }
                lastDir = curDir;
            }
            if (startingPackageName.length() > 0 && startingPackageName.charAt(0) == '.') {
                startingPackageName = startingPackageName.substring(1);
            }
        } else {
            return null;
        }
        File projectDir = lastDir;
        Project proj = (Project)projects.get(projectDir);
        if (proj == null) {
            proj = new Project(projectDir);
            projects.put(projectDir, proj);
        }
        if (startingPackageName.equals("")) {
            Package sub;
            Package startingPackage = proj.getPackage("");
            while (startingPackage != null && (sub = startingPackage.getBoringSubPackage()) != null) {
                startingPackage = sub;
            }
            proj.initialPackageName = startingPackage.getQualifiedName();
        } else {
            proj.initialPackageName = startingPackageName;
        }
        ExtensionsManager.getInstance().projectOpening(proj);
        return proj;
    }

    public static void closeProject(Project project) {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(project);
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                frames[i].doClose(true);
            }
        }
    }

    public static void cleanUp(Project project) {
        if (project.hasExecControls()) {
            project.getExecControls().dispose();
        }
        if (project.terminal != null) {
            project.terminal.dispose();
        }
        project.getDebugger().removeDebuggerListener(project);
        project.getDebugger().close(false);
        PrefMgr.addRecentProject(project.getProjectDir().getAbsolutePath());
        projects.remove(project.getProjectDir());
    }

    public static boolean createNewProject(String projectPath) {
        if (projectPath != null) {
            File dir = new File(projectPath);
            if (dir.exists()) {
                return false;
            }
            if (dir.mkdir()) {
                File newpkgFile = new File(dir, "bluej.pkg");
                File newreadmeFile = new File(dir, "README.TXT");
                try {
                    if (newpkgFile.createNewFile()) {
                        if (FileUtility.copyFile(Config.getTemplateFile("readme"), newreadmeFile)) {
                            return true;
                        }
                        Debug.message("could not copy readme template");
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static int getOpenProjectCount() {
        return projects.size();
    }

    public static Collection getProjects() {
        return projects.values();
    }

    public static Project getProject(Object projectKey) {
        return (Project)projects.get(projectKey);
    }

    public static Project getProject() {
        Collection projectColl;
        Iterator it;
        if (projects.size() == 1 && (it = (projectColl = projects.values()).iterator()).hasNext()) {
            return (Project)it.next();
        }
        return null;
    }

    private static File pathIntoStartingDirectory(String projectPath) throws IOException {
        File startingDir = new File(projectPath).getCanonicalFile();
        if (startingDir.isDirectory()) {
            return startingDir;
        }
        if (startingDir.isFile() && startingDir.getName().equals("bluej.pkg")) {
            return startingDir.getParentFile();
        }
        return null;
    }

    private Project(File projectDir) {
        if (projectDir == null) {
            throw new NullPointerException();
        }
        this.projectDir = projectDir;
        this.packages = new TreeMap();
        try {
            this.packages.put("", new Package(this));
        }
        catch (IOException exc) {
            Debug.reportError("could not read package file (unnamed package)");
        }
        this.debugger = Debugger.getDebuggerImpl(this.getProjectDir(), this.getTerminal());
        this.debugger.addDebuggerListener(this);
        this.debugger.launch();
        this.docuGenerator = new DocuGenerator(this);
    }

    public String getProjectName() {
        return this.projectDir.getName();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public boolean isReadOnly() {
        return !this.projectDir.canWrite();
    }

    public String getUniqueId() {
        return String.valueOf(new String("BJID" + this.getProjectDir().getPath()).hashCode());
    }

    public String getInitialPackageName() {
        return this.initialPackageName;
    }

    public Package getPackage(String qualifiedName) {
        Package existing = (Package)this.packages.get(qualifiedName);
        if (existing != null) {
            return existing;
        }
        if (qualifiedName.length() > 0) {
            Package pkg;
            try {
                Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
                if (parent != null) {
                    pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
                    this.packages.put(qualifiedName, pkg);
                } else {
                    pkg = null;
                }
            }
            catch (IOException exc) {
                pkg = null;
            }
            return pkg;
        }
        throw new IllegalStateException("Project.getPackage()");
    }

    public Package getCachedPackage(String qualifiedName) {
        return (Package)this.packages.get(qualifiedName);
    }

    public void createPackageDirectory(String fullName) {
        StringTokenizer st = new StringTokenizer(fullName, ".");
        File newPkgDir = this.getProjectDir();
        while (st.hasMoreTokens()) {
            newPkgDir = new File(newPkgDir, st.nextToken());
        }
        if (newPkgDir.isDirectory() || newPkgDir.mkdirs()) {
            st = new StringTokenizer(fullName, ".");
            newPkgDir = this.getProjectDir();
            File newPkgFile = new File(newPkgDir, "bluej.pkg");
            try {
                newPkgFile.createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            while (st.hasMoreTokens()) {
                newPkgDir = new File(newPkgDir, st.nextToken());
                newPkgFile = new File(newPkgDir, "bluej.pkg");
                try {
                    newPkgFile.createNewFile();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public int newPackage(String qualifiedName) {
        if (qualifiedName == null) {
            return 2;
        }
        Package existing = (Package)this.packages.get(qualifiedName);
        if (existing != null) {
            return 1;
        }
        if (qualifiedName.length() < 1) {
            return 2;
        }
        try {
            Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
            if (parent == null) {
                return 3;
            }
            this.createPackageDirectory(qualifiedName);
            Package pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
            this.packages.put(qualifiedName, pkg);
        }
        catch (IOException exc) {
            return 2;
        }
        return 0;
    }

    public Package getExistingPackage(String packageName) {
        Package r = this.getPackage("");
        while (packageName.length() != 0) {
            String nextName;
            int firstPos = packageName.indexOf(46);
            if (firstPos == -1) {
                nextName = packageName;
                packageName = "";
            } else {
                nextName = packageName.substring(0, firstPos);
                packageName = packageName.substring(firstPos + 1);
            }
            List children = r.getChildren();
            Iterator i = children.iterator();
            Package child = null;
            while (i.hasNext() && !(child = (Package)i.next()).getBaseName().equals(nextName)) {
            }
            if (child == null) {
                return null;
            }
            r = child;
        }
        return r;
    }

    private List getPackageNames(Package rootPackage) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(rootPackage.getQualifiedName());
        List children = rootPackage.getChildren();
        if (children != null) {
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Package p = (Package)i.next();
                l.addAll(this.getPackageNames(p));
            }
        }
        return l;
    }

    public List getPackageNames() {
        return this.getPackageNames(this.getPackage(""));
    }

    public String generateDocumentation() {
        return this.docuGenerator.generateProjectDocu();
    }

    public String getDocumentationFile(String filename) {
        return this.docuGenerator.getDocuPath(filename);
    }

    public void generateDocumentation(String filename) {
        this.docuGenerator.generateClassDocu(filename);
    }

    public void saveAll() {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        if (frames == null) {
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            frames[i].doSave();
        }
    }

    public void reloadAll() {
        Iterator i = this.packages.values().iterator();
        while (i.hasNext()) {
            Package pkg = (Package)i.next();
            pkg.reload();
        }
    }

    public void saveAs(PkgMgrFrame frame) {
        String newName = FileUtility.getFileName(frame, Config.getString("pkgmgr.saveAs.title"), Config.getString("pkgmgr.saveAs.buttonLabel"), false, null, true);
        if (newName != null) {
            this.saveAll();
            int result = FileUtility.copyDirectory(this.getProjectDir().getPath(), newName);
            switch (result) {
                case 0: {
                    break;
                }
                case 1: {
                    DialogManager.showError(frame, "directory-exists");
                    return;
                }
                case 2: 
                case 3: {
                    DialogManager.showError(frame, "cannot-copy-package");
                    return;
                }
            }
            Project.closeProject(this);
            Project openProj = Project.openProject(newName);
            if (openProj != null) {
                Package pkg = openProj.getPackage(openProj.getInitialPackageName());
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(pkg);
                pmf.show();
            } else {
                Debug.message("could not open package under new name");
            }
        }
    }

    public void restartVM() {
        this.getDebugger().close(true);
        this.vmClosed();
        PkgMgrFrame.displayMessage(this, Config.getString("pkgmgr.creatingVM"));
    }

    private void vmClosed() {
        Iterator i = this.packages.values().iterator();
        while (i.hasNext()) {
            Package pkg = (Package)i.next();
            pkg.removeBreakpoints();
        }
        this.removeLocalClassLoader();
    }

    public synchronized ProjectClassLoader getLocalClassLoader() {
        if (this.loader == null) {
            this.loader = ClassMgr.getProjectLoader(this.getProjectDir());
        }
        return this.loader;
    }

    public synchronized void removeLocalClassLoader() {
        if (this.loader != null) {
            PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
            for (int i = 0; i < frames.length; ++i) {
                frames[i].getObjectBench().removeAllObjects(this.getUniqueId());
                frames[i].clearTextEval();
            }
            View.removeAll(this.loader);
            new Thread(){

                public void run() {
                    Project.this.getDebugger().disposeWindows();
                }
            }.start();
            this.loader = null;
        }
    }

    public synchronized void newRemoteClassLoader() {
        this.getDebugger().newClassLoader(this.getProjectDir().getPath());
    }

    public synchronized void newRemoteClassLoaderLeavingBreakpoints() {
        this.getDebugger().newClassLoaderLeavingBreakpoints(this.getProjectDir().getPath());
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public boolean hasExecControls() {
        return this.execControls != null;
    }

    public ExecControls getExecControls() {
        if (this.execControls == null) {
            this.execControls = new ExecControls(this, this.getDebugger());
        }
        return this.execControls;
    }

    public boolean hasTerminal() {
        return this.terminal != null;
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            this.terminal = new Terminal(this);
        }
        return this.terminal;
    }

    public Class loadClass(String className) {
        try {
            return this.getLocalClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean inTestMode() {
        return this.inTestMode;
    }

    public void setTestMode(boolean mode) {
        this.inTestMode = mode;
    }

    public String getClassPath() {
        ClassPath allcp = ClassMgr.getClassMgr().getAllClassPath();
        allcp.addClassPath(this.getLocalClassLoader().getAsClassPath());
        return allcp.toString();
    }

    public String convertPathToPackageName(String pathname) {
        return JavaNames.convertFileToQualifiedName(this.getProjectDir(), new File(pathname));
    }

    public void removeStepMarks() {
        Iterator i = this.packages.values().iterator();
        while (i.hasNext()) {
            Package pkg = (Package)i.next();
            pkg.removeStepMarks();
        }
    }

    public void debuggerEvent(final DebuggerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (event.getID() == 1) {
                    PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(Project.this);
                    if (frames == null) {
                        return;
                    }
                    for (int i = 0; i < frames.length; ++i) {
                        frames[i].setDebuggerState(event.getNewState());
                    }
                    if (event.getOldState() == 1 && event.getNewState() == 2) {
                        PkgMgrFrame.displayMessage(Project.this, Config.getString("pkgmgr.creatingVMDone"));
                    }
                    if (event.getOldState() == 2 && event.getNewState() == 1) {
                        Project.this.vmClosed();
                    }
                    return;
                }
                if (event.getID() == 2) {
                    Project.this.removeStepMarks();
                    return;
                }
                DebuggerThread thr = event.getThread();
                String packageName = JavaNames.getPrefix(thr.getClass(0));
                Package pkg = Project.this.getPackage(packageName);
                if (pkg != null) {
                    switch (event.getID()) {
                        case 4: {
                            pkg.hitBreakpoint(thr);
                            break;
                        }
                        case 3: {
                            pkg.hitHalt(thr);
                            break;
                        }
                        case 6: {
                            pkg.showSourcePosition(thr);
                        }
                    }
                }
            }
        });
    }

    public String toString() {
        return "Project:" + this.getProjectName();
    }

    public void removePackage(String packageQualifiedName) {
        this.packages.remove(packageQualifiedName);
    }
}

