/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.JavaToken;
import bluej.parser.symtab.BlockDef;
import bluej.parser.symtab.ClassDef;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.JavaHashtable;
import bluej.parser.symtab.JavaStack;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.LabelDef;
import bluej.parser.symtab.MethodDef;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.PackageDef;
import bluej.parser.symtab.PrimitiveDef;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.Selection;
import bluej.parser.symtab.StringTable;
import bluej.parser.symtab.TypedDef;
import bluej.parser.symtab.VariableDef;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SymbolTable {
    private BlockDef baseScope = null;
    private PackageDef defaultPackage = null;
    private StringTable names = new StringTable();
    private JavaStack activeScopes;
    private JavaHashtable packages = new JavaHashtable();
    private Definition qualifiedScope;
    private File currentFile;
    private MethodDef currentMethod;
    private String currentIndent = "";
    private JavaVector demand;
    private JavaHashtable importedClasses;
    private PackageDef javaLang;
    private ClassDef object;
    private static Vector predefined;

    public SymbolTable() {
        this.activeScopes = new JavaStack();
        Occurrence o = new Occurrence(null, 0, 0);
        this.javaLang = new PackageDef(this.getUniqueName("java.lang"), new Occurrence(null, 0, 0), null);
        this.baseScope = new BlockDef(null, null, null);
        this.pushScope(this.baseScope);
        this.baseScope.setDefaultOrBaseScope(true);
        PrimitiveDef pBoolean = new PrimitiveDef(this.getUniqueName("boolean"), this.getObject(), (ScopedDef)this.baseScope);
        PrimitiveDef pDouble = new PrimitiveDef(this.getUniqueName("double"), this.getObject(), (ScopedDef)this.baseScope);
        PrimitiveDef pFloat = new PrimitiveDef(this.getUniqueName("float"), pDouble, (ScopedDef)this.baseScope);
        PrimitiveDef pLong = new PrimitiveDef(this.getUniqueName("long"), pFloat, (ScopedDef)this.baseScope);
        PrimitiveDef pInt = new PrimitiveDef(this.getUniqueName("int"), pLong, (ScopedDef)this.baseScope);
        PrimitiveDef pShort = new PrimitiveDef(this.getUniqueName("short"), pInt, (ScopedDef)this.baseScope);
        PrimitiveDef pByte = new PrimitiveDef(this.getUniqueName("byte"), pShort, (ScopedDef)this.baseScope);
        PrimitiveDef pChar = new PrimitiveDef(this.getUniqueName("char"), pInt, (ScopedDef)this.baseScope);
        PrimitiveDef pVoid = new PrimitiveDef(this.getUniqueName("void"), this.getObject(), (ScopedDef)this.baseScope);
        this.baseScope.add(pBoolean);
        this.baseScope.add(pDouble);
        this.baseScope.add(pFloat);
        this.baseScope.add(pLong);
        this.baseScope.add(pInt);
        this.baseScope.add(pShort);
        this.baseScope.add(pByte);
        this.baseScope.add(pChar);
        this.baseScope.add(pVoid);
        predefined = new Vector(9);
        predefined.addElement("boolean");
        predefined.addElement("double");
        predefined.addElement("float");
        predefined.addElement("long");
        predefined.addElement("int");
        predefined.addElement("short");
        predefined.addElement("byte");
        predefined.addElement("char");
        predefined.addElement("void");
        predefined.addElement("String");
    }

    public static Vector getPredefined() {
        return predefined;
    }

    public void addClasses(Vector classes) {
        if (classes != null) {
            Enumeration e = classes.elements();
            while (e.hasMoreElements()) {
                ClassDef def = new ClassDef((String)e.nextElement());
                this.getCurrentScope().add(def);
                def.setParentScope(this.getCurrentScope());
            }
        }
    }

    void addDemand(PackageDef pkg) {
        this.demand.addElement(pkg);
    }

    public void addImport(JavaToken tok, String className, String packageName) {
        if (this.importedClasses == null) {
            this.importedClasses = new JavaHashtable();
        }
        if (packageName.equals(".") || packageName.equals("")) {
            this.importedClasses.put(this.getUniqueName("~default~"), this.getDefaultPackage());
            return;
        }
        packageName = packageName.substring(1);
        if (className == null) {
            Definition d = (Definition)this.packages.get(packageName);
            if (d == null) {
                d = new PackageDef(this.getUniqueName(packageName), new Occurrence(this.currentFile, tok.getLine(), tok.getColumn()), null);
                this.packages.put(packageName, d);
            }
            this.importedClasses.put(d.getName(), d);
            this.reference(tok);
        } else {
            this.importedClasses.put(this.getUniqueName(className), new DummyClass(this.getUniqueName(className), new Occurrence(this.currentFile, tok.getLine(), tok.getColumn()), this.getUniqueName(packageName)));
            this.reference(tok);
        }
    }

    void addToCurrentScope(Definition def) {
        this.getCurrentScope().add(def);
        def.setParentScope(this.getCurrentScope());
    }

    void closeImports() {
        this.demand = null;
        this.importedClasses = null;
    }

    public Definition defineBlock(JavaToken tok) {
        BlockDef def = new BlockDef(null, this.getOccurrence(tok), this.getCurrentScope());
        this.addToCurrentScope(def);
        return this.pushScope(def);
    }

    public void defineClass(JavaToken theClass, JavaToken superClass, JavaVector interfaces, boolean isAbstract, boolean isPublic, boolean isEnum, JavaToken comment, Selection extendsInsert, Selection implementsInsert, Selection extendsReplace, Selection superReplace, Selection typeParamSelection, Vector typeParameterSelections, Vector interfaceSelections) {
        ClassDef def = new ClassDef(this.getUniqueName(theClass), isAbstract, isPublic, isEnum, this.getOccurrence(theClass), superClass == null ? null : this.getDummyClass(superClass), interfaces, this.getCurrentScope());
        def.setType(0);
        def.setExtendsInsert(extendsInsert);
        def.setImplementsInsert(implementsInsert);
        def.setExtendsReplace(extendsReplace);
        def.setSuperReplace(superReplace);
        def.setInterfaceSelections(interfaceSelections);
        def.setTypeParamInsert(typeParamSelection);
        def.setImports(this.importedClasses);
        if (comment != null) {
            def.setComment(comment.getText());
        }
        this.addToCurrentScope(def);
        this.pushScope(def);
    }

    public void defineInterface(JavaToken theInterface, JavaVector superInterfaces, boolean isPublic, JavaToken comment, Selection extendsInsert, Selection typeParamInsert, Vector typeParameterSelections, Vector superInterfaceSelections) {
        ClassDef def = new ClassDef(this.getUniqueName(theInterface), false, true, false, this.getOccurrence(theInterface), null, superInterfaces, this.getCurrentScope());
        def.setType(1);
        def.setExtendsInsert(extendsInsert);
        def.setInterfaceSelections(superInterfaceSelections);
        if (comment != null) {
            def.setComment(comment.getText());
        }
        if (typeParamInsert != null) {
            def.setTypeParamInsert(typeParamInsert);
        }
        this.addToCurrentScope(def);
        this.pushScope(def);
    }

    public void defineLabel(JavaToken theLabel) {
        this.addToCurrentScope(new LabelDef(this.getUniqueName(theLabel), this.getOccurrence(theLabel), this.getCurrentScope()));
    }

    public void defineMethod(JavaToken theMethod, JavaToken type, JavaToken comment, Selection typeArgument) {
        String name;
        if (type == null) {
            name = theMethod.getText();
        } else {
            if (theMethod == null) {
                theMethod = type;
                type = null;
            }
            name = theMethod.getText();
        }
        String typeArgumentName = null;
        if (typeArgument != null) {
            typeArgumentName = typeArgument.getText();
        }
        this.currentMethod = new MethodDef(this.getUniqueName(name), this.getOccurrence(theMethod), this.getDummyClass(type), this.getCurrentScope(), typeArgumentName);
        if (comment != null) {
            this.currentMethod.setComment(comment.getText());
        }
        this.addToCurrentScope(this.currentMethod);
        this.pushScope(this.currentMethod);
    }

    public void definePackage(JavaToken tok) {
        this.definePackage(this.getUniqueName(tok));
    }

    PackageDef definePackage(String name) {
        PackageDef pkg = (PackageDef)this.packages.get(name);
        if (pkg == null) {
            pkg = new PackageDef(this.getUniqueName(name), null, null);
            this.packages.put(name, pkg);
        }
        this.pushScope(pkg);
        return pkg;
    }

    public void defineVar(JavaToken theVariable, JavaToken type, boolean isVarargs, JavaToken comment) {
        String typename = type.getText();
        int arrayLevel = 0;
        while (typename.endsWith("[]")) {
            ++arrayLevel;
            typename = typename.substring(0, typename.length() - 2);
        }
        type.setText(typename);
        VariableDef v = new VariableDef(this.getUniqueName(theVariable), this.getOccurrence(theVariable), this.getDummyClass(type), isVarargs, arrayLevel, this.getCurrentScope());
        if (comment != null) {
            v.setComment(comment.getText());
        }
        if (this.currentMethod != null) {
            this.currentMethod.add(v);
        } else {
            this.addToCurrentScope(v);
        }
    }

    public void endMethodHead(JavaVector exceptions) {
        this.currentMethod.setExceptions(exceptions);
        this.currentMethod = null;
    }

    Definition findInImports(String name) {
        Definition def = null;
        if (this.importedClasses != null) {
            def = (Definition)this.importedClasses.get(name);
        }
        if (def == null && this.demand != null && name.charAt(0) != '~') {
            Enumeration e = this.demand.elements();
            while (def == null && e.hasMoreElements()) {
                def = ((PackageDef)e.nextElement()).lookup(name);
            }
        }
        return def;
    }

    Definition findPackage(String name) {
        return (Definition)this.packages.get(name);
    }

    ScopedDef getCurrentScope() {
        if (this.activeScopes.empty()) {
            return null;
        }
        return (ScopedDef)this.activeScopes.peek();
    }

    PackageDef getDefaultPackage() {
        if (this.defaultPackage == null) {
            this.defaultPackage = new PackageDef(this.getUniqueName("~default~"), null, null);
            this.packages.put(this.getUniqueName("~default~"), this.defaultPackage);
            this.defaultPackage.setDefaultOrBaseScope(true);
        }
        return this.defaultPackage;
    }

    public DummyClass getDummyClass(JavaToken tok) {
        if (tok == null) {
            return null;
        }
        return new DummyClass(this.getUniqueName(tok), this.getOccurrence(tok));
    }

    String getIndent() {
        return this.currentIndent;
    }

    ClassDef getObject() {
        if (this.object == null) {
            this.object = new DummyClass();
            this.object.setType(0);
            this.javaLang.add(this.object);
        }
        return this.object;
    }

    Occurrence getOccurrence(JavaToken tok) {
        if (tok == null) {
            return new Occurrence(null, 0, 0);
        }
        return new Occurrence(this.currentFile, tok.getLine(), tok.getColumn());
    }

    Definition getScope() {
        return this.qualifiedScope;
    }

    String getUniqueName(JavaToken tok) {
        return this.getUniqueName(tok.getText());
    }

    String getUniqueName(String name) {
        return this.names.getName(name);
    }

    Definition lookup(String name) {
        return this.lookup(name, -1);
    }

    Definition lookup(String name, int numParams) {
        Definition def = null;
        StringTokenizer st = null;
        String afterPackage = null;
        if (name.indexOf(46) > 0) {
            String testName = null;
            st = new StringTokenizer(name, ".");
            boolean doneWithPackage = false;
            while (st.hasMoreElements()) {
                String id = (String)st.nextElement();
                PackageDef testIt = null;
                if (testName == null) {
                    testName = id;
                    def = this.findInImports(testName);
                    if (def != null) {
                        doneWithPackage = true;
                        id = (String)st.nextElement();
                    }
                } else {
                    testName = testName + "." + id;
                }
                if (!doneWithPackage && (testIt = (PackageDef)this.packages.get(name)) != null) {
                    def = testIt;
                    afterPackage = null;
                    continue;
                }
                if (afterPackage == null) {
                    afterPackage = id;
                    continue;
                }
                afterPackage = afterPackage + "." + id;
            }
        } else if (numParams == -1 && (def = this.findInImports(name)) != null) {
            return def;
        }
        if (def != null && afterPackage != null) {
            this.setScope(def);
        } else {
            afterPackage = name;
        }
        if (afterPackage != null) {
            st = new StringTokenizer(afterPackage, ".");
            while (st.hasMoreElements()) {
                String id = (String)st.nextElement();
                if (this.qualifiedScope != null) {
                    def = this.qualifiedScope.lookup(id, numParams);
                    this.resetScope();
                } else {
                    def = this.activeScopes.lookup(id, numParams);
                }
                if (def == null) break;
                if (!st.hasMoreElements()) continue;
                this.setScope(def);
            }
        }
        return def;
    }

    Definition lookupDummy(Definition d) {
        String pkg = ((DummyClass)d).getPackage();
        return this.lookup((pkg == null ? "" : pkg + ".") + d.getName());
    }

    void openImports(JavaHashtable imports) {
        this.demand = new JavaVector();
        this.demand.addElement(this.javaLang);
        this.importedClasses = new JavaHashtable();
        if (imports != null) {
            Enumeration e = imports.elements();
            while (e.hasMoreElements()) {
                Definition newD;
                Definition d = (Definition)e.nextElement();
                if (d instanceof PackageDef) {
                    this.addDemand((PackageDef)d);
                    continue;
                }
                if (d instanceof DummyClass && (newD = this.lookupDummy(d)) != null) {
                    d = newD;
                }
                this.importedClasses.put(d.getName(), d);
            }
        }
    }

    public void popAllScopes() {
        while (this.activeScopes.peek() != this.baseScope) {
            this.activeScopes.pop();
        }
        this.importedClasses = null;
    }

    public void popScope() {
        this.activeScopes.pop();
    }

    Definition pushScope(Definition scope) {
        if (!(scope instanceof ScopedDef)) {
            throw new RuntimeException("Not a ScopedDef");
        }
        this.activeScopes.push(scope);
        return scope;
    }

    public void reference(JavaToken t) {
        t.setFile(this.currentFile);
        this.getCurrentScope().addUnresolved(t);
    }

    public void getInfo(ClassInfo info) {
        Enumeration e = this.packages.elements();
        while (e.hasMoreElements()) {
            PackageDef p = (PackageDef)e.nextElement();
            p.getInfo(info, this);
        }
    }

    void resetScope() {
        this.setScope((Definition)null);
    }

    public void resolveTypes() {
        if (this.defaultPackage != null) {
            this.defaultPackage.resolveTypes(this);
        }
        this.packages.resolveTypes(this);
    }

    public void setFile(File file) {
        this.currentFile = file;
    }

    public File getFile() {
        return this.currentFile;
    }

    public void setNearestClassScope() {
        this.setScope(this.activeScopes.findTopmostClass());
    }

    void setScope(JavaToken t) {
        Definition def = this.lookup(t.getText());
        if (def != null) {
            def.addReference(this.getOccurrence(t));
            this.setScope(def);
        }
    }

    void setScope(Definition d) {
        while (d != null && d instanceof TypedDef) {
            d = ((TypedDef)((Object)d)).getType();
        }
        if (d == null || d instanceof ScopedDef) {
            this.qualifiedScope = d;
        }
    }

    void setScope(String name) {
        Definition def = this.lookup(name);
        if (def != null) {
            this.setScope(def);
        }
    }

    public String toString() {
        return "Symbol Table";
    }

    public void useDefaultPackage() {
        this.pushScope(this.getDefaultPackage());
    }
}

