/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.JavaHashtable;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.PackageDef;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;

abstract class HasImports
extends ScopedDef {
    private JavaHashtable imports;

    HasImports(String name, Occurrence occ, ScopedDef parentScope) {
        super(name, occ, parentScope);
    }

    void closeImports(SymbolTable symbolTable) {
        symbolTable.closeImports();
    }

    boolean isTopLevel() {
        return this.getParentScope() instanceof PackageDef;
    }

    void openImports(SymbolTable symbolTable) {
        symbolTable.openImports(this.imports);
    }

    void getImportInfo(ClassInfo info) {
        if (this.imports != null) {
            Enumeration e = this.imports.elements();
            while (e.hasMoreElements()) {
                info.addImported(((Definition)e.nextElement()).getName());
            }
        }
    }

    void resolveTypes(SymbolTable symbolTable) {
        if (this.imports != null) {
            this.imports.resolveTypes(symbolTable);
        }
        if (this.isTopLevel()) {
            this.openImports(symbolTable);
        }
        super.resolveTypes(symbolTable);
    }

    void setImports(JavaHashtable imports) {
        this.imports = imports;
    }
}

